/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.features;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class RoofShape
extends ComplexEnumAttrib<Option> {
    public RoofShape() {
        super(OpenEstateAttrib.FEATURES_ROOF_SHAPE, null);
    }

    public RoofShape(Option option) {
        Option[] optionArray;
        if (option != null) {
            Option[] optionArray2 = new Option[1];
            optionArray = optionArray2;
            optionArray2[0] = option;
        } else {
            optionArray = null;
        }
        this(optionArray);
    }

    public RoofShape(Option[] optionArray) {
        this();
        if (optionArray != null) {
            ((AbstractAttribImpl)this).setValue(optionArray);
        }
    }

    public static Option[] get(EstateImpl estateImpl) {
        return (Option[])RoofShape.get(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option[] optionArray = RoofShape.get(estateImpl);
        if (optionArray != null) {
            arrayList.addAll(Arrays.asList(optionArray));
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl, String string) {
        return RoofShape.getAsString(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, string);
    }

    public static String getAsString(EstateImpl estateImpl, String string, Locale locale) {
        return RoofShape.getAsString(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, string, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public Option[] getOptionsArray(Collection<Option> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(new Option[collection.size()]) : new Option[]{};
    }

    public static boolean hasOption(EstateImpl estateImpl, Option option) {
        return RoofShape.hasOption(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, option);
    }

    public static void put(EstateImpl estateImpl, Option[] optionArray) {
        RoofShape.put(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, optionArray);
    }

    public static void put(EstateImpl estateImpl, String[] stringArray) {
        RoofShape.put(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, stringArray);
    }

    public static void putOption(EstateImpl estateImpl, Option option) {
        RoofShape.putOption(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, option);
    }

    public static void putOption(EstateImpl estateImpl, String string) {
        RoofShape.putOption(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, string);
    }

    public static void removeOption(EstateImpl estateImpl, Option option) {
        RoofShape.removeOption(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, option);
    }

    public static void removeOption(EstateImpl estateImpl, String string) {
        RoofShape.removeOption(estateImpl, OpenEstateAttrib.FEATURES_ROOF_SHAPE, string);
    }

    public static enum Option implements Translatable
    {
        HIP(I18n.marktr((String)"hip roof")),
        MANSARD(I18n.marktr((String)"mansard roof")),
        MONOPITCH(I18n.marktr((String)"monopitch roof")),
        GABLED(I18n.marktr((String)"gabled roof")),
        FLAT(I18n.marktr((String)"flat roof")),
        PYRAMID(I18n.marktr((String)"pyramid roof")),
        HALF_HIP(I18n.marktr((String)"half-hip roof"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

