/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.standard.CombinedFileFilter;
import org.java.plugin.standard.RegexpFileFilter;
import org.java.plugin.standard.ShadowDataController;
import org.java.plugin.standard.StandardPathResolver;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadingPathResolver
extends StandardPathResolver {
    private static final String UNPACK_MODE_ALWAIS = "always";
    private static final String UNPACK_MODE_NEVER = "never";
    private static final String UNPACK_MODE_SMART = "smart";
    private File shadowFolder;
    private String unpackMode;
    private Map<String, URL> shadowUrlMap = new HashMap<String, URL>();
    private Map<String, Boolean> unpackModeMap = new HashMap<String, Boolean>();
    private ShadowDataController controller;

    @Override
    public synchronized void configure(ExtendedProperties config) throws Exception {
        super.configure(config);
        String folder = config.getProperty("shadowFolder");
        if (folder != null && folder.length() > 0) {
            try {
                this.shadowFolder = new File(folder).getCanonicalFile();
            }
            catch (IOException ioe) {
                this.log.warn((Object)("failed initializing shadow folder " + folder + ", falling back to the default folder"), (Throwable)ioe);
            }
        }
        if (this.shadowFolder == null) {
            this.shadowFolder = new File(System.getProperty("java.io.tmpdir"), ".jpf-shadow");
        }
        this.log.debug((Object)("shadow folder is " + this.shadowFolder));
        if (!this.shadowFolder.exists()) {
            this.shadowFolder.mkdirs();
        }
        this.unpackMode = config.getProperty("unpackMode", UNPACK_MODE_SMART);
        this.log.debug((Object)("unpack mode parameter value is " + this.unpackMode));
        this.controller = ShadowDataController.init(this.shadowFolder, this.buildFileFilter(config));
        this.log.info((Object)("configured, shadow folder is " + this.shadowFolder));
    }

    private FileFilter buildFileFilter(ExtendedProperties config) {
        String patterns = config.getProperty("includes");
        RegexpFileFilter includesFilter = patterns != null && patterns.trim().length() > 0 ? new RegexpFileFilter(patterns) : null;
        patterns = config.getProperty("excludes");
        RegexpFileFilter excludesFilter = patterns != null && patterns.trim().length() > 0 ? new RegexpFileFilter(patterns) : null;
        if (excludesFilter == null && includesFilter == null) {
            return null;
        }
        return new CombinedFileFilter(includesFilter, excludesFilter);
    }

    @Override
    public void registerContext(Identity idt, URL url) {
        Boolean mode;
        super.registerContext(idt, url);
        if (UNPACK_MODE_ALWAIS.equalsIgnoreCase(this.unpackMode)) {
            mode = Boolean.TRUE;
        } else if (UNPACK_MODE_NEVER.equalsIgnoreCase(this.unpackMode)) {
            mode = Boolean.FALSE;
        } else {
            PluginDescriptor descr = null;
            PluginFragment fragment = null;
            if (idt instanceof PluginDescriptor) {
                descr = (PluginDescriptor)idt;
            } else if (idt instanceof PluginFragment) {
                fragment = (PluginFragment)idt;
                descr = fragment.getRegistry().getPluginDescriptor(fragment.getPluginId());
            } else if (idt instanceof PluginElement) {
                PluginElement element = (PluginElement)idt;
                descr = element.getDeclaringPluginDescriptor();
                fragment = element.getDeclaringPluginFragment();
            } else {
                throw new IllegalArgumentException("unknown identity class " + idt.getClass().getName());
            }
            mode = this.getUnpackMode(descr, fragment);
        }
        this.log.debug((Object)("unpack mode for " + idt + " is " + mode));
        this.unpackModeMap.put(idt.getId(), mode);
    }

    private Boolean getUnpackMode(PluginDescriptor descr, PluginFragment fragment) {
        Iterator<PluginElement<PluginAttribute>> i$ = this.filterCollection(descr.getAttributes("unpack"), fragment).iterator();
        if (i$.hasNext()) {
            PluginAttribute attr = i$.next();
            return "false".equalsIgnoreCase(attr.getValue());
        }
        for (Library lib : this.filterCollection(descr.getLibraries(), fragment)) {
            if (!lib.isCodeLibrary() || !lib.getPath().toLowerCase(Locale.getDefault()).endsWith(".jar") && !lib.getPath().toLowerCase(Locale.getDefault()).endsWith(".zip")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private <T extends PluginElement<?>> Collection<T> filterCollection(Collection<T> coll, PluginFragment fragment) {
        if (fragment == null) {
            return coll;
        }
        LinkedList<PluginElement> result = new LinkedList<PluginElement>();
        for (PluginElement element : coll) {
            if (!fragment.equals(element.getDeclaringPluginFragment())) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public void unregisterContext(String id) {
        this.shadowUrlMap.remove(id);
        this.unpackModeMap.remove(id);
        super.unregisterContext(id);
    }

    @Override
    public URL resolvePath(Identity idt, String path) {
        URL baseUrl;
        if (idt instanceof PluginDescriptor) {
            baseUrl = this.getBaseUrl((PluginDescriptor)idt);
        } else if (idt instanceof PluginFragment) {
            baseUrl = this.getBaseUrl((PluginFragment)idt);
        } else if (idt instanceof PluginElement) {
            PluginElement element = (PluginElement)idt;
            baseUrl = element.getDeclaringPluginFragment() != null ? this.getBaseUrl(element.getDeclaringPluginFragment()) : this.getBaseUrl(element.getDeclaringPluginDescriptor());
        } else {
            throw new IllegalArgumentException("unknown identity class " + idt.getClass().getName());
        }
        return this.resolvePath(baseUrl, path);
    }

    protected synchronized URL getBaseUrl(UniqueIdentity uid) {
        URL result = this.shadowUrlMap.get(uid.getId());
        if (result != null) {
            return result;
        }
        result = this.controller.shadowResource(this.getRegisteredContext(uid.getId()), uid.getUniqueId(), this.unpackModeMap.get(uid.getId()));
        this.shadowUrlMap.put(uid.getId(), result);
        return result;
    }
}

