/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.common.Event;
import bizcal.swing.CalendarView;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import bizcal.util.Tuple;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import lu.tudor.santec.bizcal.util.ObservableEventList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EventModel
extends CalendarModel.BaseImpl
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventModel.class);
    private static final I18n I18N = I18nFactory.getI18n(EventModel.class);
    public static final int TYPE_DAY = 1;
    public static final int TYPE_WEEK = 2;
    public static final int TYPE_MONTH = 3;
    public static final int TYPE_THREE_DAY = 4;
    private DateFormat weekNumberFormat = new SimpleDateFormat("'" + I18N.tr("week") + "' w", Locale.getDefault());
    private DateFormat monthFormatter = new SimpleDateFormat("MMMMMM yyyy", Locale.getDefault());
    private ObservableEventList events = null;
    private DateInterval interval;
    private Calendar cal;
    private int days = 1;
    private CalendarView calendarView;
    private int type;
    private Tuple hourInterval;
    private int weekStart = 2;
    private int weekEnd = 1;

    public EventModel(int n) {
        this(null, n, null);
    }

    public EventModel(int n, Tuple tuple) {
        this(null, n, tuple);
    }

    public EventModel(List list, int n) {
        this(list, n, null);
    }

    public EventModel(List list, int n, Tuple tuple) {
        this.type = n;
        this.events = (ObservableEventList)list;
        this.hourInterval = tuple;
        if (list == null) {
            this.events = new ObservableEventList();
        }
        this.events.addObserver(this);
        this.cal = new Calendar();
        this.cal.setId(this.hashCode());
        this.setDate(DateUtil.getStartOfWeek(new Date()));
    }

    @Override
    public List<Event> getEvents(Object object) throws Exception {
        return this.events;
    }

    @Override
    public List getSelectedCalendars() throws Exception {
        return Collections.nCopies(1, this.cal);
    }

    @Override
    public DateInterval getInterval() {
        return this.interval;
    }

    public void setWeekdayStartEnd(int n, int n2) {
        this.weekStart = n;
        this.weekEnd = n2;
        this.days = DateUtil.getDiffDay(this.weekStart, this.weekEnd);
        this.setDate(new Date());
    }

    public void setDate(Date date) {
        try {
            Date date2 = null;
            Date date3 = null;
            switch (this.type) {
                case 1: {
                    date2 = DateUtil.round2Day(date);
                    date3 = DateUtil.getDiffDay(date2, this.days);
                    this.cal.setSummary(I18N.tr("day view"));
                    break;
                }
                case 2: {
                    date2 = DateUtil.setDayOfWeek(date, this.weekStart);
                    date3 = DateUtil.getDiffDay(date2, this.days);
                    this.cal.setSummary(I18N.tr("week view") + " - " + this.weekNumberFormat.format(date2));
                    break;
                }
                case 3: {
                    date2 = DateUtil.round2Month(date);
                    date3 = DateUtil.getDiffDay(date2, 31);
                    this.cal.setSummary(I18N.tr("month view") + " - " + this.monthFormatter.format(date2));
                    break;
                }
                case 4: {
                    date2 = DateUtil.round2Day(date);
                    date3 = DateUtil.getDiffDay(date2, this.days);
                    this.cal.setSummary(I18N.tr("three day view") + " - " + this.weekNumberFormat.format(date2));
                    break;
                }
            }
            if (this.hourInterval != null) {
                this.setViewStart(new TimeOfDay(DateUtil.round2Hour(date2, (Integer)this.hourInterval.elementAt(0))));
                this.setViewEnd(new TimeOfDay(DateUtil.round2Hour(date3, (Integer)this.hourInterval.elementAt(1))));
            }
            this.interval = new DateInterval(date2, date3);
            this.refresh();
        }
        catch (Exception exception) {
            LOGGER.error("Can't set date.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void addEvent(Event event) {
        if (event != null) {
            this.events.add(event);
        }
    }

    public void addCalendarView(CalendarView calendarView) {
        this.calendarView = calendarView;
        this.events.notifyObservers();
    }

    @Override
    public void update(Observable observable, Object object) {
        try {
            this.calendarView.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void triggerUpdate() {
        this.events.trigger();
    }

    public int getType() {
        return this.type;
    }

    public int getDays() {
        return this.days;
    }
}

