/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.RepaintManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintUtilities
implements Printable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintUtilities.class);
    private Component componentToBePrinted;
    private HashPrintRequestAttributeSet aset;

    public static void printComponent(Component component, boolean bl, boolean bl2) {
        new PrintUtilities(component, bl2).print(bl);
    }

    public PrintUtilities(Component component, boolean bl) {
        this.componentToBePrinted = component;
        this.aset = new HashPrintRequestAttributeSet();
        if (bl) {
            this.aset.add(OrientationRequested.LANDSCAPE);
        } else {
            this.aset.add(OrientationRequested.PORTRAIT);
        }
    }

    public void print(boolean bl) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (bl) {
            if (printerJob.printDialog()) {
                try {
                    printerJob.print(this.aset);
                }
                catch (PrinterException printerException) {
                    LOGGER.error("Printing failed.");
                    LOGGER.error("> " + printerException.getLocalizedMessage(), (Throwable)printerException);
                }
            }
        } else {
            try {
                printerJob.print(this.aset);
            }
            catch (PrinterException printerException) {
                LOGGER.error("Printing failed.");
                LOGGER.error("> " + printerException.getLocalizedMessage(), (Throwable)printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = pageFormat.getImageableWidth() / (double)this.componentToBePrinted.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)this.componentToBePrinted.getHeight();
        graphics2D.scale(d, d2);
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paintAll(graphics2D);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

