/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.atlanticbb.tantlinger.ui.text.ElementWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HTMLUtils {
    private static final Tidy tidy = new Tidy();

    public static boolean isImplied(Element element) {
        return element.getName().equals("p-implied");
    }

    public static String createTag(HTML.Tag tag, String string) {
        return HTMLUtils.createTag(tag, new SimpleAttributeSet(), string);
    }

    public static String createTag(HTML.Tag tag, AttributeSet attributeSet, String string) {
        String string2 = HTMLUtils.tagOpen(tag, attributeSet) + string + HTMLUtils.tagClose(tag);
        return string2;
    }

    private static String tagOpen(HTML.Tag tag, AttributeSet attributeSet) {
        String string = "<" + tag;
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj.toString().equals("name")) continue;
            Object object = attributeSet.getAttribute(obj);
            string = string + " " + obj + "=\"" + object + "\"";
        }
        return string + ">";
    }

    private static String tagClose(HTML.Tag tag) {
        return "</" + tag + ">";
    }

    public static List getParagraphElements(JEditorPane jEditorPane) {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        try {
            HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            Element element = HTMLUtils.getParaElement(hTMLDocument, jEditorPane.getSelectionStart());
            Element element2 = HTMLUtils.getParaElement(hTMLDocument, jEditorPane.getSelectionEnd());
            while (element.getEndOffset() <= element2.getEndOffset()) {
                linkedList.add(element);
                if ((element = HTMLUtils.getParaElement(hTMLDocument, element.getEndOffset() + 1)).getEndOffset() < hTMLDocument.getLength()) continue;
                break;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return linkedList;
    }

    private static Element getParaElement(HTMLDocument hTMLDocument, int n) {
        Element element = hTMLDocument.getParagraphElement(n);
        while (HTMLUtils.isImplied(element)) {
            element = element.getParentElement();
        }
        Element element2 = HTMLUtils.getListParent(element);
        if (element2 != null) {
            element = element2;
        }
        return element;
    }

    public static Element getParent(Element element, HTML.Tag tag) {
        for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
            if (!element2.getName().equals(tag.toString())) continue;
            return element2;
        }
        return null;
    }

    public static boolean isElementEmpty(Element element) {
        String string = HTMLUtils.getElementHTML(element, false).trim();
        return string.length() == 0;
    }

    public static Element getListParent(Element element) {
        for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
            if (!element2.getName().toUpperCase().equals("UL") && !element2.getName().toUpperCase().equals("OL") && !element2.getName().equals("dl") && !element2.getName().equals("menu") && !element2.getName().equals("dir")) continue;
            return element2;
        }
        return null;
    }

    public static Element getPreviousElement(HTMLDocument hTMLDocument, Element element) {
        if (element.getStartOffset() > 0) {
            return hTMLDocument.getParagraphElement(element.getStartOffset() - 1);
        }
        return element;
    }

    public static Element getNextElement(HTMLDocument hTMLDocument, Element element) {
        if (element.getEndOffset() < hTMLDocument.getLength()) {
            return hTMLDocument.getParagraphElement(element.getEndOffset() + 1);
        }
        return element;
    }

    public static String removeEnclosingTags(Element element, String string) {
        HTML.Tag tag = HTML.getTag(element.getName());
        return HTMLUtils.removeEnclosingTags(tag, string);
    }

    public static String removeEnclosingTags(HTML.Tag tag, String string) {
        int n;
        String string2 = "<" + tag;
        String string3 = "</" + tag + ">";
        if ((string = string.trim()).startsWith(string2) && (n = string.indexOf(">")) != -1) {
            string = string.substring(n + 1, string.length());
        }
        if (string.endsWith(string3)) {
            string = string.substring(0, string.length() - string3.length());
        }
        return string;
    }

    public static String getElementHTML(Element element, boolean bl) {
        String string = "";
        try {
            StringWriter stringWriter = new StringWriter();
            ElementWriter elementWriter = new ElementWriter((Writer)stringWriter, element);
            elementWriter.write();
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            return string;
        }
        return HTMLUtils.removeEnclosingTags(element, string);
    }

    public static void removeElement(Element element) throws BadLocationException {
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        int n = element.getStartOffset();
        int n2 = element.getEndOffset() - n;
        Element element2 = HTMLUtils.getParent(element, HTML.Tag.TD);
        if (element2 != null && element.getEndOffset() == element2.getEndOffset()) {
            hTMLDocument.remove(n, n2 - 1);
        } else {
            if (element.getEndOffset() > hTMLDocument.getLength()) {
                n2 = hTMLDocument.getLength() - n;
            }
            hTMLDocument.remove(n, n2);
        }
    }

    public static HTML.Tag getStartTag(String string) {
        String string2 = string.trim();
        int n = string2.indexOf(60);
        if (n != 0) {
            return null;
        }
        int n2 = string2.indexOf(62);
        if (n2 == -1) {
            return null;
        }
        String string3 = string2.substring(1, n2).trim();
        if (string3.indexOf(32) != -1) {
            string3 = string3.split("\\s")[0];
        }
        return HTML.getTag(string3);
    }

    private static int depthFromRoot(Element element) {
        Element element2 = element;
        int n = 0;
        while (element2 != null && !element2.getName().equals("body") && !element2.getName().equals("td")) {
            element2 = element2.getParentElement();
            ++n;
        }
        return n;
    }

    public static void insertArbitraryHTML(String string, JEditorPane jEditorPane) {
        tidy.setOutputEncoding("UTF-8");
        tidy.setInputEncoding("UTF-8");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            Document document = tidy.parseDOM((InputStream)byteArrayInputStream, null);
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList != null) {
                Node node = nodeList.item(0);
                NodeList nodeList2 = node.getChildNodes();
                int n = nodeList2.getLength();
                for (int i = 0; i < n; ++i) {
                    String string2 = HTMLUtils.xmlToString(nodeList2.item(i));
                    if (string2 == null) continue;
                    HTML.Tag tag = HTMLUtils.getStartTag(string2);
                    if (tag == null) {
                        tag = HTML.Tag.SPAN;
                        string2 = "<span>" + string2 + "</span>";
                    }
                    HTMLUtils.insertHTML(string2, tag, jEditorPane);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    private static String xmlToString(Node node) {
        try {
            DOMSource dOMSource = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(dOMSource, streamResult);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        return null;
    }

    public static void insertHTML(String string, HTML.Tag tag, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument;
        HTMLEditorKit hTMLEditorKit;
        try {
            hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        int n = jEditorPane.getCaretPosition();
        Element element = hTMLDocument.getParagraphElement(n);
        boolean bl = tag.breaksFlow() || tag.isBlock();
        boolean bl2 = n == element.getStartOffset();
        string = HTMLUtils.jEditorPaneizeHTML(string);
        try {
            if (bl && bl2) {
                hTMLDocument.insertBeforeStart(element, "<p></p>");
                Element element2 = hTMLDocument.getParagraphElement(n + 1);
                hTMLEditorKit.insertHTML(hTMLDocument, n + 1, string, HTMLUtils.depthFromRoot(element2), 0, tag);
                hTMLDocument.remove(n, 1);
            } else if (bl && !bl2) {
                hTMLEditorKit.insertHTML(hTMLDocument, n, string, HTMLUtils.depthFromRoot(element), 0, tag);
            } else if (!bl && bl2) {
                hTMLDocument.insertAfterStart(element, "&nbsp;");
                hTMLEditorKit.insertHTML(hTMLDocument, n + 1, string, 0, 0, tag);
                hTMLDocument.remove(n, 1);
            } else if (!bl && !bl2) {
                hTMLEditorKit.insertHTML(hTMLDocument, n, string, 0, 0, tag);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static AttributeSet getCharacterAttributes(JEditorPane jEditorPane) {
        int n = jEditorPane.getSelectedText() != null ? jEditorPane.getSelectionEnd() - 1 : (jEditorPane.getCaretPosition() > 0 ? jEditorPane.getCaretPosition() - 1 : 0);
        try {
            StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
            return styledDocument.getCharacterElement(n).getAttributes();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static String getFontFamily(JEditorPane jEditorPane) {
        AttributeSet attributeSet = HTMLUtils.getCharacterAttributes(jEditorPane);
        if (attributeSet != null) {
            AttributeSet attributeSet2;
            Object object = attributeSet.getAttribute(StyleConstants.FontFamily);
            if (object != null) {
                return object.toString();
            }
            object = attributeSet.getAttribute(CSS.Attribute.FONT_FAMILY);
            if (object != null) {
                return object.toString();
            }
            object = attributeSet.getAttribute(HTML.Tag.FONT);
            if (object != null && object instanceof AttributeSet && (object = (attributeSet2 = (AttributeSet)object).getAttribute(HTML.Attribute.FACE)) != null) {
                return object.toString();
            }
        }
        return null;
    }

    public static void setFontFamily(JEditorPane jEditorPane, String string) {
        AttributeSet attributeSet = HTMLUtils.getCharacterAttributes(jEditorPane);
        if (attributeSet == null) {
            return;
        }
        HTMLUtils.printAttribs(attributeSet);
        if (string == null) {
            SimpleAttributeSet simpleAttributeSet;
            Object object = attributeSet.getAttribute(HTML.Tag.FONT);
            if (object != null && object instanceof AttributeSet && (object = (simpleAttributeSet = new SimpleAttributeSet((AttributeSet)object)).getAttribute(HTML.Attribute.FACE)) != null) {
                simpleAttributeSet.removeAttribute(HTML.Attribute.FACE);
                HTMLUtils.removeCharacterAttribute(jEditorPane, HTML.Tag.FONT);
                if (simpleAttributeSet.getAttributeCount() > 0) {
                    SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
                    simpleAttributeSet2.addAttribute(HTML.Tag.FONT, simpleAttributeSet);
                    HTMLUtils.setCharacterAttributes(jEditorPane, simpleAttributeSet);
                }
            }
            HTMLUtils.removeCharacterAttribute(jEditorPane, StyleConstants.FontFamily);
            HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.FONT_FAMILY);
        } else {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string);
            HTMLUtils.setCharacterAttributes(jEditorPane, simpleAttributeSet);
        }
        HTMLUtils.printAttribs(attributeSet);
    }

    public static void removeCharacterAttribute(JEditorPane jEditorPane, CSS.Attribute attribute, String string) {
        MutableAttributeSet mutableAttributeSet;
        HTMLDocument hTMLDocument;
        try {
            hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            mutableAttributeSet = ((HTMLEditorKit)jEditorPane.getEditorKit()).getInputAttributes();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        List list = HTMLUtils.tokenizeCharAttribs(hTMLDocument, jEditorPane.getSelectionStart(), jEditorPane.getSelectionEnd());
        for (CharStyleToken charStyleToken : list) {
            if (!charStyleToken.attrs.isDefined(attribute) || !charStyleToken.attrs.getAttribute(attribute).toString().equals(string)) continue;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttributes(charStyleToken.attrs);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            simpleAttributeSet.removeAttribute(attribute);
            hTMLDocument.setCharacterAttributes(charStyleToken.offs, charStyleToken.len, simpleAttributeSet, true);
        }
        int n = jEditorPane.getCaretPosition();
        mutableAttributeSet.addAttributes(hTMLDocument.getCharacterElement(n).getAttributes());
        mutableAttributeSet.removeAttribute(attribute);
    }

    public static void removeCharacterAttribute(JEditorPane jEditorPane, Object object) {
        MutableAttributeSet mutableAttributeSet;
        HTMLDocument hTMLDocument;
        try {
            hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            mutableAttributeSet = ((HTMLEditorKit)jEditorPane.getEditorKit()).getInputAttributes();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        List list = HTMLUtils.tokenizeCharAttribs(hTMLDocument, jEditorPane.getSelectionStart(), jEditorPane.getSelectionEnd());
        for (CharStyleToken charStyleToken : list) {
            if (!charStyleToken.attrs.isDefined(object)) continue;
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttributes(charStyleToken.attrs);
            simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            simpleAttributeSet.removeAttribute(object);
            hTMLDocument.setCharacterAttributes(charStyleToken.offs, charStyleToken.len, simpleAttributeSet, true);
        }
        int n = jEditorPane.getCaretPosition();
        mutableAttributeSet.addAttributes(hTMLDocument.getCharacterElement(n).getAttributes());
        mutableAttributeSet.removeAttribute(object);
    }

    private static List tokenizeCharAttribs(HTMLDocument hTMLDocument, int n, int n2) {
        LinkedList<CharStyleToken> linkedList = new LinkedList<CharStyleToken>();
        CharStyleToken charStyleToken = new CharStyleToken();
        while (n <= n2) {
            AttributeSet attributeSet = hTMLDocument.getCharacterElement(n).getAttributes();
            if (charStyleToken.attrs == null || n + 1 <= n2 && !attributeSet.isEqual(charStyleToken.attrs)) {
                charStyleToken = new CharStyleToken();
                charStyleToken.offs = n;
                linkedList.add(charStyleToken);
                charStyleToken.attrs = attributeSet;
            }
            if (n + 1 <= n2) {
                ++charStyleToken.len;
            }
            ++n;
        }
        return linkedList;
    }

    public static void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
        StyledEditorKit styledEditorKit;
        HTMLDocument hTMLDocument;
        try {
            hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
            styledEditorKit = (StyledEditorKit)jEditorPane.getEditorKit();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        simpleAttributeSet.removeAttribute("CR");
        attributeSet = simpleAttributeSet;
        int n = jEditorPane.getSelectionStart();
        int n2 = jEditorPane.getSelectionEnd();
        if (n != n2) {
            hTMLDocument.setCharacterAttributes(n, n2 - n, attributeSet, bl);
        } else {
            if (bl) {
                attributeSet = attributeSet.copyAttributes();
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
    }

    public static void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet) {
        HTMLUtils.setCharacterAttributes(jEditorPane, attributeSet, false);
    }

    public static Map tagAttribsToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf(61);
            if (n == -1) {
                if (string2 == null) break;
                string3 = hashMap.get(string2).toString();
                hashMap.put(string2, string3 + " " + string4);
                continue;
            }
            string3 = string4.substring(0, n);
            String string5 = string4.substring(string4.indexOf(61) + 1, string4.length());
            if (string5.startsWith("\"")) {
                string5 = string5.substring(1, string5.length());
            }
            if (string5.endsWith("\"")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            hashMap.put(string3, string5);
            string2 = string3;
        }
        return hashMap;
    }

    public static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        return string;
    }

    public static Color hexToColor(String string) {
        Color color;
        String string2 = string.startsWith("#") ? string.substring(1, Math.min(string.length(), 7)) : string;
        String string3 = "0x" + string2;
        try {
            color = Color.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            color = Color.BLACK;
        }
        return color;
    }

    public static Color stringToColor(String string) {
        Color color = null;
        color = string.length() == 0 ? Color.black : (string.charAt(0) == '#' ? HTMLUtils.hexToColor(string) : (string.equalsIgnoreCase("Black") ? HTMLUtils.hexToColor("#000000") : (string.equalsIgnoreCase("Silver") ? HTMLUtils.hexToColor("#C0C0C0") : (string.equalsIgnoreCase("Gray") ? HTMLUtils.hexToColor("#808080") : (string.equalsIgnoreCase("White") ? HTMLUtils.hexToColor("#FFFFFF") : (string.equalsIgnoreCase("Maroon") ? HTMLUtils.hexToColor("#800000") : (string.equalsIgnoreCase("Red") ? HTMLUtils.hexToColor("#FF0000") : (string.equalsIgnoreCase("Purple") ? HTMLUtils.hexToColor("#800080") : (string.equalsIgnoreCase("Fuchsia") ? HTMLUtils.hexToColor("#FF00FF") : (string.equalsIgnoreCase("Green") ? HTMLUtils.hexToColor("#008000") : (string.equalsIgnoreCase("Lime") ? HTMLUtils.hexToColor("#00FF00") : (string.equalsIgnoreCase("Olive") ? HTMLUtils.hexToColor("#808000") : (string.equalsIgnoreCase("Yellow") ? HTMLUtils.hexToColor("#FFFF00") : (string.equalsIgnoreCase("Navy") ? HTMLUtils.hexToColor("#000080") : (string.equalsIgnoreCase("Blue") ? HTMLUtils.hexToColor("#0000FF") : (string.equalsIgnoreCase("Teal") ? HTMLUtils.hexToColor("#008080") : (string.equalsIgnoreCase("Aqua") ? HTMLUtils.hexToColor("#00FFFF") : HTMLUtils.hexToColor(string))))))))))))))))));
        return color;
    }

    public static String jEditorPaneizeHTML(String string) {
        return string.replaceAll("(<\\s*\\w+\\b[^>]*)/(\\s*>)", "$1$2");
    }

    public static void printAttribs(AttributeSet attributeSet) {
        System.err.println("----------------------------------------------------------------");
        System.err.println(attributeSet);
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            System.err.println(obj + " " + obj.getClass().getName() + " | " + object + " " + object.getClass().getName());
        }
        System.err.println("----------------------------------------------------------------");
    }

    static {
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        tidy.setForceOutput(true);
        tidy.setFixComments(true);
        tidy.setFixUri(true);
        tidy.setDropEmptyParas(true);
        tidy.setLiteralAttribs(true);
        tidy.setTrimEmptyElements(true);
        tidy.setXHTML(true);
    }

    private static class CharStyleToken {
        int offs;
        int len;
        AttributeSet attrs;

        private CharStyleToken() {
        }
    }
}

