/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLFontSizeAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int XXSMALL = 0;
    public static final int XSMALL = 1;
    public static final int SMALL = 2;
    public static final int MEDIUM = 3;
    public static final int LARGE = 4;
    public static final int XLARGE = 5;
    public static final int XXLARGE = 6;
    private static final String SML = i18n.str("small");
    private static final String MED = i18n.str("medium");
    private static final String LRG = i18n.str("large");
    public static final int[] FONT_SIZES = new int[]{8, 10, 12, 14, 18, 24, 36};
    public static final String[] SIZES = new String[]{"xx-" + SML, "x-" + SML, SML, MED, LRG, "x-" + LRG, "xx-" + LRG};
    private int size;

    public HTMLFontSizeAction(int n) throws IllegalArgumentException {
        super("");
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Invalid size");
        }
        this.size = n;
        this.putValue("Name", SIZES[n]);
        this.putValue("BUTTON_TYPE", "radio");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        AttributeSet attributeSet = HTMLUtils.getCharacterAttributes(jEditorPane);
        if (attributeSet.isDefined(StyleConstants.FontSize)) {
            this.setSelected(attributeSet.containsAttribute(StyleConstants.FontSize, new Integer(FONT_SIZES[this.size])));
        } else {
            this.setSelected(this.size == 3);
        }
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.setSelected(false);
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        String string = "<font size=" + (this.size + 1) + ">";
        String string2 = "</font>";
        String string3 = jEditorPane.getSelectedText();
        if (string3 == null) {
            jEditorPane.replaceSelection(string + string2);
            int n = jEditorPane.getCaretPosition() - string2.length();
            if (n >= 0) {
                jEditorPane.setCaretPosition(n);
            }
        } else {
            string3 = string + string3 + string2;
            jEditorPane.replaceSelection(string3);
        }
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        StyledEditorKit.FontSizeAction fontSizeAction = new StyledEditorKit.FontSizeAction(SIZES[this.size], FONT_SIZES[this.size]);
        fontSizeAction.actionPerformed(actionEvent);
    }
}

