/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.CompoundUndoManager;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;

public class HTMLInlineAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int EM = 0;
    public static final int STRONG = 1;
    public static final int CODE = 2;
    public static final int CITE = 3;
    public static final int SUP = 4;
    public static final int SUB = 5;
    public static final int BOLD = 6;
    public static final int ITALIC = 7;
    public static final int UNDERLINE = 8;
    public static final int STRIKE = 9;
    public static final String[] INLINE_TYPES = new String[]{i18n.str("emphasis"), i18n.str("strong"), i18n.str("code"), i18n.str("cite"), i18n.str("superscript"), i18n.str("subscript"), i18n.str("bold"), i18n.str("italic"), i18n.str("underline"), i18n.str("strikethrough")};
    private static final int[] MNEMS = new int[]{i18n.mnem("emphasis"), i18n.mnem("strong"), i18n.mnem("code"), i18n.mnem("cite"), i18n.mnem("superscript"), i18n.mnem("subscript"), i18n.mnem("bold"), i18n.mnem("italic"), i18n.mnem("underline"), i18n.mnem("strikethrough")};
    private int type;

    public HTMLInlineAction(int n) throws IllegalArgumentException {
        super("");
        this.type = n;
        if (this.type < 0 || this.type >= INLINE_TYPES.length) {
            throw new IllegalArgumentException("Illegal Argument");
        }
        this.putValue("Name", INLINE_TYPES[this.type]);
        this.putValue("MnemonicKey", new Integer(MNEMS[this.type]));
        ImageIcon imageIcon = null;
        KeyStroke keyStroke = null;
        if (this.type == 6) {
            imageIcon = UIUtils.getIcon("resources/images/x16/", "bold.png");
            keyStroke = KeyStroke.getKeyStroke(66, 2);
        } else if (this.type == 7) {
            imageIcon = UIUtils.getIcon("resources/images/x16/", "italic.png");
            keyStroke = KeyStroke.getKeyStroke(73, 2);
        } else if (this.type == 8) {
            imageIcon = UIUtils.getIcon("resources/images/x16/", "underline.png");
            keyStroke = KeyStroke.getKeyStroke(85, 2);
        }
        this.putValue("SmallIcon", imageIcon);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("BUTTON_TYPE", "checkbox");
        this.putValue("ShortDescription", this.getValue("Name"));
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        this.setSelected(this.isDefined(HTMLUtils.getCharacterAttributes(jEditorPane)));
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTML.Tag tag = this.getTag();
        String string = "<" + tag.toString() + ">";
        String string2 = "</" + tag.toString() + ">";
        String string3 = jEditorPane.getSelectedText();
        if (string3 == null) {
            jEditorPane.replaceSelection(string + string2);
            int n = jEditorPane.getCaretPosition() - string2.length();
            if (n >= 0) {
                jEditorPane.setCaretPosition(n);
            }
        } else {
            string3 = string + string3 + string2;
            jEditorPane.replaceSelection(string3);
        }
    }

    public HTML.Tag getTag() {
        return this.getTagForType(this.type);
    }

    private HTML.Tag getTagForType(int n) {
        HTML.Tag tag = null;
        switch (n) {
            case 0: {
                tag = HTML.Tag.EM;
                break;
            }
            case 1: {
                tag = HTML.Tag.STRONG;
                break;
            }
            case 2: {
                tag = HTML.Tag.CODE;
                break;
            }
            case 4: {
                tag = HTML.Tag.SUP;
                break;
            }
            case 5: {
                tag = HTML.Tag.SUB;
                break;
            }
            case 3: {
                tag = HTML.Tag.CITE;
                break;
            }
            case 6: {
                tag = HTML.Tag.B;
                break;
            }
            case 7: {
                tag = HTML.Tag.I;
                break;
            }
            case 8: {
                tag = HTML.Tag.U;
                break;
            }
            case 9: {
                tag = HTML.Tag.STRIKE;
            }
        }
        return tag;
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        CompoundUndoManager.beginCompoundEdit(jEditorPane.getDocument());
        this.toggleStyle(jEditorPane);
        CompoundUndoManager.endCompoundEdit(jEditorPane.getDocument());
    }

    private boolean isDefined(AttributeSet attributeSet) {
        boolean bl = false;
        if (this.type == 4) {
            bl = StyleConstants.isSuperscript(attributeSet);
        } else if (this.type == 5) {
            bl = StyleConstants.isSubscript(attributeSet);
        } else if (this.type == 6) {
            bl = StyleConstants.isBold(attributeSet);
        } else if (this.type == 7) {
            bl = StyleConstants.isItalic(attributeSet);
        } else if (this.type == 8) {
            bl = StyleConstants.isUnderline(attributeSet);
        } else if (this.type == 9) {
            bl = StyleConstants.isStrikeThrough(attributeSet);
        }
        return bl || attributeSet.getAttribute(this.getTag()) != null;
    }

    private void toggleStyle(JEditorPane jEditorPane) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttributes(HTMLUtils.getCharacterAttributes(jEditorPane));
        boolean bl = !this.isDefined(simpleAttributeSet);
        HTML.Tag tag = this.getTag();
        if (bl) {
            simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(tag, new SimpleAttributeSet());
            HTMLUtils.setCharacterAttributes(jEditorPane, simpleAttributeSet);
        } else {
            if (this.type == 6) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.FONT_WEIGHT, "bold");
            } else if (this.type == 7) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.FONT_STYLE, "italic");
            } else if (this.type == 8) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.TEXT_DECORATION, "underline");
            } else if (this.type == 9) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.TEXT_DECORATION, "line-through");
            } else if (this.type == 4) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.VERTICAL_ALIGN, "sup");
            } else if (this.type == 5) {
                HTMLUtils.removeCharacterAttribute(jEditorPane, CSS.Attribute.VERTICAL_ALIGN, "sub");
            }
            HTMLUtils.removeCharacterAttribute(jEditorPane, tag);
        }
        this.setSelected(bl);
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.setSelected(false);
    }
}

