/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.HTMLOptionDialog;
import net.atlanticbb.tantlinger.ui.text.dialogs.LinkPanel;

public class HyperlinkDialog
extends HTMLOptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "link.png");
    private static String title = i18n.str("hyperlink");
    private static String desc = i18n.str("hyperlink_desc");
    private static boolean showHeader = true;
    private LinkPanel linkPanel;

    public HyperlinkDialog(Frame frame) {
        this(frame, title, showHeader ? desc : null, showHeader ? icon : null, true);
    }

    public HyperlinkDialog(Dialog dialog) {
        this(dialog, title, showHeader ? desc : null, showHeader ? icon : null, true);
    }

    public HyperlinkDialog(Dialog dialog, String string, String string2, Icon icon, boolean bl) {
        super(dialog, string, string2, icon);
        this.init(bl);
    }

    public HyperlinkDialog(Frame frame, String string, String string2, Icon icon, boolean bl) {
        super(frame, string, string2, icon);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.linkPanel = new LinkPanel(bl);
        this.linkPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.linkPanel);
        if (showHeader) {
            this.setSize(315, 370);
        } else {
            this.setSize(315, 314);
        }
        this.setResizable(false);
    }

    public Map getAttributes() {
        return this.linkPanel.getAttributes();
    }

    public void setAttributes(Map map) {
        this.linkPanel.setAttributes(map);
    }

    public void setHiddenAttributes(Set set) {
        this.linkPanel.setHiddenAttributes(set);
    }

    public void setLinkText(String string) {
        this.linkPanel.setLinkText(string);
    }

    public String getLinkText() {
        return this.linkPanel.getLinkText();
    }

    @Override
    public String getHTML() {
        String string = "<a";
        Map map = this.getAttributes();
        for (Object k : map.keySet()) {
            string = string + " " + k + "=\"" + map.get(k) + "\"";
        }
        string = string + ">" + this.getLinkText() + "</a>";
        return string;
    }

    public static void setHeaderVisible(boolean bl) {
        showHeader = bl;
    }
}

