/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.db.DbContactsHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbContactsHandler
extends DbContactsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbContactsHandler.class);
    public static final String PROC_REMOVE_CONTACTS = "remove_openestate_contacts";
    public static final String PROC_SAVE_CONTACTS = "save_openestate_contacts";
    public static final String VIEW_CONTACTS = "view_openestate_contacts";
    public static final String FIELD_CONTACT_ID = "contact_id";
    public static final String FIELD_PERSON_FIRST_NAME = "person_first_name";
    public static final String FIELD_PERSON_MIDDLE_NAME = "person_middle_name";
    public static final String FIELD_PERSON_LAST_NAME = "person_last_name";
    public static final String FIELD_PERSON_TITLE = "person_title";
    public static final String FIELD_PERSON_GENDER = "person_gender";
    public static final String FIELD_PERSON_DATE_OF_BIRTH = "person_date_of_birth";
    public static final String FIELD_PERSON_MAIL = "person_mail";
    public static final String FIELD_PERSON_PHONE = "person_phone";
    public static final String FIELD_PERSON_MOBILE_PHONE = "person_mobile_phone";
    public static final String FIELD_PERSON_FAX = "person_fax";
    public static final String FIELD_ADDRESS_STREET = "address_street";
    public static final String FIELD_ADDRESS_STREET2 = "address_street2";
    public static final String FIELD_ADDRESS_STREET_NR = "address_street_nr";
    public static final String FIELD_ADDRESS_POSTAL_CODE = "address_postal_code";
    public static final String FIELD_ADDRESS_CITY = "address_city";
    public static final String FIELD_ADDRESS_DISTRICT = "address_district";
    public static final String FIELD_ADDRESS_COUNTRY = "address_country";
    public static final String FIELD_ADDRESS_REGION = "address_region";
    public static final String FIELD_ADDRESS_LATITUDE = "address_latitude";
    public static final String FIELD_ADDRESS_LONGITUDE = "address_longitude";
    public static final String FIELD_CONTACT_WEBSITE = "contact_website";
    public static final String FIELD_CONTACT_OFFICE_HOURS = "contact_office_hours";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    public HSqlDbContactsHandler() {
    }

    public HSqlDbContactsHandler(String string) {
        super(string);
    }

    protected DbContact buildContact(ResultSet resultSet) throws SQLException {
        DbContact dbContact = this.createContact();
        dbContact.id = resultSet.getLong(FIELD_CONTACT_ID);
        dbContact.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbContact.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbContact.item = new AgentContactImpl();
        dbContact.item.setId(String.valueOf(dbContact.id));
        dbContact.item.setContactOfficeHours(resultSet.getString(FIELD_CONTACT_OFFICE_HOURS));
        dbContact.item.setCity(resultSet.getString(FIELD_ADDRESS_CITY));
        dbContact.item.setCountry(resultSet.getString(FIELD_ADDRESS_COUNTRY));
        dbContact.item.setDistrict(resultSet.getString(FIELD_ADDRESS_DISTRICT));
        dbContact.item.setId(String.valueOf(resultSet.getLong(FIELD_CONTACT_ID)));
        dbContact.item.setPostalCode(resultSet.getString(FIELD_ADDRESS_POSTAL_CODE));
        dbContact.item.setRegion(resultSet.getString(FIELD_ADDRESS_REGION));
        dbContact.item.setStreet(resultSet.getString(FIELD_ADDRESS_STREET));
        dbContact.item.setStreet2(resultSet.getString(FIELD_ADDRESS_STREET2));
        dbContact.item.setStreetNr(resultSet.getString(FIELD_ADDRESS_STREET_NR));
        dbContact.item.setLatitude(resultSet.getObject(FIELD_ADDRESS_LATITUDE) != null ? resultSet.getBigDecimal(FIELD_ADDRESS_LATITUDE) : null);
        dbContact.item.setLongitude(resultSet.getObject(FIELD_ADDRESS_LONGITUDE) != null ? resultSet.getBigDecimal(FIELD_ADDRESS_LONGITUDE) : null);
        dbContact.item.setPersonDateOfBirth((java.util.Date)resultSet.getDate(FIELD_PERSON_DATE_OF_BIRTH));
        dbContact.item.setPersonFax(resultSet.getString(FIELD_PERSON_FAX));
        dbContact.item.setPersonFirstName(resultSet.getString(FIELD_PERSON_FIRST_NAME));
        dbContact.item.setPersonGender(Gender.fromShortValue((String)resultSet.getString(FIELD_PERSON_GENDER)));
        dbContact.item.setPersonLastName(resultSet.getString(FIELD_PERSON_LAST_NAME));
        dbContact.item.setPersonMail(resultSet.getString(FIELD_PERSON_MAIL));
        dbContact.item.setPersonMiddleName(resultSet.getString(FIELD_PERSON_MIDDLE_NAME));
        dbContact.item.setPersonMobilePhone(resultSet.getString(FIELD_PERSON_MOBILE_PHONE));
        dbContact.item.setPersonPhone(resultSet.getString(FIELD_PERSON_PHONE));
        dbContact.item.setPersonTitle(resultSet.getString(FIELD_PERSON_TITLE));
        String string = StringUtils.trimToNull((String)resultSet.getString(FIELD_CONTACT_WEBSITE));
        if (string != null) {
            try {
                dbContact.item.setContactWebsite(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read contact website URL!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
        }
        return dbContact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbContact[] getContacts(Connection connection, Boolean bl) throws SQLException {
        DbContact[] dbContactArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_CONTACTS) + " ORDER BY " + FIELD_CONTACT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_CONTACTS) + " WHERE " + FIELD_CONTACT_ID + " IN ( SELECT " + "object_id" + " FROM " + this.getSchemaPath("view_openestate_objects") + " WHERE " + FIELD_CONTACT_ID + " = ? ) ORDER BY " + FIELD_CONTACT_ID + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContact> arrayList = new ArrayList<DbContact>();
            while (resultSet.next()) {
                arrayList.add(this.buildContact(resultSet));
            }
            dbContactArray = arrayList.toArray(new DbContact[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbContact[] getContacts(Connection connection, long[] lArray) throws SQLException {
        DbContact[] dbContactArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbContact[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_CONTACTS) + " ORDER BY " + FIELD_CONTACT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_CONTACTS) + " WHERE " + FIELD_CONTACT_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_CONTACT_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbContact> arrayList = new ArrayList<DbContact>();
            while (resultSet.next()) {
                arrayList.add(this.buildContact(resultSet));
            }
            dbContactArray = arrayList.toArray(new DbContact[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbContactArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getContactIds(Connection connection, Boolean bl) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT contact_id FROM " + this.getSchemaPath(VIEW_CONTACTS) + " ORDER BY " + FIELD_CONTACT_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT contact_id FROM " + this.getSchemaPath(VIEW_CONTACTS) + " WHERE " + FIELD_CONTACT_ID + " IN ( SELECT " + "object_id" + " FROM " + this.getSchemaPath("view_openestate_objects") + " WHERE " + FIELD_CONTACT_ID + " = ? ) ORDER BY " + FIELD_CONTACT_ID + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_CONTACT_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    public void removeContacts(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_CONTACTS) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveContact(Connection connection, DbContact dbContact) throws SQLException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block19: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_CONTACTS) + "(:" + FIELD_CONTACT_ID + ", :" + FIELD_PERSON_FIRST_NAME + ", :" + FIELD_PERSON_MIDDLE_NAME + ", :" + FIELD_PERSON_LAST_NAME + ", :" + FIELD_PERSON_TITLE + ", :" + FIELD_PERSON_GENDER + ", :" + FIELD_PERSON_DATE_OF_BIRTH + ", :" + FIELD_PERSON_MAIL + ", :" + FIELD_PERSON_PHONE + ", :" + FIELD_PERSON_MOBILE_PHONE + ", :" + FIELD_PERSON_FAX + ", :" + FIELD_ADDRESS_STREET + ", :" + FIELD_ADDRESS_STREET2 + ", :" + FIELD_ADDRESS_STREET_NR + ", :" + FIELD_ADDRESS_POSTAL_CODE + ", :" + FIELD_ADDRESS_CITY + ", :" + FIELD_ADDRESS_DISTRICT + ", :" + FIELD_ADDRESS_COUNTRY + ", :" + FIELD_ADDRESS_REGION + ", :" + FIELD_ADDRESS_LATITUDE + ", :" + FIELD_ADDRESS_LONGITUDE + ", :" + FIELD_CONTACT_WEBSITE + ", :" + FIELD_CONTACT_OFFICE_HOURS + ");");
                namedCallableStatement.setLong(FIELD_CONTACT_ID, dbContact.id);
                namedCallableStatement.setString(FIELD_PERSON_FIRST_NAME, StringUtils.abbreviate((String)dbContact.item.getPersonFirstName(), (int)150));
                namedCallableStatement.setString(FIELD_PERSON_MIDDLE_NAME, StringUtils.abbreviate((String)dbContact.item.getPersonMiddleName(), (int)150));
                namedCallableStatement.setString(FIELD_PERSON_LAST_NAME, StringUtils.abbreviate((String)dbContact.item.getPersonLastName(), (int)150));
                namedCallableStatement.setString(FIELD_PERSON_TITLE, StringUtils.abbreviate((String)dbContact.item.getPersonTitle(), (int)50));
                namedCallableStatement.setString(FIELD_PERSON_MAIL, StringUtils.abbreviate((String)dbContact.item.getPersonMail(), (int)150));
                namedCallableStatement.setString(FIELD_PERSON_PHONE, StringUtils.abbreviate((String)dbContact.item.getPersonPhone(), (int)50));
                namedCallableStatement.setString(FIELD_PERSON_MOBILE_PHONE, StringUtils.abbreviate((String)dbContact.item.getPersonMobilePhone(), (int)50));
                namedCallableStatement.setString(FIELD_PERSON_FAX, StringUtils.abbreviate((String)dbContact.item.getPersonFax(), (int)50));
                namedCallableStatement.setString(FIELD_ADDRESS_STREET, StringUtils.abbreviate((String)dbContact.item.getStreet(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_STREET2, StringUtils.abbreviate((String)dbContact.item.getStreet2(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_STREET_NR, StringUtils.abbreviate((String)dbContact.item.getStreetNr(), (int)20));
                namedCallableStatement.setString(FIELD_ADDRESS_POSTAL_CODE, StringUtils.abbreviate((String)dbContact.item.getPostalCode(), (int)10));
                namedCallableStatement.setString(FIELD_ADDRESS_CITY, StringUtils.abbreviate((String)dbContact.item.getCity(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_DISTRICT, StringUtils.abbreviate((String)dbContact.item.getDistrict(), (int)150));
                namedCallableStatement.setString(FIELD_ADDRESS_REGION, StringUtils.abbreviate((String)dbContact.item.getRegion(), (int)150));
                namedCallableStatement.setString(FIELD_CONTACT_OFFICE_HOURS, dbContact.item.getContactOfficeHours());
                URI uRI = dbContact.item.getContactWebsite();
                if (uRI != null) {
                    namedCallableStatement.setString(FIELD_CONTACT_WEBSITE, StringUtils.abbreviate((String)uRI.toString(), (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_CONTACT_WEBSITE, 12);
                }
                String object = dbContact.item.getCountry();
                if (object != null && object.length() == 2) {
                    namedCallableStatement.setString(FIELD_ADDRESS_COUNTRY, object);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_COUNTRY, 12);
                }
                Gender gender = dbContact.item.getPersonGender();
                if (gender != null) {
                    namedCallableStatement.setString(FIELD_PERSON_GENDER, gender.getShortValue());
                } else {
                    namedCallableStatement.setNull(FIELD_PERSON_GENDER, 1);
                }
                java.util.Date date = dbContact.item.getPersonDateOfBirth();
                if (date != null) {
                    namedCallableStatement.setDate(FIELD_PERSON_DATE_OF_BIRTH, new Date(date.getTime()));
                } else {
                    namedCallableStatement.setNull(FIELD_PERSON_DATE_OF_BIRTH, 91);
                }
                BigDecimal bigDecimal = dbContact.item.getLatitude();
                BigDecimal bigDecimal2 = new BigDecimal("-90");
                BigDecimal bigDecimal3 = new BigDecimal("90");
                if (bigDecimal != null && bigDecimal.compareTo(bigDecimal2) >= 0 && bigDecimal.compareTo(bigDecimal3) <= 0) {
                    namedCallableStatement.setBigDecimal(FIELD_ADDRESS_LATITUDE, bigDecimal);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_LATITUDE, 3);
                }
                BigDecimal bigDecimal4 = dbContact.item.getLongitude();
                BigDecimal bigDecimal5 = new BigDecimal("-180");
                BigDecimal bigDecimal6 = new BigDecimal("180");
                if (bigDecimal4 != null && bigDecimal4.compareTo(bigDecimal5) >= 0 && bigDecimal4.compareTo(bigDecimal6) <= 0) {
                    namedCallableStatement.setBigDecimal(FIELD_ADDRESS_LONGITUDE, bigDecimal4);
                } else {
                    namedCallableStatement.setNull(FIELD_ADDRESS_LONGITUDE, 3);
                }
                namedCallableStatement.execute();
                long l2 = l = dbContact.id < 1L ? namedCallableStatement.getLong(FIELD_CONTACT_ID) : dbContact.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveContactAdditionally(connection, dbContact, l, arrayList);
                connection.commit();
                if (dbContact.id >= 1L) break block19;
                dbContact.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    protected void saveContactAdditionally(Connection connection, DbContact dbContact, long l, List<Statement> list) throws SQLException {
    }
}

