/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.agency.AgencyEstateExportDialog;
import com.openindex.openestate.tool.agency.AgencyEstateExportFields;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.utils.CsvExportTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateExportCsvTask
extends CsvExportTask<DbAgencyObject>
implements AgencyEstateExportFields {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateExportCsvTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateExportCsvTask.class);
    private OpenEstateAction estateAction;
    private OpenEstateType estateType;
    private DbAgencyObject.Status estateStatus;
    private PublishingMode imageMode;
    private Locale locale;
    private int fieldCount;
    private List<String> dynamicFields;
    private Connection dbConnection = null;
    private Map<Long, String> dbLanguages = null;

    public AgencyEstateExportCsvTask(AbstractDbDriver abstractDbDriver, File file, AgencyEstateExportDialog.ExportSettings exportSettings) {
        this(abstractDbDriver, file, exportSettings.charset, exportSettings.estateType, exportSettings.estateAction, exportSettings.estateStatus, exportSettings.imagePublishing, exportSettings.language);
    }

    public AgencyEstateExportCsvTask(AbstractDbDriver abstractDbDriver, File file, Charset charset, OpenEstateType openEstateType, OpenEstateAction openEstateAction, DbAgencyObject.Status status, PublishingMode publishingMode, Locale locale) {
        super(file, charset, abstractDbDriver);
        this.estateAction = openEstateAction;
        this.estateType = openEstateType;
        this.estateStatus = status;
        this.imageMode = publishingMode;
        this.locale = locale;
        this.fieldCount = 15;
        this.dynamicFields = new ArrayList<String>();
    }

    protected Long doInBackground() throws Exception {
        this.dbConnection = null;
        try {
            this.dbConnection = this.getDbDriver().getConnection();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            this.dbLanguages = dbLanguagesHandler.getLanguageMap(this.dbConnection, Boolean.valueOf(true));
            Long l = super.doInBackground();
            return l;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
        }
    }

    protected String getFieldTitle(int n) {
        switch (n) {
            case 4: {
                return StringUtils.capitalize((String)I18N.tr("marketing"));
            }
            case 0: {
                return StringUtils.capitalize((String)I18N.tr("ID"));
            }
            case 1: {
                return StringUtils.capitalize((String)I18N.tr("nr"));
            }
            case 5: {
                return StringUtils.capitalize((String)I18N.tr("status"));
            }
            case 2: {
                return StringUtils.capitalize((String)I18N.tr("title"));
            }
            case 3: {
                return StringUtils.capitalize((String)I18N.tr("type"));
            }
            case 9: {
                return StringUtils.capitalize((String)I18N.tr("place"));
            }
            case 10: {
                return StringUtils.capitalize((String)I18N.tr("district"));
            }
            case 11: {
                return StringUtils.capitalize((String)I18N.tr("country"));
            }
            case 13: {
                return StringUtils.capitalize((String)I18N.tr("latitude"));
            }
            case 14: {
                return StringUtils.capitalize((String)I18N.tr("longitude"));
            }
            case 8: {
                return StringUtils.capitalize((String)I18N.tr("postcode"));
            }
            case 12: {
                return StringUtils.capitalize((String)I18N.tr("region"));
            }
            case 6: {
                return StringUtils.capitalize((String)I18N.tr("street"));
            }
            case 7: {
                return StringUtils.capitalize((String)I18N.tr("street-nr"));
            }
        }
        if (n >= 15) {
            int n2 = n - 15;
            if (!this.dynamicFields.isEmpty() && n2 >= 0 && this.dynamicFields.size() > n2) {
                String[] stringArray = this.dynamicFields.get(n2).split("\\.");
                if ("image".equals(stringArray[0])) {
                    if ("file".equals(stringArray[1])) {
                        return I18N.tr("image file") + " (" + stringArray[2] + ")";
                    }
                    if ("title".equals(stringArray[1])) {
                        return I18N.tr("image title") + " (" + stringArray[2] + ")";
                    }
                    if ("type".equals(stringArray[1])) {
                        return I18N.tr("image type") + " (" + stringArray[2] + ")";
                    }
                    return null;
                }
                try {
                    OpenEstateAttrib openEstateAttrib = OpenEstateAttrib.valueOf((String)stringArray[0]);
                    String string = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib.getGroup().getTranslation(), (CharSequence)openEstateAttrib.getGroup().name());
                    String string2 = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib.getTranslation(), (CharSequence)openEstateAttrib.name());
                    return string + "-" + string2;
                }
                catch (Exception exception) {
                    LOGGER.warn("Unknown attribute: \"" + stringArray[0] + "\"!");
                    LOGGER.warn("> " + exception.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected DbAgencyObject[] loadCsvObjects() throws SQLException {
        void var10_22;
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbFilesHandler dbFilesHandler = AgencyPlugin.getDbAgencyExtension().getFilesHandler();
        DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
        this.setMessage("Ermittle Immobilien...");
        ArrayList<DbAgencyObject> arrayList = new ArrayList<DbAgencyObject>();
        Map map = dbLanguagesHandler.getLanguageMap(this.dbConnection, Boolean.valueOf(true));
        DbObject[] dbObjectArray = this.loadCsvObjects(this.dbConnection, dbAgencyObjectsHandler);
        dbAgencyObjectsHandler.loadObjectAttribs(this.dbConnection, dbObjectArray, map);
        dbAgencyObjectsHandler.loadObjectTranslations(this.dbConnection, dbObjectArray, map);
        for (DbObject object : dbObjectArray) {
            Object[] objectArray;
            if (this.estateAction != null && !this.estateAction.equals((Object)object.item.getAction()) || this.estateType != null && !this.estateType.equals((Object)object.item.getType()) && !ArrayUtils.contains((Object[])(objectArray = object.item.getType().getParentPath()), (Object)this.estateType)) continue;
            arrayList.add((DbAgencyObject)object);
        }
        TreeMap treeMap = new TreeMap();
        EnumMap enumMap = new EnumMap(OpenEstateAttribGroup.class);
        for (DbAgencyObject dbAgencyObject : arrayList) {
            for (Object object : dbAgencyObject.item.getAttributes().values()) {
                String string;
                String string2;
                if (object.hasEmptyValue() || StringUtils.isEmpty((CharSequence)(string2 = object.getFormattedValue(this.locale)))) continue;
                OpenEstateAttribGroup openEstateAttribGroup = object.getGroup();
                OpenEstateAttrib openEstateAttrib = object.getAttrib();
                if (!OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttribGroup) && !treeMap.containsValue(openEstateAttribGroup)) {
                    string = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttribGroup.getTranslation(this.locale), (CharSequence)openEstateAttribGroup.name());
                    treeMap.put(string, openEstateAttribGroup);
                }
                if (!enumMap.containsKey(openEstateAttribGroup)) {
                    enumMap.put(openEstateAttribGroup, new TreeMap());
                }
                if (((Map)enumMap.get(openEstateAttribGroup)).containsValue(openEstateAttrib)) continue;
                string = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib.getTranslation(this.locale), (CharSequence)openEstateAttrib.name());
                ((Map)enumMap.get(openEstateAttribGroup)).put(string, openEstateAttrib);
            }
        }
        int n = 0;
        if (this.imageMode != null && !PublishingMode.NEVER.equals((Object)this.imageMode)) {
            for (DbAgencyObject dbAgencyObject : arrayList) {
                Object object;
                object = dbFilesHandler.getFileIds(this.dbConnection, dbAgencyObject.id, PublishingMode.ALWAYS.equals((Object)this.imageMode) ? null : Boolean.valueOf(true), "image/jpeg");
                if (object == null || ((AbstractAttribImpl)object).length <= n) continue;
                n = ((AbstractAttribImpl)object).length;
            }
        }
        this.fieldCount = 15;
        this.dynamicFields.clear();
        for (OpenEstateAttribGroup openEstateAttribGroup : treeMap.values()) {
            for (String string2 : ((Map)enumMap.get(openEstateAttribGroup)).values()) {
                this.dynamicFields.add(string2.name());
                ++this.fieldCount;
            }
        }
        if (enumMap.containsKey(OpenEstateAttribGroup.DESCRIPTIONS)) {
            for (OpenEstateAttrib openEstateAttrib : ((Map)enumMap.get(OpenEstateAttribGroup.DESCRIPTIONS)).values()) {
                this.dynamicFields.add(openEstateAttrib.name());
                ++this.fieldCount;
            }
        }
        boolean bl = false;
        while (var10_22 < n) {
            this.dynamicFields.add("image.file." + (int)(var10_22 + true));
            ++this.fieldCount;
            this.dynamicFields.add("image.title." + (int)(var10_22 + true));
            ++this.fieldCount;
            this.dynamicFields.add("image.type." + (int)(var10_22 + true));
            ++this.fieldCount;
            ++var10_22;
        }
        return arrayList.toArray(new DbAgencyObject[0]);
    }

    protected DbObject[] loadCsvObjects(Connection connection, DbAgencyObjectsHandler dbAgencyObjectsHandler) throws SQLException {
        return dbAgencyObjectsHandler.getObjects(connection, this.estateStatus, null);
    }

    protected String[] loadEmptyContainer() {
        return new String[this.fieldCount];
    }

    protected void writeValues(DbAgencyObject dbAgencyObject, String[] stringArray) {
        int n;
        EstateImpl estateImpl = dbAgencyObject.item;
        DbFilesHandler dbFilesHandler = AgencyPlugin.getDbAgencyExtension().getFilesHandler();
        String string = stringArray[4] = estateImpl.getAction() != null ? estateImpl.getAction().getTranslation(this.locale) : null;
        if (dbAgencyObject.id > 0L) {
            stringArray[0] = String.valueOf(dbAgencyObject.id);
        }
        stringArray[1] = estateImpl.getPublicId();
        stringArray[5] = dbAgencyObject.status != null ? dbAgencyObject.status.getTranslation() : null;
        stringArray[2] = estateImpl.getTitle(this.locale);
        stringArray[3] = estateImpl.getType() != null ? estateImpl.getType().getTranslation(this.locale) : null;
        stringArray[9] = estateImpl.getAddress().getCity();
        stringArray[10] = estateImpl.getAddress().getDistrict();
        stringArray[11] = estateImpl.getAddress().getCountry();
        if (estateImpl.getAddress().getLatitude() != null) {
            stringArray[13] = estateImpl.getAddress().getLatitude().toString();
        }
        if (estateImpl.getAddress().getLongitude() != null) {
            stringArray[14] = estateImpl.getAddress().getLongitude().toString();
        }
        stringArray[8] = estateImpl.getAddress().getPostalCode();
        stringArray[12] = estateImpl.getAddress().getRegion();
        stringArray[6] = estateImpl.getAddress().getStreet();
        stringArray[7] = estateImpl.getAddress().getStreetNr();
        for (int i = 15; i < this.fieldCount; ++i) {
            String string2;
            OpenEstateAttrib openEstateAttrib;
            AbstractAttribImpl abstractAttribImpl;
            DbFile[] dbFileArray;
            n = i - 15;
            if (this.dynamicFields.isEmpty() || n < 0 || this.dynamicFields.size() <= n || (dbFileArray = this.dynamicFields.get(n)).startsWith("image.") || (abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib = OpenEstateAttrib.valueOf((String)dbFileArray))) == null || StringUtils.isBlank((CharSequence)(string2 = abstractAttribImpl.getFormattedValue(this.locale)))) continue;
            stringArray[i] = string2.replaceAll("\\r\\n|\\r|\\n", "<br>");
        }
        if (this.imageMode != null && !PublishingMode.NEVER.equals((Object)this.imageMode)) {
            try {
                DbFile[] dbFileArray = dbFilesHandler.getFiles(this.dbConnection, dbAgencyObject.id, PublishingMode.ALWAYS.equals((Object)this.imageMode) ? null : Boolean.valueOf(true), "image/jpeg");
                dbFilesHandler.loadFileTranslations(this.dbConnection, dbFileArray, this.dbLanguages);
                n = 0;
                for (DbFile dbFile : dbFileArray) {
                    File file = new File(this.getCsvFile().getParentFile().getAbsolutePath() + File.separator + dbAgencyObject.id + "_" + ++n + ".jpg");
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        dbFilesHandler.downloadContent(this.dbConnection, dbFile.id, (OutputStream)fileOutputStream);
                    }
                    int n2 = this.dynamicFields.indexOf("image.file." + n);
                    int n3 = this.dynamicFields.indexOf("image.title." + n);
                    int n4 = this.dynamicFields.indexOf("image.type." + n);
                    if (n2 > 0) {
                        stringArray[n2 + 15] = file.getName();
                    }
                    if (n3 > 0) {
                        stringArray[n3 + 15] = dbFile.getTitle(this.locale);
                    }
                    if (n4 <= 0) continue;
                    stringArray[n4 + 15] = dbFile.type != null ? dbFile.type.getTranslation(this.locale) : null;
                }
            }
            catch (Throwable throwable) {
                LOGGER.warn("Can't load attached image!");
                LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
            }
        }
    }
}

