/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.gui.OpenEstateTypeRenderer;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.CharsetRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyEstateExportDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateExportDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateExportDialog.class);
    private OpenEstateAction selectedEstateAction = null;
    private OpenEstateType selectedEstateType = null;
    private boolean submitted = false;
    private JLabel charsetLabel;
    private JComboBox<Charset> charsetField;
    private JLabel formatLabel;
    private JComboBox<Format> formatField;
    private JLabel imageLabel;
    private JComboBox<PublishingMode> imageField;
    private JLabel languageLabel;
    private LocaleComboBox languageField;
    private JCheckBox zipOptionField;
    private JPanel filterPanel;
    private JXTitledSeparator filterTitleLabel;
    private JLabel actionLabel;
    private JComboBox<OpenEstateAction> actionField;
    private JLabel statusLabel;
    private JComboBox<DbAgencyObject.Status> statusField;
    private JLabel typeLabel;
    private JComboBox<OpenEstateType> typeField;

    private AgencyEstateExportDialog(Frame frame, boolean bl) {
        super(frame);
        this.updateLocalization();
        this.updateActionBox(null, null);
        this.setFiltersSelectable(bl);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private AgencyEstateExportDialog(Dialog dialog, boolean bl) {
        super(dialog);
        this.updateLocalization();
        this.updateActionBox(null, null);
        this.setFiltersSelectable(bl);
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{new SubmitAction()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.charsetLabel = new JLabel();
        this.charsetField = new JComboBox();
        this.charsetField.setRenderer((ListCellRenderer<Charset>)new DefaultListCellRenderer((Renderer)new CharsetRenderer()));
        this.charsetField.setSelectedIndex(-1);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.charsetField.addItem(charset);
        }
        this.charsetField.setSelectedItem(Charset.defaultCharset());
        this.formatLabel = new JLabel();
        this.formatField = new JComboBox();
        this.formatField.setRenderer((ListCellRenderer<Format>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        for (Format format : Format.values()) {
            this.formatField.addItem(format);
        }
        this.formatField.setSelectedIndex(0);
        this.languageLabel = new JLabel();
        this.languageField = new LocaleComboBox(AgencyPlugin.getLocales(), false);
        this.languageField.setSelectedLocale(Locale.getDefault());
        this.imageLabel = new JLabel();
        this.imageField = new JComboBox();
        this.imageField.setRenderer((ListCellRenderer<PublishingMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<PublishingMode>(){

            public void render(PublishingMode publishingMode, JLabel jLabel) {
                if (publishingMode == null) {
                    jLabel.setText(this.getEmptyText());
                    return;
                }
                switch (publishingMode) {
                    case ALWAYS: {
                        jLabel.setText(I18N.tr("Save all images."));
                        break;
                    }
                    case DEFAULT: {
                        jLabel.setText(I18N.tr("Save published images."));
                        break;
                    }
                    case NEVER: {
                        jLabel.setText(I18N.tr("Don't save images."));
                        break;
                    }
                    default: {
                        jLabel.setText(this.getEmptyText());
                    }
                }
            }
        }));
        this.imageField.addItem(PublishingMode.NEVER);
        this.imageField.addItem(PublishingMode.DEFAULT);
        this.imageField.addItem(PublishingMode.ALWAYS);
        this.zipOptionField = new JCheckBox();
        this.zipOptionField.setOpaque(false);
        this.filterTitleLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.typeLabel = new JLabel();
        this.typeField = new JComboBox();
        this.typeField.setRenderer((ListCellRenderer<OpenEstateType>)new DefaultListCellRenderer((Renderer)new OpenEstateTypeRenderer(true){

            public String getEmptyText() {
                return "[ " + I18N.tr("all property types") + " ]";
            }
        }));
        this.typeField.addItem(null);
        TreeMap treeMap = new TreeMap();
        for (OpenEstateType object : OpenEstateType.getRootTypes()) {
            String string = (String)StringUtils.defaultIfBlank((CharSequence)object.getTranslation(), (CharSequence)object.name());
            treeMap.put(string, new ArrayList());
            ((List)treeMap.get(string)).add(object);
            TreeMap<String, OpenEstateType> treeMap2 = new TreeMap<String, OpenEstateType>();
            for (OpenEstateType openEstateType : object.getChildTypes()) {
                String string2 = (String)StringUtils.defaultIfBlank((CharSequence)openEstateType.getTranslation(), (CharSequence)openEstateType.name());
                treeMap2.put(string2, openEstateType);
            }
            if (treeMap2.isEmpty()) continue;
            ((List)treeMap.get(string)).addAll(treeMap2.values());
        }
        for (List list : treeMap.values()) {
            for (OpenEstateType openEstateType : list) {
                this.typeField.addItem(openEstateType);
            }
        }
        this.typeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AgencyEstateExportDialog.this.updateActionBox(AgencyEstateExportDialog.this.getSelectedEstateType(), AgencyEstateExportDialog.this.getSelectedEstateAction());
            }
        });
        this.actionLabel = new JLabel();
        this.actionField = new JComboBox();
        this.actionField.setRenderer((ListCellRenderer<OpenEstateAction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<OpenEstateAction>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("every marketing type") + " ]";
            }
        }));
        this.statusLabel = new JLabel();
        this.statusField = new JComboBox();
        this.statusField.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("every status") + " ]";
            }
        }));
        this.statusField.addItem(null);
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            this.statusField.addItem(status);
        }
        Object object = DefaultFormBuilder.create((String)"right:[30dlu,pref], 3dlu, pref:grow, 3dlu, right:pref, 3dlu, [30dlu,pref]");
        object.opaque(false);
        object.add((Component)this.formatLabel).xy(1, object.nextRow());
        object.add(this.formatField).xy(3, object.row());
        object.add((Component)this.charsetLabel).xy(5, object.row());
        object.add(this.charsetField).xy(7, object.row());
        object.add((Component)this.languageLabel).xy(1, object.nextRow());
        object.add((Component)this.languageField).xyw(3, object.row(), 5);
        object.add((Component)this.imageLabel).xy(1, object.nextRow());
        object.add(this.imageField).xyw(3, object.row(), 5);
        object.add((Component)this.zipOptionField).xyw(3, object.nextRow(), 5);
        JPanel jPanel = object.getPanel();
        object = DefaultFormBuilder.create((String)"right:[30dlu,pref], 3dlu, pref:grow");
        object.opaque(false);
        object.add((Component)this.filterTitleLabel).xyw(1, object.nextRow(), 3);
        object.add((Component)this.typeLabel).xy(1, object.nextRow());
        object.add(this.typeField).xy(3, object.row());
        object.add((Component)this.actionLabel).xy(1, object.nextRow());
        object.add(this.actionField).xy(3, object.row());
        object.add((Component)this.statusLabel).xy(1, object.nextRow());
        object.add(this.statusField).xy(3, object.row());
        this.filterPanel = new JPanel(new BorderLayout());
        this.filterPanel.setOpaque(false);
        this.filterPanel.add((Component)object.getPanel(), "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.filterPanel, "Center");
        return jPanel2;
    }

    private void doSubmit() {
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("save properties"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("save properties"));
    }

    private Charset getSelectedCharset() {
        return (Charset)this.charsetField.getSelectedItem();
    }

    private OpenEstateAction getSelectedEstateAction() {
        return this.filterPanel.isVisible() ? (OpenEstateAction)this.actionField.getSelectedItem() : null;
    }

    private DbAgencyObject.Status getSelectedEstateStatus() {
        return this.filterPanel.isVisible() ? (DbAgencyObject.Status)((Object)this.statusField.getSelectedItem()) : null;
    }

    private OpenEstateType getSelectedEstateType() {
        return this.filterPanel.isVisible() ? (OpenEstateType)this.typeField.getSelectedItem() : null;
    }

    private Format getSelectedFormat() {
        return (Format)((Object)this.formatField.getSelectedItem());
    }

    private PublishingMode getSelectedImagePublishing() {
        return (PublishingMode)((Object)this.imageField.getSelectedItem());
    }

    private Locale getSelectedLanguage() {
        return (Locale)this.languageField.getSelectedItem();
    }

    private ExportSettings getSelectedSettings() {
        return new ExportSettings(this.getSelectedFormat(), this.getSelectedCharset(), this.getSelectedLanguage(), this.getSelectedImagePublishing(), this.getSelectedEstateAction(), this.getSelectedEstateType(), this.getSelectedEstateStatus(), this.isZipExportSelected());
    }

    private boolean isZipExportSelected() {
        return this.zipOptionField.isSelected();
    }

    private void setFiltersSelectable(boolean bl) {
        this.filterPanel.setVisible(bl);
    }

    public static ExportSettings showDialog(Window window) {
        return AgencyEstateExportDialog.showDialog(true, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportSettings showDialog(boolean bl, Window window) {
        ExportSettings exportSettings;
        AgencyEstateExportDialog agencyEstateExportDialog = null;
        try {
            agencyEstateExportDialog = window instanceof Dialog ? new AgencyEstateExportDialog((Dialog)window, bl) : (window instanceof Frame ? new AgencyEstateExportDialog((Frame)window, bl) : new AgencyEstateExportDialog((Frame)null, bl));
            agencyEstateExportDialog.setVisible(true);
            exportSettings = agencyEstateExportDialog.submitted ? agencyEstateExportDialog.getSelectedSettings() : null;
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(agencyEstateExportDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)agencyEstateExportDialog));
        return exportSettings;
    }

    private void updateActionBox(OpenEstateType openEstateType, OpenEstateAction openEstateAction) {
        OpenEstateAction[] openEstateActionArray;
        this.selectedEstateType = openEstateType;
        this.selectedEstateAction = openEstateAction;
        this.actionField.setEnabled(false);
        this.actionField.removeAllItems();
        this.actionField.addItem(null);
        this.actionField.setSelectedIndex(0);
        for (OpenEstateAction openEstateAction2 : openEstateActionArray = this.selectedEstateType != null ? this.selectedEstateType.createImpl().getActions() : OpenEstateAction.values()) {
            this.actionField.addItem(openEstateAction2);
            if (!openEstateAction2.equals((Object)this.selectedEstateAction)) continue;
            this.actionField.setSelectedItem(openEstateAction2);
        }
        this.actionField.setEnabled(true);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.charsetLabel.setText(StringUtils.capitalize((String)I18N.tr("character-set")) + ":");
        this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
        this.imageLabel.setText(StringUtils.capitalize((String)I18N.tr("images")) + ":");
        this.languageLabel.setText(StringUtils.capitalize((String)I18N.tr("language")) + ":");
        this.zipOptionField.setText(I18N.tr("Save as ZIP file."));
        this.filterTitleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("filter criteria")));
        this.typeLabel.setText(StringUtils.capitalize((String)I18N.tr("property type")) + ":");
        this.actionLabel.setText(StringUtils.capitalize((String)I18N.tr("marketing type")) + ":");
        this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    public static enum Format implements Translatable
    {
        CSV(I18n.marktr((String)"CSV table"), new String[]{".csv"}),
        XLS(I18n.marktr((String)"Excel table"), new String[]{".xls"});

        private final String i18nKey;
        private final String[] extensions;

        private Format(String string2, String[] stringArray) {
            this.i18nKey = string2;
            this.extensions = stringArray;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyEstateExportDialog.class, (String)this.i18nKey, (Locale)locale);
        }

        public boolean isSupported(File file) {
            if (file == null || !file.isFile()) {
                return false;
            }
            String string = file.getName().toLowerCase();
            for (String string2 : this.extensions) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }

        public String writeExtensions() {
            return "*" + StringUtils.join((Object[])this.extensions, (String)", *");
        }
    }

    public static final class ExportSettings {
        public final Format format;
        public final Charset charset;
        public final Locale language;
        public final PublishingMode imagePublishing;
        public final OpenEstateAction estateAction;
        public final OpenEstateType estateType;
        public final DbAgencyObject.Status estateStatus;
        public final boolean zipped;

        public ExportSettings(Format format, Charset charset, Locale locale, PublishingMode publishingMode, OpenEstateAction openEstateAction, OpenEstateType openEstateType, DbAgencyObject.Status status, boolean bl) {
            this.format = format;
            this.charset = charset;
            this.language = locale;
            this.imagePublishing = publishingMode;
            this.estateAction = openEstateAction;
            this.estateType = openEstateType;
            this.estateStatus = status;
            this.zipped = bl;
        }

        public String getDefaultFileName() {
            String string = I18N.tr("properties") + "-" + System.currentTimeMillis();
            if (this.zipped) {
                return string + ".zip";
            }
            if (this.format != null) {
                return string + this.format.extensions[0];
            }
            return string;
        }

        public FileFilter getFileFilter() {
            return new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (ExportSettings.this.zipped && file.isFile() && !file.getName().toLowerCase().endsWith(".zip")) {
                        return false;
                    }
                    return ExportSettings.this.format == null || ExportSettings.this.format.isSupported(file);
                }

                @Override
                public String getDescription() {
                    if (ExportSettings.this.zipped) {
                        return I18N.tr("ZIP files") + " (*.zip)";
                    }
                    if (ExportSettings.this.format != null) {
                        return ExportSettings.this.format.getTranslation() + " (" + ExportSettings.this.format.writeExtensions() + ")";
                    }
                    return null;
                }
            };
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateExportDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateExportDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
        }
    }
}

