/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.gui.AgencyObjectRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateField
extends DefaultAutoCompleteField<DbAgencyObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateField.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateField.class);

    public AgencyEstateField() {
        this.setCustomValueAllowed(false);
        this.setMultipleSelectionAllowed(false);
        this.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)new AgencyObjectRenderer("-")));
        this.setAutoCompleteHandler(new Handler());
        DbAgencyObject dbAgencyObject = new DbAgencyObject();
        dbAgencyObject.item = new EstateImpl();
        dbAgencyObject.item.setTitle("example property", Locale.GERMAN);
        this.setAgencyObject(dbAgencyObject);
    }

    public DbAgencyObject getAgencyObject() {
        return (DbAgencyObject)((Object)this.getValue());
    }

    public void setAgencyObject(DbAgencyObject dbAgencyObject) {
        this.setValue((Object)dbAgencyObject);
    }

    private static final class Handler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbAgencyObject> {
        private Handler() {
        }

        public Dimension getOptionIconSize() {
            return new Dimension(16, 16);
        }

        public String getOptionText(DbAgencyObject dbAgencyObject) {
            if (dbAgencyObject != null) {
                return dbAgencyObject.print();
            }
            return "-";
        }

        public URL getOptionIconUrl(DbAgencyObject dbAgencyObject) {
            if (dbAgencyObject != null) {
                return AgencyPlugin.getResourceImageURL("agent_estates.png", 16);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbAgencyObject> search(String string) throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            Connection connection = null;
            try {
                Object object;
                connection = ImmoToolProject.getAppDbConnection();
                Object[] objectArray = dbAgencyObjectsHandler.getObjectsByKeyword(connection, string, 100);
                if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                    object = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
                    dbAgencyObjectsHandler.loadObjectAttribs(connection, (DbObject[])objectArray, (Map)object);
                    dbAgencyObjectsHandler.loadObjectTranslations(connection, (DbObject[])objectArray, (Map)object);
                }
                object = new ArrayList();
                for (Object object2 : objectArray) {
                    object.add((DbAgencyObject)((Object)object2));
                }
                Object object3 = object;
                return object3;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

