/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.db.DbContactsHandler;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyEstateContactTask;
import com.openindex.openestate.tool.agency.AgencyEstateExportCsvTask;
import com.openindex.openestate.tool.agency.AgencyEstateExportDialog;
import com.openindex.openestate.tool.agency.AgencyEstateExportFields;
import com.openindex.openestate.tool.agency.AgencyEstateExportXlsTask;
import com.openindex.openestate.tool.agency.AgencyEstateGeoDataTask;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyExposeDialog;
import com.openindex.openestate.tool.agency.AgencyExposeTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySearchDialog;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.extensions.EstateTableExtension;
import com.openindex.openestate.tool.agency.gui.AgencySearchRenderer;
import com.openindex.openestate.tool.agency.gui.OpenEstateTypeRenderer;
import com.openindex.openestate.tool.agency.utils.GeoAreaDialog;
import com.openindex.openestate.tool.agency.utils.GeoData;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyEstateTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateTablePanel.class);
    private static final String TABLE_ID = "AgencyEstateTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_NR = 1;
    private static final int FILTER_ADDRESS = 2;
    private static final int FILTER_TYPE = 3;
    private static final int FILTER_ACTION = 4;
    private static final int FILTER_STATUS = 5;
    private static final int COUNT_FILTERS = 6;
    private final List<DbAgencySearch> tempSearchRequests = new ArrayList<DbAgencySearch>();
    private DbAgencySearch currentSearch = null;
    private List<String> filterValues;
    private JLabel estateIdLabel;
    private JFormattedTextField estateIdField;
    private JLabel estateNrLabel;
    private JTextField estateNrField;
    private JLabel estateAddressLabel;
    private JTextField estateAddressField;
    private JLabel estateTypeLabel;
    private JComboBox<OpenEstateType> estateTypeField;
    private JComboBox<OpenEstateAction> estateActionField;
    private JLabel estateStatusLabel;
    private JComboBox<DbAgencyObject.Status> estateStatusField;
    private JLabel estateSearchLabel;
    private JComboBox<DbAgencySearch> estateSearchField;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction searchAction;

    private AgencyEstateTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new EstateAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            this.filterValues.add(null);
        }
        this.estateIdLabel = new JLabel();
        this.estateIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.estateIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!AgencyEstateTablePanel.this.estateIdField.isEnabled()) {
                    return;
                }
                try {
                    AgencyEstateTablePanel.this.estateIdField.commitEdit();
                }
                catch (Exception exception) {
                    AgencyEstateTablePanel.this.estateIdField.setValue(null);
                }
                String string2 = string = AgencyEstateTablePanel.this.estateIdField.isEditValid() ? AgencyEstateTablePanel.this.estateIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && AgencyEstateTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase((String)AgencyEstateTablePanel.this.filterValues.get(0))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(0, string);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateNrLabel = new JLabel();
        this.estateNrField = new JTextField();
        this.estateNrField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyEstateTablePanel.this.estateNrField.isEnabled()) {
                    return;
                }
                String string = AgencyEstateTablePanel.this.estateNrField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyEstateTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)AgencyEstateTablePanel.this.filterValues.get(1))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(1, string);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateAddressLabel = new JLabel();
        this.estateAddressLabel.setHorizontalAlignment(4);
        this.estateAddressField = new JTextField();
        this.estateAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyEstateTablePanel.this.estateAddressField.isEnabled()) {
                    return;
                }
                String string = AgencyEstateTablePanel.this.estateAddressField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyEstateTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (string.equalsIgnoreCase((String)AgencyEstateTablePanel.this.filterValues.get(2))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(2, string);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateTypeLabel = new JLabel();
        this.estateTypeField = new JComboBox();
        this.estateTypeField.setRenderer((ListCellRenderer<OpenEstateType>)new DefaultListCellRenderer((Renderer)new OpenEstateTypeRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("filter by type") + " ]";
            }
        }));
        this.estateTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateTablePanel.this.estateTypeField.isEnabled()) {
                    return;
                }
                OpenEstateType openEstateType = (OpenEstateType)AgencyEstateTablePanel.this.estateTypeField.getSelectedItem();
                if (openEstateType == null && AgencyEstateTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (openEstateType != null && openEstateType.name().equals(AgencyEstateTablePanel.this.filterValues.get(3))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(3, openEstateType != null ? openEstateType.name() : null);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateActionField = new JComboBox();
        this.estateActionField.setRenderer((ListCellRenderer<OpenEstateAction>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<OpenEstateAction>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("filter by marketing") + " ]";
            }
        }));
        this.estateActionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateTablePanel.this.estateActionField.isEnabled()) {
                    return;
                }
                OpenEstateAction openEstateAction = (OpenEstateAction)AgencyEstateTablePanel.this.estateActionField.getSelectedItem();
                if (openEstateAction == null && AgencyEstateTablePanel.this.filterValues.get(4) == null) {
                    return;
                }
                if (openEstateAction != null && openEstateAction.name().equals(AgencyEstateTablePanel.this.filterValues.get(4))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(4, openEstateAction != null ? openEstateAction.name() : null);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateStatusLabel = new JLabel();
        this.estateStatusField = new JComboBox();
        this.estateStatusField.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyObject.Status>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("filter by status") + " ]";
            }
        }));
        this.estateStatusField.addItem(null);
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            this.estateStatusField.addItem(status);
        }
        this.estateStatusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateTablePanel.this.estateStatusField.isEnabled()) {
                    return;
                }
                DbAgencyObject.Status status = (DbAgencyObject.Status)((Object)AgencyEstateTablePanel.this.estateStatusField.getSelectedItem());
                if (status == null && AgencyEstateTablePanel.this.filterValues.get(5) == null) {
                    return;
                }
                if (status != null && status.name().equalsIgnoreCase((String)AgencyEstateTablePanel.this.filterValues.get(5))) {
                    return;
                }
                AgencyEstateTablePanel.this.filterValues.set(5, status != null ? status.name() : null);
                AgencyEstateTablePanel.this.updateFilters(true);
            }
        });
        this.estateSearchLabel = new JLabel();
        this.estateSearchField = new JComboBox();
        this.estateSearchField.setRenderer((ListCellRenderer<DbAgencySearch>)new DefaultListCellRenderer((Renderer)new AgencySearchRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("search properties") + " ]";
            }
        }));
        this.estateSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateTablePanel.this.estateSearchField.isEnabled()) {
                    return;
                }
                AgencyEstateTablePanel.this.setSearch((DbAgencySearch)((Object)AgencyEstateTablePanel.this.estateSearchField.getSelectedItem()));
                AgencyEstateTablePanel.this.doRefresh();
            }
        });
        this.searchAction = new SearchAction();
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 25dlu, 3dlu, right:pref, 3dlu, 65dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.add((Component)this.estateIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.estateIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateNrLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateNrField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateTypeLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add(this.estateTypeField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateSearchLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.estateSearchField).xy(15, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JButton((Action)this.searchAction)).xy(17, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateAddressLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.estateAddressField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add(this.estateActionField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateStatusLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.estateStatusField).xyw(15, defaultFormBuilder.row(), 3);
        return defaultFormBuilder.getPanel();
    }

    public static AgencyEstateTablePanel createTab() {
        return AgencyEstateTablePanel.createTab(null);
    }

    public static AgencyEstateTablePanel createTab(DbAgencySearch dbAgencySearch) {
        AgencyEstateTablePanel agencyEstateTablePanel = new AgencyEstateTablePanel();
        if (dbAgencySearch != null) {
            agencyEstateTablePanel.setSearch(dbAgencySearch);
        }
        return agencyEstateTablePanel;
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){

            public boolean include(AgencyEstateTable.Row row) {
                OpenEstateAction openEstateAction = (OpenEstateAction)AgencyEstateTablePanel.this.estateActionField.getSelectedItem();
                return openEstateAction == null || openEstateAction.equals((Object)row.getObject().item.getAction());
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){

            public boolean include(AgencyEstateTable.Row row) {
                OpenEstateType openEstateType = (OpenEstateType)AgencyEstateTablePanel.this.estateTypeField.getSelectedItem();
                if (openEstateType == null) {
                    return true;
                }
                OpenEstateType openEstateType2 = row.getObject().item.getType();
                return openEstateType2.equals((Object)openEstateType) || ArrayUtils.contains((Object[])openEstateType.getChildTypes(true), (Object)openEstateType2);
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyEstateTable.Row row) {
                EstateAddressImpl estateAddressImpl;
                String string = StringUtils.trimToNull((String)AgencyEstateTablePanel.this.estateAddressField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 14.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(estateAddressImpl = row.getObject().item.getAddress()).getPostalCode())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)estateAddressImpl.getCity())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)estateAddressImpl.getDistrict())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)estateAddressImpl.getRegion())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)estateAddressImpl.writeStreet(true))).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){

            public boolean include(AgencyEstateTable.Row row) {
                Number number = AgencyEstateTablePanel.this.estateIdField.isEditValid() ? (Number)((Number)AgencyEstateTablePanel.this.estateIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getObject().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyEstateTable.Row row) {
                String string = StringUtils.trimToNull((String)AgencyEstateTablePanel.this.estateNrField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 16.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)row.getObject().item.getPublicId())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyEstateTable.Row>(){

            public boolean include(AgencyEstateTable.Row row) {
                DbAgencyObject.Status status = (DbAgencyObject.Status)((Object)AgencyEstateTablePanel.this.estateStatusField.getSelectedItem());
                return status == null || status.equals((Object)row.getObject().status);
            }
        });
        return this.table;
    }

    private void doEstateCopy() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to duplicate the selected properties?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateCopyTask(lArray), (Window)ImmoToolEnvironment.getFrame());
    }

    private void doEstateExport() {
        AgencyEstateExportFields agencyEstateExportFields;
        block15: {
            if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
                return;
            }
            if (this.table.getSelectedRowCount() < 1) {
                return;
            }
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (immoToolProject == null) {
                return;
            }
            File file = AgencyPlugin.getLastExportLocation();
            int[] nArray = this.table.getSelectedRows();
            long[] lArray = new long[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.table.convertRowIndexToModel(nArray[i]);
                lArray[i] = this.table.getEstateIdAt(n);
            }
            agencyEstateExportFields = null;
            try {
                File file2;
                File file3;
                AgencyEstateExportDialog.ExportSettings exportSettings = AgencyEstateExportDialog.showDialog(false, (Window)ImmoToolEnvironment.getFrame());
                if (exportSettings == null) {
                    return;
                }
                if (exportSettings.format == null) {
                    throw new NullPointerException("Invalid export format!");
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(I18N.tr("Where do you want to save the exported file?"));
                jFileChooser.setFileFilter(exportSettings.getFileFilter());
                jFileChooser.setSelectedFile(file != null ? new File(file.getAbsolutePath() + File.separator + exportSettings.getDefaultFileName()) : new File(exportSettings.getDefaultFileName()));
                int n = jFileChooser.showSaveDialog((Component)ImmoToolEnvironment.getFrame());
                if (n != 0) {
                    return;
                }
                AgencyPlugin.setLastExportLocation(jFileChooser.getSelectedFile().getParentFile());
                if (exportSettings.zipped) {
                    file3 = jFileChooser.getSelectedFile();
                    File file4 = new File(immoToolProject.getTempDirectory().getAbsolutePath() + File.separator + System.currentTimeMillis());
                    if (!file4.mkdir()) {
                        throw new Exception("Can't create temp directory!");
                    }
                    String string = file3.getName();
                    string = string.substring(0, string.lastIndexOf(".")) + "." + exportSettings.format.name().toLowerCase();
                    file2 = new File(file4.getAbsolutePath() + File.separator + string);
                } else {
                    file3 = null;
                    file2 = jFileChooser.getSelectedFile();
                }
                if (AgencyEstateExportDialog.Format.CSV.equals((Object)exportSettings.format)) {
                    agencyEstateExportFields = new EstateExportCsvTask(lArray, immoToolProject.getDbDriver(), file2, file3, exportSettings);
                    break block15;
                }
                if (AgencyEstateExportDialog.Format.XLS.equals((Object)exportSettings.format)) {
                    agencyEstateExportFields = new EstateExportXlsTask(lArray, immoToolProject.getDbDriver(), file2, file3, exportSettings);
                    break block15;
                }
                throw new Exception("Unsupported export format: '" + (Object)((Object)exportSettings.format) + "'!");
            }
            catch (Exception exception) {
                LOGGER.error("Can't export selected properties!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't export selected properties!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
            }
        }
        if (agencyEstateExportFields != null) {
            ImmoToolUtils.executeTask(agencyEstateExportFields);
        }
    }

    private void doEstateExpose() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        try {
            AgencyExposeTask exception = AgencyExposeDialog.showDialog(ImmoToolProject.getAppInstance(), ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0])), (Window)ImmoToolEnvironment.getFrame());
            if (exception != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)exception);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't create expos\u00e9!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't create expos\u00e9!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doEstateRemove() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_REMOVE)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to delete the selected properties?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new EstateRemoveTask(lArray));
    }

    private void doEstateSetContact() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            return;
        }
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler = AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler();
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateSetContactTask(lArray, immoToolProject, dbAgencyObjectsHandler, dbAgencyObjectLogsHandler), (Window)ImmoToolEnvironment.getFrame());
    }

    private void doEstateSetGeoData() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            return;
        }
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler = AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler();
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateSetGeoDataTask(lArray, immoToolProject, dbAgencyObjectsHandler, dbAgencyObjectLogsHandler), (Window)ImmoToolEnvironment.getFrame());
    }

    private void doEstateSetStatus(DbAgencyObject.Status status) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            return;
        }
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS)) {
            return;
        }
        if (DbAgencyObject.Status.PUBLISHED.equals((Object)status) && !AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.table.getSelectedRows()) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to change the status of the selected properties to {0}?", (Object)('\"' + status.getTranslation() + '\"')), (Component)((Object)this));
        if (!bl) {
            return;
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler = AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler();
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateSetStatusTask(lArray, status, immoToolProject, dbAgencyObjectsHandler, dbAgencyObjectLogsHandler), (Window)ImmoToolEnvironment.getFrame());
    }

    private void doEstateView() {
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES)) {
            return;
        }
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        int n2 = 0;
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            long l = this.table.getEstateIdAt(n4);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyEstateViewTask(ImmoToolProject.getAppDbDriver(), l, n == 1));
            if (++n2 >= 10) break;
        }
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.estates", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearRows();
        this.table.clearSelection();
        this.updateFilters(false);
        OpenEstateType openEstateType = (OpenEstateType)this.estateTypeField.getSelectedItem();
        this.estateTypeField.setEnabled(false);
        this.estateTypeField.removeAllItems();
        this.estateTypeField.addItem(null);
        this.estateTypeField.setSelectedIndex(0);
        OpenEstateAction openEstateAction = (OpenEstateAction)this.estateActionField.getSelectedItem();
        this.estateActionField.setEnabled(false);
        this.estateActionField.removeAllItems();
        this.estateActionField.addItem(null);
        this.estateActionField.setSelectedIndex(0);
        this.estateSearchField.setEnabled(false);
        this.estateSearchField.removeAllItems();
        this.estateSearchField.addItem(null);
        this.estateSearchField.setSelectedIndex(0);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        TreeSet<DbAgencySearch> treeSet = new TreeSet<DbAgencySearch>(new Comparator<DbAgencySearch>(){

            @Override
            public int compare(DbAgencySearch dbAgencySearch, DbAgencySearch dbAgencySearch2) {
                DbAgencySearch.Type type;
                DbAgencySearch.Type type2;
                if (dbAgencySearch == dbAgencySearch2) {
                    return 0;
                }
                DbAgencySearch.Type type3 = type2 = dbAgencySearch != null ? dbAgencySearch.type : null;
                if (type2 == null) {
                    type2 = DbAgencySearch.Type.TEMP;
                }
                DbAgencySearch.Type type4 = type = dbAgencySearch != null ? dbAgencySearch2.type : null;
                if (type == null) {
                    type = DbAgencySearch.Type.TEMP;
                }
                if (type2 != type) {
                    return type2.compareTo(type);
                }
                if (dbAgencySearch.item != null && dbAgencySearch2.item != null) {
                    return StringUtils.trimToEmpty((String)dbAgencySearch.item.getName()).compareToIgnoreCase(StringUtils.trimToEmpty((String)dbAgencySearch2.item.getName()));
                }
                return 0;
            }
        });
        try {
            void var16_28;
            void map;
            DbSearch dbSearch;
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            TreeMap<OpenEstateType[], OpenEstateAction> treeMap = new TreeMap<OpenEstateType[], OpenEstateAction>();
            for (OpenEstateAction openEstateAction2 : dbAgencyObjectsHandler.getObjectActions(connection)) {
                String string = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAction2.getTranslation(), (CharSequence)openEstateAction2.name());
                dbSearch = string.toLowerCase();
                int n = 0;
                while (treeMap.containsKey(dbSearch)) {
                    dbSearch = string.toLowerCase() + "_" + n++;
                }
                treeMap.put((OpenEstateType[])dbSearch, openEstateAction2);
            }
            arrayList2.addAll(treeMap.values());
            TreeMap treeMap2 = new TreeMap();
            OpenEstateType[] objectArray = dbAgencyObjectsHandler.getObjectTypes(connection);
            int object = objectArray.length;
            boolean dbSearch2 = false;
            while (map < object) {
                OpenEstateType openEstateType2 = objectArray[map];
                if (!treeMap2.containsValue(openEstateType2)) {
                    for (OpenEstateType openEstateType3 : openEstateType2.getParentPath()) {
                        String string;
                        if (treeMap2.containsValue(openEstateType3)) continue;
                        String string2 = string = openEstateType3.getTranslation().toLowerCase();
                        int n = 0;
                        while (treeMap2.containsKey(string2)) {
                            string2 = string + "_" + n++;
                        }
                        treeMap2.put(string2, openEstateType3);
                    }
                }
                ++map;
            }
            arrayList3.addAll(treeMap2.values());
            DbAgencySearch.Type[] typeArray = new DbAgencySearch.Type[]{DbAgencySearch.Type.SIDEBAR, DbAgencySearch.Type.TEMPLATE, DbAgencySearch.Type.TEMP};
            Object object2 = dbAgencySearchesHandler.getSearches(connection, (Boolean)true, typeArray);
            int n = ((DbSearch[])object2).length;
            boolean bl = false;
            while (var16_28 < n) {
                dbSearch = object2[var16_28];
                treeSet.add((DbAgencySearch)dbSearch);
                ++var16_28;
            }
            for (DbSearch dbSearch3 : this.tempSearchRequests) {
                treeSet.add((DbAgencySearch)dbSearch3);
            }
            if (this.currentSearch != null) {
                if (this.currentSearch.id > 0L) {
                    this.currentSearch = (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, this.currentSearch.id);
                    dbAgencySearchesHandler.loadAttribConditions(connection, this.currentSearch);
                    dbAgencySearchesHandler.loadValueConditions(connection, this.currentSearch);
                }
                object2 = dbAgencyObjectsHandler.getObjects(connection, this.currentSearch);
            } else {
                object2 = dbAgencyObjectsHandler.getObjects(connection);
            }
            Map map2 = dbLanguagesHandler.getLanguageMap(connection);
            dbAgencyObjectsHandler.loadObjectAttribs(connection, (DbObject[])object2, map2);
            dbAgencyObjectsHandler.loadObjectTranslations(connection, (DbObject[])object2, map2);
            arrayList.addAll(Arrays.asList(object2));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList3, openEstateType, arrayList2, openEstateAction, treeSet, arrayList){
                final /* synthetic */ List val$typesList;
                final /* synthetic */ OpenEstateType val$oldEstateType;
                final /* synthetic */ List val$actionsList;
                final /* synthetic */ OpenEstateAction val$oldEstateAction;
                final /* synthetic */ TreeSet val$searchesList;
                final /* synthetic */ List val$objectsList;
                {
                    this.val$typesList = list;
                    this.val$oldEstateType = openEstateType;
                    this.val$actionsList = list2;
                    this.val$oldEstateAction = openEstateAction;
                    this.val$searchesList = treeSet;
                    this.val$objectsList = list3;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (Object object : this.val$typesList) {
                            AgencyEstateTablePanel.this.estateTypeField.addItem(object);
                            if (this.val$oldEstateType == null || !this.val$oldEstateType.equals(object)) continue;
                            AgencyEstateTablePanel.this.estateTypeField.setSelectedIndex(AgencyEstateTablePanel.this.estateTypeField.getItemCount() - 1);
                        }
                        for (Object object : this.val$actionsList) {
                            AgencyEstateTablePanel.this.estateActionField.addItem(object);
                            if (this.val$oldEstateAction == null || !this.val$oldEstateAction.equals(object)) continue;
                            AgencyEstateTablePanel.this.estateActionField.setSelectedIndex(AgencyEstateTablePanel.this.estateActionField.getItemCount() - 1);
                        }
                        for (Object object : this.val$searchesList) {
                            AgencyEstateTablePanel.this.estateSearchField.addItem(object);
                            if (AgencyEstateTablePanel.this.currentSearch == null || ((AgencyEstateTablePanel)AgencyEstateTablePanel.this).currentSearch.id != object.id && AgencyEstateTablePanel.this.currentSearch != object) continue;
                            AgencyEstateTablePanel.this.estateSearchField.setSelectedIndex(AgencyEstateTablePanel.this.estateSearchField.getItemCount() - 1);
                        }
                        for (Object object : this.val$objectsList) {
                            DbAgencyObject dbAgencyObject = (DbAgencyObject)((Object)object);
                            AgencyEstateTablePanel.this.table.addRow(new AgencyEstateTable.Row(dbAgencyObject));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load table!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    finally {
                        AgencyEstateTablePanel.this.estateTypeField.setEnabled(true);
                        AgencyEstateTablePanel.this.estateActionField.setEnabled(true);
                        AgencyEstateTablePanel.this.estateSearchField.setEnabled(true);
                        AgencyEstateTablePanel.this.table.setEnabled(true);
                        AgencyEstateTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new EstateViewAction()));
        JMenu jMenu = new JMenu();
        jMenu.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS));
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("change status")));
        jMenu.setToolTipText(I18N.tr("Change the status of the selected properties."));
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            jMenu.add(new JMenuItem((Action)((Object)new EstateSetStatusAction(status))));
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.add((Action)((Object)new EstateCopyAction()));
        jPopupMenu.add((Action)((Object)new EstateRemoveAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new EstateExposeAction()));
        jPopupMenu.add((Action)((Object)new EstateSetContactAction()));
        jPopupMenu.add((Action)((Object)new EstateSetGeoDataAction()));
        jPopupMenu.add((Action)((Object)new EstateExportAction()));
        ArrayList arrayList = new ArrayList();
        for (int n3 : this.table.getSelectedRows()) {
            int n4 = this.table.convertRowIndexToModel(n3);
            arrayList.add(this.table.getEstateIdAt(n4));
        }
        Long[] longArray = arrayList.toArray(new Long[0]);
        int n5 = 0;
        for (EstateTableExtension estateTableExtension : this.table.getAddons()) {
            Object[] objectArray = estateTableExtension.getActions(longArray);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (n5 == 0) {
                    jPopupMenu.addSeparator();
                    n5 = 1;
                }
                jPopupMenu.add(new JMenuItem((Action)object));
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    public long getCurrentSearchId() {
        return this.currentSearch != null ? this.currentSearch.id : -1L;
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_estates.png", 32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of properties"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("properties"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of properties.");
    }

    protected String getTableTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
        this.searchAction.setEnabled(bl);
        this.estateActionField.setEnabled(bl);
        this.estateAddressField.setEnabled(bl);
        this.estateIdField.setEnabled(bl);
        this.estateNrField.setEnabled(bl);
        this.estateSearchField.setEnabled(bl);
        this.estateStatusField.setEnabled(bl);
        this.estateTypeField.setEnabled(bl);
    }

    public void setSearch(DbAgencySearch dbAgencySearch) {
        this.currentSearch = dbAgencySearch;
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.estateIdLabel.setText(StringUtils.capitalize((String)I18N.tr("ID")) + ":");
        this.estateNrLabel.setText(StringUtils.capitalize((String)I18N.tr("nr")) + ":");
        this.estateAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.estateTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("type")) + ":");
        this.estateStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
        this.estateSearchLabel.setText(StringUtils.capitalize((String)I18N.trc("search (noun)", "search")) + ":");
    }

    private class Table
    extends AgencyEstateTable<AgencyEstateTable.Row> {
        public Table() {
            super(AgencyEstateTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyEstateTablePanel.this.doEstateRemove();
        }

        protected void doSelect() {
            AgencyEstateTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyEstateTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyEstateTablePanel.this.doEstateView();
        }
    }

    private class SearchTask
    extends ImmoToolTask<DbAgencySearch, Void> {
        private SearchTask() {
        }

        protected DbAgencySearch doInBackground() throws Exception {
            return AgencySearchDialog.showDialog(ImmoToolProject.getAppInstance(), DbAgencySearch.Type.SIDEBAR, true, true, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load search request!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(DbAgencySearch dbAgencySearch) {
            super.succeeded((Object)dbAgencySearch);
            if (dbAgencySearch == null) {
                return;
            }
            if (dbAgencySearch.id < 1L) {
                AgencyEstateTablePanel.this.tempSearchRequests.add(dbAgencySearch);
            } else {
                new AgencyPlugin.SidebarRefreshAction().actionPerformed(null);
            }
            AgencyEstateTablePanel.this.setSearch(dbAgencySearch);
            AgencyEstateTablePanel.this.doRefresh();
        }
    }

    private class SearchAction
    extends AbstractI18nAction {
        private SearchAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new SearchTask());
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Create a new search request."));
        }
    }

    private class EstateViewAction
    extends AbstractI18nAction {
        private EstateViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the selected properties."));
        }
    }

    private class EstateSetStatusTask
    extends AgencyEstateStatusTask {
        private EstateSetStatusTask(long[] lArray, DbAgencyObject.Status status, ImmoToolProject immoToolProject, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
            super(lArray, status, immoToolProject.getDbDriver(), immoToolProject.getUser(), dbAgencyObjectsHandler, dbAgencyObjectLogsHandler);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change status of selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            AgencyEstateTablePanel.this.doRefresh();
        }
    }

    private class EstateSetStatusAction
    extends AbstractI18nAction {
        private final DbAgencyObject.Status status;

        private EstateSetStatusAction(DbAgencyObject.Status status) {
            this.status = status;
            if (DbAgencyObject.Status.PUBLISHED.equals((Object)status)) {
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING));
            } else {
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateSetStatus(this.status);
        }

        protected void updateLocalization() {
            this.setName(this.status.getTranslation());
        }
    }

    private class EstateSetGeoDataTask
    extends AgencyEstateGeoDataTask {
        private final ImmoToolProject project;

        private EstateSetGeoDataTask(long[] lArray, ImmoToolProject immoToolProject, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
            super(lArray, null, immoToolProject.getDbDriver(), immoToolProject.getUser(), dbAgencyObjectsHandler, dbAgencyObjectLogsHandler);
            this.project = immoToolProject;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
            GeoData geoData = GeoAreaDialog.showDialog(this.getParentWindow(), this.project.getDbDriver(), dbGeoHandler);
            if (geoData == null) {
                return false;
            }
            this.setGeoData(geoData);
            return super.doInBackground();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change geo data of selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyEstateTablePanel.this.doRefresh();
        }
    }

    private class EstateSetGeoDataAction
    extends AbstractI18nAction {
        private EstateSetGeoDataAction() {
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateSetGeoData();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("modify geo data")));
            this.setShortDescription(I18N.tr("Modify geo data of selected properties."));
        }
    }

    private class EstateSetContactTask
    extends AgencyEstateContactTask {
        private final ImmoToolProject project;

        private EstateSetContactTask(long[] lArray, ImmoToolProject immoToolProject, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
            super(lArray, 0L, immoToolProject.getDbDriver(), immoToolProject.getUser(), dbAgencyObjectsHandler, dbAgencyObjectLogsHandler);
            this.project = immoToolProject;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            String string = I18N.tr("Please select a contact person, that you want to assign to the selected properties.");
            Long l = AgencyContactDialog.showDialog(this.project.getDbDriver(), (DbContactsHandler)dbAgencyContactsHandler, string, (Window)ImmoToolEnvironment.getFrame());
            if (l == null) {
                return false;
            }
            this.setContactId(l);
            return super.doInBackground();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change contact person of selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void finished() {
            super.finished();
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyEstateTablePanel.this.doRefresh();
        }
    }

    private class EstateSetContactAction
    extends AbstractI18nAction {
        private EstateSetContactAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_family.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateSetContact();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("assign contact")));
            this.setShortDescription(I18N.tr("Assign a contact person to the selected properties."));
        }
    }

    private class EstateRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] estateIds;

        private EstateRemoveTask(long[] lArray) {
            super(I18N.tr("Removing selected properties."));
            this.estateIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                Object object = this.estateIds;
                int n = ((long[])object).length;
                for (int i = 0; i < n; ++i) {
                    Long l = object[i];
                    this.setMessage("#" + l);
                    DbAgencyObject dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, l);
                    if (dbAgencyObject == null) {
                        LOGGER.warn("Can't find estate #" + l);
                        continue;
                    }
                    dbAgencyObjectsHandler.removeObject(connection, dbAgencyObject.id);
                }
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete properties!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyEstateTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            for (long l : this.estateIds) {
                int n = AgencyEstateTablePanel.this.table.getRowForEstateId(l);
                if (n <= -1) continue;
                AgencyEstateTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class EstateRemoveAction
    extends AbstractI18nAction {
        private EstateRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected properties."));
        }
    }

    private class EstateExposeAction
    extends AbstractI18nAction {
        private EstateExposeAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_type_pdf.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateExpose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("create expos\u00e9")));
            this.setShortDescription(I18N.tr("Create an expos\u00e9 for the selected properties."));
        }
    }

    private class EstateExportXlsTask
    extends AgencyEstateExportXlsTask {
        private final long[] estateIds;
        private final File xlsFile;
        private final File zipFile;

        private EstateExportXlsTask(long[] lArray, AbstractDbDriver abstractDbDriver, File file, File file2, AgencyEstateExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, file, exportSettings);
            this.estateIds = lArray;
            this.xlsFile = file;
            this.zipFile = file2;
        }

        @Override
        protected Long doInBackground() throws Exception {
            Long l = super.doInBackground();
            if (this.zipFile != null) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFile));){
                    Object[] objectArray = this.xlsFile.getParentFile().listFiles();
                    if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                        for (Object object : objectArray) {
                            ImmoToolUtils.loadFileIntoZipStream((File)object, (ZipOutputStream)zipOutputStream);
                        }
                    }
                    zipOutputStream.flush();
                }
            }
            return l;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export selected properties!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            if (this.zipFile != null) {
                FileUtils.deleteQuietly((File)this.xlsFile.getParentFile());
            }
        }

        @Override
        protected DbObject[] loadXlsObjects(Connection connection, DbAgencyObjectsHandler dbAgencyObjectsHandler) throws SQLException {
            return dbAgencyObjectsHandler.getObjects(connection, this.estateIds);
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            String string = this.zipFile != null ? this.zipFile.getAbsolutePath() : this.xlsFile.getAbsolutePath();
            String string2 = "<html>" + I18N.tr("The selected properties were saved.") + "<br>" + I18N.tr("into file: {0}", (Object)StringUtils.abbreviateMiddle((String)string, (String)"...", (int)75)) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)((Object)AgencyEstateTablePanel.this));
        }
    }

    private class EstateExportCsvTask
    extends AgencyEstateExportCsvTask {
        private final long[] estateIds;
        private final File csvFile;
        private final File zipFile;

        private EstateExportCsvTask(long[] lArray, AbstractDbDriver abstractDbDriver, File file, File file2, AgencyEstateExportDialog.ExportSettings exportSettings) {
            super(abstractDbDriver, file, exportSettings);
            this.estateIds = lArray;
            this.csvFile = file;
            this.zipFile = file2;
        }

        @Override
        protected Long doInBackground() throws Exception {
            Long l = super.doInBackground();
            if (this.zipFile != null) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.zipFile));){
                    Object[] objectArray = this.csvFile.getParentFile().listFiles();
                    if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                        for (Object object : objectArray) {
                            ImmoToolUtils.loadFileIntoZipStream((File)object, (ZipOutputStream)zipOutputStream);
                        }
                    }
                    zipOutputStream.flush();
                }
            }
            return l;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't export selected properties!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            if (this.zipFile != null) {
                FileUtils.deleteQuietly((File)this.csvFile.getParentFile());
            }
        }

        @Override
        protected DbObject[] loadCsvObjects(Connection connection, DbAgencyObjectsHandler dbAgencyObjectsHandler) throws SQLException {
            return dbAgencyObjectsHandler.getObjects(connection, this.estateIds);
        }

        protected void succeeded(Long l) {
            super.succeeded((Object)l);
            String string = this.zipFile != null ? this.zipFile.getAbsolutePath() : this.csvFile.getAbsolutePath();
            String string2 = "<html>" + I18N.tr("The selected properties were saved.") + "<br>" + I18N.tr("into file: {0}", (Object)StringUtils.abbreviateMiddle((String)string, (String)"...", (int)75)) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)((Object)AgencyEstateTablePanel.this));
        }
    }

    private class EstateExportAction
    extends AbstractI18nAction {
        private EstateExportAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateExport();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save as")));
            this.setShortDescription(I18N.tr("Save the selected properties to harddisk."));
        }
    }

    private class EstateCopyTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] estateIds;

        private EstateCopyTask(long[] lArray) {
            super(I18N.tr("Duplicating selected properties."));
            this.estateIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbFilesHandler dbFilesHandler = AgencyPlugin.getDbAgencyExtension().getFilesHandler();
            DbLinksHandler dbLinksHandler = AgencyPlugin.getDbAgencyExtension().getLinksHandler();
            DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                Map map = dbLanguagesHandler.getLanguageMap(connection);
                Object object = this.estateIds;
                int n = ((long[])object).length;
                for (int i = 0; i < n; ++i) {
                    Long l = object[i];
                    this.setMessage("#" + l);
                    DbAgencyObject dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, l);
                    if (dbAgencyObject == null) {
                        LOGGER.warn("estate #" + l + " not found!");
                        continue;
                    }
                    dbAgencyObjectsHandler.loadObjectAttribs(connection, dbAgencyObject, map);
                    dbAgencyObjectsHandler.loadObjectTranslations(connection, dbAgencyObject, map);
                    dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject);
                    dbAgencyObjectsHandler.loadObjectGeoDbAreas(connection, dbAgencyObject, dbGeoHandler);
                    dbAgencyObject.id = 0L;
                    dbAgencyObject.item.setPublicId(null);
                    dbAgencyObjectsHandler.saveObject(connection, dbAgencyObject, map, true, true);
                    long l2 = dbAgencyObject.id;
                    if (l2 < 1L || l == l2) {
                        throw new Exception("Property  #" + l + " was not duplicated!");
                    }
                    DbFile[] dbFileArray = dbFilesHandler.getFiles(connection, l.longValue(), null, null);
                    dbFilesHandler.loadFileTranslations(connection, dbFileArray, map);
                    for (DbFile dbFile : dbFileArray) {
                        long l3 = dbFile.id;
                        File file = null;
                        File file2 = null;
                        try {
                            boolean bl;
                            boolean bl2;
                            file = File.createTempFile("attachment.", ".bin");
                            file.deleteOnExit();
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            Object object2 = null;
                            try {
                                bl2 = dbFilesHandler.downloadContent(connection, l3, (OutputStream)fileOutputStream);
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (fileOutputStream != null) {
                                    if (object2 != null) {
                                        try {
                                            ((OutputStream)fileOutputStream).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object2).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                }
                            }
                            file2 = File.createTempFile("attachment.", ".bin");
                            file2.deleteOnExit();
                            object2 = new FileOutputStream(file2);
                            Throwable throwable = null;
                            try {
                                bl = dbFilesHandler.downloadPreview(connection, l3, (OutputStream)object2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (object2 != null) {
                                    if (throwable != null) {
                                        try {
                                            ((OutputStream)object2).close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        ((OutputStream)object2).close();
                                    }
                                }
                            }
                            dbFile.id = 0L;
                            dbFile.objectId = l2;
                            dbFilesHandler.saveFile(connection, dbFile, bl2 ? file : null, bl ? file2 : null, map);
                        }
                        catch (Throwable throwable) {
                            FileUtils.deleteQuietly((File)file);
                            FileUtils.deleteQuietly(file2);
                            throw throwable;
                        }
                        FileUtils.deleteQuietly((File)file);
                        FileUtils.deleteQuietly((File)file2);
                    }
                    DbFile[] dbFileArray2 = dbLinksHandler.getLinks(connection, l.longValue(), null, null);
                    dbLinksHandler.loadLinkTranslations(connection, (DbLink[])dbFileArray2, map);
                    for (DbFile dbFile : dbFileArray2) {
                        dbFile.id = 0L;
                        dbFile.objectId = l2;
                        dbLinksHandler.saveLink(connection, (DbLink)dbFile, map);
                    }
                }
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't copy selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void finished() {
            super.finished();
            AgencyEstateTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            AgencyEstateTablePanel.this.doRefresh();
        }
    }

    private class EstateCopyAction
    extends AbstractI18nAction {
        private EstateCopyAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_copy.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateTablePanel.this.doEstateCopy();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("duplicate property")));
            this.setShortDescription(I18N.tr("Duplicate the selected properties."));
        }
    }

    private static class EstateAddAction
    extends AbstractI18nAction {
        private EstateAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AgencyPlugin.EstateFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new property."));
        }
    }
}

