/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportLogTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportLogTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportLogTable.class);

    public AgencyExportLogTable(String string) {
        super(string);
    }

    public AgencyExportLogTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public String getExportNameAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getExportName() : null;
    }

    public Long getLogIdAt(int n) {
        DbAgencyExportLog dbAgencyExportLog = this.getLogAt(n);
        return dbAgencyExportLog != null ? Long.valueOf(dbAgencyExportLog.id) : null;
    }

    public DbAgencyExportLog getLogAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getLog() : null;
    }

    public int getRowForLogId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getLogIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.setSingleSelection();
        this.setColumnControlVisible(true);
        super.init();
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbAgencyExportLog log;
        private final String exportName;

        public Row(DbAgencyExportLog dbAgencyExportLog, String string) {
            this.log = dbAgencyExportLog;
            this.exportName = string;
        }

        public String getExportName() {
            return this.exportName;
        }

        public DbAgencyExportLog getLog() {
            return this.log;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForLog((Column)column);
            }
            return null;
        }

        public Object getValueForLog(Column column) {
            if (this.log == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.log.id;
                }
                case TIME: {
                    return this.log.time;
                }
                case TITLE: {
                    return StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToEmpty((String)this.exportName), (CharSequence)("#" + this.log.id));
                }
                case TRANSFER: {
                    return this.log.transferMode != null ? this.log.transferMode.getTranslation() : I18N.tr("unknown");
                }
                case COUNT_INSERTS: {
                    return this.log.countInserts;
                }
                case COUNT_UPDATES: {
                    return this.log.countUpdates;
                }
                case COUNT_DELETES: {
                    return this.log.countDeletes;
                }
                case COUNT_ERRORS: {
                    return this.log.countErrors;
                }
                case COUNT_WARNINGS: {
                    return this.log.countWarnings;
                }
                case COUNT_NOTICES: {
                    return this.log.countNotices;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        TIME,
        TITLE,
        TRANSFER,
        COUNT_INSERTS,
        COUNT_UPDATES,
        COUNT_DELETES,
        COUNT_ERRORS,
        COUNT_WARNINGS,
        COUNT_NOTICES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case TIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3)));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: 
                case COUNT_INSERTS: 
                case COUNT_UPDATES: 
                case COUNT_DELETES: 
                case COUNT_ERRORS: 
                case COUNT_WARNINGS: 
                case COUNT_NOTICES: {
                    return Long.class;
                }
                case TIME: {
                    return Date.class;
                }
                case TITLE: 
                case TRANSFER: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case TIME: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("interface"));
                }
                case TRANSFER: {
                    return StringUtils.capitalize((String)I18N.tr("mode"));
                }
                case COUNT_INSERTS: {
                    return StringUtils.capitalize((String)I18N.tr("insertions"));
                }
                case COUNT_UPDATES: {
                    return StringUtils.capitalize((String)I18N.tr("updates"));
                }
                case COUNT_DELETES: {
                    return StringUtils.capitalize((String)I18N.tr("removals"));
                }
                case COUNT_ERRORS: {
                    return StringUtils.capitalize((String)I18N.tr("errors"));
                }
                case COUNT_WARNINGS: {
                    return StringUtils.capitalize((String)I18N.tr("warnings"));
                }
                case COUNT_NOTICES: {
                    return StringUtils.capitalize((String)I18N.tr("notices"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

