/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSettings;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.db.DbAdminHandler;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.LocaleRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencySetupLanguagePanel
extends ImmoToolSetupDialog.AbstractForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySetupLanguagePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySetupLanguagePanel.class);
    private static final String TABLE_ID = "AgencySetupLanguagePanel.Table";
    private JXTitledSeparator languageTitle;
    private JLabel languageInfoLabel;
    private Table languageTable;

    public AgencySetupLanguagePanel() {
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.languageTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.languageInfoLabel = new JLabel();
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"pref:grow");
        defaultFormBuilder.add((Component)this.languageTitle).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.languageInfoLabel).xy(1, defaultFormBuilder.nextRow());
        this.languageTable = new Table();
        try {
            TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
            for (String string : Locale.getISOLanguages()) {
                Locale locale = new Locale(string);
                treeMap.put(locale.getDisplayLanguage().toUpperCase(), locale);
            }
            for (Locale locale : treeMap.values()) {
                this.languageTable.addRow(new TableRow(locale, false));
            }
        }
        catch (Exception exception) {
            LOGGER.error("could not build language-table!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "North");
        this.add(this.languageTable.createScrollPane(), "Center");
    }

    public Locale[] getSelection() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (int i = 0; i < this.languageTable.getRowCount(); ++i) {
            if (!this.languageTable.isEnabledAt(i)) continue;
            arrayList.add(this.languageTable.getLocaleAt(i));
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new Locale[0]) : new Locale[]{};
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("languages"));
    }

    public boolean isProjectRequired() {
        return true;
    }

    public void load(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbAdminHandler dbAdminHandler = immoToolProject.getDbExtension().getAdminHandler();
        boolean bl = dbAdminHandler.isAdmin(connection);
        AgencyPlugin.loadSettings(immoToolProject, connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale locale : AgencyPlugin.getLocales()) {
            arrayList.add(locale.toString().toLowerCase());
        }
        for (int i = 0; i < this.languageTable.getRowCount(); ++i) {
            Locale locale = this.languageTable.getLocaleAt(i);
            int n = arrayList.contains(locale.toString().toLowerCase()) ? 1 : 0;
            this.languageTable.setEnabledAt(i, n != 0);
        }
        this.languageTable.packAll();
        this.languageTable.setEnabled(bl);
    }

    public void save(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbAdminHandler dbAdminHandler = immoToolProject.getDbExtension().getAdminHandler();
        boolean bl = dbAdminHandler.isAdmin(connection);
        if (bl) {
            Locale[] localeArray = this.getSelection();
            if (localeArray.length <= 0) {
                return;
            }
            AgencyPlugin.setLocales(localeArray);
            AgencyPlugin.saveSettings(connection, immoToolProject.getUser(), immoToolProject.getDbExtension());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.languageTitle.setTitle(StringUtils.capitalize((String)I18N.tr("manage property languages")));
        this.languageInfoLabel.setText("<html>" + I18N.tr("Select the languages from the following table, that you want to use for property management.") + "</html>");
    }

    private static class TableRow
    extends AbstractTable.Row {
        private final Locale locale;
        private boolean enabled;

        private TableRow(Locale locale, boolean bl) {
            this.locale = locale;
            this.enabled = bl;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof TableColumn) {
                return this.getValueForLanguage((TableColumn)column);
            }
            return null;
        }

        private Object getValueForLanguage(TableColumn tableColumn) {
            if (this.locale == null) {
                return null;
            }
            switch (tableColumn) {
                case LANGUAGE: {
                    return this.locale;
                }
                case CODE: {
                    return StringUtils.trimToEmpty((String)this.locale.getLanguage());
                }
                case ENABLED: {
                    return this.enabled;
                }
            }
            return null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setValueAt(Object object, AbstractTable.Column column) {
            if (TableColumn.ENABLED.equals(column)) {
                this.enabled = Boolean.TRUE.equals(object);
            }
        }
    }

    private static enum TableColumn implements AbstractTable.Column
    {
        ENABLED,
        LANGUAGE,
        CODE;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case LANGUAGE: {
                    return new DefaultTableCellRenderer((Renderer)new LocaleRenderer(true));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ENABLED: {
                    return Boolean.class;
                }
                case LANGUAGE: {
                    return Locale.class;
                }
                case CODE: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ENABLED: {
                    return StringUtils.capitalize((String)I18N.tr("active"));
                }
                case LANGUAGE: {
                    return StringUtils.capitalize((String)I18N.tr("language"));
                }
                case CODE: {
                    return StringUtils.capitalize((String)I18N.tr("code"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                case ENABLED: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private static class Table
    extends AbstractTable<TableRow, AbstractTable.Model<TableRow>> {
        public Table() {
            super(AgencySetupLanguagePanel.TABLE_ID);
        }

        private Locale getLocaleAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null ? tableRow.getLocale() : null;
        }

        private int getRowForLocale(Locale locale) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Locale locale2 = this.getLocaleAt(i);
                if (locale2 == null || !locale2.equals(locale)) continue;
                return i;
            }
            return -1;
        }

        protected void init() {
            this.setSingleSelection();
            this.setSortable(false);
            this.setEditable(true);
            this.setColumnControlVisible(false);
            super.init();
            TableColumnExt tableColumnExt = this.getColumn(TableColumn.ENABLED);
            if (tableColumnExt != null) {
                tableColumnExt.setMaxWidth(100);
                tableColumnExt.setMinWidth(50);
                tableColumnExt.setWidth(75);
            }
        }

        private boolean isEnabledAt(int n) {
            TableRow tableRow = (TableRow)this.getRow(n);
            return tableRow != null && tableRow.isEnabled();
        }

        protected List<AbstractTable.Column> listColumns() {
            return new ArrayList<AbstractTable.Column>(Arrays.asList(TableColumn.values()));
        }

        public void setEnabledAt(int n, Boolean bl) {
            TableRow tableRow = (TableRow)this.getRow(n);
            if (tableRow != null) {
                tableRow.setEnabled(bl);
            }
        }
    }
}

