/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyExportLogMessage
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyExportLogMessage.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyExportLogMessage.class);
    public long logId = 0L;
    public long objectId;
    public Level level;
    public String code;
    public String text;

    public DbAgencyExportLogMessage() {
        this(0L, null, null, null);
    }

    public DbAgencyExportLogMessage(long l, String string, String string2, Level level) {
        this.objectId = l;
        this.level = level != null ? level : Level.NOTICE;
        this.code = StringUtils.trimToNull((String)string2);
        this.text = StringUtils.trimToNull((String)string);
    }

    public static enum Level implements Translatable
    {
        NOTICE(I18n.marktr((String)"notice")),
        WARNING(I18n.marktr((String)"warning")),
        ERROR(I18n.marktr((String)"error"));

        private final String i18nKey;

        private Level(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(Level.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(Level.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

