/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.HttpTransport;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.HttpUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HttpTransportPanel
extends AbstractTransportPanel<HttpTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransportPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(HttpTransportPanel.class);
    private ValidationHandler validationHandler;
    private JLabel modeLabel;
    private JLabel httpUrlLabel;
    private JTextField httpUrlField;
    private JLabel httpUserLabel;
    private JTextField httpUserField;
    private JLabel httpPassLabel;
    private JPasswordField httpPassField;
    private JCheckBox httpAnonymousModeBox;
    private JRadioButton httpPutModeBox;
    private JRadioButton httpPostModeBox;
    private JRadioButton httpPostMultipartModeBox;
    private ButtonGroup httpModeGroup;
    private JLabel httpMultipartKeyLabel;
    private JTextField httpMultipartKeyField;
    private JXTitledSeparator httpTestTitle;
    private TestAction httpTestAction;
    private JXBusyLabel httpTestLabel;
    private TestTask httpTask = null;

    public HttpTransportPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modeLabel = new JLabel();
        this.httpUrlLabel = new JLabel();
        this.httpUrlField = new JTextField();
        this.httpUserLabel = new JLabel();
        this.httpUserField = new JTextField();
        this.httpPassLabel = new JLabel();
        this.httpPassField = new JPasswordField();
        this.httpAnonymousModeBox = new JCheckBox();
        this.httpAnonymousModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpUserField.setEnabled(!HttpTransportPanel.this.httpAnonymousModeBox.isSelected());
                HttpTransportPanel.this.httpPassField.setEnabled(!HttpTransportPanel.this.httpAnonymousModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpUserField);
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpPassField);
            }
        });
        this.httpPutModeBox = new JRadioButton();
        this.httpPutModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
        this.httpPostModeBox = new JRadioButton();
        this.httpPostModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
        this.httpPostMultipartModeBox = new JRadioButton();
        this.httpPostMultipartModeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpTransportPanel.this.httpMultipartKeyField.setEnabled(HttpTransportPanel.this.httpPostMultipartModeBox.isSelected());
                HttpTransportPanel.this.validationHandler.validate((JComponent)HttpTransportPanel.this.httpMultipartKeyField);
            }
        });
        this.httpModeGroup = new ButtonGroup();
        this.httpModeGroup.add(this.httpPutModeBox);
        this.httpModeGroup.add(this.httpPostModeBox);
        this.httpModeGroup.add(this.httpPostMultipartModeBox);
        this.httpMultipartKeyLabel = new JLabel();
        this.httpMultipartKeyField = new JTextField();
        this.httpMultipartKeyField.setEnabled(false);
        this.httpTestTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.httpTestAction = new TestAction();
        this.httpTestLabel = new JXBusyLabel();
        this.httpTestLabel.setVisible(false);
        this.validationHandler.putRule((JComponent)this.httpUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.httpUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.httpPassField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.httpMultipartKeyField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.httpUrlLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpUrlField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.httpAnonymousModeBox).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpUserLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpUserField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.httpPassLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpPassField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.modeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpPutModeBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.httpPostModeBox).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpPostMultipartModeBox).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpMultipartKeyLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpMultipartKeyField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)this.httpTestTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
        defaultFormBuilder.add((Component)new JButton((Action)((Object)this.httpTestAction))).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.httpTestLabel).xy(3, defaultFormBuilder.row());
        this.updateLocalization();
        this.load((DbAgencyExport)null, (HttpTransport)null);
    }

    private void doTest() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided transport settings are incomplete!"), (Component)((Object)this));
            return;
        }
        if (this.httpTask == null) {
            this.httpTestAction.setEnabled(false);
            this.httpTestLabel.setBusy(true);
            this.httpTestLabel.setText("<html><b>" + I18N.tr("Testing connection.") + "</b><br>" + I18N.tr("Please wait for a moment.") + "</html>");
            this.httpTestLabel.setVisible(true);
            this.httpTask = new TestTask();
            ImmoToolUtils.executeTask((ImmoToolTask)this.httpTask);
        } else if (!this.httpTask.isDone()) {
            this.httpTask.cancel(true);
        }
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, HttpTransport httpTransport) {
        if (this.httpTask != null && !this.httpTask.isDone()) {
            this.httpTask.cancel(true);
        }
        if (httpTransport == null) {
            this.httpAnonymousModeBox.setSelected(false);
            this.httpModeGroup.clearSelection();
            this.httpMultipartKeyField.setText("");
            this.httpMultipartKeyField.setEnabled(false);
            this.httpPassField.setText("");
            this.httpPassField.setEnabled(true);
            this.httpPostModeBox.setSelected(false);
            this.httpPostMultipartModeBox.setSelected(false);
            this.httpPutModeBox.setSelected(false);
            this.httpUrlField.setText("");
            this.httpUserField.setText("");
            this.httpUserField.setEnabled(true);
        } else {
            this.httpAnonymousModeBox.setSelected(!httpTransport.isHttpLogin());
            this.httpPassField.setEnabled(!this.httpAnonymousModeBox.isSelected());
            this.httpPassField.setText(httpTransport.getHttpLoginPass());
            this.httpUserField.setEnabled(!this.httpAnonymousModeBox.isSelected());
            this.httpUserField.setText(httpTransport.getHttpLoginUser());
            URI uRI = httpTransport.getHttpUrl();
            this.httpUrlField.setText(uRI != null ? uRI.toString() : "");
            HttpTransport.TransportMode transportMode = httpTransport.getHttpMode();
            if (HttpTransport.TransportMode.PUT.equals((Object)transportMode)) {
                this.httpPutModeBox.setSelected(true);
            } else if (HttpTransport.TransportMode.POST.equals((Object)transportMode)) {
                this.httpMultipartKeyField.setEnabled(httpTransport.isHttpPostMultipart());
                this.httpMultipartKeyField.setText(httpTransport.getHttpPostMultipartKey());
                this.httpPostModeBox.setSelected(true);
                this.httpPostMultipartModeBox.setSelected(httpTransport.isHttpPostMultipart());
            }
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, HttpTransport httpTransport) {
        if (httpTransport == null) {
            throw new NullPointerException("empty transport-class!");
        }
        if (this.httpTask != null && !this.httpTask.isDone()) {
            this.httpTask.cancel(true);
        }
        httpTransport.setHttpLogin(!this.httpAnonymousModeBox.isSelected());
        httpTransport.setHttpLoginUser(!this.httpAnonymousModeBox.isSelected() ? this.httpUserField.getText().trim() : "");
        httpTransport.setHttpLoginPass(!this.httpAnonymousModeBox.isSelected() ? String.valueOf(this.httpPassField.getPassword()).trim() : "");
        try {
            String string = this.httpUrlField.getText().trim();
            httpTransport.setHttpUrl(StringUtils.isNotBlank((CharSequence)string) ? new URI(string) : null);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("invalid http-url!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        if (this.httpPutModeBox.isSelected()) {
            httpTransport.setHttpMode(HttpTransport.TransportMode.PUT);
        } else if (this.httpPostModeBox.isSelected() || this.httpPostMultipartModeBox.isSelected()) {
            httpTransport.setHttpMode(HttpTransport.TransportMode.POST);
            httpTransport.setHttpPostMultipart(this.httpPostMultipartModeBox.isSelected());
            httpTransport.setHttpPostMultipartKey(httpTransport.isHttpPostMultipart() ? this.httpMultipartKeyField.getText() : "");
        } else {
            httpTransport.setHttpMode(null);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.httpUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("URL")) + ":");
        this.httpUrlField.setToolTipText(I18N.tr("Enter the URL of the server."));
        this.httpUserLabel.setText(StringUtils.capitalize((String)"user") + ":");
        this.httpUserField.setToolTipText(I18N.tr("Enter the user name for authentication at the server."));
        this.httpPassLabel.setText(StringUtils.capitalize((String)"password") + ":");
        this.httpPassField.setToolTipText(I18N.tr("Enter the password for authentication at the server."));
        this.httpAnonymousModeBox.setText(I18N.tr("Don't login at the server (anonymous connection)."));
        this.httpAnonymousModeBox.setToolTipText(I18N.tr("Enable this option, if the server does not require an authentication."));
        this.modeLabel.setText(StringUtils.capitalize((String)I18N.tr("mode")) + ":");
        this.httpPutModeBox.setText(I18N.tr("via PUT-request"));
        this.httpPutModeBox.setToolTipText(I18N.tr("Enable this option, to transfer the exported files via {0}.", (Object)"HTTP-PUT"));
        this.httpPostModeBox.setText(I18N.tr("via POST-request"));
        this.httpPostModeBox.setToolTipText(I18N.tr("Enable this option, to transfer the exported files via {0}.", (Object)"HTTP-POST"));
        this.httpPostMultipartModeBox.setText(I18N.tr("via POST-request form (multipart/form-data)"));
        this.httpPostMultipartModeBox.setToolTipText(I18N.tr("Enable this option, to transfer the exported files as 'multipart/form-data' request via HTTP-POST."));
        this.httpMultipartKeyLabel.setText(StringUtils.capitalize((String)I18N.tr("form variable")) + ":");
        this.httpMultipartKeyField.setToolTipText(I18N.tr("Enter the name of the form variable within the request."));
        this.httpTestTitle.setTitle(StringUtils.capitalize((String)I18N.tr("test connection")));
    }

    private class TestTask
    extends ImmoToolTask<Boolean, Void> {
        private int responseCode = -1;
        private String responseMsg = "";

        private TestTask() {
        }

        protected Boolean doInBackground() throws Exception {
            URI uRI = new URI(HttpTransportPanel.this.httpUrlField.getText().trim());
            if (!uRI.getScheme().equalsIgnoreCase("http") && !uRI.getScheme().equalsIgnoreCase("https")) {
                throw new Exception(I18N.tr("The URL must start with {0} or {1}!", (Object)"'http://'", (Object)"'https://'"));
            }
            HttpClientBuilder httpClientBuilder = HttpUtils.builder();
            if (!HttpTransportPanel.this.httpAnonymousModeBox.isSelected()) {
                httpClientBuilder.setDefaultCredentialsProvider(HttpUtils.createAuthentication((String)HttpTransportPanel.this.httpUserField.getText().trim(), (String)String.valueOf(HttpTransportPanel.this.httpPassField.getPassword()).trim()));
            }
            try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
                CloseableHttpResponse closeableHttpResponse;
                HttpGet httpGet;
                try {
                    httpGet = new HttpGet(ImmoToolUtils.toIdnUrl((URI)uRI));
                    closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
                    if (closeableHttpResponse == null) {
                        throw new Exception(I18N.tr("No response received from the server!"));
                    }
                    this.responseCode = closeableHttpResponse.getStatusLine().getStatusCode();
                    this.responseMsg = closeableHttpResponse.getStatusLine().getReasonPhrase();
                }
                catch (Exception exception) {
                    throw new Exception(I18N.tr("Can't execute request.") + " " + exception.getLocalizedMessage(), exception);
                }
                try {
                    httpGet = closeableHttpResponse.getEntity();
                    EntityUtils.consume((HttpEntity)httpGet);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't consume response!");
                    LOGGER.warn("> " + exception.getLocalizedMessage());
                }
            }
            return true;
        }

        protected void cancelled() {
            super.cancelled();
            HttpTransportPanel.this.httpTestLabel.setText("<html><b>" + I18N.tr("The connection test was cancelled!") + "</b></html>");
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            if (this.responseCode > -1) {
                LOGGER.error("http-error (" + this.responseCode + ")!");
                LOGGER.error("> " + this.responseMsg);
            }
            HttpTransportPanel.this.httpTestLabel.setText("<html><b>" + I18N.tr("The connection test failed!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
        }

        protected void finished() {
            super.finished();
            HttpTransportPanel.this.httpTask = null;
            HttpTransportPanel.this.httpTestLabel.setBusy(false);
            HttpTransportPanel.this.httpTestAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            HttpTransportPanel.this.httpTestLabel.setText("<html><b>" + I18N.tr("The connection test was successful!") + "</b></html>");
        }
    }

    private class TestAction
    extends AbstractI18nAction {
        private TestAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HttpTransportPanel.this.doTest();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Let the program try to connect to the configured server."));
        }
    }
}

