/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.immoxml.ImmoXmlWriter;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.ImmoXmlFormatPanel;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.xml.Aktion;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Anhang;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.openestate.io.immoxml.xml.Uebertragung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmoXmlFormat
extends AbstractXmlFormat<Immoxml> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmoXmlFormat.class);
    private static final String NAME = "immoxml";
    private static final String IMMOXML_AGENT_ID = "immoxml.agent.id";
    private static final String IMMOXML_ATTACHMENT_LOCATION = "immoxml.attachment.location";
    private static final String IMMOXML_PROPERTY_PUBLIC_ID_EXPORTED = "immoxml.property.publicId.exported";
    private static final String IMMOXML_TECHNICS_MAIL = "immoxml.technics.mail";

    protected ImmoXmlWriter buildWriter() {
        Writer writer = new Writer(this.getLanguage(), this.getPropertyPricePublication(), this.getImmoXmlAttachmentLocation());
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        AbstractXmlFormat.LineBreakMode lineBreakMode = this.getXmlLineBreak();
        if (lineBreakMode != null) {
            writer.setXmlLineSeparator(lineBreakMode.getSeparator());
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        Immoxml immoxml;
        Object object2;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object2 = this.buildWriter();
            object2.setXmlLineSeparator("<br/>");
            immoxml = (Immoxml)object2.writeToObject(agencyImpl);
            string = object2.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (immoxml == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        immoxml.setUebertragung(null);
        for (Object object322 : immoxml.getAnbieter()) {
            object322.setAnbieternr(null);
            object322.setAnhang(null);
            object322.setFirma(null);
            object322.setImmoxmlAnid(null);
            object322.setImpressum(null);
            for (String string2 : object322.getImmobilie()) {
                if (string2.getVerwaltungTechn() == null) continue;
                string2.getVerwaltungTechn().setStandVom(null);
            }
        }
        try {
            Object object322;
            object2 = new StringWriter();
            object322 = null;
            try {
                String string2;
                ImmoXmlUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)immoxml, (java.io.Writer)object2);
                String string3 = ((StringWriter)object2).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                string2 = DigestUtils.sha1Hex((String)string3);
                return string2;
            }
            catch (Throwable throwable) {
                object322 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object322 != null) {
                        try {
                            ((StringWriter)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object322).addSuppressed(throwable);
                        }
                    } else {
                        ((StringWriter)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new ImmoXmlFormatPanel();
    }

    @Override
    protected Immoxml convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        boolean bl = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
        ImmoXmlWriter immoXmlWriter = this.buildWriter();
        Immoxml immoxml = (Immoxml)immoXmlWriter.writeToObject(transferImpl);
        if (immoxml == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)this.getImmoXmlTechnicsMail());
        if (string == null && exportContext.agent != null) {
            try {
                string = StringUtils.trimToNull((String)exportContext.agent.getCompany().getCompanyMail());
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load 'techn_mail'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        immoxml.getUebertragung().setTechnEmail(string);
        immoxml.getUebertragung().setUmfang(bl ? Uebertragung.Umfang.TEIL : Uebertragung.Umfang.VOLL);
        String string2 = StringUtils.trimToNull((String)this.getAgentId());
        String string3 = StringUtils.trimToNull((String)this.getImmoXmlAgentId());
        if (string2 != null || string3 != null) {
            for (Object object : immoxml.getAnbieter()) {
                if (string2 != null) {
                    object.setAnbieternr(string2);
                }
                if (string3 == null) continue;
                object.setImmoxmlAnid(string3);
            }
        }
        if (!this.isImmoXmlPropertyPublicIdExported()) {
            for (Object object : immoxml.getAnbieter()) {
                for (Object object2 : object.getImmobilie()) {
                    if (object2.getVerwaltungTechn() == null) continue;
                    object2.getVerwaltungTechn().setObjektnrExtern(object2.getVerwaltungTechn().getObjektnrIntern());
                }
            }
        }
        if (this.isImmoXmlPropertyPublicIdExported()) {
            Object object = StringUtils.trimToNull((String)this.getPropertyPrefix());
            object = object != null ? (String)object + "-" : "";
            for (Anbieter anbieter : immoxml.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    try {
                        String string4;
                        if (immobilie.getVerwaltungTechn() == null || immobilie.getVerwaltungTechn().getAktion() == null || !Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart()) || StringUtils.isBlank((CharSequence)(string4 = immobilie.getVerwaltungTechn().getObjektnrIntern()))) continue;
                        if (((String)object).length() > 0) {
                            string4 = string4.substring(((String)object).length());
                        }
                        long l = Long.parseLong(string4.trim());
                        for (ExportEntry exportEntry : exportContext.entries) {
                            if (exportEntry.objectId != l || StringUtils.isBlank((CharSequence)exportEntry.objectNr)) continue;
                            immobilie.getVerwaltungTechn().setObjektnrExtern((String)object + exportEntry.objectNr);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't update public estate-id!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
        }
        exportContext.addErrorMessages(immoXmlWriter.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return immoxml;
    }

    public String getImmoXmlAgentId() {
        return StringUtils.trimToNull((String)((String)this.get(IMMOXML_AGENT_ID)));
    }

    public AbstractFormat.AttachmentMarker getImmoXmlAttachmentLocation() {
        String string = StringUtils.trimToNull((String)((String)this.get(IMMOXML_ATTACHMENT_LOCATION)));
        return string != null ? AbstractFormat.AttachmentMarker.valueOf(string.toUpperCase()) : null;
    }

    public String getImmoXmlTechnicsMail() {
        return StringUtils.trimToNull((String)((String)this.get(IMMOXML_TECHNICS_MAIL)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public String getTitle() {
        return "ImmoXML";
    }

    @Override
    public String getVersion() {
        return ImmoXmlUtils.VERSION.toReadableVersion();
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setImmoXmlPropertyPublicIdExported(true);
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
        this.setLanguages(new Locale[]{Locale.GERMAN});
        this.setPropertyAddressHiddenIfUnpublished(true);
    }

    public boolean isImmoXmlPropertyPublicIdExported() {
        String string = StringUtils.trimToNull((String)((String)this.get(IMMOXML_PROPERTY_PUBLIC_ID_EXPORTED)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    public final boolean isPropertyPublicId() {
        return false;
    }

    public void setImmoXmlAgentId(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(IMMOXML_AGENT_ID);
        } else {
            this.put(IMMOXML_AGENT_ID, string);
        }
    }

    public void setImmoXmlAttachmentLocation(AbstractFormat.AttachmentMarker attachmentMarker) {
        if (attachmentMarker == null) {
            this.remove(IMMOXML_ATTACHMENT_LOCATION);
        } else {
            this.put(IMMOXML_ATTACHMENT_LOCATION, attachmentMarker.name());
        }
    }

    public void setImmoXmlPropertyPublicIdExported(boolean bl) {
        this.put(IMMOXML_PROPERTY_PUBLIC_ID_EXPORTED, String.valueOf(bl));
    }

    public void setImmoXmlTechnicsMail(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(IMMOXML_TECHNICS_MAIL);
        } else {
            this.put(IMMOXML_TECHNICS_MAIL, string);
        }
    }

    @Override
    protected void writeXmlObject(Immoxml immoxml, java.io.Writer writer) throws IOException, JAXBException {
        try {
            ImmoXmlDocument immoXmlDocument = ImmoXmlDocument.newDocument((Immoxml)immoxml);
            immoXmlDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends ImmoXmlWriter {
        private final PublishingMode priceMode;
        private final AbstractFormat.AttachmentMarker attachmentMarker;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, PublishingMode publishingMode, AbstractFormat.AttachmentMarker attachmentMarker) {
            super(locale);
            this.priceMode = publishingMode != null ? publishingMode : PublishingMode.DEFAULT;
            this.attachmentMarker = attachmentMarker;
            AgencyPluginUtils.initJAXB(ImmoXmlUtils.class);
        }

        protected Immobilie convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
            boolean bl;
            Immobilie immobilie = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
            boolean bl2 = bl = PublishingMode.NEVER.equals((Object)this.priceMode) || PublishingMode.DEFAULT.equals((Object)this.priceMode) && estateImpl.isHiddenPrices();
            if (bl) {
                immobilie.setPreise(ImmoXmlUtils.getFactory().createPreise());
            }
            return immobilie;
        }

        protected Anhang createAnhang(EstateAttachmentImpl estateAttachmentImpl) {
            Anhang anhang = super.createAnhang(estateAttachmentImpl);
            if (anhang == null) {
                return null;
            }
            if (AbstractFormat.AttachmentMarker.EXTERN.equals((Object)this.attachmentMarker)) {
                anhang.setLocation(Anhang.Location.EXTERN);
            } else if (AbstractFormat.AttachmentMarker.INTERN.equals((Object)this.attachmentMarker)) {
                anhang.setLocation(Anhang.Location.INTERN);
            }
            return anhang;
        }

        protected Immoxml createRoot() {
            Immoxml immoxml = super.createRoot();
            immoxml.getUebertragung().setSendersoftware(ImmoToolEnvironment.getApplicationTitle() + " " + ImmoToolEnvironment.getApplicationVersion());
            return immoxml;
        }
    }
}

