/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.ImmobilienNetFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmobilienNetFormatPanel
extends AbstractFormatPanel<ImmobilienNetFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobilienNetFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmobilienNetFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel agentMailLabel;
    private JTextField agentMailField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel optionsLabel;
    private JCheckBox publicIdExportBox;
    private JCheckBox energyCertificateBox;

    public ImmobilienNetFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.agentMailLabel = new JLabel();
        this.agentMailField = new JTextField();
        this.publicIdExportBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.agentMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdExportBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (ImmobilienNetFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, ImmobilienNetFormat immobilienNetFormat) {
        if (immobilienNetFormat == null) {
            this.agentIdField.setText("");
            this.agentMailField.setText("");
            this.publicIdExportBox.setSelected(true);
            this.technMailField.setText("");
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(immobilienNetFormat.getAgentId());
            this.agentMailField.setText(immobilienNetFormat.getAgentMail());
            this.publicIdExportBox.setSelected(immobilienNetFormat.isOpenImmoPropertyPublicIdExported());
            this.technMailField.setText(immobilienNetFormat.getOpenImmoTechnicsMail());
            this.energyCertificateBox.setSelected(immobilienNetFormat.isPropertyDescriptionWithEnergyCertificate());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, ImmobilienNetFormat immobilienNetFormat) {
        if (immobilienNetFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        immobilienNetFormat.setAgentId(this.agentIdField.getText().trim());
        immobilienNetFormat.setAgentMail(this.agentMailField.getText().trim());
        immobilienNetFormat.setOpenImmoPropertyPublicIdExported(this.publicIdExportBox.isSelected());
        immobilienNetFormat.setOpenImmoTechnicsMail(this.technMailField.getText().trim());
        immobilienNetFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.agentMailLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-mail")) + ":");
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdExportBox.setText(I18N.tr("Publish property-nr."));
        this.publicIdExportBox.setToolTipText(I18N.tr("Enable this option to publish the property-nr next to the property-ID. Not all recipients support this feature."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

