/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.Is24RestFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.utils.ImageUtils;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24RestFormatPanel
extends AbstractFormatPanel<Is24RestFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24RestFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel optionsLabel;
    private JCheckBox publicIdBox;
    private LocaleComboBox exportLocaleBox;

    public Is24RestFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.publicIdBox = new JCheckBox();
        this.exportLocaleBox = new LocaleComboBox(AgencyPlugin.getLocales(), true);
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        JLabel jLabel = new JLabel();
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ImmoToolUtils.openURL((String)"http://www.immobilienscout24.de/");
                }
            }
        });
        URL uRL = ImmoToolEnvironment.class.getResource("/com/openindex/openestate/tool/resources/logos/is24.png");
        if (uRL != null) {
            try {
                jLabel.setIcon(new ImageIcon(ImageUtils.read((URL)uRL)));
            }
            catch (IOException iOException) {
                LOGGER.warn("Can't read IS24 logo!");
                LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
            }
        }
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 100dlu");
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleBox).xyw(5, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "East");
        this.setLayout(new BorderLayout(10, 10));
        this.add(defaultFormBuilder.getPanel(), "Center");
        this.add(jPanel, "South");
        this.updateLocalization();
        this.load((DbAgencyExport)null, (Is24RestFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.publicIdBox.isSelected()) {
            list.add(AgencyPluginUtils.Message.PROPERTY_NR_IDENTIFICATION_WARNING.getTranslation());
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, Is24RestFormat is24RestFormat) {
        if (is24RestFormat == null) {
            this.estateIdPrefixField.setText("");
            this.exportLocaleBox.setSelectedIndex(-1);
            this.publicIdBox.setSelected(false);
        } else {
            this.estateIdPrefixField.setText(is24RestFormat.getPropertyPrefix());
            this.exportLocaleBox.setSelectedLocale(is24RestFormat.getLanguage());
            this.publicIdBox.setSelected(is24RestFormat.isPropertyPublicId());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, Is24RestFormat is24RestFormat) {
        if (is24RestFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        is24RestFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        is24RestFormat.setLanguage(this.exportLocaleBox.getSelectedLocale());
        is24RestFormat.setPropertyPublicId(this.publicIdBox.isSelected());
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdBox.setText(I18N.tr("Use property number for identification."));
        this.publicIdBox.setToolTipText(I18N.tr("Enable this option to export the property number instead of the property ID."));
        this.exportLocaleBox.setToolTipText(I18N.tr("The properties will be sent to the recipient in the selected language."));
    }
}

