/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.LocalTransportPanel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="There is no need to restore transient field on deserialization.")
public class LocalTransport
extends AbstractTransport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(LocalTransport.class);
    private static final String NAME = "local";
    private static final String LOCAL_DIRECTORY = "local.directory";

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new LocalTransportPanel();
    }

    public File getLocalDirectory() {
        String string = (String)this.get(LOCAL_DIRECTORY);
        return string != null ? new File(string) : null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return I18N.tr("Transport to local harddisk.");
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setLocalDirectory(new File("."));
    }

    @Override
    protected boolean isUpdatingMessage() {
        return true;
    }

    @Override
    protected boolean isUpdatingProgress() {
        return true;
    }

    public void setLocalDirectory(File file) {
        if (file == null) {
            this.remove(LOCAL_DIRECTORY);
        } else {
            this.put(LOCAL_DIRECTORY, file.getAbsolutePath());
        }
    }

    public static class Request
    extends AbstractTransportRequest<LocalTransport> {
        private final File exportFile;
        private long totalSize = -1L;
        private long copiedSize = -1L;

        public Request(LocalTransport localTransport, File file) {
            super(localTransport);
            if (file == null) {
                throw new IllegalArgumentException("No export file was specified!");
            }
            if (!file.isFile() && !file.isDirectory()) {
                throw new IllegalArgumentException("The export file is neither a file nor a directory (" + file.getAbsolutePath() + ")!");
            }
            this.exportFile = file;
        }

        protected void doCopy(File file, File file2, ImmoToolTask.Callback callback) throws IOException {
            if (file.isFile()) {
                Object object;
                File file3 = new File(file2.getAbsolutePath() + File.separator + file.getName());
                Object object2 = new FileInputStream(file);
                Object object3 = null;
                try {
                    object = new FileOutputStream(file3);
                    Throwable throwable = null;
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)object2).read(byArray, 0, byArray.length)) > 0) {
                            ((OutputStream)object).write(byArray, 0, n);
                            this.copiedSize += (long)n;
                            if (this.copiedSize > this.totalSize) {
                                this.totalSize = this.copiedSize;
                            }
                            callback.setProgress(this.copiedSize, 0L, this.totalSize);
                        }
                        ((OutputStream)object).flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((OutputStream)object).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object3 != null) {
                            try {
                                ((InputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object2).close();
                        }
                    }
                }
                if (this.totalSize > -1L) {
                    object2 = NumberFormat.getNumberInstance();
                    ((NumberFormat)object2).setMaximumFractionDigits(1);
                    object3 = ImmoToolUtils.getHumanReadableByteCount((long)this.totalSize, (NumberFormat)object2);
                    object = ImmoToolUtils.getHumanReadableByteCount((long)this.copiedSize, (NumberFormat)object2);
                    callback.setMessage(I18N.tr("{0} of {1}", object, object3));
                }
            } else if (file.isDirectory()) {
                File file4 = new File(file2.getAbsolutePath() + File.separator + file.getName());
                if (!file4.exists() && !file4.mkdir()) {
                    throw new IOException("Can't create directory: " + file4.getAbsolutePath());
                }
                Object[] objectArray = file.listFiles();
                if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                    for (Object object : objectArray) {
                        this.doCopy((File)object, file4, callback);
                    }
                }
            }
        }

        protected File doCreateTargetDirectory(ExportContext exportContext) throws IOException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH-mm");
            File file = ((LocalTransport)this.getTransport()).getLocalDirectory();
            File file2 = null;
            int n = 0;
            while (file2 == null || file2.exists()) {
                String string = simpleDateFormat.format(exportContext.stamp) + "_" + simpleDateFormat2.format(exportContext.stamp);
                if (n > 0) {
                    string = string + "_" + n;
                }
                file2 = new File(file, string);
                ++n;
            }
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Can't create directory: " + file2.getAbsolutePath());
            }
            return file2;
        }

        @Override
        public AbstractTransportRequest[] getChildRequests() {
            return null;
        }

        @Override
        public String getTitle() {
            return I18N.tr("Transferring files to local harddisk.");
        }

        @Override
        public void send(ExportContext exportContext, ImmoToolTask.Callback callback) throws AbstractTransportRequest.TransferException {
            block9: {
                File file;
                try {
                    file = this.doCreateTargetDirectory(exportContext);
                }
                catch (IOException iOException) {
                    throw new AbstractTransportRequest.TransferException("Can't create target directory!", iOException);
                }
                if (!file.isDirectory()) {
                    throw new AbstractTransportRequest.TransferException("The target directory is invalid!");
                }
                this.copiedSize = 0L;
                this.totalSize = this.exportFile.isFile() ? this.exportFile.length() : FileUtils.sizeOfDirectory((File)this.exportFile);
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                String string = ImmoToolUtils.getHumanReadableByteCount((long)this.totalSize, (NumberFormat)numberFormat);
                String string2 = ImmoToolUtils.getHumanReadableByteCount((long)this.copiedSize, (NumberFormat)numberFormat);
                callback.setMessage(I18N.tr("{0} of {1}", (Object)string2, (Object)string));
                callback.setProgress(this.copiedSize, 0L, this.totalSize);
                try {
                    if (this.exportFile.isDirectory()) {
                        Object[] objectArray = this.exportFile.listFiles();
                        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                            for (Object object : objectArray) {
                                callback.checkCancelled();
                                this.doCopy((File)object, file, callback);
                            }
                        }
                        break block9;
                    }
                    if (this.exportFile.isFile()) {
                        callback.checkCancelled();
                        this.doCopy(this.exportFile, file, callback);
                        break block9;
                    }
                    throw new AbstractTransportRequest.TransferException("The export file is invalid!");
                }
                catch (IOException iOException) {
                    throw new AbstractTransportRequest.TransferException("Can't copy into target directory!", iOException);
                }
            }
        }
    }
}

