/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlFormat;
import com.openindex.openestate.tool.agency.gui.AgencyExposeRenderer;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultSelectButton;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsiteHtmlFormatPanel
extends AbstractFormatPanel<WebsiteHtmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteHtmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsiteHtmlFormatPanel.class);
    private static final String FEED_TROVIT = "trovit";
    private static final String FEED_IMMOBILIARE = "immobiliare";
    private static final String FEED_RSS = "rss";
    private static final String FEED_ATOM = "atom";
    private static final String FEED_KYERO = "kyero";
    private ValidationHandler validationHandler;
    private JLabel pdfExportLabel;
    private JComboBox<DbAgencyExpose> pdfExportBox;
    private JLabel mapTypeLabel;
    private JComboBox<WebsiteHtmlFormat.MapType> mapTypeBox;
    private JLabel feedExportLabel;
    private DefaultSelectButton feedExportButton;
    private JLabel companyNameLabel;
    private JTextField companyNameField;
    private JLabel baseUrlLabel;
    private JTextField baseUrlField;
    private JLabel stylesheetUrlLabel;
    private JTextField stylesheetUrlField;
    private JLabel exportLocaleLabel;
    private LocaleComboBox exportLocaleBox;
    private JLabel optionsLabel;
    private JCheckBox exposeShowAgentBox;
    private JCheckBox exposeShowContactBox;
    private JCheckBox exposeShowTermsBox;
    private JCheckBox imgColorboxExportBox;

    public WebsiteHtmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.exposeShowAgentBox = new JCheckBox();
        this.exposeShowAgentBox.setName("exposeShowAgentBox");
        this.exposeShowContactBox = new JCheckBox();
        this.exposeShowContactBox.setName("exposeShowContactBox");
        this.exposeShowTermsBox = new JCheckBox();
        this.exposeShowTermsBox.setName("exposeShowTermsBox");
        this.imgColorboxExportBox = new JCheckBox();
        this.imgColorboxExportBox.setName("imgColorboxExportBox");
        this.exportLocaleLabel = new JLabel();
        this.exportLocaleBox = new LocaleComboBox(WebsiteHtmlFormat.getSupportedLocales(), true);
        this.baseUrlLabel = new JLabel();
        this.baseUrlField = new JTextField();
        this.companyNameLabel = new JLabel();
        this.companyNameField = new JTextField();
        this.stylesheetUrlLabel = new JLabel();
        this.stylesheetUrlField = new JTextField();
        this.pdfExportLabel = new JLabel();
        this.pdfExportBox = new JComboBox();
        this.pdfExportBox.setRenderer((ListCellRenderer<DbAgencyExpose>)new DefaultListCellRenderer((Renderer)new AgencyExposeRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("Don't export expos\u00e9s.") + " ]";
            }
        }));
        this.mapTypeLabel = new JLabel();
        this.mapTypeBox = new JComboBox();
        this.mapTypeBox.setRenderer((ListCellRenderer<WebsiteHtmlFormat.MapType>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<WebsiteHtmlFormat.MapType>(){

            public void render(WebsiteHtmlFormat.MapType mapType, JLabel jLabel) {
                if (mapType != null) {
                    jLabel.setText(mapType.getTitle());
                } else {
                    jLabel.setText(I18N.tr("Don't show a map."));
                }
            }
        }));
        this.mapTypeBox.addItem(null);
        for (WebsiteHtmlFormat.MapType mapType : WebsiteHtmlFormat.MapType.values()) {
            this.mapTypeBox.addItem(mapType);
        }
        this.feedExportLabel = new JLabel();
        this.feedExportButton = new DefaultSelectButton(1);
        this.feedExportButton.setEmptyText("");
        this.feedExportButton.addOption(FEED_ATOM, "Atom feed");
        this.feedExportButton.addOption(FEED_IMMOBILIARE, "Immobiliare feed");
        this.feedExportButton.addOption(FEED_KYERO, "Kyero feed");
        this.feedExportButton.addOption(FEED_RSS, "RSS feed");
        this.feedExportButton.addOption(FEED_TROVIT, "Trovit feed");
        this.feedExportButton.addMenuItemListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebsiteHtmlFormatPanel.this.baseUrlField.setEnabled(WebsiteHtmlFormatPanel.this.feedExportButton.getSelectedKeys().length > 0);
                WebsiteHtmlFormatPanel.this.validationHandler.validate((JComponent)WebsiteHtmlFormatPanel.this.baseUrlField);
            }
        });
        this.validationHandler.putRule((JComponent)this.companyNameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 25dlu:grow");
        defaultFormBuilder.border((Border)Paddings.EMPTY);
        defaultFormBuilder.add((Component)this.companyNameLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.companyNameField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleBox).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.feedExportLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.feedExportButton).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.baseUrlLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.baseUrlField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.pdfExportLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.pdfExportBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.stylesheetUrlLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.stylesheetUrlField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.mapTypeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.mapTypeBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.exposeShowAgentBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.imgColorboxExportBox).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exposeShowContactBox).xy(3, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.exposeShowTermsBox).xy(7, defaultFormBuilder.row());
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "Center");
        this.updateLocalization();
        this.load((DbAgencyExport)null, (WebsiteHtmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DbAgencyExport dbAgencyExport, WebsiteHtmlFormat websiteHtmlFormat) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            throw new RuntimeException("No project loaded!");
        }
        if (websiteHtmlFormat == null) {
            this.baseUrlField.setText("http://");
            this.baseUrlField.setEnabled(false);
            this.companyNameField.setText("");
            this.exportLocaleBox.setSelectedIndex(-1);
            this.mapTypeBox.setSelectedIndex(0);
            this.exposeShowAgentBox.setSelected(true);
            this.exposeShowContactBox.setSelected(true);
            this.exposeShowTermsBox.setSelected(true);
            this.feedExportButton.clearSelection();
            this.imgColorboxExportBox.setEnabled(true);
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            this.pdfExportBox.setSelectedIndex(0);
            this.stylesheetUrlField.setText("");
        } else {
            this.exposeShowAgentBox.setSelected(websiteHtmlFormat.isHtmlShowAgent());
            this.exposeShowContactBox.setSelected(websiteHtmlFormat.isHtmlShowContact());
            this.exposeShowTermsBox.setSelected(websiteHtmlFormat.isHtmlShowTerms());
            this.exportLocaleBox.setSelectedLocale(websiteHtmlFormat.getLanguage());
            this.mapTypeBox.setSelectedItem((Object)websiteHtmlFormat.getHtmlMapType());
            this.stylesheetUrlField.setText(websiteHtmlFormat.getHtmlStylesheet());
            this.feedExportButton.clearSelection();
            this.feedExportButton.setSelected(FEED_ATOM, websiteHtmlFormat.isHtmlFeedAtom());
            this.feedExportButton.setSelected(FEED_IMMOBILIARE, websiteHtmlFormat.isHtmlFeedImmobiliare());
            this.feedExportButton.setSelected(FEED_KYERO, websiteHtmlFormat.isHtmlFeedKyero());
            this.feedExportButton.setSelected(FEED_RSS, websiteHtmlFormat.isHtmlFeedRss());
            this.feedExportButton.setSelected(FEED_TROVIT, websiteHtmlFormat.isHtmlFeedTrovit());
            this.feedExportButton.updateText();
            URI uRI = websiteHtmlFormat.getHtmlBaseUrl();
            this.baseUrlField.setEnabled(this.feedExportButton.getSelectedKeys().length > 0);
            this.baseUrlField.setText(uRI != null ? uRI.toString() : "http://");
            this.companyNameField.setText(websiteHtmlFormat.getHtmlTitle());
            if (StringUtils.isBlank((CharSequence)this.companyNameField.getText())) {
                try {
                    this.companyNameField.setText(immoToolProject.getAgent().getCompany().getCompanyName());
                }
                catch (Exception exception) {
                    LOGGER.error("could not load company-name!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.imgColorboxExportBox.setSelected(websiteHtmlFormat.isHtmlImageColorbox());
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            Connection connection = null;
            DbAgencyExposesHandler dbAgencyExposesHandler = AgencyPlugin.getDbAgencyExtension().getExposeHandler();
            try {
                connection = immoToolProject.getDbConnection();
                TreeMap<String, DbAgencyExpose> treeMap = new TreeMap<String, DbAgencyExpose>();
                for (DbAgencyExpose dbAgencyExpose : dbAgencyExposesHandler.getExposes(connection)) {
                    int n = 0;
                    String string = dbAgencyExpose.name.toLowerCase();
                    while (treeMap.containsKey(string)) {
                        string = dbAgencyExpose.name.toLowerCase() + "_" + ++n;
                    }
                    treeMap.put(string, dbAgencyExpose);
                }
                long l = dbAgencyExport.exposeId;
                for (DbAgencyExpose dbAgencyExpose : treeMap.values()) {
                    this.pdfExportBox.addItem(dbAgencyExpose);
                    if (l <= 0L || dbAgencyExpose.id != l) continue;
                    this.pdfExportBox.setSelectedIndex(this.pdfExportBox.getItemCount() - 1);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't load exposes!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, WebsiteHtmlFormat websiteHtmlFormat) {
        if (websiteHtmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        websiteHtmlFormat.setHtmlShowAgent(this.exposeShowAgentBox.isSelected());
        websiteHtmlFormat.setHtmlShowContact(this.exposeShowContactBox.isSelected());
        websiteHtmlFormat.setHtmlShowTerms(this.exposeShowTermsBox.isSelected());
        websiteHtmlFormat.setHtmlImageColorbox(this.imgColorboxExportBox.isSelected());
        websiteHtmlFormat.setLanguage(this.exportLocaleBox.getSelectedLocale());
        websiteHtmlFormat.setHtmlMapType((WebsiteHtmlFormat.MapType)((Object)this.mapTypeBox.getSelectedItem()));
        websiteHtmlFormat.setHtmlTitle(this.companyNameField.getText().trim());
        websiteHtmlFormat.setHtmlStylesheet(this.stylesheetUrlField.getText().trim());
        DbAgencyExpose dbAgencyExpose = (DbAgencyExpose)this.pdfExportBox.getSelectedItem();
        dbAgencyExport.exposeId = dbAgencyExpose != null ? dbAgencyExpose.id : 0L;
        websiteHtmlFormat.setHtmlFeedAtom(this.feedExportButton.hasSelection(FEED_ATOM));
        websiteHtmlFormat.setHtmlFeedImmobiliare(this.feedExportButton.hasSelection(FEED_IMMOBILIARE));
        websiteHtmlFormat.setHtmlFeedKyero(this.feedExportButton.hasSelection(FEED_KYERO));
        websiteHtmlFormat.setHtmlFeedRss(this.feedExportButton.hasSelection(FEED_RSS));
        websiteHtmlFormat.setHtmlFeedTrovit(this.feedExportButton.hasSelection(FEED_TROVIT));
        try {
            websiteHtmlFormat.setHtmlBaseUrl(this.baseUrlField.isEnabled() ? new URI(this.baseUrlField.getText().trim()) : null);
        }
        catch (URISyntaxException uRISyntaxException) {
            websiteHtmlFormat.setHtmlBaseUrl(null);
            LOGGER.warn("Can't read URL!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.companyNameLabel.setText(StringUtils.capitalize((String)I18N.tr("company")) + ":");
        this.companyNameField.setToolTipText(I18N.tr("This text is used as title in the generated documents."));
        this.baseUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("base-URL")) + ":");
        this.baseUrlField.setToolTipText(I18N.tr("This URL points to the location at your webspace, where the exported files are stored."));
        this.stylesheetUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("stylesheet-URL")) + ":");
        this.stylesheetUrlField.setToolTipText(I18N.tr("This URL points to a CSS file, that is additionally loaded in the generated HTML-documents."));
        this.exportLocaleLabel.setText(StringUtils.capitalize((String)I18N.tr("language")) + ":");
        this.exportLocaleBox.setToolTipText(I18N.tr("The properties will be sent to the recipient in the selected language."));
        this.feedExportLabel.setText(StringUtils.capitalize((String)I18N.tr("exports")) + ":");
        this.feedExportButton.setToolTipText(I18N.tr("The properties may be stored in additional file formats to the webspace."));
        this.feedExportButton.setEmptyText("[ " + I18N.tr("No format selected.") + " ]");
        this.feedExportButton.updateText();
        this.pdfExportLabel.setText(StringUtils.capitalize((String)I18N.tr("expos\u00e9")) + ":");
        this.pdfExportBox.setToolTipText(I18N.tr("Use this field to specify an expos\u00e9, that is additionally transferred to the webspace."));
        this.mapTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("map")) + ":");
        this.mapTypeBox.setToolTipText(I18N.tr("Select a provider, that is used to show a map for properties with geo coordinates in the generated documents."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.exposeShowAgentBox.setText(I18N.tr("Show agency information."));
        this.exposeShowAgentBox.setToolTipText(I18N.tr("Enable this option to show information about your agency in the generated documents."));
        this.exposeShowContactBox.setText(I18N.tr("Show contact person."));
        this.exposeShowContactBox.setToolTipText(I18N.tr("Enable this option to show information about the contact person in the generated documents."));
        this.exposeShowTermsBox.setText(I18N.tr("Show terms."));
        this.exposeShowTermsBox.setToolTipText(I18N.tr("Enable this option to show the terms of your agency in the generated documents."));
        this.imgColorboxExportBox.setText(I18N.tr("Show images with colorbox."));
        this.imgColorboxExportBox.setToolTipText(I18N.tr("Enable this option to present the exported images in a colorbox gallery."));
    }
}

