/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.idx.IdxReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.idx.IdxFormat;
import org.openestate.io.idx.IdxRecord;
import org.openestate.io.idx.types.Media;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class IdxImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxImport.class);
    private static final I18n I18N = I18nFactory.getI18n(IdxImport.class);
    private static final String NAME = "idx";

    @Override
    public File getAttachedFile(String string, File file) {
        try {
            String string2;
            File file2 = new File(file, string);
            if (file2.isFile()) {
                return file2;
            }
            if (Media.isDocument((String)string)) {
                string2 = "doc";
            } else if (Media.isImage((String)string)) {
                string2 = "images";
            } else if (Media.isMovie((String)string)) {
                string2 = "movies";
            } else {
                return null;
            }
            file2 = new File(new File(file, string2), string);
            if (file2.isFile()) {
                return file2;
            }
            File file3 = file.getParentFile();
            if (file3 != null && (file2 = new File(new File(file3, string2), string)).isFile()) {
                return file2;
            }
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't find attached file '" + string + "'!");
            LOGGER.warn("> in folder " + file.getAbsolutePath());
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{"csv", "txt"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "IDX";
    }

    @Override
    public String[] getVersions() {
        return new String[]{"3.01"};
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        IdxImportReader idxImportReader = new IdxImportReader();
        idxImportReader.setOpenEstateLanguage(settings.getLanguage());
        return idxImportReader.readTransfer(file);
    }

    @Override
    public String validateFile(File file) throws IOException {
        IdxFormat idxFormat = new IdxFormat();
        CSVRecord cSVRecord = null;
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), idxFormat.getEncoding());){
            CSVParser cSVParser = idxFormat.getFormat().parse((Reader)inputStreamReader);
            cSVRecord = (CSVRecord)cSVParser.iterator().next();
        }
        catch (Exception exception) {
            throw new IOException("Can't parse file!", exception);
        }
        if (cSVRecord == null) {
            throw new IOException("No CSV record was found.");
        }
        if (cSVRecord.size() != 183) {
            throw new IOException("Invalid record length.");
        }
        return IdxRecord.newRecord((CSVRecord)cSVRecord).getVersion();
    }

    public static class IdxImportReader
    extends IdxReader {
        protected EstateImpl createEstate(IdxRecord idxRecord) throws OpenEstateException {
            return super.createEstate(idxRecord);
        }
    }
}

