/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.imports;

import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.is24.Is24CsvReader;
import com.openindex.openestate.tool.agency.AgencyImportTask;
import com.openindex.openestate.tool.agency.imports.AbstractImport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvParser;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Importmodus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24CsvImport
extends AbstractImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvImport.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24CsvImport.class);
    private static final String NAME = "is24_csv";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"csv", "txt"};
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "IS24-CSV";
    }

    @Override
    public String[] getVersions() {
        return new String[]{"1.4.0.4"};
    }

    @Override
    public boolean isIncrementalTransferSupported() {
        return true;
    }

    @Override
    public TransferImpl parseFile(File file, String string, AgencyImportTask.Settings settings) throws IOException {
        Is24CsvImportReader is24CsvImportReader = new Is24CsvImportReader();
        is24CsvImportReader.setOpenEstateLanguage(settings.getLanguage());
        is24CsvImportReader.setImportRemovedObjects(settings.isImportRemovedObjects());
        return is24CsvImportReader.readTransfer(file);
    }

    @Override
    public String validateFile(File file) throws IOException {
        InputStreamReader inputStreamReader;
        Is24CsvFormat is24CsvFormat = new Is24CsvFormat();
        CSVRecord cSVRecord = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), is24CsvFormat.getEncoding());
            Throwable throwable = null;
            try {
                CSVParser cSVParser = is24CsvFormat.getFormat().parse((Reader)inputStreamReader);
                cSVRecord = (CSVRecord)cSVParser.iterator().next();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStreamReader != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)inputStreamReader).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("Can't parse file!", exception);
        }
        if (cSVRecord == null) {
            throw new IOException("No CSV record was found.");
        }
        if (cSVRecord.size() != 182) {
            throw new IOException("Invalid record length.");
        }
        inputStreamReader = Is24CsvParser.createRecord((CSVRecord)cSVRecord);
        if (inputStreamReader == null) {
            throw new IOException("Can't parse the first record.");
        }
        return null;
    }

    public static class Is24CsvImportReader
    extends Is24CsvReader {
        private boolean importRemovedObjects = false;

        protected void initRecord(Is24CsvRecord is24CsvRecord) {
            if (this.isImportRemovedObjects() && Importmodus.LOESCHEN.equals((Object)is24CsvRecord.getImportmodus())) {
                is24CsvRecord.setImportmodus(Importmodus.IMPORTIEREN);
            }
            super.initRecord(is24CsvRecord);
        }

        public boolean isImportRemovedObjects() {
            return this.importRemovedObjects;
        }

        public void setImportRemovedObjects(boolean bl) {
            this.importRemovedObjects = bl;
        }
    }
}

