/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AuctionCancellationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionCompulsory;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AuctionModificationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRecordationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRepeated;
import com.openindex.openestate.impl.attribs.administration.AuctionSplitted;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.BuildableInShortTerm;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.BuildingPermissionAvailable;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesFemale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesMale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesTotal;
import com.openindex.openestate.impl.attribs.administration.CountRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.CountryCourtFileReference;
import com.openindex.openestate.impl.attribs.administration.CountryCourtName;
import com.openindex.openestate.impl.attribs.administration.DemolitionRequired;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LandRegisterNr;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Owner;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ConstructionPhase;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.CeilingLoad;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.Height;
import com.openindex.openestate.impl.attribs.measures.Length;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.Width;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.MarketValue;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomePerMonth;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.SupplyAccess;
import com.openindex.openestate.impl.is24.Is24Utils;
import com.openindex.openestate.impl.utils.AbstractXmlReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.is24_csv.types.DateiSuffix;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.AktionsTyp;
import org.openestate.io.is24_xml.xml.Anlageobjekt;
import org.openestate.io.is24_xml.xml.AnlageobjekteKategorieTyp;
import org.openestate.io.is24_xml.xml.ApiSuchfelderTyp;
import org.openestate.io.is24_xml.xml.AusstattungsqualitaetsTyp;
import org.openestate.io.is24_xml.xml.BauphaseTyp;
import org.openestate.io.is24_xml.xml.BebaubarNachTyp;
import org.openestate.io.is24_xml.xml.BefeuerungsArtTyp;
import org.openestate.io.is24_xml.xml.BodenbelagTyp;
import org.openestate.io.is24_xml.xml.BodenbelagWohnenTyp;
import org.openestate.io.is24_xml.xml.BueroPraxis;
import org.openestate.io.is24_xml.xml.BueroPraxisKategorienTyp;
import org.openestate.io.is24_xml.xml.DatenVerkabelungsTyp;
import org.openestate.io.is24_xml.xml.Einzelhandel;
import org.openestate.io.is24_xml.xml.EinzelhandelKategorienTyp;
import org.openestate.io.is24_xml.xml.EnergieausweisTyp;
import org.openestate.io.is24_xml.xml.EnergieausweistypTyp;
import org.openestate.io.is24_xml.xml.ErschliessungszustandTyp;
import org.openestate.io.is24_xml.xml.GarageKauf;
import org.openestate.io.is24_xml.xml.GarageMiete;
import org.openestate.io.is24_xml.xml.GaragenKategorieTyp;
import org.openestate.io.is24_xml.xml.GastroKategorieTyp;
import org.openestate.io.is24_xml.xml.Gastronomie;
import org.openestate.io.is24_xml.xml.GenehmigungTyp;
import org.openestate.io.is24_xml.xml.GeschlechtTyp;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbe;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbeEmpfohleneNutzung;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbeKategorienTyp;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenEmpfohleneNutzung;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenKauf;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenMiete;
import org.openestate.io.is24_xml.xml.HalleProduktion;
import org.openestate.io.is24_xml.xml.HalleProduktionKategorieTyp;
import org.openestate.io.is24_xml.xml.HausKategorienTyp;
import org.openestate.io.is24_xml.xml.HausKauf;
import org.openestate.io.is24_xml.xml.HausMiete;
import org.openestate.io.is24_xml.xml.HebeanlageTyp;
import org.openestate.io.is24_xml.xml.HeizungsartTyp;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.openestate.io.is24_xml.xml.JaNeinVereinbarungTyp;
import org.openestate.io.is24_xml.xml.LageartTyp;
import org.openestate.io.is24_xml.xml.MMAnhangArtenTyp;
import org.openestate.io.is24_xml.xml.MieteEinheitTyp;
import org.openestate.io.is24_xml.xml.MobilarTyp;
import org.openestate.io.is24_xml.xml.MultimediaAnhangTyp;
import org.openestate.io.is24_xml.xml.ObjektZustandTyp;
import org.openestate.io.is24_xml.xml.RauchenTyp;
import org.openestate.io.is24_xml.xml.SonstigeGewerbe;
import org.openestate.io.is24_xml.xml.SonstigeGewerbeKategorieTyp;
import org.openestate.io.is24_xml.xml.StellplatzKategorieTyp;
import org.openestate.io.is24_xml.xml.TVAnschlussTyp;
import org.openestate.io.is24_xml.xml.VermarktungGewerbeTyp;
import org.openestate.io.is24_xml.xml.VermarktungGewerbeTyp2;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckGewerbeTyp;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckWohnenKaufTyp;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckWohnenMieteTyp;
import org.openestate.io.is24_xml.xml.WAZ;
import org.openestate.io.is24_xml.xml.WGGroesse;
import org.openestate.io.is24_xml.xml.WGZimmer;
import org.openestate.io.is24_xml.xml.WGZimmerGeschlechtTyp;
import org.openestate.io.is24_xml.xml.WazKategorienTyp;
import org.openestate.io.is24_xml.xml.WazObjektZustandTyp;
import org.openestate.io.is24_xml.xml.WazZeiteinheitenTyp;
import org.openestate.io.is24_xml.xml.WohnungKategorienTyp;
import org.openestate.io.is24_xml.xml.WohnungKauf;
import org.openestate.io.is24_xml.xml.WohnungMiete;
import org.openestate.io.is24_xml.xml.ZulieferungTyp;
import org.openestate.io.is24_xml.xml.Zwangsversteigerung;
import org.openestate.io.is24_xml.xml.ZwangsversteigerungKategorieTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Is24XmlReader
extends AbstractXmlReader<Is24XmlDocument, ImmobilienTransferTyp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlReader.class);

    public Is24XmlReader() {
    }

    public Is24XmlReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(ImmobilienTransferTyp.Anbieter anbieter) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCustomValues().putCustomValue("is24.agent.id", (Object)anbieter.getScoutKundenID(), 5);
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(ImmobilieBaseTyp immobilieBaseTyp, Map<String, AgentContactImpl> map) {
        Object object;
        Object object2;
        EstateImpl estateImpl = this.createEmptyEstate();
        estateImpl.setTitle(immobilieBaseTyp.getUeberschrift(), this.getOpenEstateLanguage());
        estateImpl.setId(immobilieBaseTyp.getAnbieterObjektID());
        estateImpl.getAddress().setPublished(immobilieBaseTyp.getAdressdruck().booleanValue());
        if (immobilieBaseTyp.getAdresse() != null) {
            object2 = immobilieBaseTyp.getAdresse();
            estateImpl.getAddress().setStreetNr(object2.getHausnummer());
            estateImpl.getAddress().setCity(object2.getOrt());
            estateImpl.getAddress().setPostalCode(object2.getPostleitzahl());
            estateImpl.getAddress().setStreet(object2.getStrasse());
            object = object2.getLaenderkennzeichen();
            if (object != null) {
                estateImpl.getAddress().setCountry(OpenEstateUtils.convertToIso2Country((String)object.toString()));
            }
        }
        if (immobilieBaseTyp.getKontaktperson() != null) {
            object2 = this.createEmptyContact();
            object2.setPersonMail(immobilieBaseTyp.getKontaktperson().getEMail());
            object2.setStreetNr(immobilieBaseTyp.getKontaktperson().getHausnummer());
            object2.setContactWebsite(immobilieBaseTyp.getKontaktperson().getHomepage());
            object2.setPersonMobilePhone(immobilieBaseTyp.getKontaktperson().getMobiltelefon());
            object2.setPersonLastName(immobilieBaseTyp.getKontaktperson().getNachname());
            object2.setCity(immobilieBaseTyp.getKontaktperson().getOrt());
            object2.setPostalCode(immobilieBaseTyp.getKontaktperson().getPostleitzahl());
            object2.setStreet(immobilieBaseTyp.getKontaktperson().getStrasse());
            object2.setPersonFax(immobilieBaseTyp.getKontaktperson().getTelefax());
            object2.setPersonPhone(immobilieBaseTyp.getKontaktperson().getTelefon());
            object2.setPersonFirstName(immobilieBaseTyp.getKontaktperson().getVorname());
            object = StringUtils.trimToNull((String)immobilieBaseTyp.getKontaktperson().getAnrede());
            if (object == null) {
                object2.setPersonGender((Gender)null);
            } else if (((String)object).toLowerCase().contains("frau") || ((String)object).equalsIgnoreCase(Gender.FEMALE.name())) {
                object2.setPersonGender(Gender.FEMALE);
            } else if (((String)object).toLowerCase().contains("herr") || ((String)object).equalsIgnoreCase(Gender.MALE.name())) {
                object2.setPersonGender(Gender.MALE);
            }
            if (immobilieBaseTyp.getKontaktperson().getLaenderkennzeichen() != null) {
                object2.setCountry(OpenEstateUtils.convertToIso2Country((String)immobilieBaseTyp.getKontaktperson().getLaenderkennzeichen().toString()));
            }
        }
        if (immobilieBaseTyp.getWaehrung() != null) {
            try {
                estateImpl.setCurrency(Currency.getInstance(immobilieBaseTyp.getWaehrung().toString()));
            }
            catch (Exception exception) {
                LOGGER.warn("W\u00e4hrung konnte nicht \u00fcbernommen werden!");
                LOGGER.warn("> " + immobilieBaseTyp.getWaehrung().toString());
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if ((object2 = immobilieBaseTyp.getGruppierungsID()) != null) {
            estateImpl.setGroupId(((Long)object2).toString());
        }
        if (immobilieBaseTyp instanceof Anlageobjekt.Type) {
            this.convertImmobilie((Anlageobjekt.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof BueroPraxis.Type) {
            this.convertImmobilie((BueroPraxis.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Einzelhandel.Type) {
            this.convertImmobilie((Einzelhandel.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GarageKauf.Type) {
            this.convertImmobilie((GarageKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GarageMiete.Type) {
            this.convertImmobilie((GarageMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Gastronomie.Type) {
            this.convertImmobilie((Gastronomie.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckGewerbe.Type) {
            this.convertImmobilie((GrundstueckGewerbe.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckWohnenKauf.Type) {
            this.convertImmobilie((GrundstueckWohnenKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof GrundstueckWohnenMiete.Type) {
            this.convertImmobilie((GrundstueckWohnenMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HalleProduktion.Type) {
            this.convertImmobilie((HalleProduktion.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HausKauf.Type) {
            this.convertImmobilie((HausKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof HausMiete.Type) {
            this.convertImmobilie((HausMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof SonstigeGewerbe.Type) {
            this.convertImmobilie((SonstigeGewerbe.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WAZ.Type) {
            this.convertImmobilie((WAZ.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WGZimmer.Type) {
            this.convertImmobilie((WGZimmer.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WohnungKauf.Type) {
            this.convertImmobilie((WohnungKauf.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof WohnungMiete.Type) {
            this.convertImmobilie((WohnungMiete.Type)immobilieBaseTyp, estateImpl);
        } else if (immobilieBaseTyp instanceof Zwangsversteigerung.Type) {
            this.convertImmobilie((Zwangsversteigerung.Type)immobilieBaseTyp, estateImpl);
        } else {
            throw new IllegalArgumentException("Unbekannte Immobilienart: " + immobilieBaseTyp.getClass().getName());
        }
        estateImpl.getCustomValues().putCustomValue("nr", (Object)immobilieBaseTyp.getAnbieterObjektID(), 5);
        estateImpl.getCustomValues().putCustomValue("nr_intern", (Object)immobilieBaseTyp.getScoutObjektID(), 5);
        if (immobilieBaseTyp.getProvision() != null && !Boolean.FALSE.equals(immobilieBaseTyp.getProvisionspflichtig())) {
            AgentFee.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getProvision());
        }
        FeatureDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getAusstattung());
        LocationDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getLage());
        DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getObjektbeschreibung());
        AgentFeeInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getProvisionshinweis());
        AdditionalInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)immobilieBaseTyp.getSonstigeAngaben());
        for (MultimediaAnhangTyp multimediaAnhangTyp : immobilieBaseTyp.getMultimediaAnhang()) {
            String string;
            EstateAttachmentImpl estateAttachmentImpl;
            MMAnhangArtenTyp mMAnhangArtenTyp = multimediaAnhangTyp.getAnhangArt();
            if (MMAnhangArtenTyp.LINK.equals((Object)mMAnhangArtenTyp)) {
                try {
                    estateAttachmentImpl = this.createEmptyLink();
                    estateAttachmentImpl.setWebLink(new URI(multimediaAnhangTyp.getDateiname()));
                    estateAttachmentImpl.setTitle(multimediaAnhangTyp.getTitel(), this.getOpenEstateLanguage());
                    estateImpl.getLinks().add(estateAttachmentImpl);
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't read link: " + multimediaAnhangTyp.getDateiname());
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
                continue;
            }
            estateAttachmentImpl = this.createEmptyAttachment();
            if (MMAnhangArtenTyp.BILD.equals((Object)mMAnhangArtenTyp)) {
                estateAttachmentImpl.setType(EstateAttachmentType.IMAGE);
            } else if (MMAnhangArtenTyp.GRUNDRISS_BILD.equals((Object)mMAnhangArtenTyp)) {
                estateAttachmentImpl.setType(EstateAttachmentType.IMAGE_GROUNDPLAN);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)multimediaAnhangTyp.getDateityp())) {
                string = multimediaAnhangTyp.getDateityp().trim();
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                arrayList.add(string);
            }
            if (!StringUtils.isBlank((CharSequence)multimediaAnhangTyp.getDateiname()) && multimediaAnhangTyp.getDateiname().contains(".")) {
                string = StringUtils.substringAfterLast((String)multimediaAnhangTyp.getDateiname(), (String)".").trim();
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                arrayList.add(string);
            }
            string = null;
            for (String string2 : arrayList) {
                DateiSuffix dateiSuffix = DateiSuffix.fromFileName((String)string2);
                if (dateiSuffix != null) {
                    string = dateiSuffix.getMimeType();
                }
                if (StringUtils.isBlank((CharSequence)string)) continue;
                break;
            }
            if (StringUtils.isBlank((CharSequence)string)) {
                LOGGER.warn("Can't find MIME type for attachment!");
                LOGGER.warn("> Dateiname : '" + multimediaAnhangTyp.getDateiname() + "'");
                LOGGER.warn("> Dateityp  : '" + multimediaAnhangTyp.getDateityp() + "'");
                continue;
            }
            estateAttachmentImpl.setTitle(multimediaAnhangTyp.getTitel(), this.getOpenEstateLanguage());
            estateAttachmentImpl.setFile(multimediaAnhangTyp.getDateiname());
            estateAttachmentImpl.setMimeType(string);
            estateImpl.getAttachments().add(estateAttachmentImpl);
        }
        object = immobilieBaseTyp.getApiSuchfelder();
        if (object != null) {
            if (((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld1() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search1", ((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld1().getValue(), 5);
            }
            if (((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld2() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search2", ((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld2().getValue(), 5);
            }
            if (((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld3() != null) {
                estateImpl.getCustomValues().putCustomValue("is24.api.search3", ((ApiSuchfelderTyp)object.getValue()).getApiSuchfeld3().getValue(), 5);
            }
        }
        return estateImpl;
    }

    protected void convertImmobilie(Anlageobjekt.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        AnlageobjekteKategorieTyp anlageobjekteKategorieTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = AnlageobjekteKategorieTyp.BUEROGEBAEUDE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.OFFICE_BUILDING : (AnlageobjekteKategorieTyp.EIGENTUMSWOHNUNG.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.RESIDENCE : (AnlageobjekteKategorieTyp.EINFAMILIENHAUS.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.SINGLE_FAMILY_HOUSE : (AnlageobjekteKategorieTyp.EINKAUFSZENTRUM.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.SHOPPING_CENTER : (AnlageobjekteKategorieTyp.FREIZEITANLAGE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.LEISURE_SPORTS_FACILITY : (AnlageobjekteKategorieTyp.GASTSTAETTE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.RESTAURANT_BAR : (AnlageobjekteKategorieTyp.GESCHAEFTSHAUS.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.COMMERCIAL_BUILDING : (AnlageobjekteKategorieTyp.GEWERBEANWESEN.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.COMMERCIAL_CENTER : (AnlageobjekteKategorieTyp.GEWERBEEINHEIT.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (AnlageobjekteKategorieTyp.HALLE_LAGER.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.HALL_WAREHOUSE : (AnlageobjekteKategorieTyp.HOTEL.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.HOTEL : (AnlageobjekteKategorieTyp.INDUSTRIEANWESEN.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.INDUSTRIAL_FACILITY : (AnlageobjekteKategorieTyp.LADEN_VERKAUFSFLAECHE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.SALES_AREA : (AnlageobjekteKategorieTyp.MEHRFAMILIENHAUS.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.MULTI_FAMILY_HOUSE : (AnlageobjekteKategorieTyp.SERVICECENTER.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.SERVICE_CENTER : (AnlageobjekteKategorieTyp.SONSTIGE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (AnlageobjekteKategorieTyp.SUPERMARKT.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.CONSUMER_STORE : (AnlageobjekteKategorieTyp.WOHNANLAGE.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.HOUSING_COMPLEX : (AnlageobjekteKategorieTyp.WOHN_GESCHAEFTSHAUS.equals((Object)anlageobjekteKategorieTyp) ? OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING : OpenEstateType.GENERAL_COMMERCIAL))))))))))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)type.getGewerbeFlaechen(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        PurchasePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreis());
        PurchasePricePerArea.put((EstateImpl)estateImpl, (Number)type.getKaufpreisProQm());
        RentalIncomeActualPerAnnum.put((EstateImpl)estateImpl, (Number)type.getMietEinnahmePaIst());
        RentalIncomeDebitPerAnnum.put((EstateImpl)estateImpl, (Number)type.getMietEinnahmePaSoll());
        CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)type.getPreisProParkflaeche());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getSonstigeFlaechen(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RentableArea.put((EstateImpl)estateImpl, (Number)type.getVermietbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnFlaechen(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PurchasePriceOnAnnualRentalIncome.put((EstateImpl)estateImpl, (Number)type.getXFacheMiete());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(BueroPraxis.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        BueroPraxisKategorienTyp bueroPraxisKategorienTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = BueroPraxisKategorienTyp.ATELIER.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.ATELIER : (BueroPraxisKategorienTyp.BUERO.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE : (BueroPraxisKategorienTyp.BUEROHAUS.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_BUILDING : (BueroPraxisKategorienTyp.BUEROZENTRUM.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_CENTER : (BueroPraxisKategorienTyp.BUERO_ETAGE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_FLOOR : (BueroPraxisKategorienTyp.BUERO_UND_GESCHAEFTSGEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_COMMERCIAL_BUILDING : (BueroPraxisKategorienTyp.BUERO_UND_LAGER_GEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_COMMERCIAL_BUILDING : (BueroPraxisKategorienTyp.GEWERBE_ZENTRUM.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.COMMERCIAL_CENTER : (BueroPraxisKategorienTyp.KEINE_ANGABE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.OFFICE_SURGERY : (BueroPraxisKategorienTyp.LOFT.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.LOFT : (BueroPraxisKategorienTyp.PRAXIS.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.SURGERY : (BueroPraxisKategorienTyp.PRAXIS_ETAGE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.SURGERY_FLOOR : (BueroPraxisKategorienTyp.PRAXIS_HAUS.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.DOCTORS_OFFICE_HOUSE : (BueroPraxisKategorienTyp.WOHN_UND_GESCHAEFTSGEBAEUDE.equals((Object)bueroPraxisKategorienTyp) ? OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING : OpenEstateType.OFFICE_SURGERY)))))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        OfficeArea.put((EstateImpl)estateImpl, (Number)type.getBueroPraxisFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)type.getBueroPraxisFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        CanteenCafeteria.put((EstateImpl)estateImpl, (Boolean)type.getKantine());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (Boolean.TRUE.equals(type.getKuecheVorhanden())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        if (Boolean.TRUE.equals(type.getStarkstrom())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.HIGH_VOLTAGE_CURRENT);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readDatenVerkabelung(type.getDatenVerkabelung(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readKlimaanlage(type.getKlimaanlage(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(Einzelhandel.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        EinzelhandelKategorienTyp einzelhandelKategorienTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = EinzelhandelKategorienTyp.AUSSTELLUNGSFLAECHE.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.EXHIBITION_AREA : (EinzelhandelKategorienTyp.EINKAUFSZENTRUM.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.SHOPPING_CENTER : (EinzelhandelKategorienTyp.FACTORY_OUTLET.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.RETAIL : (EinzelhandelKategorienTyp.KAUFHAUS.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.DEPARTMENT_STORE : (EinzelhandelKategorienTyp.KEINE_ANGABE.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.RETAIL : (EinzelhandelKategorienTyp.KIOSK.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.KIOSK : (EinzelhandelKategorienTyp.LADEN.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.SHOP : (EinzelhandelKategorienTyp.SB_MARKT.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.SELF_SERVICE_MARKET : (EinzelhandelKategorienTyp.VERKAUFSFLAECHE.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.SALES_AREA : (EinzelhandelKategorienTyp.VERKAUFSHALLE.equals((Object)einzelhandelKategorienTyp) ? OpenEstateType.SHOWROOM : OpenEstateType.RETAIL)))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CeilingLoad.put((EstateImpl)estateImpl, (Number)type.getDeckenlast());
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        FrontWindowLength.put((EstateImpl)estateImpl, (Number)type.getSchaufensterfront(), (LengthValue.Unit)LengthValue.Unit.M);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        SalesArea.put((EstateImpl)estateImpl, (Number)type.getVerkaufsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)type.getVerkaufsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        Ramp.put((EstateImpl)estateImpl, (Boolean)type.getRampe());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readLageArt(type.getLageart(), estateImpl);
        if (type.getLastenaufzug() != null) {
            this.readLastenaufzug((HebeanlageTyp)type.getLastenaufzug().getValue(), estateImpl);
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
        this.readObjektZulieferung(type.getZulieferung(), estateImpl);
    }

    protected void convertImmobilie(GarageKauf.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        GaragenKategorieTyp garagenKategorieTyp = type.getObjektKategorie2();
        OpenEstateType openEstateType = GaragenKategorieTyp.AUSSENSTELLPLATZ.equals((Object)garagenKategorieTyp) ? OpenEstateType.OUTDOOR_CAR_PARKING_SPACE : (GaragenKategorieTyp.CARPORT.equals((Object)garagenKategorieTyp) ? OpenEstateType.CARPORT : (GaragenKategorieTyp.DUPLEX.equals((Object)garagenKategorieTyp) ? OpenEstateType.DUPLEX_GARAGE : (GaragenKategorieTyp.GARAGE.equals((Object)garagenKategorieTyp) ? OpenEstateType.GARAGE : (GaragenKategorieTyp.KEINE_ANGABE.equals((Object)garagenKategorieTyp) ? OpenEstateType.GENERAL_PARKING : (GaragenKategorieTyp.PARKHAUS.equals((Object)garagenKategorieTyp) ? OpenEstateType.CAR_PARK : (GaragenKategorieTyp.TIEFGARAGE.equals((Object)garagenKategorieTyp) ? OpenEstateType.UNDERGROUND_CAR_PARK : OpenEstateType.GENERAL_PARKING))))));
        estateImpl.setType(openEstateType, openEstateAction);
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        Width.put((EstateImpl)estateImpl, (Number)type.getBreite(), (LengthValue.Unit)LengthValue.Unit.M);
        CarParkingArea.put((EstateImpl)estateImpl, (Number)type.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        Height.put((EstateImpl)estateImpl, (Number)type.getHoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        Length.put((EstateImpl)estateImpl, (Number)type.getLaenge(), (LengthValue.Unit)LengthValue.Unit.M);
        if (type.getKaufpreise() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getKaufpreis());
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(GarageMiete.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        GaragenKategorieTyp garagenKategorieTyp = type.getObjektKategorie2();
        OpenEstateType openEstateType = GaragenKategorieTyp.AUSSENSTELLPLATZ.equals((Object)garagenKategorieTyp) ? OpenEstateType.OUTDOOR_CAR_PARKING_SPACE : (GaragenKategorieTyp.CARPORT.equals((Object)garagenKategorieTyp) ? OpenEstateType.CARPORT : (GaragenKategorieTyp.DUPLEX.equals((Object)garagenKategorieTyp) ? OpenEstateType.DUPLEX_GARAGE : (GaragenKategorieTyp.GARAGE.equals((Object)garagenKategorieTyp) ? OpenEstateType.GARAGE : (GaragenKategorieTyp.KEINE_ANGABE.equals((Object)garagenKategorieTyp) ? OpenEstateType.GENERAL_PARKING : (GaragenKategorieTyp.PARKHAUS.equals((Object)garagenKategorieTyp) ? OpenEstateType.CAR_PARK_UNIT : (GaragenKategorieTyp.TIEFGARAGE.equals((Object)garagenKategorieTyp) ? OpenEstateType.UNDERGROUND_CAR_PARK_UNIT : OpenEstateType.GENERAL_PARKING))))));
        estateImpl.setType(openEstateType, openEstateAction);
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        Width.put((EstateImpl)estateImpl, (Number)type.getBreite(), (LengthValue.Unit)LengthValue.Unit.M);
        CarParkingArea.put((EstateImpl)estateImpl, (Number)type.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        Height.put((EstateImpl)estateImpl, (Number)type.getHoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        Length.put((EstateImpl)estateImpl, (Number)type.getLaenge(), (LengthValue.Unit)LengthValue.Unit.M);
        if (type.getMietpreise() != null) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getMiete());
        }
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
    }

    protected void convertImmobilie(Gastronomie.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = type.getVermarktung();
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        GastroKategorieTyp gastroKategorieTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = GastroKategorieTyp.BARBETRIEB.equals((Object)gastroKategorieTyp) ? OpenEstateType.RESTAURANT_BAR : (GastroKategorieTyp.CAFFEE.equals((Object)gastroKategorieTyp) ? OpenEstateType.BISTRO_CAFE : (GastroKategorieTyp.DISKOTHEK.equals((Object)gastroKategorieTyp) ? OpenEstateType.DISCOTHEQUE : (GastroKategorieTyp.FERIENBUNGALOW.equals((Object)gastroKategorieTyp) ? OpenEstateType.BUNGALOW : (GastroKategorieTyp.GAESTEHAUS.equals((Object)gastroKategorieTyp) ? OpenEstateType.HOSPITALITY_INDUSTRY : (GastroKategorieTyp.GASTSTAETTE.equals((Object)gastroKategorieTyp) ? OpenEstateType.RESTAURANT_BAR : (GastroKategorieTyp.HOTEL.equals((Object)gastroKategorieTyp) ? OpenEstateType.HOTEL : (GastroKategorieTyp.HOTELANWESEN.equals((Object)gastroKategorieTyp) ? OpenEstateType.HOTEL : (GastroKategorieTyp.HOTEL_GARNI.equals((Object)gastroKategorieTyp) ? OpenEstateType.HOTEL : (GastroKategorieTyp.PENSION.equals((Object)gastroKategorieTyp) ? OpenEstateType.GUESTHOUSE : (GastroKategorieTyp.RESTAURANT.equals((Object)gastroKategorieTyp) ? OpenEstateType.RESTAURANT : OpenEstateType.HOSPITALITY_INDUSTRY))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountBeds.put((EstateImpl)estateImpl, (Number)type.getAnzahlBetten());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        SeatingArea.put((EstateImpl)estateImpl, (Number)type.getGastraumFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountGuestroomSeats.put((EstateImpl)estateImpl, (Number)type.getGastraumPlaetze());
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckGewerbe.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp = type.getVermarktung();
        if (vermarktungGrundstueckGewerbeTyp.getErbpacht() != null) {
            openEstateAction = OpenEstateAction.EMPHYTEUSIS;
        } else if (vermarktungGrundstueckGewerbeTyp.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGrundstueckGewerbeTyp.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else if (vermarktungGrundstueckGewerbeTyp.getPacht() != null) {
            openEstateAction = OpenEstateAction.LEASE;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        GrundstueckGewerbeKategorienTyp grundstueckGewerbeKategorienTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = GrundstueckGewerbeKategorienTyp.FREIZEIT.equals((Object)grundstueckGewerbeKategorienTyp) ? OpenEstateType.LEISURE_GROUND : (GrundstueckGewerbeKategorienTyp.GEWERBE.equals((Object)grundstueckGewerbeKategorienTyp) ? OpenEstateType.COMMERCIAL_GROUND : (GrundstueckGewerbeKategorienTyp.LAND_FORSTWIRTSCHAFT.equals((Object)grundstueckGewerbeKategorienTyp) ? OpenEstateType.AGRICULTURAL_FORESTRY_GROUND : OpenEstateType.COMMERCIAL_GROUND));
        estateImpl.setType(openEstateType, openEstateAction);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        FloorAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGFZ());
        BaseAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGRZ());
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DemolitionRequired.put((EstateImpl)estateImpl, (Boolean)type.getAbrissErforderlich());
        BuildingPermissionAvailable.put((EstateImpl)estateImpl, (Boolean)type.getBaugenehmigungVorhanden());
        BuildableInShortTerm.put((EstateImpl)estateImpl, (Boolean)type.getKurzfristigBebaubar());
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckWohnenKauf.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp = type.getVermarktung();
        if (vermarktungGrundstueckWohnenKaufTyp.getErbpacht() != null) {
            openEstateAction = OpenEstateAction.EMPHYTEUSIS;
        } else if (vermarktungGrundstueckWohnenKaufTyp.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        OpenEstateType openEstateType = OpenEstateType.RESIDENTIAL_GROUND;
        estateImpl.setType(openEstateType, openEstateAction);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        FloorAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGFZ());
        BaseAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGRZ());
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DemolitionRequired.put((EstateImpl)estateImpl, (Boolean)type.getAbrissErforderlich());
        BuildingPermissionAvailable.put((EstateImpl)estateImpl, (Boolean)type.getBaugenehmigungVorhanden());
        BuildableInShortTerm.put((EstateImpl)estateImpl, (Boolean)type.getKurzfristigBebaubar());
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(GrundstueckWohnenMiete.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp = type.getVermarktung();
        if (vermarktungGrundstueckWohnenMieteTyp.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else if (vermarktungGrundstueckWohnenMieteTyp.getPacht() != null) {
            openEstateAction = OpenEstateAction.LEASE;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        OpenEstateType openEstateType = OpenEstateType.RESIDENTIAL_GROUND;
        estateImpl.setType(openEstateType, openEstateAction);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        FloorAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGFZ());
        BaseAreaIndex.put((EstateImpl)estateImpl, (Number)type.getGRZ());
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DemolitionRequired.put((EstateImpl)estateImpl, (Boolean)type.getAbrissErforderlich());
        BuildingPermissionAvailable.put((EstateImpl)estateImpl, (Boolean)type.getBaugenehmigungVorhanden());
        BuildableInShortTerm.put((EstateImpl)estateImpl, (Boolean)type.getKurzfristigBebaubar());
        this.readBebaubarMit(type.getBebaubarMit(), estateImpl);
        this.readBebaubarNach(type.getBebaubarNach(), estateImpl);
        this.readErschliessungZustand(type.getErschliessungszustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(HalleProduktion.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGewerbeTyp vermarktungGewerbeTyp = type.getVermarktung();
        if (vermarktungGewerbeTyp.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        HalleProduktionKategorieTyp halleProduktionKategorieTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = HalleProduktionKategorieTyp.AUSSTELLUNGSFLAECHE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.EXHIBITION_AREA : (HalleProduktionKategorieTyp.HALLE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.HALL_WAREHOUSE : (HalleProduktionKategorieTyp.HOCHREGALLAGER.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.HIGH_RACK_WAREHOUSE : (HalleProduktionKategorieTyp.INDUSTRIEHALLE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.INDUSTRIAL_WAREHOUSE : (HalleProduktionKategorieTyp.INDUSTRIEHALLE_MIT_FREIFLAECHE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE : (HalleProduktionKategorieTyp.KUEHLHAUS.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.COOLING_HOUSE : (HalleProduktionKategorieTyp.KUEHLREGALLAGER.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.COLD_STORAGE_WAREHOUSE : (HalleProduktionKategorieTyp.LAGERFLAECHE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.STORAGE_AREA : (HalleProduktionKategorieTyp.LAGERHALLE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.WAREHOUSE : (HalleProduktionKategorieTyp.LAGER_MIT_FREIFLAECHE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.STORAGE_AREA : (HalleProduktionKategorieTyp.SERVICEFLAECHE.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.SERVICE_AREA : (HalleProduktionKategorieTyp.SPEDITIONSLAGER.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.FORWARDING_WAREHOUSE : (HalleProduktionKategorieTyp.WERKSTATT.equals((Object)halleProduktionKategorieTyp) ? OpenEstateType.WORKSHOP : OpenEstateType.HALL_WAREHOUSE))))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        FloorLoading.put((EstateImpl)estateImpl, (Number)type.getBodenbelastung());
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        WarehouseHeight.put((EstateImpl)estateImpl, (Number)type.getHallenhoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        StorageArea.put((EstateImpl)estateImpl, (Number)type.getLagerProduktionsFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ElectricalConnectionValue.put((EstateImpl)estateImpl, (Number)type.getStromanschlusswert());
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        LiftingPlatform.put((EstateImpl)estateImpl, (Boolean)type.getHebebuehne());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        Ramp.put((EstateImpl)estateImpl, (Boolean)type.getRampe());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readKranbahn(type.getKranbahn(), estateImpl);
        this.readLastenaufzug(type.getLastenaufzug(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(HausKauf.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        HausKategorienTyp hausKategorienTyp = type.getHausKategorie();
        OpenEstateType openEstateType = HausKategorienTyp.BAUERNHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.FARMHOUSE : (HausKategorienTyp.BESONDERE_IMMOBILIE.equals((Object)hausKategorienTyp) ? OpenEstateType.SPECIAL_HOUSE : (HausKategorienTyp.BUNGALOW.equals((Object)hausKategorienTyp) ? OpenEstateType.BUNGALOW : (HausKategorienTyp.BURG_SCHLOSS.equals((Object)hausKategorienTyp) ? OpenEstateType.CASTLE : (HausKategorienTyp.DOPPELHAUSHAELFTE.equals((Object)hausKategorienTyp) ? OpenEstateType.SEMIDETACHED_HOUSE : (HausKategorienTyp.EINFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.SINGLE_FAMILY_HOUSE : (HausKategorienTyp.MEHRFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.MULTI_FAMILY_HOUSE : (HausKategorienTyp.REIHENECKHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE_CORNERSIDE : (HausKategorienTyp.REIHENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE : (HausKategorienTyp.REIHENMITTELHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE_MIDDLE : (HausKategorienTyp.SONSTIGES.equals((Object)hausKategorienTyp) ? OpenEstateType.HOUSE : (HausKategorienTyp.VILLA.equals((Object)hausKategorienTyp) ? OpenEstateType.VILLA : (HausKategorienTyp.ZWEIFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TWO_FAMILY_HOUSE : OpenEstateType.HOUSE))))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlGaragenStellplaetze());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlSchlafzimmer());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        if (type.getKaufpreise() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getKaufpreis());
            RentalIncomePerMonth.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getMieteinnahmenProMonat());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getStellplatzKaufpreis());
            CommonCharge.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getWohngeld());
        }
        UsableArea.put((EstateImpl)estateImpl, (Number)type.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)type.getAlsFerienwohnungGeeignet());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        GrannyFlat.put((EstateImpl)estateImpl, (Boolean)type.getMitEinliegerwohnung());
        if (Boolean.TRUE.equals(type.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        Rented.put((EstateImpl)estateImpl, (Boolean)type.getVermietet());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBauphase(type.getBauphase(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(HausMiete.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        HausKategorienTyp hausKategorienTyp = type.getHausKategorie();
        OpenEstateType openEstateType = HausKategorienTyp.BAUERNHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.FARMHOUSE : (HausKategorienTyp.BESONDERE_IMMOBILIE.equals((Object)hausKategorienTyp) ? OpenEstateType.SPECIAL_HOUSE : (HausKategorienTyp.BUNGALOW.equals((Object)hausKategorienTyp) ? OpenEstateType.BUNGALOW : (HausKategorienTyp.BURG_SCHLOSS.equals((Object)hausKategorienTyp) ? OpenEstateType.CASTLE : (HausKategorienTyp.DOPPELHAUSHAELFTE.equals((Object)hausKategorienTyp) ? OpenEstateType.SEMIDETACHED_HOUSE : (HausKategorienTyp.EINFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.SINGLE_FAMILY_HOUSE : (HausKategorienTyp.MEHRFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.MULTI_FAMILY_HOUSE : (HausKategorienTyp.REIHENECKHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE_CORNERSIDE : (HausKategorienTyp.REIHENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE : (HausKategorienTyp.REIHENMITTELHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TERRACED_HOUSE_MIDDLE : (HausKategorienTyp.SONSTIGES.equals((Object)hausKategorienTyp) ? OpenEstateType.HOUSE : (HausKategorienTyp.VILLA.equals((Object)hausKategorienTyp) ? OpenEstateType.VILLA : (HausKategorienTyp.ZWEIFAMILIENHAUS.equals((Object)hausKategorienTyp) ? OpenEstateType.TWO_FAMILY_HOUSE : OpenEstateType.HOUSE))))))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlGaragenStellplaetze());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlSchlafzimmer());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        if (type.getMietpreise() != null) {
            HeatingCosts.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getHeizkosten());
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getKaltmiete());
            Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getMietpreise().getKaution());
            ServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getNebenkosten());
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getStellplatzMiete());
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getWarmmiete());
            ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)type.getMietpreise().getHeizkostenInWarmmieteEnthalten());
        }
        UsableArea.put((EstateImpl)estateImpl, (Number)type.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        if (Boolean.TRUE.equals(type.getBetreutesWohnen())) {
            ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING);
        }
        if (Boolean.TRUE.equals(type.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (Boolean.TRUE.equals(type.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(SonstigeGewerbe.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction;
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = type.getVermarktung();
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            openEstateAction = OpenEstateAction.PURCHASE;
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            openEstateAction = OpenEstateAction.RENT;
        } else {
            throw new IllegalArgumentException("Unbekannte Vermarktungsart!");
        }
        SonstigeGewerbeKategorieTyp sonstigeGewerbeKategorieTyp = type.getObjektkategorie2();
        OpenEstateType openEstateType = SonstigeGewerbeKategorieTyp.ANWESEN.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (SonstigeGewerbeKategorieTyp.BAUERNHOF.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.FARM : (SonstigeGewerbeKategorieTyp.FREIZEITANLAGE.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.LEISURE_SPORTS_FACILITY : (SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (SonstigeGewerbeKategorieTyp.GEWERBEPARK.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (SonstigeGewerbeKategorieTyp.REITERHOF.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.RIDING_ESTATE : (SonstigeGewerbeKategorieTyp.SPEZIALOBJEKT.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (SonstigeGewerbeKategorieTyp.WEINGUT.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.VINICULTURE : (SonstigeGewerbeKategorieTyp.WERKSTATT.equals((Object)sonstigeGewerbeKategorieTyp) ? OpenEstateType.WORKSHOP : OpenEstateType.GENERAL_COMMERCIAL))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        CountFloors.put((EstateImpl)estateImpl, (String)type.getEtagen());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBAB()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitBHf()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(type.getFahrzeitFlughafen()));
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(type.getFusswegOeNV()));
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)type.getGrundstuecksFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)type.getHauptflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)type.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)type.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getPersonenaufzug());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readVermarktung(type.getVermarktung(), estateImpl);
    }

    protected void convertImmobilie(WAZ.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.SHORT_TERM_RENT;
        WazKategorienTyp wazKategorienTyp = type.getWazKategorie();
        OpenEstateType openEstateType = WazKategorienTyp.APPARTMENT.equals((Object)wazKategorienTyp) ? OpenEstateType.APARTMENT : (WazKategorienTyp.HAUS.equals((Object)wazKategorienTyp) ? OpenEstateType.HOUSE : (WazKategorienTyp.WOHNUNG.equals((Object)wazKategorienTyp) ? OpenEstateType.RESIDENCE : (WazKategorienTyp.ZIMMER.equals((Object)wazKategorienTyp) ? OpenEstateType.ROOM : OpenEstateType.GENERAL_RESIDENCE)));
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlGaragenStellplaetze());
        PeopleMaximumCount.put((EstateImpl)estateImpl, (Number)type.getAnzahlPersonen());
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getEtage(), null));
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)type.getFreiAb());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)type.getFreiBis());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getKaution());
        OccupationPeriodMaximum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getMaximalmietdauer(), null));
        OccupationPeriodMinimum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getMidestmietdauer(), null));
        if (type.getMonatsmiete() != null) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMonatsmiete().getKaltmiete());
            ServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMonatsmiete().getNebenkosten());
        }
        CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)type.getParkplatzmiete());
        if (type.getPauschalmiete() != null) {
            RentFlatRate.put((EstateImpl)estateImpl, (Number)type.getPauschalmiete().getMietePauschal());
            if (WazZeiteinheitenTyp.MONAT.equals((Object)type.getPauschalmiete().getMietePro())) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.MONTH);
            } else if (WazZeiteinheitenTyp.TAG.equals((Object)type.getPauschalmiete().getMietePro())) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.DAY);
            } else if (WazZeiteinheitenTyp.WOCHE.equals((Object)type.getPauschalmiete().getMietePro())) {
                RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.WEEK);
            }
        }
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getAufzug());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)type.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        GardenUse.put((EstateImpl)estateImpl, (Boolean)type.getGartenBenutzung());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (Boolean.TRUE.equals(type.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readGeschlecht(type.getGeschlecht(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readMoebliert(type.getMobilar(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readRaucher(type.getRaucherOk(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(WGZimmer.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        OpenEstateType openEstateType = OpenEstateType.APARTMENT_SHARE;
        estateImpl.setType(openEstateType, openEstateAction);
        AgeOfFlatmatesMaximal.put((EstateImpl)estateImpl, (Number)type.getAlterDerzeitigeBewohnerBis());
        AgeOfFlatmatesMinimal.put((EstateImpl)estateImpl, (Number)type.getAlterDerzeitigeBewohnerVon());
        AgeOfRequestedFlatmatesMaximal.put((EstateImpl)estateImpl, (Number)type.getAlterGesuchterBewohnerBis());
        AgeOfRequestedFlatmatesMinimal.put((EstateImpl)estateImpl, (Number)type.getAlterGesuchterBewohnerVon());
        CountBathrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlBadezimmer());
        CountRequestedFlatmates.put((EstateImpl)estateImpl, (Number)type.getAnzahlGesuchteMitbewohner());
        CountFlatmatesMale.put((EstateImpl)estateImpl, (Number)type.getAnzahlMaennlicheMitbewohner());
        CountFlatmatesFemale.put((EstateImpl)estateImpl, (Number)type.getAnzahlWeiblicheMitbewohner());
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getEtage(), null));
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)type.getFreiAb());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)type.getFreiBis());
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getZimmerflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getAufzug());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)type.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        GardenUse.put((EstateImpl)estateImpl, (Boolean)type.getGartenBenutzung());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (type.getMietpreise() != null) {
            HeatingCosts.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getHeizkosten());
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getKaltmiete());
            Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getMietpreise().getKaution());
            if (type.getMietpreise().getMindestmietdauer() != null) {
                OccupationPeriodMinimum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getMietpreise().getMindestmietdauer().value(), null));
            }
            ServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getNebenkosten());
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getWarmmiete());
            ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)type.getMietpreise().getHeizkostenInWarmmieteEnthalten());
        }
        this.readBodenBelag(type.getBodenbelag(), estateImpl);
        this.readGeschlecht(type.getGeschlechtGesuchterBewohner(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readMoebliert(type.getMobilar(), estateImpl);
        this.readRaucher(type.getRauchen(), estateImpl);
        this.readTvAnschluss(type.getTVAnschluss(), estateImpl);
        this.readWgGroesse(type.getBewohnerzahl(), estateImpl);
        if (Boolean.TRUE.equals(type.getBadewanne())) {
            Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BATHTUB);
        }
        if (Boolean.TRUE.equals(type.getDusche())) {
            Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.SHOWER);
        }
        if (Boolean.TRUE.equals(type.getWaschmaschine())) {
            Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.WASHING_MACHINE_CONNECTION);
        }
    }

    protected void convertImmobilie(WohnungKauf.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        WohnungKategorienTyp wohnungKategorienTyp = type.getWohnungKategorie();
        OpenEstateType openEstateType = WohnungKategorienTyp.DACHGESCHOSS.equals((Object)wohnungKategorienTyp) ? OpenEstateType.ATTIC_APARTMENT : (WohnungKategorienTyp.ERDGESCHOSS.equals((Object)wohnungKategorienTyp) ? OpenEstateType.GROUND_FLOOR_APARTMENT : (WohnungKategorienTyp.ETAGENWOHNUNG.equals((Object)wohnungKategorienTyp) ? OpenEstateType.HIGHER_FLOOR_APARTMENT : (WohnungKategorienTyp.HOCHPARTERRE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.MEZZANINE : (WohnungKategorienTyp.LOFT.equals((Object)wohnungKategorienTyp) ? OpenEstateType.LOFT : (WohnungKategorienTyp.MAISONETTE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.MAISONETTE : (WohnungKategorienTyp.PENTHOUSE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.PENTHOUSE_APARTMENT : (WohnungKategorienTyp.SONSTIGE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.RESIDENCE : (WohnungKategorienTyp.SOUTERRAIN.equals((Object)wohnungKategorienTyp) ? OpenEstateType.SOUTERRAIN_APARTMENT : (WohnungKategorienTyp.TERRASSENWOHNUNG.equals((Object)wohnungKategorienTyp) ? OpenEstateType.TERRACE_APARTMENT : OpenEstateType.RESIDENCE)))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlGaragenStellplaetze());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlSchlafzimmer());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getEtage(), null));
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        if (type.getKaufpreise() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getKaufpreis());
            RentalIncomePerMonth.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getMieteinnahmenProMonat());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getStellplatzKaufpreis());
            CommonCharge.put((EstateImpl)estateImpl, (Number)type.getKaufpreise().getWohngeld());
        }
        UsableArea.put((EstateImpl)estateImpl, (Number)type.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)type.getAlsFerienwohnungGeeignet());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getAufzug());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)type.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        if (Boolean.TRUE.equals(type.getBetreutesWohnen())) {
            ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING);
        }
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)type.getDenkmalschutzobjekt());
        if (Boolean.TRUE.equals(type.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        GardenUse.put((EstateImpl)estateImpl, (Boolean)type.getGartenBenutzung());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (Boolean.TRUE.equals(type.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        Rented.put((EstateImpl)estateImpl, (Boolean)type.getVermietet());
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(WohnungMiete.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        WohnungKategorienTyp wohnungKategorienTyp = type.getWohnungKategorie();
        OpenEstateType openEstateType = WohnungKategorienTyp.DACHGESCHOSS.equals((Object)wohnungKategorienTyp) ? OpenEstateType.ATTIC_APARTMENT : (WohnungKategorienTyp.ERDGESCHOSS.equals((Object)wohnungKategorienTyp) ? OpenEstateType.GROUND_FLOOR_APARTMENT : (WohnungKategorienTyp.ETAGENWOHNUNG.equals((Object)wohnungKategorienTyp) ? OpenEstateType.HIGHER_FLOOR_APARTMENT : (WohnungKategorienTyp.HOCHPARTERRE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.MEZZANINE : (WohnungKategorienTyp.LOFT.equals((Object)wohnungKategorienTyp) ? OpenEstateType.LOFT : (WohnungKategorienTyp.MAISONETTE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.MAISONETTE : (WohnungKategorienTyp.PENTHOUSE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.PENTHOUSE_APARTMENT : (WohnungKategorienTyp.SONSTIGE.equals((Object)wohnungKategorienTyp) ? OpenEstateType.RESIDENCE : (WohnungKategorienTyp.SOUTERRAIN.equals((Object)wohnungKategorienTyp) ? OpenEstateType.SOUTERRAIN_APARTMENT : (WohnungKategorienTyp.TERRASSENWOHNUNG.equals((Object)wohnungKategorienTyp) ? OpenEstateType.TERRACE_APARTMENT : OpenEstateType.RESIDENCE)))))))));
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)type.getAnzahlGaragenStellplaetze());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)type.getAnzahlSchlafzimmer());
        BuildYear.put((EstateImpl)estateImpl, (Number)type.getBaujahr());
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)OpenEstateUtils.toString((Object)type.getEtage(), null));
        CountFloors.put((EstateImpl)estateImpl, (Number)type.getEtagenzahl());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getFreiAb());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)type.getJahrLetzteModernisierung());
        if (type.getMietpreise() != null) {
            HeatingCosts.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getHeizkosten());
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getKaltmiete());
            Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getMietpreise().getKaution());
            ServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getNebenkosten());
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getStellplatzMiete());
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)type.getMietpreise().getWarmmiete());
            ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)type.getMietpreise().getHeizkostenInWarmmieteEnthalten());
        }
        UsableArea.put((EstateImpl)estateImpl, (Number)type.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)type.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)type.getZimmer());
        Lift.put((EstateImpl)estateImpl, (Boolean)type.getAufzug());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)type.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)type.getBarrierefrei());
        if (Boolean.TRUE.equals(type.getBetreutesWohnen())) {
            ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING);
        }
        if (Boolean.TRUE.equals(type.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        WbsRequired.put((EstateImpl)estateImpl, (Boolean)type.getFoerderung());
        if (Boolean.TRUE.equals(type.getGaesteWC())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        GardenUse.put((EstateImpl)estateImpl, (Boolean)type.getGartenBenutzung());
        Basement.put((EstateImpl)estateImpl, (Boolean)type.getKeller());
        if (Boolean.TRUE.equals(type.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        this.readAustattungsQualitaet(type.getAusstattungsqualitaet(), estateImpl);
        this.readBefeuerungsArt(type.getBefeuerungsArt(), estateImpl);
        this.readEnergieAusweis(type.getEnergieausweis(), estateImpl);
        this.readHaustiere(type.getHaustiere(), estateImpl);
        this.readHeizungsArt(type.getHeizungsart(), estateImpl);
        this.readObjektZustand(type.getObjektzustand(), estateImpl);
        this.readStellplatz(type.getParkplatz(), estateImpl);
    }

    protected void convertImmobilie(Zwangsversteigerung.Type type, EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = OpenEstateAction.AUCTION;
        ZwangsversteigerungKategorieTyp zwangsversteigerungKategorieTyp = type.getObjektart();
        OpenEstateType openEstateType = ZwangsversteigerungKategorieTyp.EFH_MFH.equals((Object)zwangsversteigerungKategorieTyp) ? OpenEstateType.HOUSE : (ZwangsversteigerungKategorieTyp.EIGENTUMSWOHNUNG.equals((Object)zwangsversteigerungKategorieTyp) ? OpenEstateType.RESIDENCE : (ZwangsversteigerungKategorieTyp.GARAGE_SONSTIGES.equals((Object)zwangsversteigerungKategorieTyp) ? OpenEstateType.GENERAL_PARKING : (ZwangsversteigerungKategorieTyp.GEWERBE_ANLAGE.equals((Object)zwangsversteigerungKategorieTyp) ? OpenEstateType.GENERAL_COMMERCIAL : (ZwangsversteigerungKategorieTyp.GRUNDSTUECK.equals((Object)zwangsversteigerungKategorieTyp) ? OpenEstateType.GENERAL_PIECE_OF_LAND : OpenEstateType.GENERAL_PARKING))));
        estateImpl.setType(openEstateType, openEstateAction);
        AuctionCompulsory.put((EstateImpl)estateImpl, (Boolean)true);
        AuctionModificationDate.put((EstateImpl)estateImpl, (Calendar)type.getAenderungsdatum());
        AuctionCancellationDate.put((EstateImpl)estateImpl, (Calendar)type.getAufhebungsdatum());
        Owner.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getEigentuemer());
        AuctionRecordationDate.put((EstateImpl)estateImpl, (Calendar)type.getErfassungsdatum());
        LandRegisterNr.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getGrundbuchblattnummer());
        MarketValue.put((EstateImpl)estateImpl, (Number)type.getPreis());
        if (type.getAmtsgericht() != null) {
            CountryCourtFileReference.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getAmtsgericht().getAktenzeichen());
            CountryCourtName.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)type.getAmtsgericht().getValue());
        }
        TotalArea.put((EstateImpl)estateImpl, (Number)type.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        estateImpl.setPrimaryAreaValue(TotalArea.get((EstateImpl)estateImpl));
        if (type.getVersteigerungstermin() != null) {
            AuctionDate.put((EstateImpl)estateImpl, (Calendar)type.getVersteigerungstermin().getValue());
            AuctionSplitted.put((EstateImpl)estateImpl, (Boolean)type.getVersteigerungstermin().getTeilungsversteigerung());
            AuctionRepeated.put((EstateImpl)estateImpl, (Boolean)type.getVersteigerungstermin().getWiederholungstermin());
        }
    }

    protected AgencyImpl convertToAgency(ImmobilienTransferTyp immobilienTransferTyp) {
        if (immobilienTransferTyp.getAnbieter() == null) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        AgencyImpl agencyImpl = this.createEmptyAgency();
        AgentImpl agentImpl = this.convertAnbieter(immobilienTransferTyp.getAnbieter());
        agentImpl.setId("Agent.1");
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (JAXBElement object : immobilienTransferTyp.getAnbieter().getImmobilie()) {
            try {
                EstateImpl estateImpl = this.convertImmobilie((ImmobilieBaseTyp)object.getValue(), hashMap);
                if (estateImpl == null) continue;
                estateImpl.getCustomValues().putCustomValue("is24.agent.id", (Object)immobilienTransferTyp.getAnbieter().getScoutKundenID(), 5);
                agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn("could not read agency-estate!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        return agencyImpl;
    }

    protected TransferImpl convertToTransfer(ImmobilienTransferTyp immobilienTransferTyp) {
        if (immobilienTransferTyp.getAnbieter() == null) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        TransferImpl transferImpl = this.createEmptyTransfer();
        transferImpl.setSenderSoftwareName(immobilienTransferTyp.getErstellerSoftware());
        transferImpl.setSenderSoftwareVersion(immobilienTransferTyp.getErstellerSoftwareVersion());
        TransferAgencyImpl transferAgencyImpl = this.createEmptyTransferAgency();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(this.convertAnbieter(immobilienTransferTyp.getAnbieter()));
        transferAgencyImpl.getAgent().setId("Agent.1");
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (JAXBElement object : immobilienTransferTyp.getAnbieter().getImmobilie()) {
            String string;
            ImmobilieBaseTyp immobilieBaseTyp = (ImmobilieBaseTyp)object.getValue();
            if (AktionsTyp.LOESCHEN.equals((Object)immobilieBaseTyp.getImportmodus())) {
                string = StringUtils.trimToNull((String)immobilieBaseTyp.getAnbieterObjektID());
                if (string == null) {
                    LOGGER.warn("Can't read estate-id for deletion!");
                    continue;
                }
                if (transferAgencyImpl.getEstateIdsToRemove().contains(string)) {
                    LOGGER.warn("Estate-id for deletion is defined more then once!");
                    continue;
                }
                transferAgencyImpl.getEstateIdsToRemove().add(string);
                continue;
            }
            try {
                string = this.convertImmobilie(immobilieBaseTyp, hashMap);
                if (string == null) continue;
                string.getCustomValues().putCustomValue("is24.agent.id", (Object)immobilienTransferTyp.getAnbieter().getScoutKundenID(), 5);
                transferAgencyImpl.getEstatesToSave().add(string);
            }
            catch (Exception exception) {
                LOGGER.warn("could not read transfer-estate!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }

    protected Is24XmlDocument createXmlDocument(Document document) {
        return Is24XmlUtils.createDocument((Document)document);
    }

    protected void readAustattungsQualitaet(AusstattungsqualitaetsTyp ausstattungsqualitaetsTyp, EstateImpl estateImpl) {
        if (AusstattungsqualitaetsTyp.EINFACH.equals((Object)ausstattungsqualitaetsTyp)) {
            Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.BASIC);
        } else if (AusstattungsqualitaetsTyp.GEHOBEN.equals((Object)ausstattungsqualitaetsTyp)) {
            Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.EXCLUSIVE);
        } else if (AusstattungsqualitaetsTyp.LUXUS.equals((Object)ausstattungsqualitaetsTyp)) {
            Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.LUXURY);
        } else if (AusstattungsqualitaetsTyp.NORMAL.equals((Object)ausstattungsqualitaetsTyp)) {
            Equipment.put((EstateImpl)estateImpl, (Equipment.Option)Equipment.Option.STANDARD);
        }
    }

    protected void readBauphase(BauphaseTyp bauphaseTyp, EstateImpl estateImpl) {
        if (BauphaseTyp.HAUS_FERTIG_GESTELLT.equals((Object)bauphaseTyp)) {
            ConstructionPhase.put((EstateImpl)estateImpl, (ConstructionPhase.Option)ConstructionPhase.Option.COMPLETED);
        } else if (BauphaseTyp.HAUS_IM_BAU.equals((Object)bauphaseTyp)) {
            ConstructionPhase.put((EstateImpl)estateImpl, (ConstructionPhase.Option)ConstructionPhase.Option.UNDER_CONSTRUCTION);
        } else if (BauphaseTyp.HAUS_IN_PLANUNG.equals((Object)bauphaseTyp)) {
            ConstructionPhase.put((EstateImpl)estateImpl, (ConstructionPhase.Option)ConstructionPhase.Option.PLANNED);
        }
    }

    protected void readBebaubarMit(GrundstueckGewerbeEmpfohleneNutzung grundstueckGewerbeEmpfohleneNutzung, EstateImpl estateImpl) {
        if (grundstueckGewerbeEmpfohleneNutzung == null) {
            return;
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getAckerland() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FARMLAND);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBauerwartungsland() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.DEVELOPMENT_AREA);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBootsstaende() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.JETTY);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getBuero() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.OFFICE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getCamping() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.CAMPING);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getDoppelhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.DUPLEX_HOUSE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinfamilienhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.SINGLE_FAMILY_HOUSE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinzelhandelGross() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.RETAIL_LARGE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getEinzelhandelKlein() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.RETAIL_SMALL);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGaragen() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GARAGE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGarten() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GARDEN);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGastronomie() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GASTRONOMY);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getGewerbe() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.BUSINESS_BIG);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getHotel() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.HOTEL);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getIndustrie() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.INDUSTRY);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getKeineBebauung() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.NO_DEVELOPMENT);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getKleingewerbe() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.BUSINESS_SMALL);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getLager() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.WAREHOUSE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getMehrfamilienhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.MULTI_FAMILY_HOUSE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getObstpflanzung() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FRUIT_PLANTING);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getParkhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.PARKING_STRUCTURE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getProduktion() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.PRODUCTION);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getReihenhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.TERRACED_HOUSE);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getStellplaetze() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.CAR_PARKING_SPACES);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getVilla() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.VILLA);
        }
        if (grundstueckGewerbeEmpfohleneNutzung.getWald() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FOREST);
        }
    }

    protected void readBebaubarMit(GrundstueckWohnenEmpfohleneNutzung grundstueckWohnenEmpfohleneNutzung, EstateImpl estateImpl) {
        if (grundstueckWohnenEmpfohleneNutzung == null) {
            return;
        }
        if (grundstueckWohnenEmpfohleneNutzung.getAckerland() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FARMLAND);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBauerwartungsland() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.DEVELOPMENT_AREA);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBootsstaende() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.JETTY);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getBuero() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.OFFICE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getCamping() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.CAMPING);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getDoppelhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.DUPLEX_HOUSE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinfamilienhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.SINGLE_FAMILY_HOUSE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinzelhandelGross() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.RETAIL_LARGE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getEinzelhandelKlein() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.RETAIL_SMALL);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGaragen() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GARAGE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGarten() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GARDEN);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGastronomie() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.GASTRONOMY);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getGewerbe() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.BUSINESS_BIG);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getHotel() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.HOTEL);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getIndustrie() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.INDUSTRY);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getKeineBebauung() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.NO_DEVELOPMENT);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getKleingewerbe() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.BUSINESS_SMALL);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getLager() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.WAREHOUSE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getMehrfamilienhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.MULTI_FAMILY_HOUSE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getObstpflanzung() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FRUIT_PLANTING);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getParkhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.PARKING_STRUCTURE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getProduktion() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.PRODUCTION);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getReihenhaus() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.TERRACED_HOUSE);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getStellplaetze() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.CAR_PARKING_SPACES);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getVilla() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.VILLA);
        }
        if (grundstueckWohnenEmpfohleneNutzung.getWald() != null) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FOREST);
        }
    }

    protected void readBebaubarNach(BebaubarNachTyp bebaubarNachTyp, EstateImpl estateImpl) {
        if (BebaubarNachTyp.BAUGB_30.equals((Object)bebaubarNachTyp)) {
            BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.BINDING_SITE_PLAN);
        } else if (BebaubarNachTyp.BAUGB_34.equals((Object)bebaubarNachTyp)) {
            BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT);
        } else if (BebaubarNachTyp.BAUGB_35.equals((Object)bebaubarNachTyp)) {
            BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT);
        }
    }

    protected void readBefeuerungsArt(BefeuerungsArtTyp befeuerungsArtTyp, EstateImpl estateImpl) {
        if (befeuerungsArtTyp == null) {
            return;
        }
        if (befeuerungsArtTyp.getErdwaerme() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GEOTHERMICS);
        }
        if (befeuerungsArtTyp.getFernwaerme() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.DISTRICT_HEATING);
        }
        if (befeuerungsArtTyp.getGas() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GAS);
        }
        if (befeuerungsArtTyp.getKohle() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.COAL);
        }
        if (befeuerungsArtTyp.getOel() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.OIL);
        }
        if (befeuerungsArtTyp.getPelletheizung() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.PELLETS);
        }
        if (befeuerungsArtTyp.getSolarheizung() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.SOLAR);
        }
        if (befeuerungsArtTyp.getStrom() != null) {
            TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.ELECTRICS);
        }
    }

    protected void readBodenBelag(BodenbelagTyp bodenbelagTyp, EstateImpl estateImpl) {
        if (BodenbelagTyp.BETON.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CONCRETE);
        } else if (BodenbelagTyp.DIELEN.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.FLOOR_BOARDS);
        } else if (BodenbelagTyp.EPOXIDHARZ.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.EPOXY_RESIN);
        } else if (BodenbelagTyp.FLIESEN.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.TILES);
        } else if (BodenbelagTyp.LAMINAT.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.LAMINATE);
        } else if (BodenbelagTyp.NACH_WUNSCH.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.AS_REQUESTED);
        } else if (BodenbelagTyp.PARKETT.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PARQUET);
        } else if (BodenbelagTyp.PVC.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PVC);
        } else if (BodenbelagTyp.STEIN.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.STONE);
        } else if (BodenbelagTyp.TEPPICHBODEN.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET);
        } else if (BodenbelagTyp.TEPPICHBODEN_ANTISTATISCH.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET_ANTISTATIC);
        } else if (BodenbelagTyp.TEPPICHFLIESEN_STUHLROLLENFEST.equals((Object)bodenbelagTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET);
        }
    }

    protected void readBodenBelag(BodenbelagWohnenTyp bodenbelagWohnenTyp, EstateImpl estateImpl) {
        if (BodenbelagWohnenTyp.DIELEN.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.FLOOR_BOARDS);
        } else if (BodenbelagWohnenTyp.FLIESEN.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.TILES);
        } else if (BodenbelagWohnenTyp.LAMINAT.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.LAMINATE);
        } else if (BodenbelagWohnenTyp.PARKETT.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PARQUET);
        } else if (BodenbelagWohnenTyp.PVC.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PVC);
        } else if (BodenbelagWohnenTyp.TEPPICHBODEN.equals((Object)bodenbelagWohnenTyp)) {
            FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET);
        }
    }

    protected void readDatenVerkabelung(DatenVerkabelungsTyp datenVerkabelungsTyp, EstateImpl estateImpl) {
        if (DatenVerkabelungsTyp.JA.equals((Object)datenVerkabelungsTyp) || DatenVerkabelungsTyp.TRUE.equals((Object)datenVerkabelungsTyp)) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        }
    }

    protected void readEnergieAusweis(EnergieausweisTyp energieausweisTyp, EstateImpl estateImpl) {
        if (energieausweisTyp == null) {
            return;
        }
        BigDecimal bigDecimal = energieausweisTyp.getEnergieverbrauchskennwert();
        boolean bl = false;
        if (bigDecimal != null && EnergieausweistypTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp.getEnergieausweistyp())) {
            bl = true;
            Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.DEMAND);
            DemandTotal.put((EstateImpl)estateImpl, (Number)bigDecimal, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
        } else if (bigDecimal != null && EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp.getEnergieausweistyp())) {
            bl = true;
            Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.CONSUMPTION);
            ConsumptionTotal.put((EstateImpl)estateImpl, (Number)bigDecimal, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            ConsumptionIncludingHotWater.put((EstateImpl)estateImpl, (Boolean)energieausweisTyp.getWarmwasserEnthalten());
        }
        Available.put((EstateImpl)estateImpl, (Boolean)bl);
        if (bl && estateImpl.getAddress() != null) {
            EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)OpenEstateUtils.getEnergyEfficiencyCategory((Number)bigDecimal, (String)estateImpl.getAddress().getCountry()));
        }
    }

    protected void readErschliessungZustand(ErschliessungszustandTyp erschliessungszustandTyp, EstateImpl estateImpl) {
        if (ErschliessungszustandTyp.ERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.COMPLETELY);
        } else if (ErschliessungszustandTyp.TEILERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.PARTIALLY);
        } else if (ErschliessungszustandTyp.UNERSCHLOSSEN.equals((Object)erschliessungszustandTyp)) {
            Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.UNDEVELOPED);
        }
    }

    protected void readGeschlecht(GeschlechtTyp geschlechtTyp, EstateImpl estateImpl) {
        if (GeschlechtTyp.KEINE_EINSCHRAENKUNG.equals((Object)geschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.INDIFFERENT);
        } else if (GeschlechtTyp.NUR_FRAUEN.equals((Object)geschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.FEMALE);
        } else if (GeschlechtTyp.NUR_MAENNER.equals((Object)geschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.MALE);
        }
    }

    protected void readGeschlecht(WGZimmerGeschlechtTyp wGZimmerGeschlechtTyp, EstateImpl estateImpl) {
        if (WGZimmerGeschlechtTyp.MAENNLICH_ODER_WEIBLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.INDIFFERENT);
        } else if (WGZimmerGeschlechtTyp.WEIBLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.FEMALE);
        } else if (WGZimmerGeschlechtTyp.MAENNLICH.equals((Object)wGZimmerGeschlechtTyp)) {
            GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.MALE);
        }
    }

    protected void readHaustiere(GenehmigungTyp genehmigungTyp, EstateImpl estateImpl) {
        if (GenehmigungTyp.ERLAUBT.equals((Object)genehmigungTyp)) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.YES);
        } else if (GenehmigungTyp.NACH_VEREINBARUNG.equals((Object)genehmigungTyp)) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.AS_APPOINTED);
        } else if (GenehmigungTyp.VERBOTEN.equals((Object)genehmigungTyp)) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.NO);
        }
    }

    protected void readHeizungsArt(HeizungsartTyp heizungsartTyp, EstateImpl estateImpl) {
        if (HeizungsartTyp.ETAGENHEIZUNG.equals((Object)heizungsartTyp)) {
            TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.SELF_CONTAINED_CENTRAL);
        } else if (HeizungsartTyp.OFENHEIZUNG.equals((Object)heizungsartTyp)) {
            TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.OVEN);
        } else if (HeizungsartTyp.ZENTRALHEIZUNG.equals((Object)heizungsartTyp)) {
            TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.CENTRAL);
        }
    }

    protected void readKlimaanlage(JaNeinVereinbarungTyp jaNeinVereinbarungTyp, EstateImpl estateImpl) {
        if (JaNeinVereinbarungTyp.JA.equals((Object)jaNeinVereinbarungTyp)) {
            AirConditioned.put((EstateImpl)estateImpl, (Boolean)true);
        } else if (JaNeinVereinbarungTyp.NEIN.equals((Object)jaNeinVereinbarungTyp)) {
            AirConditioned.put((EstateImpl)estateImpl, (Boolean)false);
        }
    }

    protected void readKranbahn(HebeanlageTyp hebeanlageTyp, EstateImpl estateImpl) {
        if (hebeanlageTyp == null) {
            return;
        }
        Crane.put((EstateImpl)estateImpl, (Boolean)true);
        CraneLiftingCapacity.put((EstateImpl)estateImpl, (Number)hebeanlageTyp.getTragkraft());
    }

    protected void readLageArt(LageartTyp lageartTyp, EstateImpl estateImpl) {
        if (LageartTyp.A_LAGE.equals((Object)lageartTyp)) {
            CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_A);
        } else if (LageartTyp.B_LAGE.equals((Object)lageartTyp)) {
            CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_B);
        } else if (LageartTyp.EINKAUFSZENTRUM.equals((Object)lageartTyp)) {
            CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.SHOPPING_CENTER);
        }
    }

    protected void readLastenaufzug(HebeanlageTyp hebeanlageTyp, EstateImpl estateImpl) {
        if (hebeanlageTyp == null) {
            return;
        }
        FreightElevator.put((EstateImpl)estateImpl, (Boolean)true);
        FreightElevatorCapacity.put((EstateImpl)estateImpl, (Number)hebeanlageTyp.getTragkraft());
    }

    protected void readMoebliert(Boolean bl, EstateImpl estateImpl) {
        if (Boolean.TRUE.equals(bl)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
        } else if (Boolean.FALSE.equals(bl)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.NO);
        }
    }

    protected void readMoebliert(MobilarTyp mobilarTyp, EstateImpl estateImpl) {
        if (MobilarTyp.JA.equals((Object)mobilarTyp)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
        } else if (MobilarTyp.NEIN.equals((Object)mobilarTyp)) {
            Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.NO);
        }
    }

    protected void readObjektZulieferung(ZulieferungTyp zulieferungTyp, EstateImpl estateImpl) {
        if (ZulieferungTyp.DIREKTER_ZUGANG.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.DIRECT_ACCESS);
        } else if (ZulieferungTyp.GANZTAEGIG.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.ALL_DAY);
        } else if (ZulieferungTyp.KEINE_DIREKTE_ANFAHRT.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.NO_DIRECT_ACCESS);
        } else if (ZulieferungTyp.PKW_ZUFAHRT.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.CAR_ACCESS);
        } else if (ZulieferungTyp.VON_HINTEN.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.FROM_BACK_SIDE);
        } else if (ZulieferungTyp.VON_VORN.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.FROM_FRONT_SIDE);
        } else if (ZulieferungTyp.VORMITTAGS.equals((Object)zulieferungTyp)) {
            SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)SupplyAccess.Option.MORNING);
        }
    }

    protected void readObjektZustand(ObjektZustandTyp objektZustandTyp, EstateImpl estateImpl) {
        if (ObjektZustandTyp.ABBRUCHREIF.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.CONDEMNED);
        } else if (ObjektZustandTyp.ERSTBEZUG.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY);
        } else if (ObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT);
        } else if (ObjektZustandTyp.GEPFLEGT.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.WELL_TENDED);
        } else if (ObjektZustandTyp.MODERNISIERT.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.MODERNIZED);
        } else if (ObjektZustandTyp.NACH_VEREINBARUNG.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_APPOINTED);
        } else if (ObjektZustandTyp.NEUWERTIG.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_GOOD_AS_NEW);
        } else if (ObjektZustandTyp.RENOVIERUNGSBEDUERFTIG.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PARTIAL_RENOVATION_REQUIRED);
        } else if (ObjektZustandTyp.SANIERT.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
        } else if (ObjektZustandTyp.UNRENOVIERT.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.COMPLETE_RENOVATION_REQUIRED);
        } else if (ObjektZustandTyp.VOLLSTAENDIG_REONVIERT.equals((Object)objektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_RENOVATED);
        }
    }

    protected void readObjektZustand(WazObjektZustandTyp wazObjektZustandTyp, EstateImpl estateImpl) {
        if (WazObjektZustandTyp.ABBRUCHREIF.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.CONDEMNED);
        } else if (WazObjektZustandTyp.ERSTBEZUG.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY);
        } else if (WazObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT);
        } else if (WazObjektZustandTyp.GEPFLEGT.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.WELL_TENDED);
        } else if (WazObjektZustandTyp.MODERNISIERT.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.MODERNIZED);
        } else if (WazObjektZustandTyp.NACH_VEREINBARUNG.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_APPOINTED);
        } else if (WazObjektZustandTyp.NEUWERTIG.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_GOOD_AS_NEW);
        } else if (WazObjektZustandTyp.RENOVIERUNGSBEDUERFTIG.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PARTIAL_RENOVATION_REQUIRED);
        } else if (WazObjektZustandTyp.SANIERT.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
        } else if (WazObjektZustandTyp.UNRENOVIERT.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.COMPLETE_RENOVATION_REQUIRED);
        } else if (WazObjektZustandTyp.VOLLSTAENDIG_RENOVIERT.equals((Object)wazObjektZustandTyp)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_RENOVATED);
        }
    }

    protected void readRaucher(Boolean bl, EstateImpl estateImpl) {
        if (Boolean.TRUE.equals(bl)) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.NO);
        } else if (Boolean.FALSE.equals(bl)) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.YES);
        }
    }

    protected void readRaucher(RauchenTyp rauchenTyp, EstateImpl estateImpl) {
        if (RauchenTyp.ERLAUBT.equals((Object)rauchenTyp)) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.NO);
        } else if (RauchenTyp.UNERWUENSCHT.equals((Object)rauchenTyp)) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.YES);
        }
    }

    protected void readStellplatz(StellplatzKategorieTyp stellplatzKategorieTyp, EstateImpl estateImpl) {
        if (StellplatzKategorieTyp.AUSSEN_STELLPLATZ.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.OUTDOOR);
        } else if (StellplatzKategorieTyp.CARPORT.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.CARPORT);
        } else if (StellplatzKategorieTyp.DUPLEX.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.DUPLEX_GARAGE);
        } else if (StellplatzKategorieTyp.GARAGE.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GARAGE);
        } else if (StellplatzKategorieTyp.PARKHAUS.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK);
        } else if (StellplatzKategorieTyp.TIEFGARAGE.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_UNDERGROUND_CAR_PARK);
        } else if (StellplatzKategorieTyp.TRUE.equals((Object)stellplatzKategorieTyp)) {
            CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GENERAL);
        }
    }

    protected void readTvAnschluss(TVAnschlussTyp tVAnschlussTyp, EstateImpl estateImpl) {
        if (TVAnschlussTyp.KABEL.equals((Object)tVAnschlussTyp)) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.CABLE_TV);
        } else if (TVAnschlussTyp.KABEL_UND_SATELLIT.equals((Object)tVAnschlussTyp)) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.CABLE_SAT_TV);
        } else if (TVAnschlussTyp.SATELLIT.equals((Object)tVAnschlussTyp)) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.SAT_TV);
        }
    }

    protected void readVermarktung(VermarktungGewerbeTyp vermarktungGewerbeTyp, EstateImpl estateImpl) {
        if (vermarktungGewerbeTyp == null) {
            return;
        }
        if (vermarktungGewerbeTyp.getKauf() != null) {
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp.getPreisParkflaeche());
            VermarktungGewerbeTyp.Kauf kauf = (VermarktungGewerbeTyp.Kauf)vermarktungGewerbeTyp.getKauf().getValue();
            if (kauf != null) {
                PurchasePrice.put((EstateImpl)estateImpl, (Number)kauf.getPreis());
            }
        } else if (vermarktungGewerbeTyp.getMiete() != null) {
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp.getPreisParkflaeche());
            VermarktungGewerbeTyp.Miete miete = (VermarktungGewerbeTyp.Miete)vermarktungGewerbeTyp.getMiete().getValue();
            if (miete != null) {
                Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)miete.getKaution());
                if (MieteEinheitTyp.QUADRATMETER.equals((Object)miete.getPro())) {
                    RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)miete.getKaltmiete());
                } else {
                    RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)miete.getKaltmiete());
                }
            }
        }
        ServiceCharges.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp.getNebenkosten());
    }

    protected void readVermarktung(VermarktungGewerbeTyp2 vermarktungGewerbeTyp2, EstateImpl estateImpl) {
        if (vermarktungGewerbeTyp2 == null) {
            return;
        }
        if (vermarktungGewerbeTyp2.getKauf() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp2.getPreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp2.getPreisProParkflaeche());
        } else if (vermarktungGewerbeTyp2.getMiete() != null) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp2.getPreis());
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp2.getPreisProParkflaeche());
            VermarktungGewerbeTyp2.Miete miete = vermarktungGewerbeTyp2.getMiete();
            if (miete != null) {
                Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)miete.getKaution());
            }
        }
        ServiceCharges.put((EstateImpl)estateImpl, (Number)vermarktungGewerbeTyp2.getNebenkosten());
    }

    protected void readVermarktung(VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckGewerbeTyp == null) {
            return;
        }
        if (vermarktungGrundstueckGewerbeTyp.getErbpacht() != null) {
            Lease.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckGewerbeTyp.getPreis());
            if (vermarktungGrundstueckGewerbeTyp.getErbpacht().getValue() != null) {
                EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)((VermarktungGrundstueckGewerbeTyp.Erbpacht)vermarktungGrundstueckGewerbeTyp.getErbpacht().getValue()).getDauerInJahren());
            }
        } else if (vermarktungGrundstueckGewerbeTyp.getKauf() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckGewerbeTyp.getPreis());
        } else if (vermarktungGrundstueckGewerbeTyp.getMiete() != null) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckGewerbeTyp.getPreis());
        } else if (vermarktungGrundstueckGewerbeTyp.getPacht() != null) {
            Lease.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckGewerbeTyp.getPreis());
        }
    }

    protected void readVermarktung(VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckWohnenKaufTyp == null) {
            return;
        }
        if (vermarktungGrundstueckWohnenKaufTyp.getErbpacht() != null) {
            Lease.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckWohnenKaufTyp.getPreis());
            if (vermarktungGrundstueckWohnenKaufTyp.getErbpacht().getValue() != null) {
                EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)((VermarktungGrundstueckWohnenKaufTyp.Erbpacht)vermarktungGrundstueckWohnenKaufTyp.getErbpacht().getValue()).getDauerInJahren());
            }
        } else if (vermarktungGrundstueckWohnenKaufTyp.getKauf() != null) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckWohnenKaufTyp.getPreis());
        }
    }

    protected void readVermarktung(VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp, EstateImpl estateImpl) {
        if (vermarktungGrundstueckWohnenMieteTyp == null) {
            return;
        }
        if (vermarktungGrundstueckWohnenMieteTyp.getMiete() != null) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckWohnenMieteTyp.getPreis());
        } else if (vermarktungGrundstueckWohnenMieteTyp.getPacht() != null) {
            Lease.put((EstateImpl)estateImpl, (Number)vermarktungGrundstueckWohnenMieteTyp.getPreis());
        }
    }

    protected void readWgGroesse(WGGroesse wGGroesse, EstateImpl estateImpl) {
        int n = WGGroesse.PERSONS_02.equals((Object)wGGroesse) ? 2 : (WGGroesse.PERSONS_03.equals((Object)wGGroesse) ? 3 : (WGGroesse.PERSONS_04.equals((Object)wGGroesse) ? 4 : (WGGroesse.PERSONS_05.equals((Object)wGGroesse) ? 5 : (WGGroesse.PERSONS_06.equals((Object)wGGroesse) ? 6 : (WGGroesse.PERSONS_07.equals((Object)wGGroesse) ? 7 : (WGGroesse.PERSONS_08.equals((Object)wGGroesse) ? 8 : (WGGroesse.PERSONS_09.equals((Object)wGGroesse) ? 9 : (WGGroesse.PERSONS_10.equals((Object)wGGroesse) ? 10 : (WGGroesse.PERSONS_11_PLUS.equals((Object)wGGroesse) ? 11 : 0)))))))));
        if (n > 1) {
            CountFlatmatesTotal.put((EstateImpl)estateImpl, (Number)n);
        }
    }
}

