/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsExtension;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsUpdateListener;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.hsql.HSqlDbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.hsql.HSqlDbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.hsql.HSqlDbAgencyInterestsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyContactsExtension
extends DbAgencyContactsExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyContactsExtension.class);
    private static final String RESOURCE_PATH = "/com/openindex/openestate/tool/agency/addons/contacts/db/hsql/resources/";
    private static final DbAgencyBrokeringsHandler BROKERINGS_HANDLER = new HSqlDbAgencyBrokeringsHandler();
    private static final DbAgencyContactsHandler CONTACTS_HANDLER = new HSqlDbAgencyContactsHandler();
    private static final DbAgencyInterestsHandler INTERESTS_HANDLER = new HSqlDbAgencyInterestsHandler();

    @Override
    public DbAgencyBrokeringsHandler getBrokeringsHandler() {
        return BROKERINGS_HANDLER;
    }

    @Override
    public DbAgencyContactsHandler getContactsHandler() {
        return CONTACTS_HANDLER;
    }

    @Override
    public DbAgencyInterestsHandler getInterestsHandler() {
        return INTERESTS_HANDLER;
    }

    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_agency_brokerings", "save_immotool_agency_brokerings", "remove_immotool_agency_objects_contacts_entries", "save_immotool_agency_objects_contacts_entries", "remove_immotool_agency_interests", "remove_immotool_agency_interests_offers", "save_immotool_agency_interests", "save_immotool_agency_interests_offers"};
    }

    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_agency_brokerings", "view_immotool_agency_objects_contacts_entries", "view_immotool_agency_interests", "view_immotool_agency_interests_offers"};
    }

    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    public String getUninstallQuery() throws IOException {
        return HSqlDbAgencyContactsExtension.readHsqlQuery("uninstall.sql");
    }

    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new HSqlDbUpdateHandler("OpenEstate-Agency-Contacts", DbUpdateHandlerImpl.Type.PLUGIN_RELATION, 8L, string, RESOURCE_PATH, ((Object)((Object)this)).getClass().getClassLoader(), (AbstractDbUpdateListener)new DbAgencyContactsUpdateListener());
    }

    public void install(Connection connection, DbExtension dbExtension) throws IOException, SQLException {
        super.install(connection, dbExtension);
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbAgencyContactsExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbAgencyContactsExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbAgencyContactsExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbAgencyContactsExtension.class.getClassLoader());
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        try {
            AgencyContactsUtils.checkForDuplicateInterestSearches(connection, abstractDbDriver);
        }
        catch (ImmoToolException immoToolException) {
            throw new SQLException(immoToolException);
        }
    }
}

