/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.immobiliare_it;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.EffectiveDate;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.AbstractXmlReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Box;
import org.openestate.io.immobiliare_it.xml.Building;
import org.openestate.io.immobiliare_it.xml.ClassEnergy;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.Furniture;
import org.openestate.io.immobiliare_it.xml.Garden;
import org.openestate.io.immobiliare_it.xml.Heat;
import org.openestate.io.immobiliare_it.xml.Operation;
import org.openestate.io.immobiliare_it.xml.PictureExtended;
import org.openestate.io.immobiliare_it.xml.PictureProject;
import org.openestate.io.immobiliare_it.xml.PropertyType;
import org.openestate.io.immobiliare_it.xml.PropertyTypeBusiness;
import org.openestate.io.immobiliare_it.xml.PropertyTypeSimple;
import org.openestate.io.immobiliare_it.xml.Publisher;
import org.openestate.io.immobiliare_it.xml.Status;
import org.openestate.io.immobiliare_it.xml.TerrainType;
import org.openestate.io.immobiliare_it.xml.TransactionType;
import org.openestate.io.immobiliare_it.xml.VideoType;
import org.openestate.io.immobiliare_it.xml.YesNoReady;
import org.openestate.io.immobiliare_it.xml.types.Category;
import org.openestate.io.immobiliare_it.xml.types.EnergyUnit;
import org.openestate.io.immobiliare_it.xml.types.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ImmobiliareItReader
extends AbstractXmlReader<ImmobiliareItDocument, Feed> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItReader.class);
    private static final Map<Category, OpenEstateType> CATEGORIES;
    private static final Map<PropertyType, OpenEstateType> TYPES;
    private static final Map<PropertyTypeBusiness, OpenEstateType> COMMERCIAL_TYPES;
    private static final Map<TerrainType, OpenEstateType> TERRAINS;
    private static final Map<Transaction, OpenEstateAction> TRANSACTIONS;
    private static final Map<PropertyTypeSimple, OpenEstateType> OLD_TYPES;

    public ImmobiliareItReader() {
    }

    public ImmobiliareItReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Publisher publisher) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCompany().setCompanyMail(publisher.getEmail());
        agentImpl.getCompany().setCompanyName(publisher.getName());
        agentImpl.getCompany().setCompanyPhone(publisher.getPhone());
        String string = StringUtils.trimToNull((String)publisher.getSite());
        if (string != null) {
            try {
                agentImpl.getCompany().setCompanyWebsite(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read publisher website: " + string);
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
        }
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(Feed.Properties.Property property, Map<String, AgentContactImpl> map) throws OpenEstateException {
        Furniture furniture;
        Object object;
        Object object2;
        Object object32;
        Object object42;
        ClassEnergy classEnergy;
        Object object5;
        String string;
        TerrainType terrainType2;
        Status status;
        PropertyTypeBusiness propertyTypeBusiness;
        EstateImpl estateImpl = this.createEmptyEstate();
        TransactionType transactionType = property.getTransactionType();
        if (transactionType == null) {
            throw new OpenEstateException("No transaction was provided!");
        }
        Building building = property.getBuilding();
        PropertyType propertyType = building != null ? building.getType() : null;
        PropertyTypeSimple propertyTypeSimple = property.getPropertyType() != null ? property.getPropertyType().getType() : null;
        Category category = building != null && building.getCategory() != null ? building.getCategory() : property.getCategory();
        PropertyTypeBusiness propertyTypeBusiness2 = propertyTypeBusiness = building != null && building.getDetail() != null ? building.getDetail() : null;
        if (propertyTypeBusiness == null && property.getPropertyType() != null && property.getPropertyType().getBusinessType() != null) {
            propertyTypeBusiness = property.getPropertyType().getBusinessType().getValue();
        }
        ArrayList arrayList = new ArrayList();
        if (building != null && building.getTerrains() != null) {
            arrayList.addAll(building.getTerrains().getTerrain());
        } else if (property.getPropertyType() != null && property.getPropertyType().getTerrains() != null) {
            arrayList.addAll(property.getPropertyType().getTerrains().getTerrain());
        }
        Status status2 = status = building != null ? building.getStatus() : null;
        if (status == null) {
            status = property.getBuildingStatus();
        }
        if (Status.ABITABILE.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.HABITABLE);
        } else if (Status.BUONO.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.GOOD);
        } else if (Status.DA_RISTRUTTURARE.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.COMPLETE_REFURBISHMENT_REQUIRED);
        } else if (Status.DISCRETO.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FAIR);
        } else if (Status.IN_COSTRUZIONE.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.SHELL_CONSTRUCTION);
        } else if (Status.NUOVO.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_GOOD_AS_NEW);
        } else if (Status.OTTIMO.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.EXCELLENT);
        } else if (Status.RISTRUTTURATO.equals((Object)status)) {
            ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
        }
        OpenEstateType openEstateType = null;
        if (propertyTypeBusiness != null && COMMERCIAL_TYPES.containsKey(propertyTypeBusiness)) {
            if (PropertyTypeBusiness.AGRICOLO.equals((Object)propertyTypeBusiness)) {
                for (TerrainType terrainType2 : arrayList) {
                    if (!TERRAINS.containsKey(terrainType2)) continue;
                    openEstateType = TERRAINS.get(terrainType2);
                    break;
                }
            }
            if (openEstateType == null) {
                openEstateType = COMMERCIAL_TYPES.get(propertyTypeBusiness);
            }
        } else if (propertyType != null && TYPES.containsKey(propertyType)) {
            openEstateType = TYPES.get(propertyType);
        } else if (propertyTypeSimple != null && OLD_TYPES.containsKey(propertyTypeSimple)) {
            openEstateType = OLD_TYPES.get(propertyTypeSimple);
        } else if (category != null && CATEGORIES.containsKey(category)) {
            openEstateType = CATEGORIES.get(category);
        }
        if (openEstateType == null) {
            throw new OpenEstateException("Can't find a usable estate-type!");
        }
        AbstractTypeImpl abstractTypeImpl = openEstateType.createImpl();
        if (abstractTypeImpl == null) {
            throw new OpenEstateException("unsupported estate type (" + openEstateType + ")");
        }
        Transaction transaction = Transaction.fromXmlValue((String)transactionType.getValue());
        if (transaction == null || !TRANSACTIONS.containsKey(transaction)) {
            throw new OpenEstateException("Can't find a usable estate-action from: " + transactionType.getValue());
        }
        terrainType2 = TRANSACTIONS.get(transaction);
        if (OpenEstateAction.RENT.equals((Object)terrainType2) && !abstractTypeImpl.hasAction((OpenEstateAction)terrainType2)) {
            if (abstractTypeImpl.hasAction(OpenEstateAction.LEASE)) {
                terrainType2 = OpenEstateAction.LEASE;
            } else if (abstractTypeImpl.hasAction(OpenEstateAction.EMPHYTEUSIS)) {
                terrainType2 = OpenEstateAction.EMPHYTEUSIS;
            } else if (abstractTypeImpl.hasAction(OpenEstateAction.SHORT_TERM_RENT)) {
                terrainType2 = OpenEstateAction.SHORT_TERM_RENT;
            }
        }
        if (!abstractTypeImpl.hasAction((OpenEstateAction)terrainType2)) {
            throw new OpenEstateException("The estate-action '" + terrainType2 + "' is not supported by the estate-type '" + openEstateType + "'!");
        }
        estateImpl.setType(abstractTypeImpl, (OpenEstateAction)terrainType2);
        List<OpenEstateType> list = Arrays.asList(openEstateType.getParentPath());
        estateImpl.setTitle(estateImpl.getFallbackTitle(this.getOpenEstateLanguage()), this.getOpenEstateLanguage());
        estateImpl.setId(StringUtils.trimToNull((String)property.getUniqueId()));
        estateImpl.setPublicId(StringUtils.trimToNull((String)property.getUniqueId()));
        if (property.getDateExpiration() != null) {
            estateImpl.setPublishEnd(property.getDateExpiration().getTime());
        }
        if (property.getDateUpdated() != null) {
            EffectiveDate.put((EstateImpl)estateImpl, (Calendar)property.getDateUpdated());
        }
        if (property.getLocation() != null) {
            string = StringUtils.trimToEmpty((String)property.getLocation().getCountryCode());
            if (string.length() == 3) {
                estateImpl.getAddress().setCountry(string);
                estateImpl.getCustomValues().putCustomValue("geodb.immobiliare.0", (Object)string, 5);
            } else if (string.length() == 2) {
                estateImpl.getAddress().setCountry(string);
                estateImpl.getCustomValues().putCustomValue("geodb.immobiliare.0", (Object)OpenEstateUtils.convertToIso3Country((String)string), 5);
            }
            if (property.getLocation().getCity() != null) {
                estateImpl.getAddress().setCity(property.getLocation().getCity().getValue());
            }
            if (property.getLocation().getLocality() != null) {
                estateImpl.getAddress().setPostalCode(property.getLocation().getLocality().getPostalCode());
                object5 = property.getLocation().getLocality().getLatitude();
                classEnergy = property.getLocation().getLocality().getLongitude();
                if (object5 != null && classEnergy != null) {
                    estateImpl.getAddress().setLatitude((BigDecimal)object5);
                    estateImpl.getAddress().setLongitude(classEnergy);
                }
                if ((object42 = property.getLocation().getLocality().getThoroughfare()) != null) {
                    estateImpl.getAddress().setStreet(object42.getValue());
                    estateImpl.getAddress().setPublished(Boolean.TRUE.equals(object42.getDisplay()));
                }
                object32 = "";
                if (property.getLocation().getAdministrativeArea() != null) {
                    object32 = (String)object32 + property.getLocation().getAdministrativeArea();
                }
                if (property.getLocation().getSubAdministrativeArea() != null) {
                    if (StringUtils.isNotBlank((CharSequence)object32)) {
                        object32 = (String)object32 + " / ";
                    }
                    object32 = (String)object32 + property.getLocation().getSubAdministrativeArea().getValue();
                }
                if (StringUtils.isNotBlank((CharSequence)object32)) {
                    estateImpl.getAddress().setRegion((String)object32);
                }
            }
        }
        if (arrayList.contains(TerrainType.SEMINATIVO) || arrayList.contains(TerrainType.SEMINATIVO_ARBORATO) || arrayList.contains(TerrainType.SEMINATIVO_ARBORATO_IRRIGUO) || arrayList.contains(TerrainType.SEMINATIVO_IRRIGUO)) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FARMLAND);
        }
        if (arrayList.contains(TerrainType.FRUTTETO) || arrayList.contains(TerrainType.AGRUMETO) || arrayList.contains(TerrainType.ULIVETO) || arrayList.contains(TerrainType.RISAIA_STABILE) || arrayList.contains(TerrainType.CASTAGNETO_DA_FRUTTO) || arrayList.contains(TerrainType.ORTO) || arrayList.contains(TerrainType.ORTO_IRRIGUO)) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FRUIT_PLANTING);
        }
        if (arrayList.contains(TerrainType.BOSCO_ALTO_FUSTO) || arrayList.contains(TerrainType.BOSCO_CEDUO) || arrayList.contains(TerrainType.BOSCO_MISTO)) {
            BuildableWith.putOption((EstateImpl)estateImpl, (BuildableWith.Option)BuildableWith.Option.FOREST);
        }
        if (property.getFeatures() != null) {
            CountRooms.put((EstateImpl)estateImpl, (Number)property.getFeatures().getRooms());
            string = property.getFeatures().getPrice();
            if (string != null) {
                estateImpl.setCurrency(string.getCurrency());
                estateImpl.setHiddenPrices(string.getReserved());
                if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
                    PurchasePrice.put((EstateImpl)estateImpl, (Number)string.getValue());
                } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
                    RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)string.getValue());
                } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
                    RentFlatRate.put((EstateImpl)estateImpl, (Number)string.getValue());
                } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
                    Lease.put((EstateImpl)estateImpl, (Number)string.getValue());
                }
            }
            if ((object5 = property.getFeatures().getSize()) != null) {
                if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
                    TotalArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
                    CommercialArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                    PlotArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
                    CarParkingArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                    ResidentialArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                } else {
                    TotalArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
                }
            }
            for (Object object42 : property.getFeatures().getDescription()) {
                if (StringUtils.isBlank((CharSequence)object42.getValue())) continue;
                object32 = object42.getLanguage() != null ? OpenEstateUtils.buildLocale((String)object42.getLanguage().value()) : this.getOpenEstateLanguage();
                DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)object32, (String)object42.getValue());
            }
            classEnergy = property.getFeatures().getEnergyClass();
            if (ClassEnergy.A_PLUS.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.A_PLUS);
            } else if (ClassEnergy.A.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.A);
            } else if (ClassEnergy.B.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.B);
            } else if (ClassEnergy.C.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.C);
            } else if (ClassEnergy.D.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.D);
            } else if (ClassEnergy.E.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.E);
            } else if (ClassEnergy.F.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.F);
            } else if (ClassEnergy.G.equals((Object)classEnergy)) {
                EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)EfficiencyCategory.Option.G);
            }
            if (property.getFeatures().getEnergyPerformance() != null) {
                Available.put((EstateImpl)estateImpl, (Boolean)property.getFeatures().getEnergyPerformance().getCertified());
                object42 = property.getFeatures().getEnergyPerformance().getValue();
                object32 = property.getFeatures().getEnergyPerformance().getUnit();
                if (object42 != null && EnergyUnit.KWH_M2ANNO.equals(object32)) {
                    Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.CONSUMPTION);
                    ConsumptionTotal.put((EstateImpl)estateImpl, (String)object42, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                }
            }
        }
        if (property.getExtraFeatures() != null) {
            CountBathrooms.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getBathrooms());
            WarehouseHeight.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getBeamHeight(), (LengthValue.Unit)LengthValue.Unit.M);
            CountBedrooms.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getBedrooms());
            BuildYear.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getBuildYear());
            PriceDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)property.getExtraFeatures().getFreeConditions());
            CountFloors.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getNumFloors());
            AirConditioned.put((EstateImpl)estateImpl, (Boolean)property.getExtraFeatures().getAirConditioning());
            if (property.getExtraFeatures().getAdditionalCosts() != null) {
                if (OpenEstateAction.PURCHASE.equals((Object)terrainType2)) {
                    CommonCharge.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getAdditionalCosts().getValue());
                } else {
                    ServiceCharges.put((EstateImpl)estateImpl, (Number)property.getExtraFeatures().getAdditionalCosts().getValue());
                }
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().getBalcony()) || Boolean.TRUE.equals(property.getExtraFeatures().getTerrace())) {
                BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)true);
            } else if (Boolean.FALSE.equals(property.getExtraFeatures().getBalcony()) || Boolean.FALSE.equals(property.getExtraFeatures().getTerrace())) {
                BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)false);
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().getSecurityAlarm())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.ALARM_SYSTEM);
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().getNet())) {
                Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
            }
            if (abstractTypeImpl.hasAttrib(OpenEstateAttrib.FEATURES_LIFT)) {
                Lift.put((EstateImpl)estateImpl, (Boolean)property.getExtraFeatures().getElevator());
            } else if (abstractTypeImpl.hasAttrib(OpenEstateAttrib.FEATURES_FREIGHT_ELEVATOR)) {
                FreightElevator.put((EstateImpl)estateImpl, (Boolean)property.getExtraFeatures().getElevator());
            }
            string = property.getExtraFeatures().getOverheadCrane();
            if (string != null) {
                if (YesNoReady.YES.equals((Object)string)) {
                    Crane.put((EstateImpl)estateImpl, (Boolean)true);
                } else if (YesNoReady.NO.equals((Object)string)) {
                    Crane.put((EstateImpl)estateImpl, (Boolean)false);
                }
            }
            if ((object5 = property.getExtraFeatures().getOfficeSize()) != null) {
                OfficeArea.put((EstateImpl)estateImpl, (Number)object5.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if ((classEnergy = property.getExtraFeatures().getExternalArea()) != null) {
                PlotArea.put((EstateImpl)estateImpl, (Number)classEnergy.getValue(), (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (org.openestate.io.immobiliare_it.xml.Kitchen.ABITABILE.equals(object42 = property.getExtraFeatures().getKitchen())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.OPEN_PLAN_KITCHEN);
            } else if (org.openestate.io.immobiliare_it.xml.Kitchen.ANGOLO_COTTURA.equals(object42)) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.KITCHEN_NOOK);
            } else if (org.openestate.io.immobiliare_it.xml.Kitchen.CUCINOTTO.equals(object42)) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.SMALL_KITCHEN);
            } else if (org.openestate.io.immobiliare_it.xml.Kitchen.SEMI_ABITABILE.equals(object42)) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.OPEN_KITCHEN);
            }
            object32 = property.getExtraFeatures().getHeating();
            if (Heat.AUTONOMO.equals(object32)) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.INDEPENDENT);
            } else if (Heat.CENTRALIZZATO.equals(object32)) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.CENTRAL);
            } else if (Heat.TELERISCALDAMENTO.equals(object32)) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.DISTRICT_HEATING);
            }
            object2 = property.getExtraFeatures().getGarden();
            if (Garden.COMUNE.equals(object2)) {
                GardenUse.put((EstateImpl)estateImpl, (Boolean)true);
            } else if (Garden.NESSUNO.equals(object2)) {
                GardenUse.put((EstateImpl)estateImpl, (Boolean)false);
            } else if (Garden.PRIVATO.equals(object2)) {
                GardenUse.put((EstateImpl)estateImpl, (Boolean)true);
            }
            object = property.getExtraFeatures().getGarage();
            if (object != null) {
                CountParkingSpaces.put((EstateImpl)estateImpl, (Number)object.getValue());
                if (Box.BoxType.BOX.equals((Object)object.getType())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GARAGE);
                } else if (Box.BoxType.POSTO_AUTO.equals((Object)object.getType())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GENERAL);
                } else if (Box.BoxType.RIMESSA.equals((Object)object.getType())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.CARPORT);
                }
            }
            if (Furniture.ARREDATO.equals((Object)(furniture = property.getExtraFeatures().getFurniture()))) {
                Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
            } else if (Furniture.NON_ARREDATO.equals((Object)furniture)) {
                Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.NO);
            } else if (Furniture.PARZIALMENTE_ARREDATO.equals((Object)furniture)) {
                Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.PARTIAL);
            }
            org.openestate.io.immobiliare_it.xml.Floor floor = property.getExtraFeatures().getFloor();
            if (floor != null) {
                String string2;
                String string3 = string2 = floor.getValue() == null ? null : NumberFormat.getIntegerInstance(this.getOpenEstateLanguage()).format(floor.getValue());
                if (string2 != null) {
                    Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)string2);
                }
            }
        }
        if ((string = property.getPictures()) != null) {
            object5 = string.getPictureUrlAndPicture().iterator();
            while (object5.hasNext()) {
                classEnergy = (PictureProject)object5.next();
                object42 = null;
                if (classEnergy instanceof PictureExtended) {
                    object42 = StringUtils.trimToNull((String)((PictureExtended)classEnergy).getUrl());
                }
                if (object42 == null) {
                    object42 = StringUtils.trimToNull((String)classEnergy.getValue());
                }
                if (object42 == null) continue;
                try {
                    object32 = new URI((String)object42);
                }
                catch (URISyntaxException uRISyntaxException) {
                    object32 = null;
                }
                object2 = this.createEmptyAttachment();
                object2.setPublished(Boolean.valueOf(true));
                if (object32 != null) {
                    object2.setFile((URI)object32);
                    estateImpl.getAttachments().add(object2);
                    continue;
                }
                object2.setFile((String)object42);
                estateImpl.getAttachments().add(object2);
            }
        }
        if ((object5 = property.getBlueprints()) != null) {
            classEnergy = object5.getBlueprint().iterator();
            while (classEnergy.hasNext()) {
                object42 = (PictureExtended)classEnergy.next();
                object32 = StringUtils.trimToNull((String)object42.getUrl());
                if (object32 == null) {
                    object32 = StringUtils.trimToNull((String)object42.getValue());
                }
                if (object32 == null) continue;
                try {
                    object2 = new URI((String)object32);
                }
                catch (URISyntaxException uRISyntaxException) {
                    object2 = null;
                }
                object = this.createEmptyAttachment();
                object.setPublished(Boolean.valueOf(true));
                object.setType(EstateAttachmentType.IMAGE_GROUNDPLAN);
                if (object2 != null) {
                    object.setFile((URI)object2);
                    estateImpl.getAttachments().add(object);
                    continue;
                }
                object.setFile((String)object32);
                estateImpl.getAttachments().add(object);
            }
        }
        if ((classEnergy = property.getVideos()) != null) {
            block10: for (Object object32 : classEnergy.getVideo()) {
                object2 = StringUtils.trimToNull((String)object32.getValue());
                if (object2 == null) continue;
                try {
                    object = new URI((String)object2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    object = null;
                }
                if (VideoType.LOCAL.equals((Object)object32.getType())) {
                    furniture = this.createEmptyAttachment();
                    furniture.setPublished(Boolean.valueOf(true));
                    if (object != null) {
                        furniture.setFile((URI)object);
                        estateImpl.getAttachments().add(furniture);
                        continue;
                    }
                    furniture.setFile((String)object2);
                    estateImpl.getAttachments().add(furniture);
                    continue;
                }
                if (!VideoType.REMOTE.equals((Object)object32.getType()) || object == null) continue;
                for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                    String string4;
                    if (!estateLinkProvider.isVideo() || (string4 = estateLinkProvider.getLinkIdFromUrl(((URI)object).toString())) == null) continue;
                    EstateLinkImpl estateLinkImpl = this.createEmptyLink();
                    estateLinkImpl.setProviderLink(new EstateLinkImpl.ProviderLink(string4, estateLinkProvider));
                    estateLinkImpl.setPublished(Boolean.valueOf(true));
                    estateImpl.getLinks().add(estateLinkImpl);
                    continue block10;
                }
            }
        }
        return estateImpl;
    }

    protected AgencyImpl convertToAgency(Feed feed) {
        AgentImpl agentImpl = feed.getMetadata() != null && feed.getMetadata().getPublisher() != null ? this.convertAnbieter(feed.getMetadata().getPublisher()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        AgencyImpl agencyImpl = this.createEmptyAgency();
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        if (feed.getProperties() != null) {
            for (Feed.Properties.Property property : feed.getProperties().getProperty()) {
                try {
                    EstateImpl estateImpl = this.convertImmobilie(property, hashMap);
                    if (estateImpl == null) continue;
                    agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
                }
                catch (Exception exception) {
                    LOGGER.warn("could not read agency-estate!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        return agencyImpl;
    }

    protected TransferImpl convertToTransfer(Feed feed) {
        AgentImpl agentImpl = feed.getMetadata() != null && feed.getMetadata().getPublisher() != null ? this.convertAnbieter(feed.getMetadata().getPublisher()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        TransferImpl transferImpl = this.createEmptyTransfer();
        TransferAgencyImpl transferAgencyImpl = this.createEmptyTransferAgency();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        if (feed.getProperties() != null) {
            for (Feed.Properties.Property property : feed.getProperties().getProperty()) {
                String string;
                if (Operation.DELETE.equals((Object)property.getOperation())) {
                    string = StringUtils.trimToNull((String)property.getUniqueId());
                    if (string == null) {
                        LOGGER.warn("Can't read estate-id for deletion!");
                        continue;
                    }
                    if (transferAgencyImpl.getEstateIdsToRemove().contains(string.trim())) {
                        LOGGER.warn("Estate-id for deletion is defined more then once!");
                        continue;
                    }
                    transferAgencyImpl.getEstateIdsToRemove().add(string.trim());
                    continue;
                }
                try {
                    string = this.convertImmobilie(property, hashMap);
                    if (string == null) continue;
                    transferAgencyImpl.getEstatesToSave().add(string);
                }
                catch (Exception exception) {
                    LOGGER.warn("could not read agency-estate!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }

    protected ImmobiliareItDocument createXmlDocument(Document document) {
        return ImmobiliareItUtils.createDocument((Document)document);
    }

    static {
        TRANSACTIONS = new EnumMap<Transaction, OpenEstateAction>(Transaction.class);
        TRANSACTIONS.put(Transaction.RENT, OpenEstateAction.RENT);
        TRANSACTIONS.put(Transaction.SALE, OpenEstateAction.PURCHASE);
        CATEGORIES = new EnumMap<Category, OpenEstateType>(Category.class);
        CATEGORIES.put(Category.COMMERCIALE, OpenEstateType.GENERAL_COMMERCIAL);
        CATEGORIES.put(Category.RESIDENZIALE, OpenEstateType.GENERAL_RESIDENCE);
        CATEGORIES.put(Category.VACANZE, OpenEstateType.COTTAGE);
        OLD_TYPES = new EnumMap<PropertyTypeSimple, OpenEstateType>(PropertyTypeSimple.class);
        OLD_TYPES.put(PropertyTypeSimple.AGRITURISMO, OpenEstateType.FARMHOUSE);
        OLD_TYPES.put(PropertyTypeSimple.APPARTAMENTO, OpenEstateType.RESIDENCE);
        OLD_TYPES.put(PropertyTypeSimple.ATTICO, OpenEstateType.PENTHOUSE_APARTMENT);
        OLD_TYPES.put(PropertyTypeSimple.BAITA, OpenEstateType.ALPINE_HUT);
        OLD_TYPES.put(PropertyTypeSimple.BED_AND_BREAKFAST, OpenEstateType.GUEST_ROOM);
        OLD_TYPES.put(PropertyTypeSimple.BUNGALOW, OpenEstateType.BUNGALOW);
        OLD_TYPES.put(PropertyTypeSimple.CAMERA, OpenEstateType.ROOM);
        OLD_TYPES.put(PropertyTypeSimple.CASALE, OpenEstateType.FARMHOUSE);
        OLD_TYPES.put(PropertyTypeSimple.CASA_INDIPENDENTE, OpenEstateType.HOUSE);
        OLD_TYPES.put(PropertyTypeSimple.CASA_PER_FERIE_GRUPPI, OpenEstateType.COTTAGE);
        OLD_TYPES.put(PropertyTypeSimple.CHALET, OpenEstateType.CHALET);
        OLD_TYPES.put(PropertyTypeSimple.GARAGE, OpenEstateType.GARAGE);
        OLD_TYPES.put(PropertyTypeSimple.HOTEL, OpenEstateType.HOTEL);
        OLD_TYPES.put(PropertyTypeSimple.LOFT, OpenEstateType.LOFT);
        OLD_TYPES.put(PropertyTypeSimple.MANSARDA, OpenEstateType.ATTIC_APARTMENT);
        OLD_TYPES.put(PropertyTypeSimple.MULTIPROPRIET\u00c0, OpenEstateType.HOUSING_COMPLEX);
        OLD_TYPES.put(PropertyTypeSimple.PALAZZO, OpenEstateType.PALACE);
        OLD_TYPES.put(PropertyTypeSimple.PARCO_VACANZE, OpenEstateType.LEISURE_FACILITY);
        OLD_TYPES.put(PropertyTypeSimple.RESIDENCE, OpenEstateType.RESIDENCE);
        OLD_TYPES.put(PropertyTypeSimple.RUSTICO, OpenEstateType.COUNTRY_HOUSE);
        OLD_TYPES.put(PropertyTypeSimple.STABILE, OpenEstateType.HOUSE);
        OLD_TYPES.put(PropertyTypeSimple.STANZA, OpenEstateType.ROOM);
        OLD_TYPES.put(PropertyTypeSimple.VILLA, OpenEstateType.VILLA);
        OLD_TYPES.put(PropertyTypeSimple.VILLETTA, OpenEstateType.VILLA);
        OLD_TYPES.put(PropertyTypeSimple.VILLETTA_A_SCHIERA, OpenEstateType.TERRACED_HOUSE);
        TYPES = new EnumMap<PropertyType, OpenEstateType>(PropertyType.class);
        TYPES.put(PropertyType.AGRITURISMO, OpenEstateType.FARMHOUSE);
        TYPES.put(PropertyType.APPARTAMENTO, OpenEstateType.RESIDENCE);
        TYPES.put(PropertyType.ATTICO, OpenEstateType.PENTHOUSE_APARTMENT);
        TYPES.put(PropertyType.BAITA, OpenEstateType.ALPINE_HUT);
        TYPES.put(PropertyType.BED_AND_BREAKFAST, OpenEstateType.GUEST_ROOM);
        TYPES.put(PropertyType.BUNGALOW, OpenEstateType.BUNGALOW);
        TYPES.put(PropertyType.CAMERA, OpenEstateType.ROOM);
        TYPES.put(PropertyType.CASALE, OpenEstateType.FARMHOUSE);
        TYPES.put(PropertyType.CASA_INDIPENDENTE, OpenEstateType.HOUSE);
        TYPES.put(PropertyType.CASA_PER_FERIE_GRUPPI, OpenEstateType.COTTAGE);
        TYPES.put(PropertyType.CHALET, OpenEstateType.CHALET);
        TYPES.put(PropertyType.GARAGE, OpenEstateType.GARAGE);
        TYPES.put(PropertyType.HOTEL, OpenEstateType.HOTEL);
        TYPES.put(PropertyType.LOFT, OpenEstateType.LOFT);
        TYPES.put(PropertyType.MANSARDA, OpenEstateType.ATTIC_APARTMENT);
        TYPES.put(PropertyType.MULTIPROPRIET\u00c0, OpenEstateType.HOUSING_COMPLEX);
        TYPES.put(PropertyType.PALAZZO, OpenEstateType.PALACE);
        TYPES.put(PropertyType.PARCO_VACANZE, OpenEstateType.LEISURE_FACILITY);
        TYPES.put(PropertyType.RESIDENCE, OpenEstateType.RESIDENCE);
        TYPES.put(PropertyType.RUSTICO, OpenEstateType.COUNTRY_HOUSE);
        TYPES.put(PropertyType.STABILE, OpenEstateType.HOUSE);
        TYPES.put(PropertyType.STANZA, OpenEstateType.ROOM);
        TYPES.put(PropertyType.VILLA, OpenEstateType.VILLA);
        TYPES.put(PropertyType.VILLETTA, OpenEstateType.VILLA);
        TYPES.put(PropertyType.VILLETTA_A_SCHIERA, OpenEstateType.TERRACED_HOUSE);
        COMMERCIAL_TYPES = new EnumMap<PropertyTypeBusiness, OpenEstateType>(PropertyTypeBusiness.class);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ABBIGLIAMENTO, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.AGRICOLO, OpenEstateType.AGRICULTURAL_FORESTRY_GROUND);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ALBERGO, OpenEstateType.HOSPITALITY_INDUSTRY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ALIMENTARI, OpenEstateType.PREMISE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ALTRO_ALIMENTARE, OpenEstateType.PREMISE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ALTRO_NON_ALIMENTARE, OpenEstateType.PREMISE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.AUTO_OFFICINA, OpenEstateType.WORKSHOP);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.AZIENDA_AGRICOLA, OpenEstateType.GENERAL_AGRICULTURE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.BAR, OpenEstateType.RESTAURANT_BAR);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.BED_AND_BREAKFAST, OpenEstateType.GUEST_ROOM);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CAPANNONE, OpenEstateType.HALL_WAREHOUSE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CAPANNONE_INDUSTRIALE, OpenEstateType.INDUSTRIAL_WAREHOUSE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CARTOLERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CASALINGHI, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CASA_DI_CURA, OpenEstateType.LEISURE_SPORTS_FACILITY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.CENTRO_COMMERCIALE, OpenEstateType.SHOPPING_CENTER);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.COMMERCIALE, OpenEstateType.COMMERCIAL_GROUND);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.DISCOTECA, OpenEstateType.DISCOTHEQUE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.EDICOLA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ESTETICA_SOLARIUM, OpenEstateType.TANNING_SALON);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.FERRAMENTA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.GARAGE, OpenEstateType.GARAGE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.GELATERIA, OpenEstateType.GASTRONOMY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.GIOCHI, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.HOTEL, OpenEstateType.HOTEL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.INDUSTRIALE, OpenEstateType.INDUSTRIAL_GROUND);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.INFORMATICA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.LABORATORIO, OpenEstateType.OFFICE_SURGERY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.LAVANDERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.LIBRERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.MAGAZZINO, OpenEstateType.WAREHOUSE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.NEGOZIO, OpenEstateType.PREMISE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PALESTRA, OpenEstateType.FITNESS_STUDIO);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PANETTERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PARRUCCHIERE_UOMO_DONNA, OpenEstateType.GENERAL_COMMERCIAL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PASTICCERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PENSIONE, OpenEstateType.GUESTHOUSE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PIZZA_AL_TAGLIO, OpenEstateType.GASTRONOMY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PIZZERIA, OpenEstateType.PIZZERIA);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.PUB, OpenEstateType.RESTAURANT_BAR);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.RESIDENZIALE, OpenEstateType.RESIDENTIAL_GROUND);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.RISTORANTE, OpenEstateType.RESTAURANT);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.ROSTICCERIA, OpenEstateType.RESTAURANT);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.SCOMMESSE, OpenEstateType.GENERAL_COMMERCIAL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.SCUDERIA, OpenEstateType.RIDING_ESTATE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.SHOWROOM, OpenEstateType.EXHIBITION_AREA);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.STABILE, OpenEstateType.HOUSE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.STABILIMENTO_BALNEARE, OpenEstateType.LEISURE_SPORTS_FACILITY);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.TABACCHERIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.TELEFONIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.TINTORIA, OpenEstateType.RETAIL);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.UFFICIO, OpenEstateType.OFFICE_COMMERCIAL_PREMISE);
        COMMERCIAL_TYPES.put(PropertyTypeBusiness.VIDEONOLEGGIO, OpenEstateType.RETAIL);
        TERRAINS = new EnumMap<TerrainType, OpenEstateType>(TerrainType.class);
        TERRAINS.put(TerrainType.SEMINATIVO, OpenEstateType.CULTIVATION);
        TERRAINS.put(TerrainType.SEMINATIVO_ARBORATO, OpenEstateType.CULTIVATION);
        TERRAINS.put(TerrainType.SEMINATIVO_ARBORATO_IRRIGUO, OpenEstateType.CULTIVATION);
        TERRAINS.put(TerrainType.SEMINATIVO_IRRIGUO, OpenEstateType.CULTIVATION);
        TERRAINS.put(TerrainType.VIGNETO, OpenEstateType.VINICULTURE);
    }
}

