/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieStellplatz;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StellplatzMiete
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(StellplatzMiete.class);
    protected static final int FIELD_OBJEKTKATEGORIE = 60;
    protected static final int FIELD_LAENGE = 61;
    protected static final int FIELD_BREITE = 62;
    protected static final int FIELD_HOEHE = 63;
    protected static final int FIELD_FLAECHE = 64;
    protected static final int FIELD_FREI_AB = 65;
    protected static final int FIELD_FREI_BIS = 66;
    protected static final int FIELD_SANIERUNGSJAHR = 67;
    protected static final int FIELD_BAUJAHR = 68;
    protected static final int FIELD_OBJEKTZUSTAND = 69;
    protected static final int FIELD_MIETE = 90;

    public StellplatzMiete() {
        this.setImmobilienart(Immobilienart.STELLPLATZ_MIETE);
    }

    public Integer getBaujahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(68));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Baujahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getBreite() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Breite'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getFlaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Flaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Calendar getFreiAb() {
        try {
            return Is24CsvFormat.parseDateAsCalendar(this.get(65));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read 'frei ab'!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public Calendar getFreiBis() {
        try {
            return Is24CsvFormat.parseDateAsCalendar(this.get(66));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read 'frei bis'!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public BigDecimal getHoehe() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Hoehe'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getLaenge() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(61));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Laenge'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getMiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Miete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieStellplatz getObjektkategorie() {
        return ObjektkategorieStellplatz.parse(this.get(60));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(69));
    }

    public Integer getSanierungsjahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(67));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Sanierungsjahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public static StellplatzMiete newRecord(CSVRecord cSVRecord) {
        StellplatzMiete stellplatzMiete = new StellplatzMiete();
        stellplatzMiete.parse(cSVRecord);
        return stellplatzMiete;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.STELLPLATZ_MIETE);
        return super.print();
    }

    public void setBaujahr(Number number) {
        this.set(68, Is24CsvFormat.printNumber(number, 4));
    }

    public void setBreite(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setFlaeche(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setFreiAb(Calendar calendar) {
        this.set(65, Is24CsvFormat.printDate(calendar));
    }

    public void setFreiAb(Date date) {
        this.set(65, Is24CsvFormat.printDate(date));
    }

    public void setFreiBis(Calendar calendar) {
        this.set(66, Is24CsvFormat.printDate(calendar));
    }

    public void setFreiBis(Date date) {
        this.set(66, Is24CsvFormat.printDate(date));
    }

    public void setHoehe(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setLaenge(Number number) {
        this.set(61, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setMiete(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 6, 2));
    }

    public void setObjektkategorie(ObjektkategorieStellplatz objektkategorieStellplatz) {
        this.set(60, objektkategorieStellplatz != null ? objektkategorieStellplatz.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(69, objektzustand != null ? objektzustand.print() : null);
    }

    public void setSanierungsjahr(Number number) {
        this.set(67, Is24CsvFormat.printNumber(number, 4));
    }
}

