/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.OpenimmoFeedback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmoFeedbackDocument
extends OpenImmoDocument<OpenimmoFeedback> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoFeedbackDocument.class);

    public OpenImmoFeedbackDocument(Document document) {
        super(document);
        if (!OpenImmoFeedbackDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    @Override
    public OpenImmoVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            Element element = (Element)XmlUtils.newXPath((String)"/io:openimmo_feedback/io:version", (Document)object).selectSingleNode(object);
            if (element == null) {
                Element element2 = XmlUtils.getRootElement((Document)object);
                return "http://www.openimmo.de".equalsIgnoreCase(element2.getNamespaceURI()) ? OpenImmoVersion.V1_2_0 : OpenImmoVersion.V1_2_3;
            }
            string = StringUtils.trimToNull((String)element.getTextContent());
            if (string == null) {
                LOGGER.warn("Can't find version information in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = OpenImmoVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "openimmo_feedback".equals(element.getLocalName());
    }

    public static OpenImmoFeedbackDocument newDocument() throws ParserConfigurationException, JAXBException {
        return OpenImmoFeedbackDocument.newDocument(OpenImmoUtils.getFactory().createOpenimmoFeedback());
    }

    public static OpenImmoFeedbackDocument newDocument(OpenimmoFeedback openimmoFeedback) throws ParserConfigurationException, JAXBException {
        if (StringUtils.isBlank((CharSequence)openimmoFeedback.getVersion())) {
            openimmoFeedback.setVersion(OpenImmoUtils.VERSION.toReadableVersion());
        }
        Document document = XmlUtils.newDocument();
        OpenImmoUtils.createMarshaller("UTF-8", true).marshal((Object)openimmoFeedback, (Node)document);
        return new OpenImmoFeedbackDocument(document);
    }

    public void setDocumentVersion(OpenImmoVersion openImmoVersion) {
        try {
            Object object;
            Document document = this.getDocument();
            String string = StringUtils.trimToEmpty((String)XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung/@version", (Document)document).stringValueOf((Object)document));
            String[] stringArray = StringUtils.split((String)string, (String)"/", (int)2);
            Element element = (Element)XmlUtils.newXPath((String)"/io:openimmo_feedback/io:version", (Document)document).selectSingleNode((Object)document);
            if (OpenImmoVersion.V1_2_4.isNewerThen(openImmoVersion)) {
                if (element != null) {
                    Element element2 = XmlUtils.getRootElement((Document)document);
                    element2.removeChild(element);
                }
                return;
            }
            if (element == null) {
                object = (Element)XmlUtils.newXPath((String)"/io:openimmo_feedback", (Document)document).selectSingleNode((Object)document);
                if (object == null) {
                    LOGGER.warn("Can't find an <openimmo_feedback> element in the document!");
                    return;
                }
                element = document.createElement("version");
                object.insertBefore(element, object.getFirstChild());
            }
            object = openImmoVersion.toReadableVersion();
            if (stringArray.length > 1) {
                object = (String)object + "/" + stringArray[1];
            }
            element.setTextContent((String)object);
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public OpenimmoFeedback toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (OpenimmoFeedback)OpenImmoUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

