/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.attribs.administration.ApartmentNr;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEnd;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.GrossArea;
import com.openindex.openestate.impl.attribs.prices.Conventioned;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.CurrencyValue;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.extensions.EstateTableExtension;
import com.openindex.openestate.tool.agency.gui.AreaValueRenderer;
import com.openindex.openestate.tool.agency.gui.CurrencyValueRenderer;
import com.openindex.openestate.tool.agency.gui.RoomCountRenderer;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.AlphanumComparator;
import com.openindex.openestate.tool.utils.FormattedDate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateTable.class);
    private List<EstateTableExtension> addons;
    private Map<AbstractTable.Column, EstateTableExtension> addonColumns;

    public AgencyEstateTable(String string) {
        super(string);
    }

    public AgencyEstateTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    protected AbstractTable.Model<R> createModel() {
        return new AbstractTable.Model<R>(){

            public Object getValueAt(int n, int n2) {
                AbstractTable.Column column = this.getColumn(n2);
                return AgencyEstateTable.this.addonColumns.containsKey(column) ? ((EstateTableExtension)AgencyEstateTable.this.addonColumns.get(column)).getColumnValue(column, (Row)this.getRow(n)) : super.getValueAt(n, n2);
            }
        };
    }

    public EstateTableExtension[] getAddons() {
        return this.addons.toArray(new EstateTableExtension[0]);
    }

    public DbAgencyObject getEstateAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getObject() : null;
    }

    public Long getEstateIdAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? Long.valueOf(row.getObject().id) : null;
    }

    public DbAgencyObject.Status getEstateStatusAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getObject().status : null;
    }

    public int getRowForEstateId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getEstateIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.addons = new ArrayList<EstateTableExtension>();
        this.addonColumns = new HashMap<AbstractTable.Column, EstateTableExtension>();
        try {
            for (EstateTableExtension estateTableExtension : AgencyPluginUtils.getEstateTableExtensions()) {
                this.addons.add(estateTableExtension);
                for (AbstractTable.Column column : (AbstractTable.Column[])ObjectUtils.defaultIfNull((Object)estateTableExtension.getColumns(), (Object)new AbstractTable.Column[0])) {
                    this.addonColumns.put(column, estateTableExtension);
                    this.getModel().addColumn(column, false);
                }
            }
            this.getModel().fireTableStructureChanged();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load estate table extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        super.init();
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class DateValueRenderer
    extends AbstractRenderer<DateValue> {
        private DateFormat format;

        public DateValueRenderer() {
            this(null, null);
        }

        public DateValueRenderer(String string) {
            this(string, null);
        }

        public DateValueRenderer(DateFormat dateFormat) {
            this(null, dateFormat);
        }

        public DateValueRenderer(String string, DateFormat dateFormat) {
            super(string);
            this.format = dateFormat != null ? dateFormat : DateFormat.getDateTimeInstance();
        }

        public void render(DateValue dateValue, JLabel jLabel) {
            if (dateValue != null) {
                Date date = dateValue.getDateValue();
                jLabel.setText(date != null ? this.format.format(date) : dateValue.getTextValue());
            } else {
                jLabel.setText(this.getEmptyText());
            }
        }
    }

    public static final class DateValue
    implements Comparable<DateValue> {
        private FormattedDate dateValue;
        private String textValue;

        public DateValue(FormattedDate formattedDate) {
            this.setDateValue(formattedDate);
        }

        public DateValue(String string) {
            this.setTextValue(string);
        }

        @Override
        public int compareTo(DateValue dateValue) {
            if (dateValue == null) {
                return 1;
            }
            if (this == dateValue) {
                return 0;
            }
            if (this.getTextValue() == null && dateValue.getTextValue() != null) {
                return -1;
            }
            if (this.getTextValue() != null && dateValue.getTextValue() == null) {
                return 1;
            }
            if (this.getDateValue() == null && dateValue.getDateValue() != null) {
                return 1;
            }
            if (this.getDateValue() != null && dateValue.getDateValue() == null) {
                return -1;
            }
            return new AlphanumComparator().compare(StringUtils.trimToEmpty((String)this.getTextValue()), StringUtils.trimToEmpty((String)dateValue.getTextValue()));
        }

        public Date getDateValue() {
            return this.dateValue != null ? new Date(this.dateValue.getTime()) : null;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public void setDateValue(FormattedDate formattedDate) {
            this.dateValue = formattedDate;
            this.textValue = this.dateValue != null ? String.valueOf(this.dateValue.getTime()) : null;
        }

        public void setTextValue(String string) {
            this.dateValue = null;
            this.textValue = StringUtils.trimToNull((String)string);
        }

        public String toString() {
            if (this.dateValue != null) {
                return this.dateValue.toString();
            }
            return StringUtils.trimToEmpty((String)this.textValue);
        }
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbAgencyObject object;

        public Row(DbAgencyObject dbAgencyObject) {
            this.object = dbAgencyObject;
        }

        public DbAgencyObject getObject() {
            return this.object;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForEstate((Column)column);
            }
            return null;
        }

        public Object getValueForEstate(Column column) {
            if (this.object == null) {
                return null;
            }
            EstateImpl estateImpl = this.object.item;
            EstateAddressImpl estateAddressImpl = estateImpl != null ? estateImpl.getAddress() : null;
            switch (column) {
                case ID: {
                    return this.object.id;
                }
                case NR: {
                    return estateImpl != null ? estateImpl.getPublicId() : null;
                }
                case TYPE: {
                    OpenEstateType openEstateType = estateImpl != null ? estateImpl.getType() : null;
                    return openEstateType != null ? openEstateType.getTranslation() : null;
                }
                case ACTION: {
                    OpenEstateAction openEstateAction = estateImpl != null ? estateImpl.getAction() : null;
                    return openEstateAction != null ? openEstateAction.getTranslation() : null;
                }
                case PRICE: {
                    return estateImpl != null ? estateImpl.getPrimaryPriceValue() : null;
                }
                case SERVICE_CHARGES: {
                    return estateImpl != null ? ServiceCharges.get((EstateImpl)estateImpl) : null;
                }
                case AREA: {
                    if (estateImpl == null) {
                        return null;
                    }
                    AreaValue areaValue = GrossArea.get((EstateImpl)estateImpl);
                    if (areaValue == null) {
                        areaValue = estateImpl.getPrimaryAreaValue();
                    }
                    return areaValue;
                }
                case ROOMS: {
                    return estateImpl != null ? CountRooms.getAsFloat((EstateImpl)estateImpl) : null;
                }
                case TITLE: {
                    if (estateImpl == null) {
                        return null;
                    }
                    String string = StringUtils.trimToNull((String)estateImpl.getTitle(Locale.getDefault()));
                    if (string == null) {
                        String string2;
                        Iterator iterator = estateImpl.getLanguages().iterator();
                        while (iterator.hasNext() && (string = StringUtils.trimToNull((String)estateImpl.getTitle(string2 = (String)iterator.next()))) == null) {
                        }
                    }
                    return string;
                }
                case STREET: {
                    if (estateAddressImpl == null) {
                        return null;
                    }
                    String string = "";
                    if (StringUtils.isNotBlank((CharSequence)estateAddressImpl.getStreet())) {
                        string = string + StringUtils.trimToEmpty((String)estateAddressImpl.getStreet());
                    }
                    string = string + " ";
                    if (StringUtils.isNotBlank((CharSequence)estateAddressImpl.getStreetNr())) {
                        string = string + StringUtils.trimToEmpty((String)estateAddressImpl.getStreetNr());
                    }
                    return StringUtils.trimToNull((String)string);
                }
                case POSTALCODE: {
                    return estateAddressImpl != null ? StringUtils.trimToNull((String)estateAddressImpl.getPostalCode()) : null;
                }
                case CITY: {
                    return estateAddressImpl != null ? StringUtils.trimToNull((String)estateAddressImpl.getCity()) : null;
                }
                case DISTRICT: {
                    return estateAddressImpl != null ? StringUtils.trimToNull((String)estateAddressImpl.getDistrict()) : null;
                }
                case REGION: {
                    return estateAddressImpl != null ? StringUtils.trimToNull((String)estateAddressImpl.getRegion()) : null;
                }
                case COUNTRY: {
                    return estateAddressImpl != null ? StringUtils.trimToNull((String)estateAddressImpl.writeCountry()) : null;
                }
                case STATUS: {
                    return this.object.status;
                }
                case CONVENTIONED: {
                    return estateImpl != null ? StringUtils.trimToNull((String)Conventioned.getAsString((EstateImpl)estateImpl)) : null;
                }
                case FLOOR: {
                    return estateImpl != null ? StringUtils.trimToNull((String)Floor.get((EstateImpl)estateImpl, (Locale)Locale.getDefault())) : null;
                }
                case APARTMENT_NR: {
                    return estateImpl != null ? StringUtils.trimToNull((String)ApartmentNr.get((EstateImpl)estateImpl, (Locale)Locale.getDefault())) : null;
                }
                case AVAILABLE_FROM: {
                    if (estateImpl == null) {
                        return null;
                    }
                    Date date = AvailabilityBeginDate.get((EstateImpl)estateImpl);
                    if (date != null) {
                        return new DateValue(FormattedDate.createDateInstance((Date)date, (int)3));
                    }
                    return new DateValue(AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)Locale.getDefault()));
                }
                case AVAILABLE_UNTIL: {
                    if (estateImpl == null) {
                        return null;
                    }
                    Date date = AvailabilityEndDate.get((EstateImpl)estateImpl);
                    if (date != null) {
                        return new DateValue(FormattedDate.createDateInstance((Date)date, (int)3));
                    }
                    return new DateValue(AvailabilityEnd.get((EstateImpl)estateImpl, (Locale)Locale.getDefault()));
                }
                case CHANGE_TIME: {
                    return this.object.modifiedAt;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        NR,
        TYPE,
        ACTION,
        PRICE,
        SERVICE_CHARGES,
        AREA,
        ROOMS,
        TITLE,
        STREET,
        POSTALCODE,
        CITY,
        DISTRICT,
        REGION,
        COUNTRY,
        STATUS,
        CONVENTIONED,
        FLOOR,
        APARTMENT_NR,
        AVAILABLE_FROM,
        AVAILABLE_UNTIL,
        CHANGE_TIME;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case AREA: {
                    return new DefaultTableCellRenderer((Renderer)new AreaValueRenderer());
                }
                case AVAILABLE_FROM: 
                case AVAILABLE_UNTIL: {
                    return new DefaultTableCellRenderer((Renderer)new DateValueRenderer(DateFormat.getDateInstance(2)));
                }
                case PRICE: 
                case SERVICE_CHARGES: {
                    return new DefaultTableCellRenderer((Renderer)new CurrencyValueRenderer());
                }
                case ROOMS: {
                    return new DefaultTableCellRenderer((Renderer)new RoomCountRenderer());
                }
                case STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer());
                }
                case CHANGE_TIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case STATUS: {
                    return DbAgencyObject.Status.class;
                }
                case CHANGE_TIME: {
                    return Date.class;
                }
                case PRICE: {
                    return CurrencyValue.class;
                }
                case AREA: {
                    return AreaValue.class;
                }
                case SERVICE_CHARGES: 
                case ROOMS: {
                    return Float.class;
                }
                case NR: 
                case TYPE: 
                case ACTION: 
                case TITLE: 
                case STREET: 
                case POSTALCODE: 
                case CITY: 
                case DISTRICT: 
                case REGION: 
                case COUNTRY: 
                case CONVENTIONED: 
                case FLOOR: 
                case APARTMENT_NR: {
                    return String.class;
                }
                case AVAILABLE_FROM: 
                case AVAILABLE_UNTIL: {
                    return DateValue.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return StringUtils.capitalize((String)I18N.tr("ID"));
                }
                case NR: {
                    return StringUtils.capitalize((String)I18N.tr("nr"));
                }
                case TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case ACTION: {
                    return StringUtils.capitalize((String)I18N.tr("marketing"));
                }
                case PRICE: {
                    return StringUtils.capitalize((String)I18N.tr("price"));
                }
                case SERVICE_CHARGES: {
                    return StringUtils.capitalize((String)OpenEstateAttrib.PRICES_SERVICE_CHARGES.getTranslation());
                }
                case AREA: {
                    return StringUtils.capitalize((String)I18N.tr("area"));
                }
                case ROOMS: {
                    return StringUtils.capitalize((String)I18N.tr("rooms"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("title"));
                }
                case STREET: {
                    return StringUtils.capitalize((String)I18N.tr("street"));
                }
                case POSTALCODE: {
                    return StringUtils.capitalize((String)I18N.tr("postcode"));
                }
                case CITY: {
                    return StringUtils.capitalize((String)I18N.tr("place"));
                }
                case DISTRICT: {
                    return StringUtils.capitalize((String)I18N.tr("district"));
                }
                case REGION: {
                    return StringUtils.capitalize((String)I18N.tr("region"));
                }
                case COUNTRY: {
                    return StringUtils.capitalize((String)I18N.tr("country"));
                }
                case STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("status"));
                }
                case CONVENTIONED: {
                    return OpenEstateAttrib.PRICES_CONVENTIONED.getTranslation();
                }
                case FLOOR: {
                    return StringUtils.capitalize((String)OpenEstateAttrib.FEATURES_FLOOR.getTranslation());
                }
                case APARTMENT_NR: {
                    return StringUtils.capitalize((String)OpenEstateAttrib.ADMINISTRATION_APARTMENT_NR.getTranslation());
                }
                case AVAILABLE_FROM: {
                    return I18N.tr("available from");
                }
                case AVAILABLE_UNTIL: {
                    return I18N.tr("available until");
                }
                case CHANGE_TIME: {
                    return I18N.tr("last modification");
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                case NR: {
                    return new AlphanumComparator();
                }
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case AVAILABLE_FROM: 
                case AVAILABLE_UNTIL: 
                case SERVICE_CHARGES: 
                case CHANGE_TIME: 
                case DISTRICT: 
                case REGION: 
                case COUNTRY: 
                case CONVENTIONED: 
                case FLOOR: 
                case APARTMENT_NR: {
                    return false;
                }
            }
            return true;
        }
    }
}

