/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.utils.XHTMLViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.CursorListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportLogPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportLogPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportLogPanel.class);
    private static File lastSaveLocation = null;
    private String currentExportName = null;
    private DbAgencyExportLog currentLog = null;
    private JXTitledSeparator title;
    private JScrollPane logScrollPane;
    private XHTMLViewer logField;
    private AbstractI18nAction pdfAction;
    private AbstractI18nAction printAction;

    public AgencyExportLogPanel() {
        this(true);
    }

    public AgencyExportLogPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        JPanel jPanel = null;
        if (bl) {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.pdfAction = this.createPdfAction();
            this.printAction = this.createPrintAction();
            jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (Action[])new Action[]{this.pdfAction, this.printAction});
        }
        this.logField = new XHTMLViewer();
        this.logField.addCursorListener(new CursorListener());
        this.logField.addLinkListener(new LinkListener(){

            public void linkClicked(BasicPanel basicPanel, String string) {
                long l;
                if (StringUtils.isBlank((CharSequence)string)) {
                    return;
                }
                if (!string.startsWith("#")) {
                    return;
                }
                String string2 = StringUtils.trimToNull((String)string.substring(1));
                if (string2 == null) {
                    return;
                }
                try {
                    l = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn("Can't load object ID from link (" + string + ")!");
                    LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    return;
                }
                new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
            }
        });
        this.logScrollPane = new JScrollPane((Component)this.logField);
        this.logScrollPane.setBorder(Paddings.EMPTY);
        this.logScrollPane.setPreferredSize(new Dimension(100, 100));
        this.setBorder((Border)(bl ? Paddings.DIALOG : Paddings.EMPTY));
        this.setLayout(new BorderLayout(5, 5));
        if (jPanel != null) {
            this.add(jPanel, "North");
        }
        this.add(this.logScrollPane, "Center");
        this.updateLocalization();
    }

    public AbstractI18nAction createPdfAction() {
        return new PdfAction();
    }

    public AbstractI18nAction createPrintAction() {
        return new PrintAction();
    }

    private void doPdf() {
        if (this.currentLog == null) {
            return;
        }
        String string = StringUtils.trimToNull((String)this.currentLog.writeHtmlReport(this.currentExportName));
        if (string == null) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return I18N.tr("PDF files") + " (*.pdf)";
            }
        });
        if (lastSaveLocation != null) {
            jFileChooser.setSelectedFile(new File(lastSaveLocation, "export-protocol-" + this.currentLog.id + ".pdf"));
        } else {
            jFileChooser.setSelectedFile(new File("export-protocol-" + this.currentLog.id + ".pdf"));
        }
        int n = jFileChooser.showSaveDialog((Component)((Object)this));
        if (0 != n) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AgencyExportLogPanel.setLastSaveLocation(file.getAbsoluteFile().getParentFile());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ITextRenderer iTextRenderer = new ITextRenderer();
            iTextRenderer.setDocumentFromString(string);
            iTextRenderer.layout();
            iTextRenderer.createPDF((OutputStream)fileOutputStream);
            iTextRenderer.finishPDF();
            fileOutputStream.flush();
            String string2 = "<html><b>" + I18N.tr("The protocol was saved to harddisk.") + "</b><br>" + StringUtils.capitalize((String)I18N.tr("file")) + ": " + StringUtils.abbreviateMiddle((String)file.getAbsolutePath(), (String)"...", (int)75) + "</html>";
            ImmoToolUtils.showMessageInfoDialog((String)string2, (Component)((Object)this));
        }
        catch (Exception exception) {
            LOGGER.error("Can't create PDF protocol!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't create PDF protocol!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doPrint() {
        try {
            PrinterJob printerJob = this.logField.createPrinterJob();
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            LOGGER.error("Can't print protocol!");
            LOGGER.error("> " + printerException.getLocalizedMessage(), (Throwable)printerException);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't print protocol!", (Throwable)printerException, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    public static synchronized void setLastSaveLocation(File file) {
        lastSaveLocation = file;
    }

    public void setLog(DbAgencyExportLog dbAgencyExportLog, String string) {
        String string2;
        this.currentLog = dbAgencyExportLog;
        this.currentExportName = string;
        if (this.pdfAction != null) {
            this.pdfAction.setEnabled(dbAgencyExportLog != null && dbAgencyExportLog.id > 0L);
        }
        if (this.printAction != null) {
            this.printAction.setEnabled(dbAgencyExportLog != null && dbAgencyExportLog.id > 0L);
        }
        if (this.title != null) {
            string2 = I18N.tr("export protocol");
            if (dbAgencyExportLog != null && dbAgencyExportLog.id > 0L) {
                int n;
                int n2 = n = dbAgencyExportLog.entries != null ? dbAgencyExportLog.entries.size() : 0;
                if (n > 0) {
                    string2 = string2 + " / ";
                    string2 = string2 + I18N.trn("{0} property", "{0} properties", (long)n, (Object)n);
                }
            }
            this.title.setTitle(StringUtils.capitalize((String)string2));
        }
        if (dbAgencyExportLog == null) {
            this.logScrollPane.setVisible(false);
        } else {
            string2 = StringUtils.trimToNull((String)dbAgencyExportLog.writeHtmlReport(string));
            if (string2 != null) {
                try {
                    this.logField.setDocument(XHTMLViewer.parseDocument((String)string2));
                }
                catch (IOException iOException) {
                    LOGGER.warn("Can't parse HTML document!");
                    LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
                }
            }
            this.logScrollPane.setVisible(string2 != null);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.setLog(this.currentLog, this.currentExportName);
    }

    private class PrintAction
    extends AbstractI18nAction {
        private PrintAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"print.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportLogPanel.this.doPrint();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("print")));
            this.setShortDescription(I18N.tr("Print the export protocol."));
        }
    }

    private class PdfAction
    extends AbstractI18nAction {
        private PdfAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_saveas.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyExportLogPanel.this.doPdf();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save")));
            this.setShortDescription(I18N.tr("Save the export protocol to harddisk."));
        }
    }
}

