/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportPool.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportPool.class);
    private final File poolFolder;
    private final DbAgencyExtension dbExtension;
    private final Map<Long, Long> objectStamps;

    public AgencyExportPool(File file, DbAgencyExtension dbAgencyExtension) {
        this.poolFolder = file;
        this.dbExtension = dbAgencyExtension;
        this.objectStamps = new HashMap<Long, Long>();
    }

    public synchronized void cleanup() {
        FileUtils.deleteQuietly((File)this.poolFolder);
    }

    public synchronized File getObjectFile(long l) {
        return new File(this.poolFolder, l + ".xml");
    }

    public synchronized File getPoolFolder() {
        return this.poolFolder;
    }

    public synchronized boolean isObjectModifiedSinceLastExport(long l, Date date) {
        if (date == null) {
            return true;
        }
        if (!this.objectStamps.containsKey(l)) {
            return true;
        }
        return this.objectStamps.get(l) > date.getTime();
    }

    public synchronized EstateImpl lookupObject(long l, Connection connection, Map<Long, String> map, Map<Long, DbGeo> map2) throws IOException, DocumentException, SQLException {
        String string;
        Object object;
        File file = this.getObjectFile(l);
        if (file.isFile()) {
            if (file.length() < 1L) {
                return null;
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Document document = OpenEstateUtils.loadDocument((InputStream)fileInputStream);
                EstateImpl estateImpl = new EstateImpl(document);
                return estateImpl;
            }
        }
        DbAgencyObjectsHandler dbAgencyObjectsHandler = this.dbExtension.getObjectsHandler();
        DbFilesHandler dbFilesHandler = this.dbExtension.getFilesHandler();
        DbLinksHandler dbLinksHandler = this.dbExtension.getLinksHandler();
        DbGeoHandler dbGeoHandler = this.dbExtension.getGeoHandler();
        DbAgencyObject dbAgencyObject = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, l);
        if (dbAgencyObject == null) {
            FileUtils.touch((File)file);
            return null;
        }
        dbAgencyObjectsHandler.loadObjectAttribs(connection, dbAgencyObject, map);
        dbAgencyObjectsHandler.loadObjectTranslations(connection, dbAgencyObject, map);
        dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject);
        dbAgencyObjectsHandler.loadObjectGeoDbAreas(connection, dbAgencyObject, dbGeoHandler);
        dbAgencyObject.item.setContactId(String.valueOf(dbAgencyObject.contactId));
        dbAgencyObject.writeGeoDbAreasIntoCustomValues(map2);
        FileWriterWithEncoding fileWriterWithEncoding = dbFilesHandler.getFiles(connection, dbAgencyObject.id, null, null);
        dbFilesHandler.loadFileTranslations(connection, (DbFile[])fileWriterWithEncoding, map);
        for (DbFile dbFile : fileWriterWithEncoding) {
            EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
            estateAttachmentImpl.setFile(StringUtils.trimToNull((String)dbFile.name));
            estateAttachmentImpl.setHash(StringUtils.trimToNull((String)dbFile.hash));
            estateAttachmentImpl.setMimeType(StringUtils.trimToNull((String)dbFile.mimeType));
            estateAttachmentImpl.setPublished(Boolean.valueOf(dbFile.published));
            estateAttachmentImpl.setType(dbFile.type);
            if (dbFile.translations != null && !dbFile.translations.isEmpty()) {
                for (Map.Entry object2 : dbFile.translations.entrySet()) {
                    String string2 = (String)object2.getKey();
                    object = (DbFile.Translation)object2.getValue();
                    string = StringUtils.trimToNull((String)object.title);
                    if (string == null) continue;
                    estateAttachmentImpl.setTitle(string, string2);
                }
            }
            dbAgencyObject.item.getAttachments().add(estateAttachmentImpl);
        }
        FileWriterWithEncoding fileWriterWithEncoding2 = dbLinksHandler.getLinks(connection, dbAgencyObject.id, null, null);
        dbLinksHandler.loadLinkTranslations(connection, (DbLink[])fileWriterWithEncoding2, map);
        for (EstateAttachmentImpl estateAttachmentImpl : fileWriterWithEncoding2) {
            EstateLinkImpl estateLinkImpl = new EstateLinkImpl();
            estateLinkImpl.setPublished(Boolean.valueOf(estateAttachmentImpl.published));
            if (estateAttachmentImpl.webLinkUrl != null) {
                estateLinkImpl.setWebLink(estateAttachmentImpl.webLinkUrl);
            } else if (estateAttachmentImpl.provider != null && estateAttachmentImpl.providerLinkId != null) {
                estateLinkImpl.setProviderLink(new EstateLinkImpl.ProviderLink(estateAttachmentImpl.providerLinkId, estateAttachmentImpl.provider));
            }
            if (estateAttachmentImpl.translations != null && !estateAttachmentImpl.translations.isEmpty()) {
                for (Map.Entry entry : estateAttachmentImpl.translations.entrySet()) {
                    object = (String)entry.getKey();
                    string = (DbLink.Translation)entry.getValue();
                    String string3 = StringUtils.trimToNull((String)((DbLink.Translation)string).title);
                    if (string3 == null) continue;
                    estateLinkImpl.setTitle(string3, (String)object);
                }
            }
            dbAgencyObject.item.getLinks().add(estateLinkImpl);
        }
        try (FileWriterWithEncoding fileWriterWithEncoding3 = new FileWriterWithEncoding(file, "UTF-8");){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)dbAgencyObject.item, (Writer)fileWriterWithEncoding3, (boolean)true, (String)"UTF-8");
        }
        if (dbAgencyObject.modifiedAt != null) {
            this.objectStamps.put(dbAgencyObject.id, dbAgencyObject.modifiedAt.getTime());
        } else {
            LOGGER.warn("Unknown last modification for object #" + dbAgencyObject.id + "!");
        }
        return dbAgencyObject.item;
    }
}

