/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportViewTask
extends ImmoToolTask<AgencyExportViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportViewTask.class);
    private long exportId;
    private boolean selectCreatedTab;
    private final AgencyExportViewPanel viewTab;
    private AbstractDbDriver dbDriver;

    public AgencyExportViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public AgencyExportViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading property export {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.exportId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public AgencyExportViewTask(AbstractDbDriver abstractDbDriver, long l, AgencyExportViewPanel agencyExportViewPanel) {
        super(I18N.tr("Loading property export {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.exportId = l;
        this.selectCreatedTab = true;
        this.viewTab = agencyExportViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AgencyExportViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(AgencyExportViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    AgencyExportViewPanel agencyExportViewPanel = (AgencyExportViewPanel)abstractMainTab;
                    if (this.exportId < 1L && agencyExportViewPanel.getCurrentExportId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)agencyExportViewPanel));
                        return null;
                    }
                    if (this.exportId <= 0L || agencyExportViewPanel.getCurrentExportId() != this.exportId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)agencyExportViewPanel));
                    return null;
                }
            }
            if (this.exportId < 1L) {
                return this.viewTab != null ? this.viewTab : AgencyExportViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbAgencyExport dbAgencyExport = dbAgencyExportsHandler.getExport(connection2, this.exportId);
                if (dbAgencyExport == null) {
                    throw new Exception("Can't find property export #" + this.exportId);
                }
                dbAgencyExportsHandler.loadExportSettings(connection2, dbAgencyExport);
                if (this.viewTab == null) {
                    object = AgencyExportViewPanel.createTab(dbAgencyExport);
                    break block8;
                }
                object = this.viewTab;
                ((AgencyExportViewPanel)((Object)object)).setExport(dbAgencyExport);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load property export!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(AgencyExportViewPanel agencyExportViewPanel) {
        super.succeeded((Object)agencyExportViewPanel);
        if (agencyExportViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)agencyExportViewPanel, (boolean)this.selectCreatedTab);
            }
            agencyExportViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

