/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.db.DbAdapter;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbLanguage;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLinksHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.hsql.HSqlDbAdapter;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyUpdateListener;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.hsql.HSqlDbAgencySearchesHandler;
import com.openindex.openestate.tool.agency.extensions.DbAgencyAdapter;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyExtension
extends DbAgencyAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/agency/db/hsql/resources/";
    private static final DbAgencyContactsHandler CONTACTS_HANDLER = new HSqlDbAgencyContactsHandler();
    private static final DbAgencyExportsHandler EXPORTS_HANDLER = new HSqlDbAgencyExportsHandler();
    private static final DbAgencyExposesHandler EXPOSES_HANDLER = new HSqlDbAgencyExposesHandler();
    private static final DbAgencyObjectLogsHandler OBJECT_LOGS_HANDLER = new HSqlDbAgencyObjectLogsHandler();
    private static final DbAgencyObjectsHandler OBJECTS_HANDLER = new HSqlDbAgencyObjectsHandler();
    private static final DbAgencySearchesHandler SEARCHES_HANDLER = new HSqlDbAgencySearchesHandler();
    private static final DbAdapter OPENESTATE_DB_ADAPTER = new HSqlDbAdapter();

    @Override
    public DbAgencyContactsHandler getContactsHandler() {
        return CONTACTS_HANDLER;
    }

    @Override
    public DbAgencyExportsHandler getExportsHandler() {
        return EXPORTS_HANDLER;
    }

    @Override
    public DbAgencyExposesHandler getExposeHandler() {
        return EXPOSES_HANDLER;
    }

    @Override
    public DbFilesHandler getFilesHandler() {
        return OPENESTATE_DB_ADAPTER.getFilesHandler();
    }

    @Override
    public DbGeoHandler getGeoHandler() {
        return OPENESTATE_DB_ADAPTER.getGeoHandler();
    }

    @Override
    public DbLanguagesHandler getLanguagesHandler() {
        return OPENESTATE_DB_ADAPTER.getLanguageHandler();
    }

    @Override
    public DbLinksHandler getLinksHandler() {
        return OPENESTATE_DB_ADAPTER.getLinksHandler();
    }

    @Override
    public DbAgencyObjectLogsHandler getObjectLogsHandler() {
        return OBJECT_LOGS_HANDLER;
    }

    @Override
    public DbAgencyObjectsHandler getObjectsHandler() {
        return OBJECTS_HANDLER;
    }

    @Override
    public final String[] getRequiredProcedures() {
        return new String[]{"remove_openestate_contacts", "save_openestate_contacts", "save_immotool_agency_contacts", "remove_immotool_agency_exports", "remove_immotool_agency_exports_logs", "remove_immotool_agency_exports_logs_entries", "remove_immotool_agency_exports_logs_messages", "remove_immotool_agency_exports_publishings", "remove_immotool_agency_exports_settings", "save_immotool_agency_exports", "save_immotool_agency_exports_logs", "save_immotool_agency_exports_logs_entries", "save_immotool_agency_exports_publishings", "save_immotool_agency_exports_settings", "set_immotool_agency_exports_enabled", "remove_immotool_agency_exposes", "remove_immotool_agency_exposes_files", "remove_immotool_agency_exposes_settings", "save_immotool_agency_exposes", "save_immotool_agency_exposes_files", "save_immotool_agency_exposes_settings", "remove_immotool_logs", "remove_immotool_logs_changes", "save_immotool_logs", "save_immotool_logs_changes", "save_immotool_agency_objects_logs", "remove_openestate_objects", "remove_openestate_objects_attribs", "remove_immotool_agency_objects_exports", "remove_openestate_objects_geodbs_areas", "remove_openestate_objects_i18n", "save_openestate_objects", "save_immotool_agency_objects", "save_openestate_objects_attribs", "save_immotool_agency_objects_exports", "save_openestate_objects_geodbs_areas", "save_openestate_objects_i18n", "set_openestate_objects_contact", "set_immotool_agency_objects_status", "remove_openestate_searches", "remove_openestate_searches_attribs", "remove_openestate_searches_params", "remove_openestate_searches_values", "save_openestate_searches", "save_immotool_agency_searches", "save_openestate_searches_attribs", "save_openestate_searches_params", "save_openestate_searches_values", "set_openestate_searches_enabled"};
    }

    @Override
    public final String[] getRequiredViews() {
        return new String[]{"view_openestate_contacts", "view_immotool_agency_exports", "view_immotool_agency_exports_logs", "view_immotool_agency_exports_logs_entries", "view_immotool_agency_exports_logs_messages", "view_immotool_agency_exports_publishings", "view_immotool_agency_exports_settings", "view_immotool_agency_exposes", "view_immotool_agency_exposes_files", "view_immotool_agency_exposes_files_content", "view_immotool_agency_exposes_settings", "view_immotool_logs_changes", "view_immotool_agency_objects_logs", "view_openestate_objects", "view_openestate_objects_actions", "view_openestate_objects_attribs", "view_immotool_agency_objects_exports", "view_openestate_objects_geodbs_areas", "view_openestate_objects_i18n", "view_openestate_objects_types", "view_openestate_searches", "view_openestate_searches_attribs", "view_openestate_searches_params", "view_openestate_searches_values"};
    }

    @Override
    public DbAgencySearchesHandler getSearchesHandler() {
        return SEARCHES_HANDLER;
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbAgencyExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new AgencyUpdateHandler(string, new DbAgencyUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        OPENESTATE_DB_ADAPTER.install(connection, false);
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbAgencyExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbAgencyExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
            DbLanguage dbLanguage = new DbLanguage();
            dbLanguage.locale = null;
            dbLanguage.enabled = true;
            this.getLanguagesHandler().saveLanguage(connection, dbLanguage);
            Locale[] localeArray = OpenEstateUtils.getAvailableLocales();
            Locale locale = null;
            for (Locale locale2 : localeArray) {
                if (!Locale.getDefault().getLanguage().equalsIgnoreCase(locale2.getLanguage())) continue;
                locale = locale2;
                break;
            }
            if (locale == null) {
                locale = Locale.ENGLISH;
            }
            for (Locale locale2 : localeArray) {
                dbLanguage = new DbLanguage();
                dbLanguage.locale = locale2;
                dbLanguage.enabled = locale.getLanguage().equals(locale2.getLanguage());
                this.getLanguagesHandler().saveLanguage(connection, dbLanguage);
            }
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbAgencyExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbAgencyExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_objects");
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_contacts");
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_exposes");
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_searches");
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_exports");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_objects");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_contacts");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_exposes");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_searches");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_exports");
        AgencyPluginUtils.updateEstateFileHashes(connection, abstractDbDriver, null);
    }

    private static final class AgencyUpdateHandler
    extends HSqlDbUpdateHandler {
        public AgencyUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-Agency", DbUpdateHandlerImpl.Type.PLUGIN, AgencyPlugin.getInstance().getApiVersion(), string, HSqlDbAgencyExtension.RESOURCE_PATH, AgencyPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 13L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_objects");
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_contacts");
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_exposes");
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_searches");
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_agency_exports");
            }
            if (l < 13L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_objects");
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_contacts");
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_exposes");
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_searches");
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_agency_exports");
            }
        }
    }
}

