/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractFormatPanel<ExportType extends AbstractFormat>
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractFormatPanel.class);

    protected void appendFooterImage(JPanel jPanel, String string, final URI uRI, URL uRL) throws IOException {
        final JLabel jLabel = new JLabel();
        ImageIcon imageIcon = new ImageIcon(ImageUtils.read((URL)uRL));
        jLabel.setIcon(imageIcon);
        jLabel.setOpaque(false);
        jLabel.setBackground(Color.WHITE);
        jLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.setToolTipText(string);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ImmoToolUtils.openURL((URI)uRI);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setOpaque(true);
                jLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setOpaque(false);
                jLabel.repaint();
            }
        });
        jPanel.add(jLabel);
    }

    public List<String> getWarnings() {
        return new ArrayList<String>();
    }

    public abstract boolean isValidInput();

    public abstract void load(DbAgencyExport var1, ExportType var2);

    public abstract void save(DbAgencyExport var1, ExportType var2);
}

