/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.extensions.ExportExtension;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractTransport
extends HashMap<String, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractTransport.class);

    protected AbstractTransport() {
    }

    public abstract AbstractTransportPanel createSetupPanel();

    protected void doFinishTransport(ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException {
    }

    protected void doInitTransport(ExportContext exportContext, File file, ImmoToolTask.Callback callback) throws IOException {
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return super.equals(object);
    }

    public final String getMessageCodeTranslation(String string) {
        return this.getMessageCodeTranslation(string, null);
    }

    public String getMessageCodeTranslation(String string, Locale locale) {
        for (DefaultMessageCode defaultMessageCode : DefaultMessageCode.values()) {
            if (!defaultMessageCode.name().equalsIgnoreCase(string)) continue;
            return locale != null ? defaultMessageCode.getTranslation(locale) : defaultMessageCode.getTranslation();
        }
        return null;
    }

    public abstract String getName();

    public abstract String getTitle();

    public static AbstractTransport getTransport(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (ExportExtension exportExtension : AgencyPluginUtils.getExportExtensions()) {
            Object[] objectArray = exportExtension.createTransports();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((AbstractTransport)object).getName().equalsIgnoreCase(string)) continue;
                return object;
            }
        }
        return null;
    }

    public static Map<String, AbstractTransport> getTransports() {
        HashMap<String, AbstractTransport> hashMap = new HashMap<String, AbstractTransport>();
        for (ExportExtension exportExtension : AgencyPluginUtils.getExportExtensions()) {
            Object[] objectArray = exportExtension.createTransports();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                hashMap.put(((AbstractTransport)object).getName(), (AbstractTransport)object);
            }
        }
        return hashMap;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + super.hashCode();
    }

    public void initDefaults() {
    }

    protected boolean isUpdatingMessage() {
        return false;
    }

    protected boolean isUpdatingProgress() {
        return false;
    }

    @Deprecated
    public static Map<String, AbstractTransport> listAvailableTransports() {
        return AbstractTransport.getTransports();
    }

    public static enum DefaultMessageCode implements Translatable
    {
        TRANSPORT_TRANSFER_FAILED(I18n.marktr((String)"transport process failed"));

        private final String i18nKey;

        private DefaultMessageCode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(DefaultMessageCode.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DefaultMessageCode.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

