/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.AbstractTransportRequest;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.HttpTransportPanel;
import com.openindex.openestate.tool.utils.HttpUtils;
import eu.medsea.mimeutil.MimeType;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HttpTransport
extends AbstractTransport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTransport.class);
    private static final I18n I18N = I18nFactory.getI18n(HttpTransport.class);
    private static final String NAME = "http";
    private static final String HTTP_LOGIN = "http.login";
    private static final String HTTP_LOGIN_PASS = "http.login.pass";
    private static final String HTTP_LOGIN_USER = "http.login.user";
    private static final String HTTP_MODE = "http.mode";
    private static final String HTTP_POST_MULTIPART = "http.post.multipart";
    private static final String HTTP_POST_MULTIPART_KEY = "http.post.multipart.key";
    private static final String HTTP_URL = "http.url";

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new HttpTransportPanel();
    }

    public String getHttpLoginPass() {
        return StringUtils.trimToNull((String)((String)this.get(HTTP_LOGIN_PASS)));
    }

    public String getHttpLoginUser() {
        return StringUtils.trimToNull((String)((String)this.get(HTTP_LOGIN_USER)));
    }

    public TransportMode getHttpMode() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTTP_MODE)));
        return !StringUtils.isBlank((CharSequence)string) ? TransportMode.valueOf(string.toUpperCase()) : null;
    }

    @Deprecated
    public String getHttpPostMulitpartKey() {
        return this.getHttpPostMultipartKey();
    }

    public String getHttpPostMultipartKey() {
        return StringUtils.trimToNull((String)((String)this.get(HTTP_POST_MULTIPART_KEY)));
    }

    public URI getHttpUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTTP_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read url: " + string);
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return I18N.tr("Transport to a HTTP server.");
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setHttpLogin(false);
        this.setHttpMode(TransportMode.POST);
        this.setHttpPostMultipart(false);
        this.setHttpPostMultipartKey("upload");
    }

    public boolean isHttpLogin() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTTP_LOGIN)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Deprecated
    public boolean isHttpPostMulitpart() {
        return this.isHttpPostMultipart();
    }

    public boolean isHttpPostMultipart() {
        String string = StringUtils.trimToNull((String)((String)this.get(HTTP_POST_MULTIPART)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    protected boolean isUpdatingMessage() {
        return false;
    }

    @Override
    protected boolean isUpdatingProgress() {
        return false;
    }

    public void setHttpLogin(boolean bl) {
        this.put(HTTP_LOGIN, String.valueOf(bl));
    }

    public void setHttpLoginPass(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(HTTP_LOGIN_PASS);
        } else {
            this.put(HTTP_LOGIN_PASS, string);
        }
    }

    public void setHttpLoginUser(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(HTTP_LOGIN_USER);
        } else {
            this.put(HTTP_LOGIN_USER, string);
        }
    }

    public void setHttpMode(TransportMode transportMode) {
        if (transportMode == null) {
            this.remove(HTTP_MODE);
        } else {
            this.put(HTTP_MODE, transportMode.toString());
        }
    }

    @Deprecated
    public void setHttpPostMulitpart(boolean bl) {
        this.setHttpPostMultipart(bl);
    }

    @Deprecated
    public void setHttpPostMulitpartKey(String string) {
        this.setHttpPostMultipartKey(string);
    }

    public void setHttpPostMultipart(boolean bl) {
        this.put(HTTP_POST_MULTIPART, String.valueOf(bl));
    }

    public void setHttpPostMultipartKey(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(HTTP_POST_MULTIPART_KEY);
        } else {
            this.put(HTTP_POST_MULTIPART_KEY, string);
        }
    }

    public void setHttpUrl(URI uRI) {
        if (uRI == null) {
            this.remove(HTTP_URL);
        } else {
            this.put(HTTP_URL, uRI.toString());
        }
    }

    public static class Request
    extends AbstractTransportRequest<HttpTransport> {
        private final File exportFile;

        public Request(HttpTransport httpTransport, File file) {
            super(httpTransport);
            if (file == null) {
                throw new IllegalArgumentException("No export file was specified!");
            }
            if (!file.isFile() && !file.isDirectory()) {
                throw new IllegalArgumentException("The export file is neither a file nor a directory (" + file.getAbsolutePath() + ")!");
            }
            this.exportFile = file;
        }

        protected void doHandleResponse(HttpResponse httpResponse) throws IOException {
            if (httpResponse == null) {
                throw new IOException("No response was received from the HTTP server.");
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            int n = statusLine != null ? statusLine.getStatusCode() : -1;
            String string = StringUtils.trimToEmpty((String)(statusLine != null ? statusLine.getReasonPhrase() : null));
            if (n < 200 || n > 299) {
                throw new IOException(I18N.tr("The server responded with an error (code {0}).", (Object)n) + " " + string);
            }
        }

        protected final void doSend(HttpClient httpClient, URI uRI, File file) throws IOException {
            if (file.isDirectory()) {
                Object[] objectArray = file.listFiles();
                if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                    for (Object object : objectArray) {
                        this.doSend(httpClient, uRI, (File)object);
                    }
                }
            } else if (file.isFile()) {
                MimeType mimeType = ImmoToolUtils.getMimeType((File)file);
                String string = mimeType != null ? mimeType.toString() : "application/octet-stream";
                this.doSend(httpClient, uRI, file, string);
            }
        }

        protected final void doSend(HttpClient httpClient, URI uRI, File file, String string) throws IOException {
            HttpTransport httpTransport = (HttpTransport)this.getTransport();
            TransportMode transportMode = httpTransport.getHttpMode();
            if (TransportMode.PUT.equals((Object)transportMode)) {
                this.doSendAsPut(httpClient, uRI, file, string);
            } else if (TransportMode.POST.equals((Object)transportMode)) {
                if (httpTransport.isHttpPostMultipart()) {
                    this.doSendAsPostMultipart(httpClient, uRI, file, string);
                } else {
                    this.doSendAsPost(httpClient, uRI, file, string);
                }
            } else {
                throw new IOException("Unsupported transport mode '" + (Object)((Object)transportMode) + "'!");
            }
        }

        protected void doSendAsPost(HttpClient httpClient, URI uRI, File file, String string) throws IOException {
            ContentType contentType = StringUtils.isNotBlank((CharSequence)string) ? ContentType.create((String)string) : null;
            HttpPost httpPost = new HttpPost(uRI);
            httpPost.setEntity((HttpEntity)new FileEntity(file, contentType));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            this.doHandleResponse(httpResponse);
        }

        protected void doSendAsPostMultipart(HttpClient httpClient, URI uRI, File file, String string) throws IOException {
            HttpTransport httpTransport = (HttpTransport)this.getTransport();
            ContentType contentType = StringUtils.isNotBlank((CharSequence)string) ? ContentType.create((String)string) : ContentType.DEFAULT_BINARY;
            HttpPost httpPost = new HttpPost(uRI);
            httpPost.setEntity(MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart(httpTransport.getHttpPostMultipartKey(), (ContentBody)new FileBody(file, contentType)).build());
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            this.doHandleResponse(httpResponse);
        }

        protected void doSendAsPut(HttpClient httpClient, URI uRI, File file, String string) throws IOException {
            String string2 = StringUtils.trimToEmpty((String)uRI.toString());
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            ContentType contentType = StringUtils.isNotBlank((CharSequence)string) ? ContentType.create((String)string) : null;
            HttpPut httpPut = new HttpPut(string2 + file.getName());
            httpPut.setEntity((HttpEntity)new FileEntity(file, contentType));
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            this.doHandleResponse(httpResponse);
        }

        @Override
        public AbstractTransportRequest[] getChildRequests() {
            return null;
        }

        @Override
        public String getTitle() {
            return I18N.tr("Transferring files via {0}.", (Object)"HTTP");
        }

        @Override
        public void send(ExportContext exportContext, ImmoToolTask.Callback callback) throws AbstractTransportRequest.TransferException {
            block21: {
                HttpTransport httpTransport = (HttpTransport)this.getTransport();
                URI uRI = httpTransport.getHttpUrl();
                if (uRI == null) {
                    throw new AbstractTransportRequest.TransferException("No target URL was set!");
                }
                if (!uRI.getScheme().equalsIgnoreCase(HttpTransport.NAME) && !uRI.getScheme().equalsIgnoreCase("https")) {
                    throw new AbstractTransportRequest.TransferException("Unsupported protocol for target URL '" + uRI.toString() + "'!");
                }
                uRI = ImmoToolUtils.toIdnUrl((URI)uRI);
                callback.checkCancelled();
                HttpClientBuilder httpClientBuilder = HttpUtils.builder();
                if (httpTransport.isHttpLogin()) {
                    httpClientBuilder.setDefaultCredentialsProvider(HttpUtils.createAuthentication((String)httpTransport.getHttpLoginUser(), (String)httpTransport.getHttpLoginPass()));
                }
                try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
                    callback.checkCancelled();
                    if (this.exportFile.isDirectory()) {
                        Object[] objectArray = this.exportFile.listFiles();
                        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
                            for (Object object : objectArray) {
                                callback.checkCancelled();
                                this.doSend((HttpClient)closeableHttpClient, uRI, (File)object);
                            }
                        }
                        break block21;
                    }
                    if (this.exportFile.isFile()) {
                        callback.checkCancelled();
                        this.doSend((HttpClient)closeableHttpClient, uRI, this.exportFile);
                        break block21;
                    }
                    throw new AbstractTransportRequest.TransferException("The export file is invalid!");
                }
                catch (IOException iOException) {
                    throw new AbstractTransportRequest.TransferException("Can't send file to target URL!", iOException);
                }
            }
        }
    }

    public static enum TransportMode {
        POST,
        PUT;

    }
}

