/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.IdxCsvFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class IdxCsvFormatPanel
extends AbstractFormatPanel<IdxCsvFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxCsvFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(IdxCsvFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private LocaleComboBox exportLocaleBox;

    public IdxCsvFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.zipExportBox = new JCheckBox();
        this.publicIdBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.exportLocaleBox = new LocaleComboBox(AgencyPlugin.getLocales(), true);
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleBox).xyw(5, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.publicIdBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (IdxCsvFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(AgencyPluginUtils.Message.FULL_EXPORT_WARNING.getTranslation());
        if (this.publicIdBox.isSelected()) {
            list.add(AgencyPluginUtils.Message.PROPERTY_NR_IDENTIFICATION_WARNING.getTranslation());
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, IdxCsvFormat idxCsvFormat) {
        if (idxCsvFormat == null) {
            this.agentIdField.setText("");
            this.exportLocaleBox.setSelectedIndex(-1);
            this.publicIdBox.setSelected(false);
            this.zipExportBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(idxCsvFormat.getAgentId());
            this.exportLocaleBox.setSelectedLocale(idxCsvFormat.getLanguage());
            this.publicIdBox.setSelected(idxCsvFormat.isPropertyPublicId());
            this.energyCertificateBox.setSelected(idxCsvFormat.isPropertyDescriptionWithEnergyCertificate());
            AbstractFormat.Compression compression = idxCsvFormat.getCompression();
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)compression));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, IdxCsvFormat idxCsvFormat) {
        if (idxCsvFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        idxCsvFormat.setAgentId(this.agentIdField.getText().trim());
        idxCsvFormat.setLanguage(this.exportLocaleBox.getSelectedLocale());
        idxCsvFormat.setPropertyPublicId(this.publicIdBox.isSelected());
        idxCsvFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        idxCsvFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.exportLocaleBox.setToolTipText(I18N.tr("The properties will be sent to the recipient in the selected language."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdBox.setText(I18N.tr("Use property number for identification."));
        this.publicIdBox.setToolTipText(I18N.tr("Enable this option to export the property number instead of the property ID."));
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

