/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ImmoXmlFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImmoXmlFormatPanel
extends AbstractFormatPanel<ImmoXmlFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmoXmlFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel immoxmlAgentIdLabel;
    private JTextField immoxmlAgentIdField;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private JLabel agentMailLabel;
    private JTextField agentMailField;
    private JLabel technMailLabel;
    private JTextField technMailField;
    private JLabel exportLineBreakLabel;
    private JComboBox<AbstractXmlFormat.LineBreakMode> exportLineBreakBox;
    private JLabel imageLocationLabel;
    private JComboBox<AbstractFormat.AttachmentMarker> imageLocationBox;
    private JLabel optionsLabel;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdExportBox;
    private JCheckBox unpublishedAddressHiddenBox;
    private JCheckBox energyCertificateBox;
    private LocaleComboBox exportLocaleBox;

    public ImmoXmlFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.zipExportBox = new JCheckBox();
        this.publicIdExportBox = new JCheckBox();
        this.unpublishedAddressHiddenBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.exportLocaleBox = new LocaleComboBox(AgencyPlugin.getLocales(), true);
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.immoxmlAgentIdLabel = new JLabel();
        this.immoxmlAgentIdField = new JTextField();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.technMailLabel = new JLabel();
        this.technMailField = new JTextField();
        this.agentMailLabel = new JLabel();
        this.agentMailField = new JTextField();
        this.exportLineBreakLabel = new JLabel();
        this.exportLineBreakBox = new JComboBox();
        this.exportLineBreakBox.setRenderer((ListCellRenderer<AbstractXmlFormat.LineBreakMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        for (AbstractXmlFormat.LineBreakMode enum_ : AbstractXmlFormat.LineBreakMode.values()) {
            this.exportLineBreakBox.addItem(enum_);
        }
        this.imageLocationLabel = new JLabel();
        this.imageLocationBox = new JComboBox();
        this.imageLocationBox.setRenderer((ListCellRenderer<AbstractFormat.AttachmentMarker>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<AbstractFormat.AttachmentMarker>(){

            public String getEmptyText() {
                return I18N.tr("Keep attachments unchanged.");
            }
        }));
        this.imageLocationBox.addItem(null);
        for (Enum enum_ : AbstractFormat.AttachmentMarker.values()) {
            this.imageLocationBox.addItem((AbstractFormat.AttachmentMarker)enum_);
        }
        this.validationHandler.putRule((JComponent)this.agentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        this.validationHandler.putRule((JComponent)this.immoxmlAgentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 25dlu:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLocaleBox).xyw(5, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.agentMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentMailField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.immoxmlAgentIdLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.immoxmlAgentIdField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.technMailLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.technMailField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.imageLocationLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.imageLocationBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.exportLineBreakLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.exportLineBreakBox).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.zipExportBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.publicIdExportBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.unpublishedAddressHiddenBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.updateLocalization();
        this.load((DbAgencyExport)null, (ImmoXmlFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, ImmoXmlFormat immoXmlFormat) {
        if (immoXmlFormat == null) {
            this.agentIdField.setText("");
            this.agentMailField.setText("");
            this.estateIdPrefixField.setText("");
            this.exportLineBreakBox.setSelectedItem((Object)AbstractXmlFormat.LineBreakMode.NATIVE);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.imageLocationBox.setSelectedItem(null);
            this.immoxmlAgentIdField.setText("");
            this.publicIdExportBox.setSelected(true);
            this.technMailField.setText("");
            this.unpublishedAddressHiddenBox.setSelected(false);
            this.zipExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(immoXmlFormat.getAgentId());
            this.agentMailField.setText(immoXmlFormat.getAgentMail());
            this.estateIdPrefixField.setText(immoXmlFormat.getPropertyPrefix());
            this.exportLocaleBox.setSelectedLocale(immoXmlFormat.getLanguage());
            this.imageLocationBox.setSelectedItem((Object)immoXmlFormat.getImmoXmlAttachmentLocation());
            this.immoxmlAgentIdField.setText(immoXmlFormat.getImmoXmlAgentId());
            this.publicIdExportBox.setSelected(immoXmlFormat.isImmoXmlPropertyPublicIdExported());
            this.technMailField.setText(immoXmlFormat.getImmoXmlTechnicsMail());
            this.unpublishedAddressHiddenBox.setSelected(immoXmlFormat.isPropertyAddressHiddenIfUnpublished());
            this.energyCertificateBox.setSelected(immoXmlFormat.isPropertyDescriptionWithEnergyCertificate());
            AbstractFormat.Compression compression = immoXmlFormat.getCompression();
            this.zipExportBox.setSelected(AbstractFormat.Compression.ZIP.equals((Object)compression));
            AbstractXmlFormat.LineBreakMode lineBreakMode = immoXmlFormat.getXmlLineBreak();
            this.exportLineBreakBox.setSelectedItem((Object)(lineBreakMode != null ? lineBreakMode : AbstractXmlFormat.LineBreakMode.NATIVE));
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, ImmoXmlFormat immoXmlFormat) {
        if (immoXmlFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        immoXmlFormat.setAgentId(this.agentIdField.getText().trim());
        immoXmlFormat.setAgentMail(this.agentMailField.getText().trim());
        immoXmlFormat.setPropertyPrefix(this.estateIdPrefixField.getText().trim());
        immoXmlFormat.setImmoXmlAgentId(this.immoxmlAgentIdField.getText().trim());
        immoXmlFormat.setLanguage(this.exportLocaleBox.getSelectedLocale());
        immoXmlFormat.setImmoXmlPropertyPublicIdExported(this.publicIdExportBox.isSelected());
        immoXmlFormat.setXmlLineBreak((AbstractXmlFormat.LineBreakMode)((Object)this.exportLineBreakBox.getSelectedItem()));
        immoXmlFormat.setImmoXmlAttachmentLocation((AbstractFormat.AttachmentMarker)((Object)this.imageLocationBox.getSelectedItem()));
        immoXmlFormat.setImmoXmlTechnicsMail(this.technMailField.getText().trim());
        immoXmlFormat.setPropertyAddressHiddenIfUnpublished(this.unpublishedAddressHiddenBox.isSelected());
        immoXmlFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
        immoXmlFormat.setCompression(this.zipExportBox.isSelected() ? AbstractFormat.Compression.ZIP : AbstractFormat.Compression.UNCOMPRESSED);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.immoxmlAgentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("ImmoXML-ID")) + ":");
        this.immoxmlAgentIdField.setToolTipText(I18N.tr("Enter your ImmoXML agent-ID for the recipient, if required."));
        this.agentMailLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-mail")) + ":");
        this.technMailLabel.setText(StringUtils.capitalize((String)I18N.tr("support-mail")) + ":");
        this.technMailField.setToolTipText(I18N.tr("Enter your e-mail address for technical feedback. Some recipients are sending their protocols to this address."));
        this.imageLocationLabel.setText(StringUtils.capitalize((String)I18N.tr("marking")) + ":");
        this.imageLocationBox.setToolTipText(I18N.tr("Use this field to specify, if attachments are marked 'internal' or 'external'."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.exportLineBreakLabel.setText(StringUtils.capitalize((String)I18N.tr("line break")) + ":");
        this.exportLineBreakBox.setToolTipText(I18N.tr("Use this field to specify, how line breaks are written into the exported file."));
        this.exportLocaleBox.setToolTipText(I18N.tr("The properties will be sent to the recipient in the selected language."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.zipExportBox.setText(I18N.tr("Compress exported files into a ZIP-archive."));
        this.zipExportBox.setToolTipText(I18N.tr("Compressing the exported files into a ZIP-archive will reduce the total file size of the export."));
        this.publicIdExportBox.setText(I18N.tr("Publish property-nr."));
        this.publicIdExportBox.setToolTipText(I18N.tr("Enable this option to publish the property-nr next to the property-ID. Not all recipients support this feature."));
        this.unpublishedAddressHiddenBox.setText(I18N.tr("Don't export unpublished addresses."));
        this.unpublishedAddressHiddenBox.setToolTipText(I18N.tr("Enable this option, if you don't want to export unpublished addresses."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

