/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.immobiliare_it.ImmobiliareItWriter;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ImmobiliareXmlFormatPanel;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.LocationStructure;
import org.openestate.io.immobiliare_it.xml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Transient fields use the default values on de-serialization.")
public class ImmobiliareXmlFormat
extends AbstractXmlFormat<Feed> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareXmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(ImmobiliareXmlFormat.class);
    private static final String NAME = "immobiliare";
    public static final String GEODB = "immobiliare";
    private static final String IMMOBILIARE_BASE_URL = "immobiliare.baseUrl";
    private static final String IMMOBILIARE_PUBLISHER_MAIL = "immobiliare.publisher.mail";

    protected ImmobiliareItWriter buildWriter() {
        return this.buildWriter(null, null);
    }

    private Writer buildWriter(ExportContext exportContext) {
        return exportContext != null ? this.buildWriter(exportContext.dbDriver, exportContext.dbExtension) : this.buildWriter(null, null);
    }

    private Writer buildWriter(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        Writer writer = new Writer(this.getLanguage(), abstractDbDriver, dbAgencyExtension);
        writer.setXmlLineSeparator("<br/>");
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        URI uRI = this.getImmobiliareBaseUrl();
        if (uRI != null) {
            writer.setBaseUrl(uRI.toString());
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        Feed feed;
        Object object2;
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("immobiliare");
        if (geoAreaImpl == null) {
            throw new AbstractFormat.NotExportableException("No region selected!");
        }
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object2 = this.buildWriter();
            object2.setXmlLineSeparator("<br/>");
            feed = (Feed)object2.writeToObject(agencyImpl);
            string = object2.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (feed == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        feed.setMetadata(null);
        feed.setVersion(null);
        if (feed.getProperties() != null) {
            for (Object object322 : feed.getProperties().getProperty()) {
                object322.setDateUpdated(null);
            }
        }
        try {
            Object object322;
            object2 = new StringWriter();
            object322 = null;
            try {
                ImmobiliareItUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)feed, (java.io.Writer)object2);
                String string2 = ((StringWriter)object2).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                String string3 = DigestUtils.sha1Hex((String)string2);
                return string3;
            }
            catch (Throwable throwable) {
                object322 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object322 != null) {
                        try {
                            ((StringWriter)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object322).addSuppressed(throwable);
                        }
                    } else {
                        ((StringWriter)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    protected Feed convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        Object object;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            throw new RuntimeException("No project loaded!");
        }
        Writer writer = this.buildWriter(exportContext);
        Feed feed = writer.writeToObject(transferImpl);
        if (feed == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)this.getImmobiliarePublisherMail());
        if (string == null) {
            try {
                string = StringUtils.trimToNull((String)immoToolProject.getAgent().getCompany().getCompanyMail());
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load load publisher-mail!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        feed.getMetadata().getPublisher().setEmail(string);
        String string2 = StringUtils.trimToNull((String)this.getAgentMail());
        if (string2 != null && (object = feed.getProperties()) != null) {
            for (Feed.Properties.Property property : object.getProperty()) {
                if (property.getAgent() == null) {
                    property.setAgent(ImmobiliareItUtils.getFactory().createFeedPropertiesPropertyAgent());
                }
                property.getAgent().setEmail(string2);
            }
        }
        if (PublishingMode.NEVER.equals((Object)this.getPropertyFilePublication()) && feed.getProperties() != null) {
            for (Feed.Properties.Property property : feed.getProperties().getProperty()) {
                property.setPictures(null);
                property.setBlueprints(null);
                property.setVideos(null);
            }
        }
        exportContext.addErrorMessages(writer.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return feed;
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new ImmobiliareXmlFormatPanel();
    }

    public URI getImmobiliareBaseUrl() {
        String string = StringUtils.trimToNull((String)((String)this.get(IMMOBILIARE_BASE_URL)));
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read url: " + string);
            return null;
        }
    }

    public String getImmobiliarePublisherMail() {
        return StringUtils.trimToNull((String)((String)this.get(IMMOBILIARE_PUBLISHER_MAIL)));
    }

    @Override
    public String getName() {
        return "immobiliare";
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL};
    }

    @Override
    public String getTitle() {
        return "Immobiliare-XML";
    }

    @Override
    public String getVersion() {
        return ImmobiliareItUtils.VERSION.toReadableVersion();
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        return "properties-full.xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setPropertyPublicId(false);
        this.setAttachmentMode(AbstractFormat.AttachmentMode.FILE);
        this.setCompression(AbstractFormat.Compression.UNCOMPRESSED);
        this.setLanguages(new Locale[]{Locale.ITALIAN});
    }

    @Override
    public boolean isFullTransportWarningShown() {
        return false;
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("immobiliare");
        if (geoAreaImpl == null) {
            return false;
        }
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.removeCustomGeoAreas();
        estateImpl.putCustomGeoArea("immobiliare", geoAreaImpl);
        return true;
    }

    public void setImmobiliareBaseUrl(URI uRI) {
        if (uRI == null) {
            this.remove(IMMOBILIARE_BASE_URL);
        } else {
            this.put(IMMOBILIARE_BASE_URL, uRI.toString());
        }
    }

    public void setImmobiliarePublisherMail(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(IMMOBILIARE_PUBLISHER_MAIL);
        } else {
            this.put(IMMOBILIARE_PUBLISHER_MAIL, string);
        }
    }

    @Override
    protected void writeXmlObject(Feed feed, java.io.Writer writer) throws IOException, JAXBException {
        try {
            ImmobiliareItDocument immobiliareItDocument = ImmobiliareItDocument.newDocument((Feed)feed);
            immobiliareItDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends ImmobiliareItWriter {
        private final Map<Long, DbGeoArea> areas;
        private final AbstractDbDriver dbDriver;
        private final DbAgencyExtension dbExtension;
        private Connection dbConnection = null;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
            super(locale);
            this.dbDriver = abstractDbDriver;
            this.dbExtension = dbAgencyExtension;
            this.areas = new HashMap<Long, DbGeoArea>();
            AgencyPluginUtils.initJAXB(ImmobiliareItUtils.class);
        }

        private Connection initConnection() throws SQLException {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbDriver.getConnection();
            }
            return this.dbConnection;
        }

        private DbGeoArea lookupArea(Long l) throws SQLException {
            if (this.areas.containsKey(l)) {
                return this.areas.get(l);
            }
            Connection connection = this.initConnection();
            DbGeoArea dbGeoArea = this.dbExtension.getGeoHandler().getGeoArea(connection, l.longValue());
            this.areas.put(dbGeoArea.id, dbGeoArea);
            return dbGeoArea;
        }

        private List<DbGeoArea> lookupAreaPath(DbGeoArea dbGeoArea) throws SQLException {
            ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
            if (dbGeoArea == null) {
                return arrayList;
            }
            if (dbGeoArea.parentAreaId > 0L) {
                arrayList.addAll(this.lookupAreaPath(this.lookupArea(dbGeoArea.parentAreaId)));
            }
            arrayList.add(dbGeoArea);
            return arrayList;
        }

        private DbGeoArea[] lookupAreas(GeoAreaImpl geoAreaImpl) throws SQLException {
            Long l = Long.valueOf(geoAreaImpl.getId());
            DbGeoArea dbGeoArea = this.lookupArea(l);
            if (dbGeoArea == null) {
                return null;
            }
            List<DbGeoArea> list = this.lookupAreaPath(dbGeoArea);
            return list.toArray(new DbGeoArea[0]);
        }

        public Feed.Properties.Property convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
            ObjectFactory objectFactory = ImmobiliareItUtils.getFactory();
            Feed.Properties.Property property = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
            if (property == null || !list.isEmpty()) {
                return null;
            }
            if (property.getLocation() == null) {
                property.setLocation(objectFactory.createLocationStructure());
            }
            if (this.dbDriver != null) {
                GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea("immobiliare");
                DbGeoArea[] dbGeoAreaArray = null;
                if (geoAreaImpl != null) {
                    try {
                        dbGeoAreaArray = this.lookupAreas(geoAreaImpl);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load areas from geodb 'immobiliare'!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
                if (dbGeoAreaArray != null && dbGeoAreaArray.length > 0) {
                    property.getLocation().setAdministrativeArea(StringUtils.trimToEmpty((String)dbGeoAreaArray[0].name));
                }
                if (dbGeoAreaArray != null && dbGeoAreaArray.length > 1) {
                    property.getLocation().setSubAdministrativeArea(objectFactory.createLocationStructureSubAdministrativeArea());
                    property.getLocation().getSubAdministrativeArea().setValue(StringUtils.trimToEmpty((String)dbGeoAreaArray[1].name));
                    property.getLocation().getSubAdministrativeArea().setCode(StringUtils.trimToNull((String)dbGeoAreaArray[1].providerId));
                }
                if (dbGeoAreaArray != null && dbGeoAreaArray.length > 2) {
                    property.getLocation().setCity(objectFactory.createLocationStructureCity());
                    property.getLocation().getCity().setValue(StringUtils.trimToEmpty((String)dbGeoAreaArray[2].name));
                    try {
                        property.getLocation().getCity().setCode(new BigInteger(dbGeoAreaArray[2].providerId));
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't write geo-code for city!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        property.getLocation().getCity().setCode(null);
                    }
                }
                if (dbGeoAreaArray != null && dbGeoAreaArray.length > 3) {
                    if (property.getLocation().getLocality() == null) {
                        property.getLocation().setLocality(objectFactory.createLocationStructureLocality());
                    }
                    property.getLocation().getLocality().setNeighbourhood(objectFactory.createLocationStructureLocalityNeighbourhood());
                    property.getLocation().getLocality().getNeighbourhood().setType(LocationStructure.Locality.Neighbourhood.LocationNeighbourhoodType.AREA);
                    property.getLocation().getLocality().getNeighbourhood().setValue(StringUtils.trimToEmpty((String)dbGeoAreaArray[3].name));
                    try {
                        property.getLocation().getLocality().getNeighbourhood().setId(new BigInteger(dbGeoAreaArray[3].providerId));
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't write geo-code for locality!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        property.getLocation().getLocality().getNeighbourhood().setValue(null);
                    }
                }
            }
            return property;
        }

        public Feed writeToObject(AgencyImpl agencyImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                Feed feed = (Feed)super.writeToObject(agencyImpl);
                return feed;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }

        public Feed writeToObject(TransferImpl transferImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                Feed feed = (Feed)super.writeToObject(transferImpl);
                return feed;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }
    }
}

