/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.attribs.descriptions.Keywords;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.AbstractPdfExpose;
import com.openindex.openestate.tool.agency.expose.PdfDetailedExposePanel;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfDetailedExpose
extends AbstractPdfExpose {
    private static final long serialVersionUID = 4132552141531L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfDetailedExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfDetailedExpose.class);
    public static final String NAME = "detailedPdf";
    private static final String AREAS = "detailedPdf.areas";
    private static final String GALLERY_MODE = "detailedPdf.gallery.mode";
    private static final String GALLERY_SEPARATE_PLANS = "detailedPdf.gallery.separatePlans";
    private static final String GALLERY_SEPARATE_PANORAMAS = "detailedPdf.gallery.separatePanoramas";
    @Deprecated
    private static final String TERMS = "detailedPdf.terms";
    private static final String TERMS_TEXT_SIZE = "detailedPdf.terms.text.size";
    private transient I18n i18n = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void build(OutputStream outputStream) throws IOException, DocumentException {
        block21: {
            DbAgencyObject dbAgencyObject = this.getEstateObject();
            Boolean bl = dbAgencyObject.item.getAddress().isPublished();
            PublishingMode publishingMode = this.getPublishAddress();
            if (PublishingMode.ALWAYS.equals((Object)publishingMode)) {
                dbAgencyObject.item.getAddress().setPublished(true);
            } else if (PublishingMode.NEVER.equals((Object)publishingMode)) {
                dbAgencyObject.item.getAddress().setPublished(false);
            }
            try {
                File file;
                File file2 = file = this.isTemplate() ? this.getTemplateFile() : null;
                if (file != null && file.isFile()) {
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        this.build(fileInputStream, outputStream);
                        break block21;
                    }
                }
                if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
                    this.build(PageSize.A4.rotate(), outputStream);
                } else {
                    this.build(PageSize.A4, outputStream);
                }
            }
            finally {
                dbAgencyObject.item.getAddress().setPublished(Boolean.TRUE.equals(bl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(InputStream inputStream, OutputStream outputStream) throws IOException, DocumentException {
        try (PdfReader pdfReader = null;){
            pdfReader = new PdfReader(inputStream);
            this.build(pdfReader, pdfReader.getPageSize(1), outputStream);
        }
    }

    private void build(Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        this.build(null, rectangle, outputStream);
    }

    private void build(PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        ImmoToolAgent immoToolAgent = this.getAgent();
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        String string = StringUtils.trimToEmpty((String)dbAgencyObject.item.getTitle(this.locale.getLanguage()));
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        Document document = new Document(new Rectangle(f, f2));
        PdfPTable pdfPTable = this.createTable(rectangle);
        pdfPTable.setWidths(new float[]{pdfPTable.getTotalWidth() * 0.5f, pdfPTable.getTotalWidth() * 0.5f});
        this.buildDocument(document, pdfPTable, pdfReader, rectangle, outputStream);
        document.addAuthor(immoToolAgent != null && immoToolAgent.getCompany() != null ? StringUtils.trimToEmpty((String)immoToolAgent.getCompany().getCompanyName()) : "");
        document.addCreationDate();
        document.addCreator(ImmoToolEnvironment.getApplicationTitle() + " v" + ImmoToolEnvironment.getApplicationVersion());
        document.addProducer();
        document.addTitle(string);
        document.addSubject(StringUtils.capitalize((String)this.i18n.tr("property")) + " #" + dbAgencyObject.id);
        String string2 = Keywords.get((EstateImpl)dbAgencyObject.item, (Locale)this.locale);
        if (!StringUtils.isBlank((CharSequence)string2)) {
            document.addKeywords(string2.trim());
        }
        document.close();
    }

    @Override
    public AbstractExposePanel createForm() {
        return new PdfDetailedExposePanel();
    }

    protected PdfPTable createTable(Rectangle rectangle) {
        Area[] areaArray;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        float f = rectangle.getWidth();
        AbstractExpose.HorizontalAlign horizontalAlign = this.getBodyTextAlignment();
        int n = AbstractExpose.HorizontalAlign.CENTER.equals((Object)horizontalAlign) ? 1 : (AbstractExpose.HorizontalAlign.JUSTIFY.equals((Object)horizontalAlign) ? 3 : (AbstractExpose.HorizontalAlign.LEFT.equals((Object)horizontalAlign) ? 0 : (AbstractExpose.HorizontalAlign.RIGHT.equals((Object)horizontalAlign) ? 2 : 3)));
        int n2 = 0;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setTotalWidth(f - 60.0f - 60.0f);
        String string = dbAgencyObject.item.getTitle(this.locale.getLanguage());
        OpenEstateType openEstateType = dbAgencyObject.item.getType();
        String string2 = openEstateType.getTranslation(this.locale);
        OpenEstateAction openEstateAction = dbAgencyObject.item.getAction();
        String string3 = openEstateAction.getTranslation(this.locale);
        Font font = new Font(this.bodyFontH1);
        font.setColor(this.bodyTextFgColor);
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPaddingTop(0.0f);
        pdfPCell.setPaddingBottom(0.0f);
        if (!StringUtils.isBlank((CharSequence)string)) {
            areaArray = StringUtils.replace((String)string, (String)"  ", (String)System.lineSeparator());
            pdfPCell.addElement((Element)new Paragraph(areaArray.trim(), font));
            pdfPCell.addElement((Element)new Paragraph(string2 + " / " + string3, this.bodyFontNormal));
        } else {
            pdfPCell.addElement((Element)new Paragraph(string2 + " / " + string3, font));
        }
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPTable.addCell(pdfPCell);
        areaArray = this.getAreas();
        if (areaArray == null) {
            areaArray = Area.values();
        }
        for (Area area : areaArray) {
            if (Area.GENERAL == area) {
                n2 += this.writeGeneralArea(pdfPTable, n2, n);
                continue;
            }
            if (Area.IMAGES == area) {
                n2 += this.writeImageArea(pdfPTable, n2, rectangle);
                continue;
            }
            if (Area.LINKS == area) {
                n2 += this.writeLinksArea(pdfPTable, n2, n);
                continue;
            }
            if (Area.AGENCY == area) {
                n2 += this.writeAgencyArea(pdfPTable, n2);
                continue;
            }
            if (Area.TERMS == area) {
                n2 += this.writeTermsArea(pdfPTable, n2, n);
                continue;
            }
            LOGGER.warn("Unprintable area: " + (Object)((Object)area));
        }
        return pdfPTable;
    }

    public GalleryMode getGalleryMode() {
        String string = (String)this.get(GALLERY_MODE);
        return string != null ? GalleryMode.valueOf(string) : null;
    }

    public Area[] getAreas() {
        String string = (String)this.get(AREAS);
        if (string == null) {
            return new Area[0];
        }
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (String string2 : StringUtils.split((String)string, (char)',')) {
            try {
                arrayList.add(Area.valueOf(string2));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load area: " + string2 + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return arrayList.toArray(new Area[0]);
    }

    private static int getGalleryColumnCount(GalleryMode galleryMode) {
        if (GalleryMode.ONE_PER_SITE.equals((Object)galleryMode)) {
            return 1;
        }
        if (GalleryMode.TWO_PER_SITE.equals((Object)galleryMode)) {
            return 1;
        }
        if (GalleryMode.ONE_PER_ROW.equals((Object)galleryMode)) {
            return 1;
        }
        if (GalleryMode.TWO_PER_ROW.equals((Object)galleryMode)) {
            return 2;
        }
        if (GalleryMode.THREE_PER_ROW.equals((Object)galleryMode)) {
            return 3;
        }
        if (GalleryMode.FOUR_PER_ROW.equals((Object)galleryMode)) {
            return 4;
        }
        return 0;
    }

    private static Float getGalleryImageWidth(GalleryMode galleryMode, float f) {
        int n = PdfDetailedExpose.getGalleryColumnCount(galleryMode);
        if (n == 1) {
            return Float.valueOf(f);
        }
        if (n > 1) {
            return Float.valueOf(f / (float)n - 10.0f);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getTermsTextSize() {
        String string = (String)this.get(TERMS_TEXT_SIZE);
        return string != null ? Integer.parseInt(string) : 0;
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18nFactory.getI18n(PdfDetailedExpose.class).tr("detailed expos\u00e9"));
    }

    @Override
    protected void init(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        super.init(immoToolProject, connection);
        this.i18n = I18nFactory.getI18n(PdfDetailedExpose.class, (Locale)this.getLocale());
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setAreas(Area.values());
        this.setBodyHeadNumbered(true);
        this.setGalleryMode(GalleryMode.TWO_PER_ROW);
        this.setGallerySeparatePanoramas(true);
        this.setGallerySeparatePlans(true);
        this.setGalleryShowUnpublishedImages(false);
        this.setShowUnpublishedLinks(false);
        this.setTerms(true);
        this.setTermsTextSize(10);
    }

    public boolean isGallerySeparatePanoramas() {
        String string = (String)this.get(GALLERY_SEPARATE_PLANS);
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isGallerySeparatePlans() {
        String string = (String)this.get(GALLERY_SEPARATE_PANORAMAS);
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isGalleryShowUnpublishedImages() {
        return PublishingMode.ALWAYS.equals((Object)this.getPublishFiles());
    }

    public boolean isShowUnpublishedLinks() {
        return PublishingMode.ALWAYS.equals((Object)this.getPublishLinks());
    }

    @Deprecated
    public boolean isTerms() {
        String string = (String)this.get(TERMS);
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public void setAreas(Area[] areaArray) {
        if (areaArray == null || areaArray.length < 1) {
            this.remove(AREAS);
        } else {
            Object[] objectArray = new String[areaArray.length];
            for (int i = 0; i < areaArray.length; ++i) {
                objectArray[i] = areaArray[i].name();
            }
            this.put(AREAS, StringUtils.join((Object[])objectArray, (String)","));
        }
    }

    public void setGalleryMode(GalleryMode galleryMode) {
        if (galleryMode == null) {
            this.remove(GALLERY_MODE);
        } else {
            this.put(GALLERY_MODE, galleryMode.name());
        }
    }

    public void setGallerySeparatePanoramas(boolean bl) {
        this.put(GALLERY_SEPARATE_PLANS, String.valueOf(bl));
    }

    public void setGallerySeparatePlans(boolean bl) {
        this.put(GALLERY_SEPARATE_PANORAMAS, String.valueOf(bl));
    }

    public void setGalleryShowUnpublishedImages(boolean bl) {
        this.setPublishFiles(bl ? PublishingMode.ALWAYS : PublishingMode.DEFAULT);
    }

    public void setShowUnpublishedLinks(boolean bl) {
        this.setPublishLinks(bl ? PublishingMode.ALWAYS : PublishingMode.DEFAULT);
    }

    @Deprecated
    public void setTerms(boolean bl) {
        this.put(TERMS, String.valueOf(bl));
    }

    public void setTermsTextSize(int n) {
        if (n < 1) {
            this.remove(TERMS_TEXT_SIZE);
        } else {
            this.put(TERMS_TEXT_SIZE, String.valueOf(n));
        }
    }

    private int writeAgencyArea(PdfPTable pdfPTable, int n) {
        URI uRI;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        ImmoToolAgent immoToolAgent = this.getAgent();
        if (immoToolAgent == null) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n2 = n;
        int n3 = 0;
        this.buildTableHead(pdfPTable, ++n2, StringUtils.capitalize((String)this.i18n.tr("agency")));
        this.buildTableHead2(pdfPTable, n2, ++n3, StringUtils.capitalize((String)this.i18n.tr("the offer is managed by")));
        this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("company")), immoToolAgent.getCompany().getCompanyName());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(immoToolAgent.getCompany().writeFullAddress(System.lineSeparator()));
        if (immoToolAgent.getCompany().getRegion() != null && immoToolAgent.getCompany().getRegion().trim().length() > 0) {
            stringBuilder.append(" / ").append(immoToolAgent.getCompany().getRegion());
        }
        this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("address")), stringBuilder.toString());
        String string = StringUtils.trimToNull((String)immoToolAgent.getAufsichtsBehoerde());
        if (string != null) {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("controlling authority")), string);
        }
        if ((string = StringUtils.trimToNull((String)immoToolAgent.getGewerbeErlaubnis())) != null) {
            if (immoToolAgent.getCompany() != null && "de".equalsIgnoreCase(immoToolAgent.getCompany().getCountry())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("concession (according \u00a734c)")), string);
            } else {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("concession")), string);
            }
        }
        if ((string = StringUtils.trimToNull((String)immoToolAgent.getHandelsRegister())) != null) {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("company registry")), string);
        }
        if ((string = StringUtils.trimToNull((String)immoToolAgent.getUstId())) != null) {
            this.buildTableRow(pdfPTable, this.i18n.tr("VAT ID"), string);
        }
        if ((string = StringUtils.trimToNull((String)immoToolAgent.getVertretung())) != null) {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("authorized representative")), string);
        }
        if ((uRI = immoToolAgent.getCompany().getCompanyWebsite()) != null && !StringUtils.isBlank((CharSequence)uRI.getHost())) {
            String string2 = StringUtils.substringAfter((String)uRI.toString(), (String)(uRI.getScheme() + "://"));
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("website")), string2);
        }
        long l = dbAgencyObject.contactId;
        try {
            this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
            this.buildTableHead2(pdfPTable, n2, ++n3, StringUtils.capitalize((String)this.i18n.tr("your contact person")));
            DbAgencyContact dbAgencyContact = this.getEstateContact();
            if (dbAgencyContact != null) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("name")), dbAgencyContact.item.writePersonFullName());
            } else {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("name")), immoToolAgent.getCompany().writePersonFullName());
            }
            if (dbAgencyContact != null && !StringUtils.isBlank((CharSequence)dbAgencyContact.item.getPersonPhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("phone")), dbAgencyContact.item.getPersonPhone().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getPersonPhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("phone")), immoToolAgent.getCompany().getPersonPhone().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getCompanyPhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("phone")), immoToolAgent.getCompany().getCompanyPhone().trim());
            }
            if (dbAgencyContact != null && !StringUtils.isBlank((CharSequence)dbAgencyContact.item.getPersonMobilePhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("mobile")), dbAgencyContact.item.getPersonMobilePhone().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getPersonMobilePhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("mobile")), immoToolAgent.getCompany().getPersonMobilePhone().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getCompanyMobilePhone())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("mobile")), immoToolAgent.getCompany().getCompanyMobilePhone().trim());
            }
            if (dbAgencyContact != null && !StringUtils.isBlank((CharSequence)dbAgencyContact.item.getPersonFax())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("fax")), dbAgencyContact.item.getPersonFax().trim());
            } else if (immoToolAgent.getCompany().getPersonFax() != null && immoToolAgent.getCompany().getPersonFax().trim().length() > 0) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("fax")), immoToolAgent.getCompany().getPersonFax().trim());
            } else if (immoToolAgent.getCompany().getCompanyFax() != null && immoToolAgent.getCompany().getCompanyFax().trim().length() > 0) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("fax")), immoToolAgent.getCompany().getCompanyFax().trim());
            }
            if (dbAgencyContact != null && !StringUtils.isBlank((CharSequence)dbAgencyContact.item.getPersonMail())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("e-mail")), dbAgencyContact.item.getPersonMail().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getPersonMail())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("e-mail")), immoToolAgent.getCompany().getPersonMail().trim());
            } else if (!StringUtils.isBlank((CharSequence)immoToolAgent.getCompany().getCompanyMail())) {
                this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("e-mail")), immoToolAgent.getCompany().getCompanyMail().trim());
            }
        }
        catch (Exception exception) {
            LOGGER.warn("could not load contact!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return n2 - n;
    }

    private int writeGeneralArea(PdfPTable pdfPTable, int n, int n2) {
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        AbstractTypeImpl abstractTypeImpl = dbAgencyObject.item.getTypeSpec();
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n3 = n;
        int n4 = 0;
        this.buildTableHead(pdfPTable, ++n3, StringUtils.capitalize((String)this.i18n.tr("general information")));
        this.buildTableHead2(pdfPTable, n3, ++n4, StringUtils.capitalize((String)this.i18n.tr("general")));
        if (!StringUtils.isBlank((CharSequence)dbAgencyObject.item.getPublicId())) {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("property nr")), dbAgencyObject.item.getPublicId().trim());
        } else {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("property ID")), String.valueOf(dbAgencyObject.id));
        }
        this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("address")), dbAgencyObject.item.getAddress().writeFullAddress(System.lineSeparator(), this.locale));
        if (!StringUtils.isBlank((CharSequence)dbAgencyObject.item.getAddress().getRegion())) {
            this.buildTableRow(pdfPTable, StringUtils.capitalize((String)this.i18n.tr("region")), dbAgencyObject.item.getAddress().getRegion().trim());
        }
        LinkedHashSet<OpenEstateAttrib> linkedHashSet = new LinkedHashSet<OpenEstateAttrib>();
        for (Object object2 : OpenEstateAttribGroup.values()) {
            for (OpenEstateAttrib openEstateAttrib : abstractTypeImpl.getAttribsByGroup((OpenEstateAttribGroup)object2)) {
                if (!dbAgencyObject.item.hasAttribute(openEstateAttrib)) continue;
                linkedHashSet.add(openEstateAttrib);
            }
        }
        OpenEstateAttribGroup openEstateAttribGroup = null;
        for (OpenEstateAttrib openEstateAttrib : linkedHashSet) {
            Object object2;
            if (OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttrib.getGroup()) || OpenEstateAttrib.PRICES_SPECIAL_OFFER.equals((Object)openEstateAttrib) || !dbAgencyObject.item.hasAttribute(openEstateAttrib) || StringUtils.isBlank((CharSequence)(object2 = dbAgencyObject.writeValueForPublic(openEstateAttrib, this.locale)))) continue;
            if (openEstateAttribGroup == null || !openEstateAttribGroup.equals((Object)openEstateAttrib.getGroup())) {
                openEstateAttribGroup = openEstateAttrib.getGroup();
                String string = openEstateAttribGroup.getTranslation(this.locale);
                this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
                this.buildTableHead2(pdfPTable, n3, ++n4, string.trim());
            }
            String string = openEstateAttrib.getTranslation(this.locale);
            this.buildTableRow(pdfPTable, string.trim(), ((String)object2).trim());
        }
        for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.DESCRIPTIONS.getAttributes()) {
            String string;
            if (OpenEstateAttrib.DESCRIPTIONS_KEYWORDS.equals((Object)openEstateAttrib) || dbAgencyObject.item.isHiddenPrices() && OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION.equals((Object)openEstateAttrib) && dbAgencyObject.item.hasAttribute(OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION) || !dbAgencyObject.item.hasAttribute(openEstateAttrib) || StringUtils.isBlank((CharSequence)(string = dbAgencyObject.writeValueForPublic(openEstateAttrib, this.locale)))) continue;
            String string2 = openEstateAttrib.getTranslation(this.locale);
            this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
            this.buildTableHead2(pdfPTable, n3, ++n4, string2);
            this.buildTableRow(pdfPTable, string, 0, n2);
        }
        return n3 - n;
    }

    private int writeImageArea(PdfPTable pdfPTable, int n, Rectangle rectangle) {
        Object object;
        Image image;
        File file;
        GalleryMode galleryMode = this.getGalleryMode();
        if (GalleryMode.NO_GALLERY.equals((Object)galleryMode)) {
            return 0;
        }
        if (galleryMode == null) {
            galleryMode = GalleryMode.TWO_PER_ROW;
        }
        Integer n2 = this.getResolution();
        boolean bl = this.isGallerySeparatePlans();
        boolean bl2 = this.isGallerySeparatePanoramas();
        int n3 = PdfDetailedExpose.getGalleryColumnCount(galleryMode);
        if (n3 < 1) {
            return 0;
        }
        int n4 = 0;
        ArrayList<DbFile> arrayList = new ArrayList<DbFile>();
        ArrayList<DbFile> arrayList2 = bl ? new ArrayList<DbFile>() : null;
        ArrayList<DbFile> arrayList3 = bl2 ? new ArrayList<DbFile>() : null;
        for (DbFile object22 : this.getEstateFiles()) {
            if (!"image/bmp".equalsIgnoreCase(object22.mimeType) && !"image/jpeg".equalsIgnoreCase(object22.mimeType) && !"image/png".equalsIgnoreCase(object22.mimeType)) continue;
            ++n4;
            if (bl && (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)object22.type) || EstateAttachmentType.IMAGE_MAP.equals((Object)object22.type))) {
                arrayList2.add(object22);
                continue;
            }
            if (bl2 && EstateAttachmentType.IMAGE_PANORAMA.equals((Object)object22.type)) {
                arrayList3.add(object22);
                continue;
            }
            arrayList.add(object22);
        }
        if (n4 < 1) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n5 = n;
        int n6 = 0;
        if (!GalleryMode.ONE_PER_SITE.equals((Object)galleryMode)) {
            this.buildTableHead(pdfPTable, ++n5, StringUtils.capitalize((String)this.i18n.tr("gallery")));
            PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph("", this.bodyFontSmall));
            pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPTable.addCell(pdfPCell);
        }
        PdfPTable pdfPTable2 = null;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        n6 = 0;
        for (DbFile dbFile : arrayList) {
            if (n6 % n3 == 0) {
                if (pdfPTable2 != null) {
                    this.writeImageRow(pdfPTable, pdfPTable2, arrayList4);
                }
                pdfPTable2 = new PdfPTable(n3);
                pdfPTable2.setWidthPercentage(100.0f);
                arrayList4.clear();
            }
            ++n6;
            try {
                Object object2;
                float f;
                file = this.getEstateFileDownload(dbFile);
                if (file == null) continue;
                image = null;
                boolean bl3 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) && n3 == 1;
                Float f2 = PdfDetailedExpose.getGalleryImageWidth(galleryMode, pdfPTable.getTotalWidth());
                if (f2 == null) continue;
                float f3 = f2.floatValue();
                float f4 = f = bl3 ? f3 * 0.4f : f3;
                if (GalleryMode.TWO_PER_SITE.equals((Object)galleryMode)) {
                    f = (rectangle.getHeight() - 110.0f - 90.0f) / 2.0f - 30.0f;
                    if (n6 < 3) {
                        f -= 30.0f;
                    }
                }
                if (n2 != null && n2 >= 72) {
                    object = ImageUtils.readAsRgb((File)file);
                    object2 = ImageUtils.scaleToFit((BufferedImage)object, (int)((int)f3), (int)((int)f), (int)n2);
                    image = Image.getInstance((java.awt.Image)object2, null);
                    ((java.awt.Image)object).flush();
                    ((java.awt.Image)object2).flush();
                } else {
                    object = ImageUtils.readAsRgb((File)file);
                    image = Image.getInstance((java.awt.Image)object, null);
                    ((java.awt.Image)object).flush();
                }
                if (image == null) continue;
                image.setBorderWidth(0.0f);
                if (image.getWidth() > f3 || image.getHeight() > f) {
                    image.scaleToFit(f3, f);
                }
                if (GalleryMode.ONE_PER_SITE.equals((Object)galleryMode)) {
                    object = StringUtils.capitalize((String)EstateAttachmentType.IMAGE.getTranslation(this.locale));
                    object2 = dbFile.getTitle(this.locale);
                    if (object2 != null && ((String)object2).trim().length() > 0) {
                        object = (String)object + " '" + (String)object2 + "'";
                    }
                    if (n6 > 0) {
                        this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    }
                    this.buildTableHead(pdfPTable, ++n5, (String)object);
                    PdfPCell pdfPCell = new PdfPCell((Phrase)new Paragraph("", this.bodyFontSmall));
                    pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
                    pdfPCell.setBorderWidth(0.0f);
                    pdfPCell.setPadding(0.0f);
                    pdfPCell.setPaddingTop(10.0f);
                    pdfPTable.addCell(pdfPCell);
                } else {
                    object = dbFile.getTitle(this.locale);
                    arrayList4.add(object != null ? ((String)object).trim() : null);
                }
                object = new PdfPCell(image, false);
                object.setBorderWidth(0.0f);
                object.setPadding(0.0f);
                object.setBackgroundColor(this.bodyTextBgColor);
                object.setHorizontalAlignment(1);
                pdfPTable2.addCell((PdfPCell)object);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't write image into pdf!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        while (n6 % n3 != 0) {
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPTable2.addCell(pdfPCell);
            arrayList4.add(null);
            ++n6;
        }
        this.writeImageRow(pdfPTable, pdfPTable2, arrayList4);
        if (bl && arrayList2 != null && !arrayList2.isEmpty()) {
            for (DbFile dbFile : arrayList2) {
                try {
                    Object object3;
                    Object object4;
                    float f;
                    file = this.getEstateFileDownload(dbFile);
                    if (file == null) continue;
                    float f5 = pdfPTable.getTotalWidth();
                    float f6 = f = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f5 * 0.45f : f5 * 1.2f;
                    if (n2 != null && n2 >= 72) {
                        object4 = ImageUtils.readAsRgb((File)file);
                        object3 = ImageUtils.scaleToFit((BufferedImage)object4, (int)((int)f5), (int)((int)f), (int)n2);
                        image = Image.getInstance((java.awt.Image)object3, null);
                        ((java.awt.Image)object4).flush();
                        ((java.awt.Image)object3).flush();
                    } else {
                        object4 = ImageUtils.readAsRgb((File)file);
                        image = Image.getInstance((java.awt.Image)object4, null);
                        ((java.awt.Image)object4).flush();
                    }
                    if (image == null) continue;
                    image.setBorderWidth(0.0f);
                    if (image.getWidth() > f5 || image.getHeight() > f) {
                        image.scaleToFit(f5, f);
                    }
                    object4 = !StringUtils.isBlank((CharSequence)(object3 = dbFile.getTitle(this.locale))) ? ((String)object3).trim() : (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)dbFile.type) || EstateAttachmentType.IMAGE_MAP.equals((Object)dbFile.type) ? dbFile.type.getTranslation(this.locale) : StringUtils.capitalize((String)EstateAttachmentType.IMAGE.getTranslation(this.locale)));
                    this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    this.buildTableHead(pdfPTable, ++n5, (String)object4);
                    object = new PdfPCell(image, false);
                    object.setBorderWidth(0.0f);
                    object.setPaddingTop(10.0f);
                    object.setHorizontalAlignment(1);
                    object.setVerticalAlignment(4);
                    object.setColspan(pdfPTable.getNumberOfColumns());
                    object.setBackgroundColor(this.bodyTextBgColor);
                    pdfPTable.addCell((PdfPCell)object);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't write image into pdf!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        if (bl2 && arrayList3 != null && !arrayList3.isEmpty()) {
            for (DbFile dbFile : arrayList3) {
                try {
                    Object object5;
                    Object object6;
                    float f;
                    file = this.getEstateFileDownload(dbFile);
                    if (file == null) continue;
                    float f7 = pdfPTable.getTotalWidth();
                    float f8 = f = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f7 * 0.45f : f7 * 1.2f;
                    if (n2 != null && n2 >= 72) {
                        object6 = ImageUtils.readAsRgb((File)file);
                        if (AbstractExpose.Orientation.PORTRAIT.equals((Object)this.orientation)) {
                            object5 = ImageUtils.rotateToLeft((BufferedImage)object6);
                            ((java.awt.Image)object6).flush();
                            object6 = object5;
                        }
                        object5 = ImageUtils.scaleToFit((BufferedImage)object6, (int)((int)f7), (int)((int)f), (int)n2);
                        ((java.awt.Image)object6).flush();
                        image = Image.getInstance((java.awt.Image)object5, null);
                        ((java.awt.Image)object5).flush();
                    } else {
                        object6 = ImageUtils.readAsRgb((File)file);
                        if (AbstractExpose.Orientation.PORTRAIT.equals((Object)this.orientation)) {
                            object5 = ImageUtils.rotateToLeft((BufferedImage)object6);
                            ((java.awt.Image)object6).flush();
                            object6 = object5;
                        }
                        image = Image.getInstance((java.awt.Image)object6, null);
                        ((java.awt.Image)object6).flush();
                    }
                    if (image == null) continue;
                    image.setBorderWidth(0.0f);
                    if (image.getWidth() > f7 || image.getHeight() > f) {
                        image.scaleToFit(f7, f);
                    }
                    object6 = !StringUtils.isBlank((CharSequence)(object5 = dbFile.getTitle(this.locale))) ? ((String)object5).trim() : (EstateAttachmentType.IMAGE_PANORAMA.equals((Object)dbFile.type) ? dbFile.type.getTranslation(this.locale) : StringUtils.capitalize((String)EstateAttachmentType.IMAGE.getTranslation(this.locale)));
                    this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    this.buildTableHead(pdfPTable, ++n5, (String)object6);
                    object = new PdfPCell(image, false);
                    object.setBorderWidth(0.0f);
                    object.setPaddingTop(10.0f);
                    object.setHorizontalAlignment(1);
                    object.setVerticalAlignment(4);
                    object.setColspan(pdfPTable.getNumberOfColumns());
                    object.setBackgroundColor(this.bodyTextBgColor);
                    pdfPTable.addCell((PdfPCell)object);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't write image into pdf!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return n5 - n;
    }

    private void writeImageRow(PdfPTable pdfPTable, PdfPTable pdfPTable2, List<String> list) {
        for (String string : list) {
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingBottom(10.0f);
            if (!StringUtils.isBlank((CharSequence)string)) {
                Paragraph paragraph = new Paragraph(string.trim(), this.bodyFontSmall);
                paragraph.setAlignment(1);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable2.addCell(pdfPCell);
        }
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.addElement((Element)pdfPTable2);
        pdfPTable.addCell(pdfPCell);
    }

    private int writeLinksArea(PdfPTable pdfPTable, int n, int n2) {
        Object[] objectArray = this.getEstateLinks();
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n3 = n;
        int n4 = 0;
        if (n3 > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        this.buildTableHead(pdfPTable, ++n3, StringUtils.capitalize((String)this.i18n.tr("web links")));
        for (Object object : objectArray) {
            URI uRI = object.getUrl();
            if (uRI == null || StringUtils.isBlank((CharSequence)uRI.getHost())) continue;
            String string = StringUtils.trimToNull((String)object.getTitle(this.locale.getLanguage()));
            if (string == null && ((DbLink)object).provider != null && ((DbLink)object).provider.isVideo()) {
                string = StringUtils.capitalize((String)this.i18n.tr("video"));
            } else if (string == null) {
                string = StringUtils.capitalize((String)this.i18n.tr("web link"));
            }
            String string2 = StringUtils.substringAfter((String)uRI.toString(), (String)(uRI.getScheme() + "://"));
            this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
            this.buildTableHead2(pdfPTable, n3, ++n4, string);
            this.buildTableRow(pdfPTable, string2, 0, n2);
        }
        return n3 - n;
    }

    private int writeTermsArea(PdfPTable pdfPTable, int n, int n2) {
        ImmoToolAgent immoToolAgent = this.getAgent();
        if (immoToolAgent == null) {
            return 0;
        }
        String string = immoToolAgent.getTerms(this.locale.getLanguage());
        if (string == null || string.trim().length() == 0) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n3 = n;
        int n4 = this.getTermsTextSize();
        if (n3 > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        this.buildTableHead(pdfPTable, ++n3, StringUtils.capitalize((String)this.i18n.tr("terms & conditions")));
        if (n4 < 1) {
            this.buildTableRow(pdfPTable, string.trim(), 0, n2);
        } else {
            this.buildTableRow(pdfPTable, string.trim(), (float)n4, n2);
        }
        return n3 - n;
    }

    public static enum GalleryMode implements Translatable
    {
        ONE_PER_ROW(I18n.marktr((String)"Show images among themselves.")),
        TWO_PER_ROW(I18n.marktr((String)"Show two images next to each other.")),
        THREE_PER_ROW(I18n.marktr((String)"Show three images next to each other.")),
        FOUR_PER_ROW(I18n.marktr((String)"Show four images next to each other.")),
        ONE_PER_SITE(I18n.marktr((String)"Show one image per page.")),
        TWO_PER_SITE(I18n.marktr((String)"Show two images per page.")),
        NO_GALLERY(I18n.marktr((String)"Don't show any images."));

        private final String i18nKey;

        private GalleryMode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum Area implements Translatable
    {
        GENERAL(I18n.marktr((String)"general information")),
        IMAGES(I18n.marktr((String)"gallery")),
        LINKS(I18n.marktr((String)"web links")),
        AGENCY(I18n.marktr((String)"agent & contact person")),
        TERMS(I18n.marktr((String)"terms & conditions"));

        private final String i18nKey;

        private Area(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(PdfDetailedExpose.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

