/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.descriptions.Keywords;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.expose.AbstractPdfExpose;
import com.openindex.openestate.tool.agency.expose.PdfShortExpose;
import com.openindex.openestate.tool.agency.expose.PdfVitrineExposePanel;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.utils.ImageUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class PdfVitrineExpose
extends AbstractPdfExpose {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfVitrineExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(PdfVitrineExpose.class);
    public static final String NAME = "vitrinePdf";
    private static final String LOCALE_SECONDARY = "locale.secondary";
    private static final String BIGIMAGE_TYPE = "vitrinePdf.bigImage.type";
    private static final String SMALLIMAGE1_TYPE = "vitrinePdf.smallImage1.type";
    private static final String SMALLIMAGE2_TYPE = "vitrinePdf.smallImage2.type";
    protected static final float MARGIN_TOP = 15.0f;
    protected static final float MARGIN_BOTTOM = 15.0f;
    protected static final float MARGIN_LEFT = 15.0f;
    protected static final float MARGIN_RIGHT = 15.0f;
    private static final float LANDSCAPE_TITLE_HEIGHT = 75.0f;
    private static final float LANDSCAPE_TITLE_IMAGE_WIDTH = 150.0f;
    private static final float LANDSCAPE_BIGIMAGE_HEIGHT = 280.0f;
    private static final float LANDSCAPE_BIGIMAGE_WIDTH = 300.0f;
    private static final float LANDSCAPE_PRICE_HEIGHT = 30.0f;
    private static final float LANDSCAPE_COMMISSION_HEIGHT = 25.0f;
    private static final float PORTRAIT_TITLE_HEIGHT = 75.0f;
    private static final float PORTRAIT_TITLE_IMAGE_WIDTH = 100.0f;
    private static final float PORTRAIT_BIGIMAGE_HEIGHT = 280.0f;
    private static final float PORTRAIT_BIGIMAGE_WIDTH = 385.0f;
    private static final float PORTRAIT_PRICE_HEIGHT = 30.0f;
    private static final float PORTRAIT_COMMISSION_HEIGHT = 25.0f;
    private transient I18n primaryI18n = null;
    private transient I18n secondaryI18n = null;
    protected Locale secondaryLocale = null;

    public PdfVitrineExpose() {
        this.setHeader(false);
        this.setFooter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void build(OutputStream outputStream) throws IOException, DocumentException {
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        Boolean bl = dbAgencyObject.item.getAddress().isPublished();
        PublishingMode publishingMode = this.getPublishAddress();
        if (PublishingMode.ALWAYS.equals((Object)publishingMode)) {
            dbAgencyObject.item.getAddress().setPublished(true);
        } else if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            dbAgencyObject.item.getAddress().setPublished(false);
        }
        try {
            if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
                this.build(PageSize.A4.rotate(), outputStream);
            } else {
                this.build(PageSize.A4, outputStream);
            }
        }
        finally {
            dbAgencyObject.item.getAddress().setPublished(Boolean.TRUE.equals(bl));
        }
    }

    private void build(Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        this.build(null, rectangle, outputStream);
    }

    private void build(PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws IOException, DocumentException {
        ImmoToolAgent immoToolAgent = this.getAgent();
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        String string = StringUtils.trimToEmpty((String)dbAgencyObject.item.getTitle(this.locale.getLanguage()));
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        Document document = new Document(new Rectangle(f, f2));
        PdfPTable pdfPTable = this.createTable(rectangle);
        if (pdfPTable.getNumberOfColumns() == 2) {
            pdfPTable.setWidths(new float[]{pdfPTable.getTotalWidth() * 0.65f, pdfPTable.getTotalWidth() * 0.35f});
        }
        this.buildDocument(document, pdfPTable, pdfReader, rectangle, outputStream);
        document.addAuthor(immoToolAgent != null && immoToolAgent.getCompany() != null ? StringUtils.trimToEmpty((String)immoToolAgent.getCompany().getCompanyName()) : "");
        document.addCreationDate();
        document.addCreator(ImmoToolEnvironment.getApplicationTitle() + " v" + ImmoToolEnvironment.getApplicationVersion());
        document.addProducer();
        document.addSubject(StringUtils.capitalize((String)this.primaryI18n.tr("property")) + " #" + dbAgencyObject.id);
        document.addTitle(string);
        String string2 = Keywords.get((EstateImpl)dbAgencyObject.item, (Locale)this.locale);
        if (!StringUtils.isBlank((CharSequence)string2)) {
            document.addKeywords(string2.trim());
        }
        document.close();
    }

    @Override
    protected void buildTemplate(PdfTemplate pdfTemplate, float f, float f2, int n, int n2, int n3) throws DocumentException {
    }

    @Override
    public AbstractExposePanel createForm() {
        return new PdfVitrineExposePanel();
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="Use of different constants for portrait and landscape is intended.")
    protected PdfPTable createTable(Rectangle rectangle) throws DocumentException {
        float f = rectangle.getWidth();
        float f2 = rectangle.getHeight();
        float f3 = f - 15.0f - 15.0f;
        float f4 = f2 - 15.0f - 15.0f;
        float f5 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 10.0f : 0.0f;
        float f6 = f3 - 20.0f - f5;
        float f7 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f6 - 300.0f : f6;
        PdfPTable pdfPTable = this.writeTitleTable(f3);
        float f8 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 75.0f : 75.0f;
        PdfPTable pdfPTable2 = this.writeInfoTable(f7);
        float f9 = pdfPTable2.calculateHeights(true) + 5.0f;
        PdfPTable pdfPTable3 = this.writePriceTable(f3 - 20.0f);
        float f10 = pdfPTable3.calculateHeights(true);
        PdfPTable pdfPTable4 = this.writeImageTable(AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 300.0f : f7);
        float f11 = pdfPTable4.calculateHeights(true) + 10.0f;
        float f12 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f4 - f8 - f9 - f10 - 20.0f - 1.0f : f4 - f8 - f9 - f10 - f11 - 20.0f - 1.0f;
        PdfPTable pdfPTable5 = this.writeTextTable(f7, f12);
        PdfPTable pdfPTable6 = new PdfPTable(1);
        pdfPTable6.setTotalWidth(f3);
        PdfPCell pdfPCell = new PdfPCell(pdfPTable);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPTable6.addCell(pdfPCell);
        if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
            PdfPTable pdfPTable7 = new PdfPTable(2);
            pdfPTable7.setTotalWidth(new float[]{f7 + 20.0f + f5, 300.0f});
            pdfPCell = new PdfPCell(pdfPTable2);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(5.0f);
            pdfPCell.setPaddingLeft(20.0f);
            pdfPCell.setPaddingRight(f5);
            pdfPTable7.addCell(pdfPCell);
            pdfPCell = new PdfPCell(pdfPTable4);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPCell.setRowspan(2);
            pdfPCell.setVerticalAlignment(5);
            pdfPTable7.addCell(pdfPCell);
            pdfPCell = new PdfPCell(pdfPTable5);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPCell.setPaddingBottom(10.0f);
            pdfPCell.setPaddingLeft(20.0f);
            pdfPCell.setPaddingRight(f5);
            pdfPTable7.addCell(pdfPCell);
            pdfPCell = new PdfPCell(pdfPTable7);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPTable6.addCell(pdfPCell);
        } else {
            pdfPCell = new PdfPCell(pdfPTable2);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(5.0f);
            pdfPCell.setPaddingLeft(20.0f);
            pdfPCell.setPaddingRight(f5);
            pdfPTable6.addCell(pdfPCell);
            pdfPCell = new PdfPCell(pdfPTable4);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPCell.setPaddingLeft(20.0f);
            pdfPCell.setPaddingRight(f5);
            if (pdfPTable4.getTotalWidth() < f6) {
                float f13 = (f6 - pdfPTable4.getTotalWidth()) / 2.0f;
                pdfPCell.setPaddingLeft(pdfPCell.getPaddingLeft() + f13);
                pdfPCell.setPaddingRight(pdfPCell.getPaddingRight() + f13);
            }
            pdfPTable6.addCell(pdfPCell);
            pdfPCell = new PdfPCell(pdfPTable5);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPCell.setPaddingBottom(10.0f);
            pdfPCell.setPaddingLeft(20.0f);
            pdfPCell.setPaddingRight(f5);
            pdfPTable6.addCell(pdfPCell);
        }
        pdfPCell = new PdfPCell(pdfPTable3);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingLeft(20.0f);
        pdfPTable6.addCell(pdfPCell);
        return pdfPTable6;
    }

    public EstateAttachmentType getBigImageType() {
        String string = (String)this.get(BIGIMAGE_TYPE);
        try {
            return !StringUtils.isBlank((CharSequence)string) ? EstateAttachmentType.valueOf((String)string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Unknown image type '" + string + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    private Image getImage(DbFile dbFile, float f, float f2, int n, boolean bl) {
        try {
            File file = this.getEstateFileDownload(dbFile);
            BufferedImage bufferedImage = file != null ? ImageUtils.readAsRgb((File)file) : null;
            return bufferedImage != null ? this.getImage(bufferedImage, f, f2, n, bl) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load image!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    private Image getImage(BufferedImage bufferedImage, float f, float f2, int n, boolean bl) {
        if (bufferedImage == null) {
            return null;
        }
        try {
            Image image;
            if (bl) {
                float f3;
                if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                    f3 = f / f2;
                    float f4 = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
                    if (f4 > f3) {
                        BufferedImage bufferedImage2 = ImageUtils.cropToRatio((BufferedImage)bufferedImage, (int)((int)f), (int)((int)f2));
                        bufferedImage.flush();
                        bufferedImage = bufferedImage2;
                    }
                } else if (bufferedImage.getWidth() < bufferedImage.getHeight()) {
                    f3 = f / f2;
                    float f5 = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
                    if (f5 < f3) {
                        BufferedImage bufferedImage3 = ImageUtils.cropToRatio((BufferedImage)bufferedImage, (int)((int)f), (int)((int)f2));
                        bufferedImage.flush();
                        bufferedImage = bufferedImage3;
                    }
                }
            }
            if (n >= 72) {
                BufferedImage bufferedImage4 = ImageUtils.scaleToFit((BufferedImage)bufferedImage, (int)((int)f), (int)((int)f2), (int)n);
                image = Image.getInstance((java.awt.Image)bufferedImage4, null);
                bufferedImage.flush();
                bufferedImage4.flush();
            } else {
                image = Image.getInstance((java.awt.Image)bufferedImage, null);
                bufferedImage.flush();
            }
            if (image == null) {
                return null;
            }
            image.setBorderWidth(0.0f);
            image.setBackgroundColor(this.bodyTextBgColor);
            if (image.getWidth() > f || image.getHeight() > f2) {
                image.scaleToFit(f, f2);
            }
            return image;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load image!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected AbstractAttribImpl getInfo1stValue(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if (!(list.contains(OpenEstateType.GENERAL_AGRICULTURE) || list.contains(OpenEstateType.GENERAL_PARKING) || list.contains(OpenEstateType.GENERAL_COMMERCIAL) || list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND))) {
            if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                arrayList.add(OpenEstateAttrib.MEASURES_COUNT_ROOMS);
            } else {
                LOGGER.warn("Unsupported estate types: '" + StringUtils.join(list, (String)"', '") + "'!");
            }
        }
        for (OpenEstateAttrib openEstateAttrib : arrayList) {
            AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
            if (abstractAttribImpl == null) continue;
            return abstractAttribImpl;
        }
        return null;
    }

    protected AbstractAttribImpl getInfo2ndValue(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        String string = dbAgencyObject.item.getAddress() != null ? StringUtils.trimToEmpty((String)dbAgencyObject.item.getAddress().getCountry()).toLowerCase() : null;
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if ("it".equals(string)) {
            arrayList.add(OpenEstateAttrib.MEASURES_GROSS_AREA);
        }
        if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
        } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            arrayList.add(OpenEstateAttrib.MEASURES_CAR_PARKING_AREA);
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
        } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            arrayList.add(OpenEstateAttrib.MEASURES_COMMERCIAL_AREA);
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            arrayList.add(OpenEstateAttrib.MEASURES_PLOT_AREA);
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
        } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            arrayList.add(OpenEstateAttrib.MEASURES_RESIDENTIAL_AREA);
            arrayList.add(OpenEstateAttrib.MEASURES_TOTAL_AREA);
        } else {
            LOGGER.warn("Unsupported estate types: '" + StringUtils.join(list, (String)"', '") + "'!");
        }
        for (OpenEstateAttrib openEstateAttrib : arrayList) {
            AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
            if (abstractAttribImpl == null) continue;
            return abstractAttribImpl;
        }
        return null;
    }

    protected String[][] getInfoBooleanStrings(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        EnumMap<OpenEstateAttrib, Enum[]> enumMap = new EnumMap<OpenEstateAttrib, Enum[]>(OpenEstateAttrib.class);
        if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_DEMOLITION_REQUIRED);
        } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            arrayList.add(OpenEstateAttrib.FEATURES_LIT_UP);
            arrayList.add(OpenEstateAttrib.FEATURES_APPLICABILITY);
            enumMap.put(OpenEstateAttrib.FEATURES_APPLICABILITY, new Enum[]{Applicability.Option.WHEELCHAIR});
            arrayList.add(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY);
            enumMap.put(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY, new Enum[]{SecurityTechnology.Option.ALARM_SYSTEM, SecurityTechnology.Option.CAMERA});
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_RENTED);
        } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            arrayList.add(OpenEstateAttrib.FEATURES_AIR_CONDITIONED);
            arrayList.add(OpenEstateAttrib.FEATURES_LIFT);
            arrayList.add(OpenEstateAttrib.FEATURES_LIFTING_PLATFORM);
            arrayList.add(OpenEstateAttrib.FEATURES_BARRIER_FREE);
            arrayList.add(OpenEstateAttrib.FEATURES_BASEMENT);
            arrayList.add(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY);
            enumMap.put(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY, new Enum[]{SecurityTechnology.Option.ALARM_SYSTEM, SecurityTechnology.Option.CAMERA});
            arrayList.add(OpenEstateAttrib.FEATURES_COMMERCIAL_ROOMS);
            arrayList.add(OpenEstateAttrib.CONDITION_CONDITION_TYPE);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_BUILDING_PERMISSION_AVAILABLE);
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_BUILDABLE_IN_SHORT_TERM);
            arrayList.add(OpenEstateAttrib.CONDITION_DEVELOPMENT);
            arrayList.add(OpenEstateAttrib.FEATURES_BARRIER_FREE);
            arrayList.add(OpenEstateAttrib.FEATURES_STOCK_OF_TREES);
            arrayList.add(OpenEstateAttrib.FEATURES_PERMISSION_TO_CUT_DOWN_TREES);
            arrayList.add(OpenEstateAttrib.FEATURES_WELL);
        } else if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            arrayList.add(OpenEstateAttrib.FEATURES_TYPE_OF_HEATING);
            arrayList.add(OpenEstateAttrib.MEASURES_CAR_PARKING_TYPE);
            arrayList.add(OpenEstateAttrib.CONDITION_CONDITION_TYPE);
            arrayList.add(OpenEstateAttrib.FEATURES_AIR_CONDITIONED);
            arrayList.add(OpenEstateAttrib.FEATURES_SWIMMING_POOL);
            arrayList.add(OpenEstateAttrib.FEATURES_SAUNA);
            arrayList.add(OpenEstateAttrib.FEATURES_LIFT);
            arrayList.add(OpenEstateAttrib.FEATURES_GARDEN_USE);
            arrayList.add(OpenEstateAttrib.FEATURES_BALCONY_TERRACE);
            arrayList.add(OpenEstateAttrib.FEATURES_BASEMENT);
            arrayList.add(OpenEstateAttrib.FEATURES_CONSERVATORY);
            arrayList.add(OpenEstateAttrib.FEATURES_WELL);
            arrayList.add(OpenEstateAttrib.FEATURES_BARRIER_FREE);
            arrayList.add(OpenEstateAttrib.FEATURES_SHUTTERS_INTERIOR);
            arrayList.add(OpenEstateAttrib.FEATURES_KITCHEN);
            enumMap.put(OpenEstateAttrib.FEATURES_KITCHEN, new Enum[]{Kitchen.Option.FITTED_KITCHEN});
            arrayList.add(OpenEstateAttrib.FEATURES_BATHROOM);
            enumMap.put(OpenEstateAttrib.FEATURES_BATHROOM, new Enum[]{Bathroom.Option.BATHTUB});
            arrayList.add(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY);
            enumMap.put(OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY, new Enum[]{SecurityTechnology.Option.ALARM_SYSTEM, SecurityTechnology.Option.CAMERA});
            arrayList.add(OpenEstateAttrib.SURROUNDINGS_VIEW);
            arrayList.add(OpenEstateAttrib.FEATURES_BUILDING_STYLE);
            arrayList.add(OpenEstateAttrib.FEATURES_RESIDENTIAL_ROOMS);
        } else {
            LOGGER.warn("Unsupported estate types: '" + StringUtils.join(list, (String)"', '") + "'!");
        }
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        block0: for (OpenEstateAttrib openEstateAttrib : arrayList) {
            Object[] objectArray;
            Object[] objectArray2;
            Boolean bl;
            AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
            if (abstractAttribImpl == null || abstractAttribImpl.hasEmptyValue()) continue;
            if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                bl = ((SimpleBooleanAttrib)abstractAttribImpl).getValue();
                if (!Boolean.TRUE.equals(bl)) continue;
                objectArray2 = new String[this.secondaryLocale != null ? 2 : 1];
                objectArray2[0] = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib.getTranslation(this.locale), (CharSequence)openEstateAttrib.name());
                if (this.secondaryLocale != null) {
                    objectArray2[1] = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib.getTranslation(this.secondaryLocale), (CharSequence)openEstateAttrib.name());
                }
                arrayList2.add(objectArray2);
                continue;
            }
            if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                bl = (SimpleEnumAttrib)abstractAttribImpl;
                objectArray2 = bl.getValue();
                Object[] objectArray3 = objectArray = enumMap.containsKey(openEstateAttrib) ? (Enum[])enumMap.get(openEstateAttrib) : bl.getOptions();
                if (objectArray2 == null || !ArrayUtils.contains((Object[])objectArray, (Object)objectArray2)) continue;
                Object[] objectArray4 = new String[this.secondaryLocale != null ? 2 : 1];
                objectArray4[0] = (String)StringUtils.defaultIfBlank((CharSequence)bl.getOptionTranslation((Enum)objectArray2, this.locale), (CharSequence)objectArray2.name());
                if (this.secondaryLocale != null) {
                    objectArray4[1] = (String)StringUtils.defaultIfBlank((CharSequence)bl.getOptionTranslation((Enum)objectArray2, this.secondaryLocale), (CharSequence)objectArray2.name());
                }
                arrayList2.add(objectArray4);
                continue;
            }
            if (!(abstractAttribImpl instanceof ComplexEnumAttrib)) continue;
            bl = (ComplexEnumAttrib)abstractAttribImpl;
            objectArray2 = bl.getValue();
            Object[] objectArray5 = objectArray = enumMap.containsKey(openEstateAttrib) ? (Enum[])enumMap.get(openEstateAttrib) : bl.getOptions();
            if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
            for (Object object : objectArray2) {
                if (!ArrayUtils.contains((Object[])objectArray, (Object)object)) continue;
                String[] stringArray = new String[this.secondaryLocale != null ? 2 : 1];
                stringArray[0] = (String)StringUtils.defaultIfBlank((CharSequence)bl.getOptionTranslation((Enum)object, this.locale), (CharSequence)((Enum)object).name());
                if (this.secondaryLocale != null) {
                    stringArray[1] = (String)StringUtils.defaultIfBlank((CharSequence)bl.getOptionTranslation((Enum)object, this.secondaryLocale), (CharSequence)((Enum)object).name());
                }
                arrayList2.add(stringArray);
                continue block0;
            }
        }
        return !arrayList2.isEmpty() ? (String[][])arrayList2.toArray((T[])new String[0][]) : new String[][]{};
    }

    @Override
    protected float getMarginBottom(int n) {
        return 15.0f;
    }

    @Override
    protected float getMarginLeft(int n) {
        return 15.0f;
    }

    @Override
    protected float getMarginRight(int n) {
        return 15.0f;
    }

    @Override
    protected float getMarginTop(int n) {
        return 15.0f;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected AbstractAttribImpl getPrice1stValue(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        OpenEstateAction openEstateAction = dbAgencyObject.item.getAction();
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_PURCHASE_PRICE);
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES);
            arrayList.add(OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES);
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_RENT_FLAT_RATE);
            arrayList.add(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES);
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction) || OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_LEASE);
        } else if (OpenEstateAction.AUCTION.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_MARKET_VALUE);
        } else {
            LOGGER.warn("Unsupported estate action: '" + openEstateAction + "'!");
        }
        for (OpenEstateAttrib openEstateAttrib : arrayList) {
            AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
            if (abstractAttribImpl == null) continue;
            return abstractAttribImpl;
        }
        return null;
    }

    protected AbstractAttribImpl getPrice2ndValue(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        OpenEstateAction openEstateAction = dbAgencyObject.item.getAction();
        ArrayList<OpenEstateAttrib> arrayList = new ArrayList<OpenEstateAttrib>();
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_PURCHASE_PRICE_PER_AREA);
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_SERVICE_CHARGES);
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_SERVICE_CHARGES);
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction) || OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.PRICES_LEASE_PER_AREA);
        } else if (OpenEstateAction.AUCTION.equals((Object)openEstateAction)) {
            arrayList.add(OpenEstateAttrib.ADMINISTRATION_AUCTION_DATE);
        } else {
            LOGGER.warn("Unsupported estate action: '" + openEstateAction + "'!");
        }
        for (OpenEstateAttrib openEstateAttrib : arrayList) {
            AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(openEstateAttrib);
            if (abstractAttribImpl == null) continue;
            return abstractAttribImpl;
        }
        return null;
    }

    protected AbstractAttribImpl getPriceCommissionValue(DbAgencyObject dbAgencyObject, List<OpenEstateType> list) {
        return dbAgencyObject.item.getAttribute(OpenEstateAttrib.PRICES_AGENT_FEE);
    }

    public Locale getSecondaryLocale() {
        String string = (String)this.get(LOCALE_SECONDARY);
        return !StringUtils.isBlank((CharSequence)string) ? OpenEstateUtils.buildLocale((String)string) : null;
    }

    public EstateAttachmentType getSmallImage1Type() {
        String string = (String)this.get(SMALLIMAGE1_TYPE);
        try {
            return !StringUtils.isBlank((CharSequence)string) ? EstateAttachmentType.valueOf((String)string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Unknown image type '" + string + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public EstateAttachmentType getSmallImage2Type() {
        String string = (String)this.get(SMALLIMAGE2_TYPE);
        try {
            return !StringUtils.isBlank((CharSequence)string) ? EstateAttachmentType.valueOf((String)string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Unknown image type '" + string + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected AbstractAttribImpl getTextValue(DbAgencyObject dbAgencyObject) {
        AbstractAttribImpl abstractAttribImpl = dbAgencyObject.item.getAttribute(OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION);
        if (abstractAttribImpl == null) {
            abstractAttribImpl = dbAgencyObject.item.getAttribute(OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION);
        }
        return abstractAttribImpl;
    }

    @Override
    public String getTitle() {
        return StringUtils.capitalize((String)I18nFactory.getI18n(PdfShortExpose.class).tr("vitrine expos\u00e9"));
    }

    @Override
    protected void init(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        super.init(immoToolProject, connection);
        this.secondaryLocale = this.getSecondaryLocale();
        if (this.locale == null && this.secondaryLocale != null) {
            this.locale = this.secondaryLocale;
            this.secondaryLocale = null;
        } else if (this.locale != null && this.secondaryLocale != null && this.locale.getLanguage().equals(this.secondaryLocale.getLanguage())) {
            this.secondaryLocale = null;
        }
        this.primaryI18n = I18nFactory.getI18n(PdfVitrineExpose.class, (Locale)this.locale);
        this.secondaryI18n = this.secondaryLocale != null ? I18nFactory.getI18n(PdfVitrineExpose.class, (Locale)this.secondaryLocale) : null;
    }

    public void setBigImageType(EstateAttachmentType estateAttachmentType) {
        if (estateAttachmentType == null) {
            this.remove(BIGIMAGE_TYPE);
        } else {
            this.put(BIGIMAGE_TYPE, estateAttachmentType.name());
        }
    }

    public void setSecondaryLocale(Locale locale) {
        if (locale == null) {
            this.remove(LOCALE_SECONDARY);
        } else {
            this.put(LOCALE_SECONDARY, locale.toString());
        }
    }

    public void setSmallImage1Type(EstateAttachmentType estateAttachmentType) {
        if (estateAttachmentType == null) {
            this.remove(SMALLIMAGE1_TYPE);
        } else {
            this.put(SMALLIMAGE1_TYPE, estateAttachmentType.name());
        }
    }

    public void setSmallImage2Type(EstateAttachmentType estateAttachmentType) {
        if (estateAttachmentType == null) {
            this.remove(SMALLIMAGE2_TYPE);
        } else {
            this.put(SMALLIMAGE2_TYPE, estateAttachmentType.name());
        }
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="Use of different constants for portrait and landscape is intended.")
    protected PdfPTable writeImageTable(float f) throws DocumentException {
        int n = this.getResolution();
        EstateAttachmentType estateAttachmentType = this.getBigImageType();
        EstateAttachmentType estateAttachmentType2 = this.getSmallImage1Type();
        EstateAttachmentType estateAttachmentType3 = this.getSmallImage2Type();
        float f2 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 280.0f : 280.0f;
        float f3 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 300.0f : 385.0f;
        float f4 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f2 / 2.0f - 4.0f : f2 / 2.0f - 2.0f;
        float f5 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? f / 2.0f - 2.0f : f - f3 - 4.0f;
        ArrayList<DbFile> arrayList = new ArrayList<DbFile>();
        DbFile dbFile = null;
        DbFile dbFile2 = null;
        DbFile dbFile3 = null;
        for (DbFile dbFile4 : this.getEstateFiles()) {
            if (!dbFile4.published || !dbFile4.mimeType.toLowerCase().startsWith("image/")) continue;
            if (dbFile == null && estateAttachmentType != null && estateAttachmentType.equals((Object)dbFile4.type)) {
                dbFile = dbFile4;
            } else if (dbFile2 == null && estateAttachmentType2 != null && estateAttachmentType2.equals((Object)dbFile4.type)) {
                dbFile2 = dbFile4;
            } else if (dbFile3 == null && estateAttachmentType3 != null && estateAttachmentType3.equals((Object)dbFile4.type)) {
                dbFile3 = dbFile4;
            } else if (!EstateAttachmentType.IMAGE_MAP.equals((Object)dbFile4.type) && !EstateAttachmentType.IMAGE_PANORAMA.equals((Object)dbFile4.type)) {
                arrayList.add(dbFile4);
            }
            if (arrayList.size() >= 3 && dbFile != null && dbFile2 != null && dbFile3 != null) break;
        }
        int n2 = 0;
        if (dbFile == null) {
            DbFile dbFile5 = dbFile = arrayList.size() > n2 ? (DbFile)arrayList.get(n2++) : null;
        }
        if (dbFile2 == null) {
            DbFile dbFile6 = dbFile2 = arrayList.size() > n2 ? (DbFile)arrayList.get(n2++) : null;
        }
        if (dbFile3 == null) {
            dbFile3 = arrayList.size() > n2 ? (DbFile)arrayList.get(n2++) : null;
        }
        Image image = dbFile != null ? this.getImage(dbFile, f3, f2, n, false) : null;
        PdfPCell pdfPCell = image != null ? new PdfPCell(image, false) : new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        boolean bl = dbFile2 != null && !EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)dbFile2.type) && !EstateAttachmentType.IMAGE_MAP.equals((Object)dbFile2.type);
        Image image2 = dbFile2 != null ? this.getImage(dbFile2, f5, f4, n, bl) : null;
        PdfPCell pdfPCell2 = image2 != null ? new PdfPCell(image2, false) : new PdfPCell();
        pdfPCell2.setBorderWidth(0.0f);
        pdfPCell2.setPadding(0.0f);
        boolean bl2 = dbFile3 != null && !EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)dbFile3.type) && !EstateAttachmentType.IMAGE_MAP.equals((Object)dbFile3.type);
        Image image3 = dbFile3 != null ? this.getImage(dbFile3, f5, f4, n, bl2) : null;
        PdfPCell pdfPCell3 = image3 != null ? new PdfPCell(image3, false) : new PdfPCell();
        pdfPCell3.setBorderWidth(0.0f);
        pdfPCell3.setPadding(0.0f);
        PdfPTable pdfPTable = new PdfPTable(2);
        if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
            pdfPTable.setTotalWidth(new float[]{f5 + 2.0f, f5 + 2.0f});
            pdfPCell2.setHorizontalAlignment(2);
            pdfPCell2.setVerticalAlignment(4);
            pdfPCell2.setPaddingBottom(4.0f);
            pdfPCell2.setPaddingRight(2.0f);
            pdfPTable.addCell(pdfPCell2);
            pdfPCell3.setHorizontalAlignment(0);
            pdfPCell3.setVerticalAlignment(4);
            pdfPCell3.setPaddingBottom(4.0f);
            pdfPCell3.setPaddingLeft(2.0f);
            pdfPTable.addCell(pdfPCell3);
            pdfPCell.setColspan(2);
            pdfPCell.setHorizontalAlignment(1);
            pdfPCell.setVerticalAlignment(4);
            pdfPTable.addCell(pdfPCell);
        } else {
            float f6 = image != null ? image.getScaledWidth() : f3;
            pdfPTable.setTotalWidth(new float[]{f5 + 4.0f, f6});
            pdfPCell2.setHorizontalAlignment(2);
            pdfPCell2.setVerticalAlignment(4);
            pdfPCell2.setPaddingBottom(2.0f);
            pdfPCell2.setPaddingRight(4.0f);
            pdfPTable.addCell(pdfPCell2);
            pdfPCell.setRowspan(2);
            pdfPCell.setHorizontalAlignment(0);
            pdfPCell.setVerticalAlignment(5);
            pdfPTable.addCell(pdfPCell);
            pdfPCell3.setHorizontalAlignment(2);
            pdfPCell3.setVerticalAlignment(6);
            pdfPCell3.setPaddingTop(2.0f);
            pdfPCell3.setPaddingRight(4.0f);
            pdfPTable.addCell(pdfPCell3);
        }
        return pdfPTable;
    }

    protected PdfPTable writeInfoTable(float f) throws DocumentException {
        PdfPTable pdfPTable;
        int n;
        Object object;
        String[] stringArray;
        String string22;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        List<OpenEstateType> list = Arrays.asList(dbAgencyObject.item.getType().getParentPath());
        Font font = new Font(this.bodyFontH1);
        font.setSize(font.getSize() * 1.2f);
        String[] stringArray2 = new String[]{dbAgencyObject.item.getAddress().getDistrict(), dbAgencyObject.item.getAddress().getCity(), dbAgencyObject.item.getAddress().getRegion()};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string22 : stringArray2) {
            if (!StringUtils.isEmpty((CharSequence)string22) && !arrayList.contains(string22)) {
                arrayList.add(string22);
            }
            if (arrayList.size() >= 2) break;
        }
        String[] stringArray3 = new String[this.secondaryLocale != null ? 2 : 1];
        stringArray3[0] = StringUtils.capitalize((String)this.primaryI18n.tr("address"));
        stringArray3[0] = stringArray3[0] + ":";
        if (this.secondaryLocale != null) {
            stringArray3[1] = StringUtils.capitalize((String)this.secondaryI18n.tr("address"));
            stringArray3[1] = stringArray3[1] + ":";
        }
        PdfPTable pdfPTable2 = this.writeKeyValueTable(stringArray3, StringUtils.join(arrayList, (String)" / "), null, null, Float.valueOf(f), null);
        ArrayList<PdfPTable> arrayList2 = new ArrayList<PdfPTable>();
        string22 = this.getInfo1stValue(dbAgencyObject, list);
        if (string22 != null) {
            stringArray = new String[this.secondaryLocale != null ? 2 : 1];
            stringArray[0] = (String)StringUtils.defaultIfBlank((CharSequence)string22.getAttrib().getTranslation(this.locale), (CharSequence)string22.getAttrib().name());
            stringArray[0] = stringArray[0] + ":";
            if (this.secondaryLocale != null) {
                stringArray[1] = (String)StringUtils.defaultIfBlank((CharSequence)string22.getAttrib().getTranslation(this.secondaryLocale), (CharSequence)string22.getAttrib().name());
                stringArray[1] = stringArray[1] + ":";
            }
            object = dbAgencyObject.writeValueForPublic((AbstractAttribImpl)string22, this.locale);
            arrayList2.add(this.writeKeyValueTable(stringArray, (String)object, null, null, null, null));
        }
        if ((stringArray = this.getInfo2ndValue(dbAgencyObject, list)) != null) {
            object = new String[this.secondaryLocale != null ? 2 : 1];
            object[0] = (String)StringUtils.defaultIfBlank((CharSequence)stringArray.getAttrib().getTranslation(this.locale), (CharSequence)stringArray.getAttrib().name());
            object[0] = (String)object[0] + ":";
            if (this.secondaryLocale != null) {
                object[1] = (String)StringUtils.defaultIfBlank((CharSequence)stringArray.getAttrib().getTranslation(this.secondaryLocale), (CharSequence)stringArray.getAttrib().name());
                object[1] = (String)object[1] + ":";
            }
            String object2 = dbAgencyObject.writeValueForPublic((AbstractAttribImpl)stringArray, this.locale);
            arrayList2.add(this.writeKeyValueTable((String[])object, object2, null, null, null, null));
        }
        if (!ArrayUtils.isEmpty((Object[])(object = this.getInfoBooleanStrings(dbAgencyObject, list)))) {
            for (String[] f9 : object) {
                n = 0;
                while (n < f9.length) {
                    int n2 = n++;
                    f9[n2] = f9[n2] + ":";
                }
                arrayList2.add(this.writeKeyValueTable(f9, "\u2611", null, font, null, null));
                if (arrayList2.size() == 4) break;
            }
        }
        float f2 = 0.0f;
        for (PdfPTable pdfPCell : arrayList2) {
            f2 += pdfPCell.getTotalWidth();
        }
        if (AbstractExpose.Orientation.PORTRAIT.equals((Object)this.orientation)) {
            PdfPTable arrayList3;
            for (int i = arrayList2.size(); i > 0 && f2 > f; f2 -= arrayList3.getTotalWidth(), --i) {
                arrayList3 = (PdfPTable)arrayList2.remove(i - 1);
            }
        }
        if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
            pdfPTable = new PdfPTable(1);
            pdfPTable.setTotalWidth(f);
        } else {
            pdfPTable = new PdfPTable(arrayList2.isEmpty() ? 1 : (arrayList2.size() == 1 ? 2 : arrayList2.size() * 2 - 1));
        }
        if (pdfPTable2 != null) {
            PdfPCell fArray = new PdfPCell(pdfPTable2);
            fArray.setBorderWidth(0.0f);
            fArray.setPadding(0.0f);
            fArray.setPaddingBottom(10.0f);
            fArray.setColspan(pdfPTable.getNumberOfColumns());
            pdfPTable.addCell(fArray);
        }
        if (AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation)) {
            PdfPCell pdfPCell;
            ArrayList<Float[]> arrayList3 = new ArrayList<Float[]>();
            int n3 = 0;
            Float[] floatArray = null;
            PdfPTable pdfPTable3 = null;
            ArrayList<PdfPTable> arrayList4 = new ArrayList<PdfPTable>();
            for (PdfPTable pdfPTable4 : arrayList2) {
                int n4 = n3 % 2;
                if (n4 == 0 || pdfPTable3 == null) {
                    pdfPTable3 = new PdfPTable(4);
                    arrayList4.add(pdfPTable3);
                    floatArray = new Float[2];
                    arrayList3.add(floatArray);
                }
                floatArray[n4] = Float.valueOf(pdfPTable4.getTotalWidth());
                PdfPCell pdfPCell2 = new PdfPCell(pdfPTable4);
                pdfPCell2.setBorderWidth(0.0f);
                pdfPCell2.setPadding(0.0f);
                if (arrayList4.size() > 1) {
                    pdfPCell2.setPaddingTop(6.0f);
                }
                pdfPCell2.setHorizontalAlignment(0);
                pdfPTable3.addCell(pdfPCell2);
                pdfPCell = new PdfPCell();
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setPadding(0.0f);
                pdfPTable3.addCell(pdfPCell);
                ++n3;
            }
            if (pdfPTable3 != null && n3 % pdfPTable3.getNumberOfColumns() != 0) {
                while (n3 % pdfPTable3.getNumberOfColumns() != 0) {
                    PdfPCell pdfPCell3 = new PdfPCell();
                    pdfPCell3.setBorderWidth(0.0f);
                    pdfPCell3.setPadding(0.0f);
                    pdfPTable3.addCell(pdfPCell3);
                    ++n3;
                }
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (Float[] floatArray2 : arrayList3) {
                if (floatArray2[0] != null) {
                    f3 = Math.max(f3, floatArray2[0].floatValue());
                }
                if (floatArray2[1] == null) continue;
                f4 = Math.max(f4, floatArray2[1].floatValue());
            }
            n3 = 0;
            for (PdfPTable pdfPTable5 : arrayList4) {
                Object object2;
                Float f5;
                pdfPCell = (PdfPCell)arrayList3.get(n3);
                Float f6 = f5 = pdfPCell != null && ((Float[])pdfPCell).length > 0 ? pdfPCell[0] : null;
                if (f5 == null) {
                    f5 = Float.valueOf(0.0f);
                }
                Object object3 = object2 = pdfPCell != null && ((Float[])pdfPCell).length > 1 ? pdfPCell[1] : null;
                if (object2 == null) {
                    object2 = Float.valueOf(0.0f);
                }
                float f7 = (f - f3 - f4) / 2.0f;
                if (f5.floatValue() < f3) {
                    f7 += f3 - f5.floatValue();
                }
                float f8 = f - f5.floatValue() - ((Float)object2).floatValue() - f7 - 1.0f;
                pdfPTable5.setTotalWidth(new float[]{f5.floatValue(), f7, ((Float)object2).floatValue(), f8});
                PdfPCell pdfPCell4 = new PdfPCell(pdfPTable5);
                pdfPCell4.setBorderWidth(0.0f);
                pdfPCell4.setPadding(0.0f);
                pdfPTable.addCell(pdfPCell4);
                ++n3;
            }
        } else {
            float[] fArray = new float[pdfPTable.getNumberOfColumns()];
            float f9 = arrayList2.size() > 1 ? (float)Math.floor((f - f2) / (float)(arrayList2.size() - 1)) : 0.0f;
            n = 0;
            for (PdfPTable pdfPTable6 : arrayList2) {
                PdfPCell pdfPCell;
                if (n > 0) {
                    fArray[n++] = f9;
                    pdfPCell = new PdfPCell();
                    pdfPCell.setBorderWidth(0.0f);
                    pdfPCell.setPadding(0.0f);
                    pdfPTable.addCell(pdfPCell);
                }
                fArray[n++] = pdfPTable6.getTotalWidth();
                pdfPCell = new PdfPCell(pdfPTable6);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setPadding(0.0f);
                if (n == 1) {
                    pdfPCell.setHorizontalAlignment(0);
                } else if (n == pdfPTable.getNumberOfColumns()) {
                    pdfPCell.setHorizontalAlignment(2);
                } else {
                    pdfPCell.setHorizontalAlignment(1);
                }
                pdfPTable.addCell(pdfPCell);
            }
            if (arrayList2.size() == 1) {
                fArray[n++] = f - f2 - 1.0f;
                PdfPCell pdfPCell = new PdfPCell();
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setPadding(0.0f);
                pdfPTable.addCell(pdfPCell);
            }
            pdfPTable.setTotalWidth(fArray);
        }
        return pdfPTable;
    }

    private PdfPTable writeKeyValueTable(String[] chunk, String string, Font font, Font font2, Float f, Float f2) throws DocumentException {
        String string22;
        if (ArrayUtils.isEmpty((Object[])chunk)) {
            return null;
        }
        if (font == null) {
            font = new Font(this.bodyFontSmall);
        }
        if (font2 == null) {
            font2 = new Font(this.bodyFontH1);
        }
        float f3 = 0.0f;
        ArrayList<PdfPCell> arrayList = new ArrayList<PdfPCell>();
        for (String string22 : chunk) {
            Chunk chunk2 = new Chunk(string22, font);
            Paragraph paragraph = new Paragraph(chunk2);
            paragraph.setAlignment(0);
            paragraph.setLeading(0.0f, 1.0f);
            PdfPCell pdfPCell2 = new PdfPCell();
            if (f2 != null && f2.floatValue() > 0.0f) {
                pdfPCell2.setFixedHeight(f2.floatValue() / (float)((Chunk)chunk).length);
            }
            pdfPCell2.setVerticalAlignment(5);
            pdfPCell2.setBorderWidth(0.0f);
            pdfPCell2.setPadding(0.0f);
            pdfPCell2.setPaddingRight(4.0f);
            pdfPCell2.addElement((Element)paragraph);
            arrayList.add(pdfPCell2);
            f3 = Math.max(f3, chunk2.getWidthPoint() + pdfPCell2.getPaddingLeft() + pdfPCell2.getPaddingRight());
        }
        Chunk chunk3 = new Chunk(string, font2);
        Paragraph paragraph = new Paragraph(chunk3);
        paragraph.setAlignment(0);
        paragraph.setLeading(0.0f, 1.0f);
        PdfPCell pdfPCell = new PdfPCell();
        if (f2 != null && f2.floatValue() > 0.0f) {
            pdfPCell.setFixedHeight(f2.floatValue());
        }
        pdfPCell.setVerticalAlignment(5);
        pdfPCell.setRowspan(arrayList.size());
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.addElement((Element)paragraph);
        string22 = new PdfPTable(2);
        int n = 0;
        for (PdfPCell pdfPCell2 : arrayList) {
            if (arrayList.size() > 1) {
                if (n == 0) {
                    pdfPCell2.setVerticalAlignment(6);
                } else {
                    pdfPCell2.setVerticalAlignment(4);
                }
            }
            string22.addCell(pdfPCell2);
            if (n == 0) {
                string22.addCell(pdfPCell);
            }
            ++n;
        }
        float f4 = f3 + 1.0f;
        float f5 = chunk3.getWidthPoint() + pdfPCell.getPaddingLeft() + pdfPCell.getPaddingRight();
        if (f != null && f.floatValue() > 0.0f) {
            string22.setTotalWidth(new float[]{f4, f.floatValue() - f4});
        } else {
            string22.setTotalWidth(new float[]{f4, f5});
        }
        return string22;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="Use of different constants for portrait and landscape is intended.")
    protected PdfPTable writePriceTable(float f) throws DocumentException {
        PdfPCell pdfPCell;
        PdfPTable pdfPTable;
        Object object;
        String[] stringArray;
        String[] stringArray2;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        List<OpenEstateType> list = Arrays.asList(dbAgencyObject.item.getType().getParentPath());
        float f2 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 30.0f : 30.0f;
        float f3 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 25.0f : 25.0f;
        Font font = new Font(this.bodyFontNormal);
        ArrayList<PdfPTable> arrayList = new ArrayList<PdfPTable>();
        AbstractAttribImpl abstractAttribImpl = this.getPrice1stValue(dbAgencyObject, list);
        if (abstractAttribImpl != null) {
            stringArray2 = new String[this.secondaryLocale != null ? 2 : 1];
            stringArray2[0] = (String)StringUtils.defaultIfBlank((CharSequence)abstractAttribImpl.getAttrib().getTranslation(this.locale), (CharSequence)abstractAttribImpl.getAttrib().name());
            stringArray2[0] = stringArray2[0] + ":";
            if (this.secondaryLocale != null) {
                stringArray2[1] = (String)StringUtils.defaultIfBlank((CharSequence)abstractAttribImpl.getAttrib().getTranslation(this.secondaryLocale), (CharSequence)abstractAttribImpl.getAttrib().name());
                stringArray2[1] = stringArray2[1] + ":";
            }
            stringArray = dbAgencyObject.writeValueForPublic(abstractAttribImpl, this.locale);
            arrayList.add(this.writeKeyValueTable(stringArray2, (String)stringArray, null, null, null, Float.valueOf(f2)));
        }
        if ((stringArray2 = this.getPrice2ndValue(dbAgencyObject, list)) != null) {
            stringArray = new String[this.secondaryLocale != null ? 2 : 1];
            stringArray[0] = (String)StringUtils.defaultIfBlank((CharSequence)stringArray2.getAttrib().getTranslation(this.locale), (CharSequence)stringArray2.getAttrib().name());
            stringArray[0] = stringArray[0] + ":";
            if (this.secondaryLocale != null) {
                stringArray[1] = (String)StringUtils.defaultIfBlank((CharSequence)stringArray2.getAttrib().getTranslation(this.secondaryLocale), (CharSequence)stringArray2.getAttrib().name());
                stringArray[1] = stringArray[1] + ":";
            }
            object = dbAgencyObject.writeValueForPublic((AbstractAttribImpl)stringArray2, this.locale);
            arrayList.add(this.writeKeyValueTable(stringArray, (String)object, null, null, null, Float.valueOf(f2)));
        }
        stringArray = null;
        object = this.getPriceCommissionValue(dbAgencyObject, list);
        if (object != null) {
            pdfPTable = new String[this.secondaryLocale != null ? 2 : 1];
            pdfPTable[0] = (String)StringUtils.defaultIfBlank((CharSequence)object.getAttrib().getTranslation(this.locale), (CharSequence)object.getAttrib().name());
            PdfPTable pdfPTable2 = pdfPTable;
            pdfPTable2[0] = (String)pdfPTable2[0] + ":";
            if (this.secondaryLocale != null) {
                pdfPTable[1] = (String)StringUtils.defaultIfBlank((CharSequence)object.getAttrib().getTranslation(this.secondaryLocale), (CharSequence)object.getAttrib().name());
                PdfPTable pdfPTable3 = pdfPTable;
                pdfPTable3[1] = (String)pdfPTable3[1] + ":";
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Object object2 = dbAgencyObject.writeValueForPublic((AbstractAttribImpl)object, this.locale);
            if (!StringUtils.isBlank((CharSequence)object2)) {
                arrayList2.add(((String)object2).trim());
            }
            if (this.secondaryLocale != null && !StringUtils.isBlank((CharSequence)(object2 = dbAgencyObject.writeValueForPublic((AbstractAttribImpl)object, this.secondaryLocale)))) {
                arrayList2.add(((String)object2).trim());
            }
            stringArray = this.writeKeyValueTable((String[])pdfPTable, StringUtils.join(arrayList2, (String)System.lineSeparator()), null, font, Float.valueOf(f), Float.valueOf(f3));
        }
        pdfPTable = new PdfPTable(arrayList.isEmpty() ? 1 : (arrayList.size() == 1 ? 2 : arrayList.size() * 2 - 1));
        float f4 = 0.0f;
        for (PdfPTable pdfPTable4 : arrayList) {
            f4 += pdfPTable4.getTotalWidth();
        }
        float f5 = arrayList.size() > 1 ? (float)Math.floor((f - f4) / (float)(arrayList.size() - 1)) : 0.0f;
        int n = 0;
        float[] fArray = new float[pdfPTable.getNumberOfColumns()];
        for (PdfPTable pdfPTable5 : arrayList) {
            PdfPCell pdfPCell2;
            if (n > 0) {
                fArray[n++] = f5;
                pdfPCell2 = new PdfPCell();
                pdfPCell2.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell2.setBorderWidth(0.0f);
                pdfPCell2.setPadding(0.0f);
                pdfPTable.addCell(pdfPCell2);
            }
            fArray[n++] = pdfPTable5.getTotalWidth();
            pdfPCell2 = new PdfPCell(pdfPTable5);
            pdfPCell2.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell2.setBorderWidth(0.0f);
            pdfPCell2.setPadding(0.0f);
            if (n == 1) {
                pdfPCell2.setHorizontalAlignment(0);
            } else if (n == pdfPTable.getNumberOfColumns()) {
                pdfPCell2.setHorizontalAlignment(2);
            } else {
                pdfPCell2.setHorizontalAlignment(1);
            }
            pdfPTable.addCell(pdfPCell2);
        }
        if (arrayList.size() == 1) {
            fArray[n++] = f - f4 - 1.0f;
            pdfPCell = new PdfPCell();
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPTable.addCell(pdfPCell);
        }
        pdfPTable.setTotalWidth(fArray);
        if (stringArray != null) {
            pdfPCell = new PdfPCell((PdfPTable)stringArray);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    protected PdfPTable writeTextTable(float f, float f2) throws DocumentException {
        Font font;
        Object object;
        String string;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        AbstractExpose.HorizontalAlign horizontalAlign = this.getBodyTextAlignment();
        Font font2 = new Font(this.bodyFontNormal);
        font2.setSize(15.0f);
        AbstractAttribImpl abstractAttribImpl = this.getTextValue(dbAgencyObject);
        String string2 = abstractAttribImpl != null ? dbAgencyObject.writeValueForPublic(abstractAttribImpl, this.locale) : null;
        String string3 = abstractAttribImpl != null && this.secondaryLocale != null ? dbAgencyObject.writeValueForPublic(abstractAttribImpl, this.secondaryLocale) : null;
        float f3 = !StringUtils.isBlank((CharSequence)string2) && !StringUtils.isBlank(string3) ? f2 / 2.0f : f2;
        PdfPCell pdfPCell = null;
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            string = StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)string2), (int)1500);
            object = font2;
            font = new Paragraph(string, object);
            font.setMultipliedLeading(1.1f);
            if (AbstractExpose.HorizontalAlign.CENTER.equals((Object)horizontalAlign)) {
                font.setAlignment(1);
            } else if (AbstractExpose.HorizontalAlign.JUSTIFY.equals((Object)horizontalAlign)) {
                font.setAlignment(3);
            } else if (AbstractExpose.HorizontalAlign.LEFT.equals((Object)horizontalAlign)) {
                font.setAlignment(0);
            } else if (AbstractExpose.HorizontalAlign.RIGHT.equals((Object)horizontalAlign)) {
                font.setAlignment(2);
            } else {
                font.setAlignment(3);
            }
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setFixedHeight(f3);
            pdfPCell.addElement((Element)font);
        }
        string = null;
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            object = StringUtils.abbreviate((String)StringUtils.trimToEmpty((String)string3), (int)1500);
            font = font2;
            Paragraph paragraph = new Paragraph((String)object, font);
            paragraph.setMultipliedLeading(1.1f);
            if (AbstractExpose.HorizontalAlign.CENTER.equals((Object)horizontalAlign)) {
                paragraph.setAlignment(1);
            } else if (AbstractExpose.HorizontalAlign.JUSTIFY.equals((Object)horizontalAlign)) {
                paragraph.setAlignment(3);
            } else if (AbstractExpose.HorizontalAlign.LEFT.equals((Object)horizontalAlign)) {
                paragraph.setAlignment(0);
            } else if (AbstractExpose.HorizontalAlign.RIGHT.equals((Object)horizontalAlign)) {
                paragraph.setAlignment(2);
            } else {
                paragraph.setAlignment(3);
            }
            string = new PdfPCell();
            string.setBorderWidth(0.0f);
            string.setPadding(0.0f);
            string.setFixedHeight(f3);
            string.addElement((Element)paragraph);
        }
        object = new PdfPTable(1);
        object.setTotalWidth(new float[]{f});
        if (pdfPCell != null && string != null) {
            pdfPCell.setPaddingBottom(3.0f);
            string.setPaddingTop(3.0f);
            string.setBorderWidthTop(1.0f);
            string.setBorderColorTop(this.getBorderColor());
        }
        if (pdfPCell != null) {
            if (string != null) {
                pdfPCell.setPaddingBottom(5.0f);
            }
            object.addCell(pdfPCell);
        }
        if (string != null) {
            object.addCell((PdfPCell)string);
        }
        if (pdfPCell == null && string == null) {
            font = new PdfPCell();
            font.setBorderWidth(0.0f);
            font.setPadding(0.0f);
            font.setFixedHeight(f2);
            object.addCell((PdfPCell)font);
        }
        return object;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_BRANCHES"}, justification="Use of different constants for portrait and landscape is intended.")
    protected PdfPTable writeTitleTable(float f) throws DocumentException {
        Paragraph paragraph;
        Object object;
        PdfPCell pdfPCell;
        DbAgencyObject dbAgencyObject = this.getEstateObject();
        int n = this.getResolution();
        float f2 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 75.0f : 75.0f;
        float f3 = this.bodyFontSmall.getCalculatedSize();
        float f4 = f2 - f3;
        ArrayList<PdfPCell> arrayList = new ArrayList<PdfPCell>();
        if (this.locale != null) {
            pdfPCell = new PdfPCell();
            pdfPCell.setFixedHeight(this.secondaryLocale != null ? f4 / 2.0f : f4);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(5.0f);
            pdfPCell.setPaddingRight(5.0f);
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setVerticalAlignment(5);
            object = dbAgencyObject.item.getTitle(this.locale);
            if (StringUtils.isBlank((CharSequence)object)) {
                object = dbAgencyObject.item.getFallbackTitle(this.locale);
            }
            if (!StringUtils.isBlank((CharSequence)object)) {
                paragraph = new Paragraph();
                for (String object2 : StringUtils.splitByWholeSeparator((String)object, (String)"  ")) {
                    if (!paragraph.isEmpty()) {
                        paragraph.add((Object)Chunk.NEWLINE);
                    }
                    paragraph.add((Object)new Chunk(object2, this.bodyFontH1));
                }
                paragraph.setAlignment(0);
                paragraph.setLeading(0.0f, 1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            arrayList.add(pdfPCell);
        }
        if (this.secondaryLocale != null) {
            pdfPCell = new PdfPCell();
            pdfPCell.setFixedHeight(this.locale != null ? f4 / 2.0f : f4);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(5.0f);
            pdfPCell.setPaddingRight(5.0f);
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setVerticalAlignment(5);
            object = dbAgencyObject.item.getTitle(this.secondaryLocale);
            if (StringUtils.isBlank((CharSequence)object)) {
                object = dbAgencyObject.item.getFallbackTitle(this.secondaryLocale);
            }
            if (!StringUtils.isBlank((CharSequence)object)) {
                paragraph = new Paragraph();
                for (String string : StringUtils.splitByWholeSeparator((String)object, (String)"  ")) {
                    if (!paragraph.isEmpty()) {
                        paragraph.add((Object)Chunk.NEWLINE);
                    }
                    paragraph.add((Object)new Chunk(string, this.bodyFontH1));
                }
                paragraph.setAlignment(0);
                paragraph.setLeading(0.0f, 1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            arrayList.add(pdfPCell);
        }
        pdfPCell = null;
        object = this.getAgentLogoImage();
        float f5 = 0.0f;
        if (object != null) {
            float f6 = AbstractExpose.Orientation.LANDSCAPE.equals((Object)this.orientation) ? 150.0f : 100.0f;
            Image image = this.getImage((BufferedImage)(object = ImageUtils.convertToRgb((BufferedImage)object)), f6, f4, n, false);
            if (image != null) {
                f5 = image.getScaledWidth();
                pdfPCell = new PdfPCell(image, false);
                pdfPCell.setFixedHeight(f4);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setPadding(0.0f);
                pdfPCell.setRowspan(arrayList.size());
                pdfPCell.setHorizontalAlignment(0);
                pdfPCell.setVerticalAlignment(5);
            }
        }
        PdfPCell pdfPCell2 = new PdfPCell();
        pdfPCell2.setFixedHeight(f3);
        pdfPCell2.setBorderWidth(0.0f);
        pdfPCell2.setPadding(0.0f);
        String string = dbAgencyObject.item.getPublicId();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = "#" + dbAgencyObject.id;
        }
        if (!StringUtils.isBlank((CharSequence)string)) {
            Paragraph paragraph2 = new Paragraph(string, this.bodyFontSmall);
            paragraph2.setAlignment(2);
            paragraph2.setLeading(0.0f, 1.0f);
            pdfPCell2.addElement((Element)paragraph2);
        }
        PdfPTable pdfPTable = new PdfPTable(pdfPCell != null ? 2 : 1);
        if (pdfPCell != null) {
            pdfPTable.setTotalWidth(new float[]{f5 + 5.0f, f - f5 - 5.0f});
            pdfPTable.addCell(pdfPCell);
        }
        for (PdfPCell pdfPCell3 : arrayList) {
            pdfPTable.addCell(pdfPCell3);
        }
        pdfPCell2.setColspan(pdfPTable.getNumberOfColumns());
        pdfPTable.addCell(pdfPCell2);
        return pdfPTable;
    }
}

