/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoCountry;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.GeoAreaRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GeoAreaPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1975304674963860515L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoAreaPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(GeoAreaPanel.class);
    private final Map<String, DbGeoCountry> dbCountries = new HashMap<String, DbGeoCountry>();
    private final Map<Integer, DbGeoArea> dbSelection = new HashMap<Integer, DbGeoArea>();
    private final List<AreaField> areaFields = new ArrayList<AreaField>();
    private DbGeoCountry dbCountry = null;
    private DbGeo geoDb;
    private JLabel countryLabel;
    private JLabel countryField;
    private DefaultFormBuilder formBuilder;
    private JPanel busyPanel;
    private JXBusyLabel busyLabel;

    public GeoAreaPanel(DbGeo dbGeo) {
        this(dbGeo, 50);
    }

    public GeoAreaPanel(DbGeo dbGeo, int n) {
        this.build(dbGeo, n);
    }

    private void build(DbGeo dbGeo, int n) {
        this.geoDb = dbGeo;
        int n2 = n > 0 ? n : 50;
        this.countryLabel = new JLabel();
        this.countryField = new JLabel();
        this.formBuilder = DefaultFormBuilder.create((String)("right:[" + n2 + "dlu,pref], 3dlu, 30dlu:grow"));
        this.formBuilder.add((Component)this.countryLabel).xy(1, this.formBuilder.nextRow());
        this.formBuilder.add((Component)this.countryField).xy(3, this.formBuilder.row());
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setVisible(false);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)("right:[" + n2 + "dlu,pref], 3dlu, 30dlu:grow"));
        defaultFormBuilder.add((Component)this.busyLabel).xy(3, defaultFormBuilder.nextRow());
        this.busyPanel = defaultFormBuilder.getPanel();
        this.busyPanel.setVisible(false);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.formBuilder.getPanel(), "Center");
        this.add(this.busyPanel, "South");
        this.updateLocalization();
    }

    private AreaField createAndAppendField(int n) {
        AreaField areaField = new AreaField(n);
        this.formBuilder.add((Component)areaField.label).xy(1, this.formBuilder.nextRow());
        this.formBuilder.add((Component)areaField.box).xy(3, this.formBuilder.row());
        this.formBuilder.getPanel().revalidate();
        this.formBuilder.getPanel().repaint();
        return areaField;
    }

    public DbGeoArea getGeoArea() {
        for (int i = this.areaFields.size() - 1; i >= 0; --i) {
            AreaField areaField = this.areaFields.get(i);
            Object object = areaField.box.getSelectedItem();
            DbGeoArea dbGeoArea = (DbGeoArea)object;
            if (dbGeoArea == null) {
                continue;
            }
            return dbGeoArea;
        }
        return null;
    }

    public DbGeo getGeoDb() {
        return this.geoDb;
    }

    public void load(Connection connection, DbGeoHandler dbGeoHandler) throws SQLException {
        this.load(connection, dbGeoHandler, null);
    }

    public void load(Connection connection, DbGeoHandler dbGeoHandler, DbAgencyObject dbAgencyObject) throws SQLException {
        int n;
        AreaField areaField;
        this.dbSelection.clear();
        this.dbCountry = null;
        if (this.dbCountries.isEmpty()) {
            for (DbGeoCountry dbGeoCountry : dbGeoHandler.getGeoCountries(connection, this.geoDb.id)) {
                this.dbCountries.put(dbGeoCountry.locale.getCountry().toUpperCase(), dbGeoCountry);
            }
        }
        if (dbAgencyObject == null) {
            this.setCountry(null, null, false);
            return;
        }
        DbGeoCountry dbGeoCountry = null;
        DbGeoArea dbGeoArea = null;
        DbGeoArea[] dbGeoAreaArray = new DbGeoArea[]{};
        if (dbAgencyObject.geoDbAreas != null && dbAgencyObject.geoDbAreas.containsKey(this.geoDb.id) && (dbGeoArea = (DbGeoArea)dbAgencyObject.geoDbAreas.get(this.geoDb.id)) != null && (dbGeoCountry = dbGeoHandler.getGeoCountry(connection, dbGeoArea.countryId)) != null && (dbGeoAreaArray = dbGeoArea.getPath(connection, dbGeoHandler)) == null) {
            dbGeoAreaArray = new DbGeoArea[]{};
        }
        if (dbGeoCountry == null) {
            dbGeoCountry = dbGeoHandler.getGeoCountry(connection, this.geoDb.id, dbAgencyObject.item.getAddress().getCountry());
        }
        this.setCountry(dbGeoCountry != null ? dbGeoCountry.locale.getCountry() : null, dbGeoCountry != null ? dbGeoCountry.name : null, dbGeoAreaArray.length == 0);
        if (dbGeoAreaArray.length > 0) {
            for (int i = 0; i < dbGeoAreaArray.length; ++i) {
                DbGeoArea[] dbGeoAreaArray2;
                DbGeoArea dbGeoArea2 = dbGeoAreaArray[i];
                this.dbSelection.put(i, dbGeoArea2);
                if (this.areaFields.size() > i) {
                    areaField = this.areaFields.get(i);
                } else {
                    areaField = this.createAndAppendField(i);
                    this.areaFields.add(areaField);
                }
                areaField.box.setEnabled(false);
                areaField.box.removeAllItems();
                areaField.box.addItem(null);
                for (DbGeoArea dbGeoArea3 : dbGeoAreaArray2 = dbGeoArea2.parentAreaId < 1L ? dbGeoHandler.getGeoAreas(connection, dbGeoArea2.countryId, false) : dbGeoHandler.getGeoAreas(connection, dbGeoArea2.parentAreaId)) {
                    areaField.box.addItem(dbGeoArea3);
                }
                areaField.box.setSelectedItem(dbGeoArea2);
                areaField.box.setEnabled(true);
            }
        }
        for (int i = n = dbGeoAreaArray.length > 0 ? dbGeoAreaArray.length : 1; i < this.areaFields.size(); ++i) {
            areaField = this.areaFields.get(i);
            areaField.box.setEnabled(false);
            areaField.box.removeAllItems();
            areaField.box.addItem(null);
        }
        if (dbGeoAreaArray.length > 0) {
            AreaField areaField2;
            int n2 = dbGeoAreaArray.length;
            if (this.areaFields.size() > n2) {
                areaField2 = this.areaFields.get(n2);
            } else {
                areaField2 = this.createAndAppendField(n2);
                this.areaFields.add(areaField2);
            }
            areaField2.box.setEnabled(false);
            areaField2.box.setModel(this.loadGeoChildAreaModel(connection, dbGeoArea.id));
            areaField2.box.setSelectedItem(null);
            areaField2.box.setEnabled(areaField2.box.getItemCount() > 1);
        }
    }

    private DefaultComboBoxModel<DbGeoArea> loadGeoChildAreaModel(Connection connection, long l) throws SQLException {
        DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
        DefaultComboBoxModel<DbGeoArea> defaultComboBoxModel = new DefaultComboBoxModel<DbGeoArea>();
        defaultComboBoxModel.addElement(null);
        for (DbGeoArea dbGeoArea : dbGeoHandler.getGeoAreas(connection, l)) {
            defaultComboBoxModel.addElement(dbGeoArea);
        }
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel<DbGeoArea> loadGeoCountryAreaModel(Connection connection, long l) throws SQLException {
        DbGeoHandler dbGeoHandler = AgencyPlugin.getDbAgencyExtension().getGeoHandler();
        DefaultComboBoxModel<DbGeoArea> defaultComboBoxModel = new DefaultComboBoxModel<DbGeoArea>();
        defaultComboBoxModel.addElement(null);
        for (DbGeoArea dbGeoArea : dbGeoHandler.getGeoAreas(connection, l, false)) {
            defaultComboBoxModel.addElement(dbGeoArea);
        }
        return defaultComboBoxModel;
    }

    private ImmoToolTask reloadGeoChildAreaBox(final ImmoToolProject immoToolProject, final JComboBox<DbGeoArea> jComboBox, final long l) {
        jComboBox.setEnabled(false);
        jComboBox.removeAllItems();
        jComboBox.addItem(null);
        if (l < 1L) {
            return null;
        }
        this.busyLabel.setBusy(true);
        this.busyLabel.setText(I18N.tr("Loading further regions."));
        this.busyLabel.setVisible(true);
        this.busyPanel.setVisible(true);
        return new ImmoToolTask<DefaultComboBoxModel<DbGeoArea>, Void>(){

            protected DefaultComboBoxModel<DbGeoArea> doInBackground() throws Exception {
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    DefaultComboBoxModel defaultComboBoxModel = GeoAreaPanel.this.loadGeoChildAreaModel(connection, l);
                    return defaultComboBoxModel;
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                GeoAreaPanel.this.busyLabel.setText(I18N.tr("An error occurred!"));
            }

            protected void finished() {
                super.finished();
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoAreaPanel.this.busyLabel.setBusy(false);
            }

            protected void succeeded(DefaultComboBoxModel<DbGeoArea> defaultComboBoxModel) {
                super.succeeded(defaultComboBoxModel);
                jComboBox.setModel(defaultComboBoxModel);
                jComboBox.setSelectedItem(null);
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoAreaPanel.this.busyLabel.setVisible(false);
            }
        };
    }

    private ImmoToolTask reloadGeoCountryAreaBox(final ImmoToolProject immoToolProject, final JComboBox<DbGeoArea> jComboBox, final long l) {
        jComboBox.setEnabled(false);
        jComboBox.removeAllItems();
        jComboBox.addItem(null);
        if (l < 1L) {
            return null;
        }
        this.busyLabel.setBusy(true);
        this.busyLabel.setText(I18N.tr("Loading further regions."));
        this.busyLabel.setVisible(true);
        this.busyPanel.setVisible(true);
        return new ImmoToolTask<DefaultComboBoxModel<DbGeoArea>, Void>(){

            protected DefaultComboBoxModel<DbGeoArea> doInBackground() throws Exception {
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    DefaultComboBoxModel defaultComboBoxModel = GeoAreaPanel.this.loadGeoCountryAreaModel(connection, l);
                    return defaultComboBoxModel;
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                GeoAreaPanel.this.busyLabel.setText(I18N.tr("An error occurred!"));
            }

            protected void finished() {
                super.finished();
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoAreaPanel.this.busyLabel.setBusy(false);
            }

            protected void succeeded(DefaultComboBoxModel<DbGeoArea> defaultComboBoxModel) {
                super.succeeded(defaultComboBoxModel);
                jComboBox.setModel(defaultComboBoxModel);
                jComboBox.setSelectedItem(null);
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoAreaPanel.this.busyLabel.setVisible(false);
            }
        };
    }

    public void save(DbAgencyObject dbAgencyObject) {
        if (dbAgencyObject.geoDbAreas == null) {
            dbAgencyObject.geoDbAreas = new HashMap();
        }
        dbAgencyObject.geoDbAreas.remove(this.geoDb.id);
        DbGeoArea dbGeoArea = this.getGeoArea();
        if (dbGeoArea != null) {
            dbAgencyObject.geoDbAreas.put(this.geoDb.id, dbGeoArea);
        }
    }

    public void setCountry(String string, String string2, boolean bl) {
        if (string == null || !this.dbCountries.containsKey(string)) {
            this.dbCountry = null;
            if (string != null) {
                Object object = string2;
                if (StringUtils.isEmpty((CharSequence)object)) {
                    object = string;
                }
                this.countryField.setText(I18N.tr("The country {0} is not supported by the geo database.", object));
            } else {
                this.countryField.setText(I18N.tr("No country selected."));
            }
            this.countryField.setFont(this.countryField.getFont().deriveFont(2));
            this.dbSelection.clear();
            for (AreaField areaField : this.areaFields) {
                areaField.box.setEnabled(false);
                areaField.box.removeAllItems();
                areaField.box.addItem(null);
                areaField.box.setSelectedItem(null);
            }
        } else {
            DbGeoCountry dbGeoCountry = this.dbCountry;
            if (dbGeoCountry == null || !dbGeoCountry.locale.getCountry().equals(string)) {
                DbGeoCountry dbGeoCountry2;
                this.dbCountry = dbGeoCountry2 = this.dbCountries.get(string);
                this.countryField.setText(string2);
                this.countryField.setFont(this.countryField.getFont().deriveFont(1));
                if (this.areaFields.isEmpty()) {
                    this.areaFields.add(this.createAndAppendField(0));
                } else {
                    this.dbSelection.clear();
                    for (int i = 0; i < this.areaFields.size(); ++i) {
                        AreaField areaField = this.areaFields.get(i);
                        areaField.box.setEnabled(false);
                        areaField.box.removeAllItems();
                        areaField.box.addItem(null);
                        areaField.box.setSelectedItem(null);
                        areaField.box.setEnabled(i == 0);
                    }
                }
                if (bl) {
                    ImmoToolUtils.executeTask((ImmoToolTask)this.reloadGeoCountryAreaBox(ImmoToolProject.getAppInstance(), this.areaFields.get(0).box, dbGeoCountry2.id));
                }
            }
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.countryLabel.setText(StringUtils.capitalize((String)I18N.tr("country")) + ":");
        for (AreaField areaField : this.areaFields) {
            areaField.updateLabel();
        }
    }

    private class GeoSelectAction
    implements ActionListener {
        private final ImmoToolProject project;
        private final JComboBox box;
        private final int level;

        private GeoSelectAction(ImmoToolProject immoToolProject, JComboBox jComboBox, int n) {
            this.project = immoToolProject;
            this.box = jComboBox;
            this.level = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object;
            if (!this.box.isEnabled()) {
                return;
            }
            Object object2 = this.box.getSelectedItem();
            if ("".equals(object2)) {
                object2 = null;
            }
            if (object2 instanceof DbGeoArea) {
                object = (DbGeoArea)object2;
                if (GeoAreaPanel.this.dbSelection.containsKey(this.level) && ((DbGeoArea)((GeoAreaPanel)GeoAreaPanel.this).dbSelection.get((Object)Integer.valueOf((int)this.level))).id == object.id) {
                    return;
                }
                GeoAreaPanel.this.dbSelection.put(this.level, object);
            }
            if (GeoAreaPanel.this.areaFields.size() > this.level + 1) {
                object = (AreaField)GeoAreaPanel.this.areaFields.get(this.level + 1);
            } else {
                if (object2 == null) {
                    return;
                }
                object = GeoAreaPanel.this.createAndAppendField(this.level + 1);
                GeoAreaPanel.this.areaFields.add(object);
            }
            for (n = this.level + 1; n < GeoAreaPanel.this.areaFields.size(); ++n) {
                AreaField areaField = (AreaField)GeoAreaPanel.this.areaFields.get(n);
                areaField.box.setEnabled(false);
                areaField.box.removeAllItems();
                areaField.box.addItem(null);
            }
            if (object2 instanceof DbGeoArea) {
                n = this.level + 1;
                while (GeoAreaPanel.this.dbSelection.containsKey(n)) {
                    GeoAreaPanel.this.dbSelection.remove(n);
                    ++n;
                }
                long l = ((DbGeoArea)object2).id;
                ImmoToolUtils.executeTask((ImmoToolTask)GeoAreaPanel.this.reloadGeoChildAreaBox(this.project, ((AreaField)object).box, l));
            } else {
                n = this.level;
                while (GeoAreaPanel.this.dbSelection.containsKey(n)) {
                    GeoAreaPanel.this.dbSelection.remove(n);
                    ++n;
                }
            }
        }
    }

    private class AreaField {
        private final int level;
        private JLabel label;
        private JComboBox<DbGeoArea> box;

        private AreaField(int n) {
            this.level = n;
            this.label = new JLabel();
            this.box = new JComboBox();
            this.box.setRenderer((ListCellRenderer<DbGeoArea>)new DefaultListCellRenderer((Renderer)new GeoAreaRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("no selection") + " ]";
                }
            }));
            this.box.addActionListener(new GeoSelectAction(ImmoToolProject.getAppInstance(), this.box, n));
            this.updateLabel();
        }

        private void updateLabel() {
            this.label.setText(I18N.tr("region") + " (" + (this.level + 1) + "):");
        }
    }
}

