/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyEstateContactEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.contacts.ContactsEntryRelationPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewContactTablePanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewContactTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewContactTablePanel.class);
    private static final String RELATION_TABLE_ID = "AgencyEstateViewContactTablePanel.RelationTable";
    private DbAgencyObject currentAgencyObject = null;
    private JXTitledSeparator entriesTitle;
    private RelationTable entriesTable;
    private RelationForm relationForm;
    private RelationAddAction relationAddAction;
    private RefreshAction refreshAction;
    private ShowActionsAction showActionsAction;

    public AgencyEstateViewContactTablePanel() {
        this.build();
    }

    public void addContactsEntry(DbContactsEntry dbContactsEntry, String string, String string2) {
        this.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(dbContactsEntry, string, string2));
    }

    private void build() {
        this.entriesTable = new RelationTable();
        this.entriesTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.entriesTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.entriesTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    private void doEntryView() {
        int n = this.entriesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.entriesTable.getContactEntryIdAt(this.entriesTable.convertRowIndexToModel(n));
        new ContactsPlugin.EntryFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.entriesTable.setEnabled(false);
        this.entriesTable.clearSelection();
        this.entriesTable.clearRows();
        this.showActionsAction.setEnabled(false);
        ArrayList<DbContactsEntry> arrayList = new ArrayList<DbContactsEntry>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        HashMap<Long, DbAgencyEstateContactEntry> hashMap2 = new HashMap<Long, DbAgencyEstateContactEntry>();
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        try {
            int dbContactsEntryArray;
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyContactsUtils.getContactsHandler();
            defaultComboBoxModel.addElement(null);
            DbContactsGroup[] objectArray = dbContactsHandler.getGroups(connection);
            int lArray = objectArray.length;
            for (dbContactsEntryArray = 0; dbContactsEntryArray < lArray; ++dbContactsEntryArray) {
                DbContactsGroup dbContactsGroup = objectArray[dbContactsEntryArray];
                hashMap.put(dbContactsGroup.id, dbContactsGroup.name);
                defaultComboBoxModel.addElement(dbContactsGroup);
            }
            if (this.currentAgencyObject != null && this.currentAgencyObject.id > 0L) {
                DbAgencyEstateContactEntry[] dbAgencyEstateContactEntryArray = dbAgencyContactsHandler.getEstateContactEntries(connection, this.currentAgencyObject.id, 0L);
                long[] lArray2 = new long[dbAgencyEstateContactEntryArray.length];
                for (dbContactsEntryArray = 0; dbContactsEntryArray < dbAgencyEstateContactEntryArray.length; ++dbContactsEntryArray) {
                    lArray2[dbContactsEntryArray] = dbAgencyEstateContactEntryArray[dbContactsEntryArray].contactEntryId;
                    hashMap2.put(dbAgencyEstateContactEntryArray[dbContactsEntryArray].contactEntryId, dbAgencyEstateContactEntryArray[dbContactsEntryArray]);
                }
                DbContactsEntry[] dbContactsEntryArray2 = dbContactsHandler.getEntries(connection, lArray2);
                dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray2);
                arrayList.addAll(Arrays.asList(dbContactsEntryArray2));
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(defaultComboBoxModel, arrayList, hashMap, hashMap2){
                final /* synthetic */ DefaultComboBoxModel val$relationContactsGroupModel;
                final /* synthetic */ List val$entriesList;
                final /* synthetic */ Map val$groupNames;
                final /* synthetic */ Map val$relationsMap;
                {
                    this.val$relationContactsGroupModel = defaultComboBoxModel;
                    this.val$entriesList = list;
                    this.val$groupNames = map;
                    this.val$relationsMap = map2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AgencyEstateViewContactTablePanel.this.relationForm.setContactsGroupsModel(this.val$relationContactsGroupModel);
                        for (DbContactsEntry dbContactsEntry : this.val$entriesList) {
                            String string = (String)this.val$groupNames.get(dbContactsEntry.groupId);
                            String string2 = this.val$relationsMap.containsKey(dbContactsEntry.id) ? ((DbAgencyEstateContactEntry)this.val$relationsMap.get((Object)Long.valueOf((long)dbContactsEntry.id))).relationNotes : null;
                            AgencyEstateViewContactTablePanel.this.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(dbContactsEntry, string, string2));
                        }
                    }
                    finally {
                        AgencyEstateViewContactTablePanel.this.entriesTable.setEnabled(true);
                        AgencyEstateViewContactTablePanel.this.showActionsAction.setEnabled(false);
                        AgencyEstateViewContactTablePanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doRefresh() {
        try {
            this.load(this.currentAgencyObject);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activity contacts!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activity contacts!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.entriesTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.entriesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.add((Action)((Object)new EntryViewAction()));
        Object[] objectArray = this.entriesTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Long[] longArray = null;
            if (longArray == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = this.entriesTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = this.entriesTable.convertRowIndexToModel(n4);
                    arrayList.add(this.entriesTable.getContactEntryIdAt(n5));
                }
                longArray = arrayList.toArray(new Long[0]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    objectArray2 = object.createActionMenuItems(immoToolProject, longArray, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.show(component, n, n2);
    }

    public RelationForm getRelationForm() {
        return this.relationForm;
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("addresses"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbAgencyObject dbAgencyObject) {
        this.currentAgencyObject = dbAgencyObject;
        this.relationForm.unselectRelation();
        this.entriesTable.setEnabled(false);
        this.entriesTable.clearSelection();
        this.entriesTable.clearRows();
        this.entriesTable.setEnabled(true);
        this.updateTitle();
    }

    public void save(DbAgencyObject dbAgencyObject) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException {
        DbAgencyContactsHandler dbAgencyContactsHandler = AgencyContactsUtils.getContactsHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbAgencyContactsHandler.getEstateContactEntries(connection, dbAgencyObject.id, 0L);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                hashMap.put(((DbAgencyEstateContactEntry)object).contactEntryId, object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.entriesTable.getRowCount(); ++i) {
            Object object;
            Long l = this.entriesTable.getContactEntryIdAt(i);
            object = this.entriesTable.getNotesAt(i);
            DbAgencyEstateContactEntry serializable = hashMap.containsKey(l) ? (DbAgencyEstateContactEntry)hashMap.get(l) : new DbAgencyEstateContactEntry();
            serializable.agencyEstateId = dbAgencyObject.id;
            serializable.contactEntryId = l;
            serializable.relationNotes = object;
            dbAgencyContactsHandler.saveEstateContactEntry(connection, serializable);
            arrayList.add(l);
            hashMap.put(l, serializable);
        }
        for (Long l : hashMap.keySet().toArray(new Long[0])) {
            if (arrayList.contains(l)) continue;
            dbAgencyContactsHandler.removeEstateContactEntry(connection, (DbAgencyEstateContactEntry)hashMap.get(l));
            hashMap.remove(l);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("assigned addresses"));
        int n2 = n = this.entriesTable != null ? this.entriesTable.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.entriesTitle.setTitle(string);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyEstateViewContactTablePanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        private RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewContactTablePanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        private RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewContactTablePanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                AgencyEstateViewContactTablePanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewContactTablePanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class EntryViewAction
    extends AbstractI18nAction {
        private EntryViewAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewContactTablePanel.this.doEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the addressbook entry."));
        }
    }

    public static class RelationTableRow
    extends ContactsEntryTable.Row {
        private String relationNotes;

        private RelationTableRow(DbContactsEntry dbContactsEntry, String string, String string2) {
            super(dbContactsEntry, string);
            this.relationNotes = string2;
        }

        public String getRelationNotes() {
            return this.relationNotes;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof RelationTableColumn) {
                return this.getValueForRelation((RelationTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForRelation(RelationTableColumn relationTableColumn) {
            switch (relationTableColumn) {
                case RELATION_NOTES: {
                    return StringUtils.trimToNull((String)this.relationNotes);
                }
            }
            return null;
        }

        public void setRelationNotes(String string) {
            this.relationNotes = string;
        }
    }

    public static enum RelationTableColumn implements AbstractTable.Column
    {
        RELATION_NOTES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case RELATION_NOTES: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case RELATION_NOTES: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case RELATION_NOTES: {
                    return StringUtils.capitalize((String)I18N.tr("notes"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private final class RelationTable
    extends ContactsEntryTable<RelationTableRow> {
        private RelationTable() {
            super(AgencyEstateViewContactTablePanel.RELATION_TABLE_ID);
        }

        protected void doSelect() {
            AgencyEstateViewContactTablePanel.this.showActionsAction.setEnabled(this.getSelectedColumnCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                AgencyEstateViewContactTablePanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                AgencyEstateViewContactTablePanel.this.relationForm.selectRelation(this.getContactEntryAt(n), this.getNotesAt(n));
            }
        }

        protected void doShowActions(int n, int n2) {
            AgencyEstateViewContactTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyEstateViewContactTablePanel.this.doEntryView();
        }

        public String getNotesAt(int n) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            return relationTableRow != null ? relationTableRow.getRelationNotes() : null;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(RelationTableColumn.values()));
            return list;
        }

        public void setNotesAt(int n, String string) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            if (relationTableRow != null) {
                relationTableRow.setRelationNotes(string);
            }
        }
    }

    public final class RelationForm
    extends ContactsEntryRelationPanel {
        private RelationForm() {
            super(true);
        }

        protected void close() {
            if (AgencyEstateViewContactTablePanel.this.entriesTable.getSelectedRowCount() > 0) {
                AgencyEstateViewContactTablePanel.this.entriesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbContactsGroup dbContactsGroup, DbContactsEntry dbContactsEntry, String string) {
            if (dbContactsGroup == null || dbContactsEntry == null) {
                return false;
            }
            AgencyEstateViewContactTablePanel.this.entriesTable.setEnabled(false);
            try {
                if (this.getCurrentContactEntryId() < 1L) {
                    AgencyEstateViewContactTablePanel.this.entriesTable.addRow((AbstractTable.Row)new RelationTableRow(dbContactsEntry, dbContactsGroup.name, string));
                } else {
                    int n = AgencyEstateViewContactTablePanel.this.entriesTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = AgencyEstateViewContactTablePanel.this.entriesTable.convertRowIndexToModel(n);
                        AgencyEstateViewContactTablePanel.this.entriesTable.setRowAt(n2, (AbstractTable.Row)new RelationTableRow(dbContactsEntry, dbContactsGroup.name, string));
                    }
                }
            }
            finally {
                AgencyEstateViewContactTablePanel.this.entriesTable.clearSelection();
                AgencyEstateViewContactTablePanel.this.entriesTable.setEnabled(true);
                AgencyEstateViewContactTablePanel.this.updateTitle();
            }
            return true;
        }
    }
}

