/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.utils.Authorization;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;
import org.openestate.is24.restapi.utils.Verification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClient.class);
    public static final String LIVE_API = "https://rest.immobilienscout24.de/restapi";
    public static final String SANDBOX_API = "https://rest.sandbox-immobilienscout24.de/restapi";
    public static final String RESPONSE_HEADER_API_CLIENT = "L-IS24-ApiClient";
    public static final String RESPONSE_HEADER_CAUSER_ID = "L-IS24-CauserId";
    public static final String RESPONSE_HEADER_REQUEST_REFNUM = "L-IS24-RequestRefnum";
    public static final String RESPONSE_HEADER_RESOURCE_ID = "L-IS24-ResourceId";
    public static final String XML_CONTENT_TYPE = "application/xml";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final String apiBaseUrl;
    private final String consumerToken;
    private final String consumerSecret;
    private OAuthConsumer oAuthConsumer = null;
    private OAuthProvider oAuthProvider = null;

    protected AbstractClient(String string, String string2, String string3) {
        string = StringUtils.trimToEmpty((String)string);
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.apiBaseUrl = string;
        this.consumerToken = StringUtils.trimToEmpty((String)string2);
        this.consumerSecret = StringUtils.trimToEmpty((String)string3);
    }

    public final void authorize(Authorization authorization) throws OAuthException {
        this.authorize(authorization.accessToken, authorization.accessTokenSecret);
    }

    public final void authorize(String string, String string2) throws OAuthException {
        this.oAuthConsumer = this.buildOAuthConsumer(this.consumerToken, this.consumerSecret);
        this.oAuthConsumer.setTokenWithSecret(string, string2);
        this.oAuthProvider = this.buildOAuthProvider(this.apiBaseUrl);
        this.oAuthProvider.setOAuth10a(true);
    }

    public final Authorization authorizeAfterVerification(Verification verification, String string) throws OAuthException {
        return this.authorizeAfterVerification(verification.requestToken, verification.requestTokenSecret, string);
    }

    public final Authorization authorizeAfterVerification(String string, String string2, String string3) throws OAuthException {
        this.oAuthConsumer = this.buildOAuthConsumer(this.consumerToken, this.consumerSecret);
        this.oAuthConsumer.setTokenWithSecret(string, string2);
        this.oAuthProvider = this.buildOAuthProvider(this.apiBaseUrl);
        this.oAuthProvider.setOAuth10a(true);
        this.oAuthProvider.retrieveAccessToken(this.oAuthConsumer, string3, new String[0]);
        return new Authorization(this.oAuthConsumer.getToken(), this.oAuthConsumer.getTokenSecret());
    }

    protected OAuthConsumer buildOAuthConsumer(String string, String string2) {
        return new DefaultOAuthConsumer(string, string2);
    }

    protected OAuthProvider buildOAuthProvider(String string) {
        return new DefaultOAuthProvider(string + "/security/oauth/request_token", string + "/security/oauth/access_token", string + "/security/oauth/confirm_access");
    }

    @Override
    public void close() throws IOException {
    }

    public final Verification fetchVerification() throws OAuthException {
        return this.fetchVerification(null);
    }

    public final Verification fetchVerification(String string) throws OAuthException {
        OAuthConsumer oAuthConsumer = this.buildOAuthConsumer(this.consumerToken, this.consumerSecret);
        OAuthProvider oAuthProvider = this.buildOAuthProvider(this.apiBaseUrl);
        String string2 = oAuthProvider.retrieveRequestToken(oAuthConsumer, StringUtils.trimToEmpty((String)string), new String[0]);
        return new Verification(string2, oAuthConsumer.getToken(), oAuthConsumer.getTokenSecret());
    }

    public final String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public final OAuthConsumer getAuthConsumer() throws OAuthNotAuthorizedException {
        if (this.oAuthConsumer == null) {
            throw new OAuthNotAuthorizedException();
        }
        return this.oAuthConsumer;
    }

    public final OAuthProvider getAuthProvider() throws OAuthNotAuthorizedException {
        if (this.oAuthProvider == null) {
            throw new OAuthNotAuthorizedException();
        }
        return this.oAuthProvider;
    }

    public static String getEncoding() {
        return "UTF-8";
    }

    public static String getUrlEncodedValue(String string) {
        try {
            return StringUtils.replace((String)new URLCodec().encode(StringUtils.trimToNull((String)string), AbstractClient.getEncoding()), (String)"+", (String)"%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("Unsupported encoding!", (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    protected abstract Response sendJsonRequest(URL var1, RequestMethod var2, String var3) throws IOException, OAuthException;

    protected abstract Response sendXmlRequest(URL var1, RequestMethod var2, String var3) throws IOException, OAuthException;

    protected abstract Response sendXmlAttachmentRequest(URL var1, RequestMethod var2, String var3, InputStream var4, String var5, String var6) throws IOException, OAuthException;

    protected abstract Response sendVideoUploadRequest(URI var1, RequestMethod var2, String var3, InputStream var4, String var5, long var6) throws IOException, OAuthException;
}

