/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenImmo_1_2_0
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_0.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_0;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_1);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.downgradeUebertragungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <uebertragung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeUserDefinedExtendElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <user_defined_extend> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeAnbieterChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <anbieter> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeBieterverfahrenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <bieterverfahren> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeBewertungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <bewertung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeGeoChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <geo> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeHeizkostenEnthaltenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <heizkosten_enthalten> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeAusstattungChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <ausstattung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeMieteinnahmenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <mieteinnahmen_ist> and <mieteinnahmen_soll> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBefeuerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <befeuerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHausElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <haus> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_0);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeMieteinnahmenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <mieteinnahmen_ist> and <mieteinnahmen_soll> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeBefeuerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:befeuerung[@FERN or @BLOCK or @WASSER-ELEKTRO]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("FERN");
            element.removeAttribute("BLOCK");
            element.removeAttribute("WASSER-ELEKTRO");
        }
    }

    protected void downgradeHausElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if ("KRANKENHAUS".equalsIgnoreCase(string)) {
                element.removeAttribute("haustyp");
                continue;
            }
            if ("PFLEGEHEIM".equalsIgnoreCase(string)) {
                element.removeAttribute("haustyp");
                continue;
            }
            if ("SANATORIUM".equalsIgnoreCase(string)) {
                element.removeAttribute("haustyp");
                continue;
            }
            if ("SENIORENHEIM".equalsIgnoreCase(string)) {
                element.removeAttribute("haustyp");
                continue;
            }
            if (!"BETREUTES-WOHNEN".equalsIgnoreCase(string)) continue;
            element.removeAttribute("haustyp");
        }
    }

    protected void downgradeMieteinnahmenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:mieteinnahmen_ist[@periode] |/io:openimmo/io:anbieter/io:immobilie/io:preise/io:mieteinnahmen_soll[@periode]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getTextContent());
            Double d = null;
            try {
                d = string != null ? Double.valueOf(DatatypeConverter.parseDouble((String)string)) : null;
            }
            catch (Exception exception) {
                String string2 = element.getTagName();
                LOGGER.warn("Can't parse <" + string2 + ">" + string + "</" + string2 + "> as number!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            if (d != null && d > 0.0) {
                String string3 = StringUtils.trimToNull((String)element.getAttribute("periode"));
                if ("MONAT".equalsIgnoreCase(string3)) {
                    element.setTextContent(DatatypeConverter.printDouble((double)(d * 12.0)));
                } else if ("WOCHE".equalsIgnoreCase(string3)) {
                    element.setTextContent(DatatypeConverter.printDouble((double)(d * 52.0)));
                } else if ("TAG".equalsIgnoreCase(string3)) {
                    element.setTextContent(DatatypeConverter.printDouble((double)(d * 365.0)));
                }
            }
            element.removeAttribute("periode");
        }
    }

    protected void downgradeUebertragungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung[@senderversion or @regi_id or @modus]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("senderversion");
            element.removeAttribute("regi_id");
            element.removeAttribute("modus");
        }
    }

    protected void removeAnbieterChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:lizenzkennung | /io:openimmo/io:anbieter/io:impressum_strukt", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeAusstattungChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:dvbt | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:breitband_zugang | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:umts_empfang | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:abstellraum | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:fahrradraum | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:rolladen", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeBewertungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:bewertung", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeBieterverfahrenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:bieterverfahren", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeGeoChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:geo/io:anzahl_etagen | /io:openimmo/io:anbieter/io:immobilie/io:geo/io:karten_makro | /io:openimmo/io:anbieter/io:immobilie/io:geo/io:karten_mikro | /io:openimmo/io:anbieter/io:immobilie/io:geo/io:virtuelletour | /io:openimmo/io:anbieter/io:immobilie/io:geo/io:luftbildern", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeHeizkostenEnthaltenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:heizkosten_enthalten", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeUserDefinedExtendElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"//io:user_defined_extend", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeMieteinnahmenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:mieteinnahmen_ist |/io:openimmo/io:anbieter/io:immobilie/io:preise/io:mieteinnahmen_soll", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.setAttribute("periode", "JAHR");
        }
    }
}

