/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyContactsHandlerImpl;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyEstateContactEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyContactsHandler
extends DbAgencyContactsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyContactsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyContactsHandler.class);
    public static final String VIEW_AGENCY_OBJECTS_CONTACTS_ENTRIES = "view_immotool_agency_objects_contacts_entries";
    public static final String PROC_REMOVE_AGENCY_OBJECTS_CONTACTS_ENTRIES = "remove_immotool_agency_objects_contacts_entries";
    public static final String PROC_SAVE_AGENCY_OBJECTS_CONTACTS_ENTRIES = "save_immotool_agency_objects_contacts_entries";
    private static final String FIELD_AGENCY_OBJECT_ID = "agency_object_id";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_RELATION_TYPE = "relation_type";
    private static final String FIELD_RELATION_NOTES = "relation_notes";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    private static DbAgencyEstateContactEntry createEstateContactEntry(ResultSet resultSet) throws SQLException {
        DbAgencyEstateContactEntry dbAgencyEstateContactEntry = new DbAgencyEstateContactEntry();
        dbAgencyEstateContactEntry.agencyEstateId = resultSet.getLong(FIELD_AGENCY_OBJECT_ID);
        dbAgencyEstateContactEntry.contactEntryId = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
        dbAgencyEstateContactEntry.relationType = resultSet.getString(FIELD_RELATION_TYPE);
        dbAgencyEstateContactEntry.relationNotes = resultSet.getString(FIELD_RELATION_NOTES);
        dbAgencyEstateContactEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyEstateContactEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbAgencyEstateContactEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyEstateContactEntry[] getEstateContactEntries(Connection connection, long[] lArray, long[] lArray2) throws SQLException {
        DbAgencyEstateContactEntry[] dbAgencyEstateContactEntryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (lArray != null) {
                arrayList.add("agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            if (lArray2 != null) {
                arrayList.add("contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_objects_contacts_entries " + string + " ORDER BY " + FIELD_CREATED_AT + " ASC;");
            int n2 = 0;
            if (lArray != null) {
                for (n = 0; n < lArray.length; ++n) {
                    preparedStatement.setLong(++n2, lArray[n]);
                }
            }
            if (lArray2 != null) {
                for (n = 0; n < lArray2.length; ++n) {
                    preparedStatement.setLong(++n2, lArray2[n]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyEstateContactEntry> arrayList2 = new ArrayList<DbAgencyEstateContactEntry>();
            while (resultSet.next()) {
                arrayList2.add(HSqlDbAgencyContactsHandler.createEstateContactEntry(resultSet));
            }
            dbAgencyEstateContactEntryArray = arrayList2.toArray(new DbAgencyEstateContactEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyEstateContactEntryArray;
    }

    @Override
    public void removeEstateContactEntries(Connection connection, DbAgencyEstateContactEntry[] dbAgencyEstateContactEntryArray) throws SQLException {
        if (dbAgencyEstateContactEntryArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_agency_objects_contacts_entries(:agency_object_id, :contacts_entry_id);");
            for (DbAgencyEstateContactEntry dbAgencyEstateContactEntry : dbAgencyEstateContactEntryArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyEstateContactEntry.agencyEstateId);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbAgencyEstateContactEntry.contactEntryId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEstateContactEntry(Connection connection, DbAgencyEstateContactEntry dbAgencyEstateContactEntry) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_objects_contacts_entries(:agency_object_id, :contacts_entry_id, :relation_type, :relation_notes);");
            namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyEstateContactEntry.agencyEstateId);
            namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbAgencyEstateContactEntry.contactEntryId);
            namedCallableStatement.setString(FIELD_RELATION_TYPE, StringUtils.abbreviate((String)dbAgencyEstateContactEntry.relationType, (int)100));
            namedCallableStatement.setString(FIELD_RELATION_NOTES, dbAgencyEstateContactEntry.relationNotes != null && dbAgencyEstateContactEntry.relationNotes.trim().length() > 0 ? dbAgencyEstateContactEntry.relationNotes.trim() : null);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

