/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlValidationHandler
implements ValidationEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlValidationHandler.class);

    public boolean handleEvent(ValidationEvent validationEvent) {
        if (validationEvent == null) {
            throw new IllegalArgumentException("No validation event was provided!");
        }
        int n = -1;
        int n2 = -1;
        if (validationEvent.getLocator() != null) {
            n = validationEvent.getLocator().getLineNumber();
            n2 = validationEvent.getLocator().getColumnNumber();
        }
        if (2 == validationEvent.getSeverity()) {
            LOGGER.warn("fatal validation error");
            if (n > -1 && n2 > -1) {
                LOGGER.warn("> at line " + n + " / column " + n2);
            }
            LOGGER.warn("> " + validationEvent.getMessage());
            return false;
        }
        if (0 == validationEvent.getSeverity()) {
            LOGGER.warn("validation warning");
            if (n > -1 && n2 > -1) {
                LOGGER.warn("> at line " + n + " / column " + n2);
            }
            LOGGER.warn("> " + validationEvent.getMessage());
        } else {
            LOGGER.warn("validation error");
            if (n > -1 && n2 > -1) {
                LOGGER.warn("> at line " + n + " / column " + n2);
            }
            LOGGER.warn("> " + validationEvent.getMessage());
        }
        return true;
    }
}

