/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandler;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.extensions.ContactViewExtension;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.extensions.EstateTableExtension;
import com.openindex.openestate.tool.agency.extensions.EstateViewExtension;
import com.openindex.openestate.tool.agency.extensions.ExportExtension;
import com.openindex.openestate.tool.agency.extensions.ExportViewExtension;
import com.openindex.openestate.tool.agency.extensions.ExposeExtension;
import com.openindex.openestate.tool.agency.extensions.ImportExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyPluginUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyPluginUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyPluginUtils.class);
    private static final List<Class> JAXB_UTIL_CLASSES = new ArrayList<Class>();

    private AgencyPluginUtils() {
    }

    public static Collection<ContactViewExtension> getContactViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ContactViewExtension> arrayList = new ArrayList<ContactViewExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("ContactViewExtension", ContactViewExtension.class, immoToolProject, null)) {
            arrayList.add((ContactViewExtension)object);
        }
        return arrayList;
    }

    public static DbAgencyExtension getDbAgencyExtension(ImmoToolProject immoToolProject) {
        return immoToolProject != null ? AgencyPluginUtils.getDbAgencyExtension(immoToolProject.getDbDriver()) : null;
    }

    public static DbAgencyExtension getDbAgencyExtension(AbstractDbDriver abstractDbDriver) {
        return abstractDbDriver != null ? AgencyPluginUtils.getDbAgencyExtension(abstractDbDriver.getName()) : null;
    }

    public static DbAgencyExtension getDbAgencyExtension(String string) {
        for (Object object : AgencyPluginUtils.getExtensionHandlers("DbAgencyExtension", DbAgencyExtension.class, null, null)) {
            DbAgencyExtension dbAgencyExtension = (DbAgencyExtension)object;
            if (!dbAgencyExtension.isSupportedDriver(string)) continue;
            return dbAgencyExtension;
        }
        return null;
    }

    public static Collection<DbAgencyExtension> getDbAgencyExtensions() {
        ArrayList<DbAgencyExtension> arrayList = new ArrayList<DbAgencyExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("DbAgencyExtension", DbAgencyExtension.class, null, null)) {
            arrayList.add((DbAgencyExtension)object);
        }
        return arrayList;
    }

    public static Collection<EstateTableExtension> getEstateTableExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<EstateTableExtension> arrayList = new ArrayList<EstateTableExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("EstateTableExtension", EstateTableExtension.class, immoToolProject, null)) {
            arrayList.add((EstateTableExtension)object);
        }
        return arrayList;
    }

    public static Collection<EstateViewExtension> getEstateViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<EstateViewExtension> arrayList = new ArrayList<EstateViewExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("EstateViewExtension", EstateViewExtension.class, immoToolProject, null)) {
            arrayList.add((EstateViewExtension)object);
        }
        return arrayList;
    }

    public static Collection<ExportExtension> getExportExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ExportExtension> arrayList = new ArrayList<ExportExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("ExportExtension", ExportExtension.class, immoToolProject, null)) {
            arrayList.add((ExportExtension)object);
        }
        return arrayList;
    }

    public static Collection<ExportViewExtension> getExportViewExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ExportViewExtension> arrayList = new ArrayList<ExportViewExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("ExportViewExtension", ExportViewExtension.class, immoToolProject, null)) {
            arrayList.add((ExportViewExtension)object);
        }
        return arrayList;
    }

    public static Collection<ExposeExtension> getExposeExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ExposeExtension> arrayList = new ArrayList<ExposeExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("ExposeExtension", ExposeExtension.class, immoToolProject, null)) {
            arrayList.add((ExposeExtension)object);
        }
        return arrayList;
    }

    private static Collection<Object> getExtensionHandlers(String string, Class clazz, ImmoToolProject immoToolProject, String[] stringArray) {
        return ImmoToolEnvironment.getExtensionHandlers((String)"OpenEstate-Tool-Agency", (String)string, (Class)clazz, (ImmoToolProject)immoToolProject, (String[])stringArray);
    }

    public static Collection<ImportExtension> getImportExtensions() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        ArrayList<ImportExtension> arrayList = new ArrayList<ImportExtension>();
        for (Object object : AgencyPluginUtils.getExtensionHandlers("ImportExtension", ImportExtension.class, immoToolProject, null)) {
            arrayList.add((ImportExtension)object);
        }
        return arrayList;
    }

    public static synchronized void initJAXB(Class<?> clazz) {
        if (clazz == null || JAXB_UTIL_CLASSES.contains(clazz)) {
            return;
        }
        try {
            Method method = clazz.getMethod("initContext", ClassLoader.class);
            ClassLoader classLoader = AgencyPlugin.class.getClassLoader();
            method.invoke(null, classLoader);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error("Can't find initContext method within " + clazz.getName());
            LOGGER.error("> " + noSuchMethodException.getLocalizedMessage(), (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException | SecurityException exception) {
            LOGGER.error("Can't access initContext method from " + clazz.getName());
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Invalid argument for initContext method from " + clazz.getName());
            LOGGER.error("> " + illegalArgumentException.getLocalizedMessage(), (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.error("The initContext method from " + clazz.getName() + " threw an exception!");
            LOGGER.error("> " + invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException);
        }
        finally {
            JAXB_UTIL_CLASSES.add(clazz);
        }
    }

    public static void updateEstateFileHashes(Connection connection, AbstractDbDriver abstractDbDriver, ImmoToolTask.Callback callback) throws SQLException {
        AgencyPluginUtils.updateEstateFileHashes(connection, abstractDbDriver, 0L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEstateFileHashes(Connection connection, AbstractDbDriver abstractDbDriver, long l, ImmoToolTask.Callback callback) throws SQLException {
        DbAgencyExtension dbAgencyExtension = AgencyPluginUtils.getDbAgencyExtension(abstractDbDriver.getName());
        DbFilesHandler dbFilesHandler = dbAgencyExtension.getFilesHandler();
        for (DbFile dbFile : dbFilesHandler.getFiles(connection, l, null, null)) {
            if (!StringUtils.isBlank((CharSequence)dbFile.hash)) continue;
            String string = "Calculate hash for attachment #" + dbFile.id + " of property #" + dbFile.objectId + ".";
            if (callback != null) {
                callback.setMessage(string);
            }
            LOGGER.info(string);
            File file = null;
            try {
                file = File.createTempFile("temp.", ".bin");
                try (Closeable closeable = new FileOutputStream(file);){
                    dbFilesHandler.downloadContent(connection, dbFile.id, (OutputStream)closeable);
                }
                closeable = new FileInputStream(file);
                var14_14 = null;
                try {
                    dbFile.hash = DigestUtils.sha1Hex((InputStream)closeable);
                    dbFile.size = file.length();
                }
                catch (Throwable throwable) {
                    var14_14 = throwable;
                    throw throwable;
                }
                finally {
                    if (closeable != null) {
                        if (var14_14 != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable) {
                                var14_14.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)closeable).close();
                        }
                    }
                }
                dbFilesHandler.saveFile(connection, dbFile, null);
            }
            catch (IOException | SQLException exception) {
                LOGGER.error("Can't update hash for property attachment #" + dbFile.id + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    public static String writeValueForPublic(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Locale locale) {
        return AgencyPluginUtils.writeValueForPublic(estateImpl, estateImpl.getAttribute(openEstateAttrib), locale);
    }

    public static String writeValueForPublic(EstateImpl estateImpl, AbstractAttribImpl abstractAttribImpl, Locale locale) {
        Date date;
        SimpleTimeAttrib simpleTimeAttrib;
        if (abstractAttribImpl == null || abstractAttribImpl.hasEmptyValue()) {
            return null;
        }
        OpenEstateAttrib openEstateAttrib = abstractAttribImpl.getAttrib();
        if (OpenEstateAttrib.ADMINISTRATION_AVAILABILITY_BEGIN_DATE.equals((Object)openEstateAttrib)) {
            long l;
            simpleTimeAttrib = (SimpleTimeAttrib)abstractAttribImpl;
            date = simpleTimeAttrib.getValue();
            long l2 = l = date != null ? date.getTime() : -1L;
            if (l > -1L && l <= System.currentTimeMillis()) {
                return OpenEstateConstant.FROM_NOW_ON.getTranslation(locale);
            }
        }
        if (estateImpl.isHiddenPrices()) {
            if (OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_BASIC_RENT.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_PURCHASE_PRICE.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_PURCHASE_PRICE_PER_AREA.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_LEASE.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_LEASE_PER_AREA.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_RENT_FLAT_RATE.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_RENT_INCLUDING_SERVICE_CHARGES_PER_AREA.equals((Object)openEstateAttrib) || OpenEstateAttrib.PRICES_UNCONVENTIONED_PRICE.equals((Object)openEstateAttrib)) {
                return OpenEstateConstant.ON_REQUEST.getTranslation(locale);
            }
            if (OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION.equals((Object)openEstateAttrib)) {
                return null;
            }
        }
        if (abstractAttribImpl instanceof ComplexCurrencyAttrib && (date = (simpleTimeAttrib = (ComplexCurrencyAttrib)abstractAttribImpl).getValue()) != null) {
            date.setUnit(estateImpl.getCurrency());
        }
        return abstractAttribImpl.getFormattedValue(locale);
    }

    public static enum Message implements Translatable
    {
        FULL_EXPORT_WARNING(I18n.marktr((String)"The export is configured as full transfer. Please consider, that the recipient will delete all properties in his database, that are not part of the export.")),
        PROPERTY_NR_IDENTIFICATION_WARNING(I18n.marktr((String)"The property-nr is used by the recipient for identification of the properties. Please note, that yout should not change the property-nr of an already exported property."));

        private final String i18nKey;

        private Message(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AgencyPluginUtils.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyPluginUtils.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

