/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.Is24RestAccessDialog;
import com.openindex.openestate.tool.agency.export.Is24RestTransport;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.HttpUtils;
import com.openindex.openestate.tool.utils.ImageUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.client.HttpClient;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.ImportExport;
import org.openestate.is24.restapi.hc43.HttpComponents43Client;
import org.openestate.is24.restapi.utils.Authorization;
import org.openestate.is24.restapi.utils.Verification;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.realestatecounts.RealEstateCounts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24RestTransportPanel
extends AbstractTransportPanel<Is24RestTransport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestTransportPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24RestTransportPanel.class);
    private static final String CALLBACK_URL = "https://is24.openestate.org/callback.php";
    private ValidationHandler validationHandler;
    private JLabel webserviceUrlLabel;
    private JComboBox<String> webserviceUrlField;
    private JXTitledSeparator consumerTitle;
    private JLabel consumerTokenLabel;
    private JTextField consumerTokenField;
    private JLabel consumerSecretLabel;
    private JPasswordField consumerSecretField;
    private JCheckBox consumerDefaultField;
    private JXTitledSeparator accessTitle;
    private JLabel accessTokenLabel;
    private JTextField accessTokenField;
    private JLabel accessSecretLabel;
    private JPasswordField accessSecretField;
    private JXBusyLabel busyLabel;
    private AccessRequestAction accessRequestAction;
    private AccessTestAction accessTestAction;

    public Is24RestTransportPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.consumerTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.accessTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.webserviceUrlLabel = new JLabel();
        this.webserviceUrlField = new JComboBox();
        this.webserviceUrlField.setEditable(true);
        this.webserviceUrlField.addItem("https://rest.immobilienscout24.de/restapi");
        this.webserviceUrlField.addItem("https://rest.sandbox-immobilienscout24.de/restapi");
        this.consumerTokenLabel = new JLabel();
        this.consumerTokenField = new JTextField();
        this.consumerSecretLabel = new JLabel();
        this.consumerSecretField = new JPasswordField();
        this.consumerDefaultField = new JCheckBox();
        this.consumerDefaultField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Is24RestTransportPanel.this.consumerDefaultField.isEnabled()) {
                    return;
                }
                Is24RestTransportPanel.this.setFormEnabled(true);
            }
        });
        this.accessTokenLabel = new JLabel();
        this.accessTokenField = new JTextField();
        this.accessSecretLabel = new JLabel();
        this.accessSecretField = new JPasswordField();
        this.accessRequestAction = new AccessRequestAction();
        this.accessTestAction = new AccessTestAction();
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setVisible(false);
        this.busyLabel.setVerticalAlignment(3);
        JLabel jLabel = new JLabel();
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ImmoToolUtils.openURL((String)"http://www.immobilienscout24.de/");
                }
            }
        });
        URL uRL = ImmoToolEnvironment.class.getResource("/com/openindex/openestate/tool/resources/logos/is24.png");
        if (uRL != null) {
            try {
                jLabel.setIcon(new ImageIcon(ImageUtils.read((URL)uRL)));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read IS24 logo!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.validationHandler.putRule(this.webserviceUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.consumerTokenField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.consumerSecretField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.accessTokenField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.accessSecretField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 125dlu, 3dlu, right:pref, 3dlu, 30dlu:grow");
        defaultFormBuilder.add((Component)this.webserviceUrlLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.webserviceUrlField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.consumerTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.consumerTokenLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.consumerTokenField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.consumerSecretLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.consumerSecretField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.consumerDefaultField).xyw(3, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.accessTitle, (Action[])new Action[]{this.accessRequestAction, this.accessTestAction})).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.accessTokenLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.accessTokenField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.accessSecretLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.accessSecretField).xy(7, defaultFormBuilder.row());
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.busyLabel, "Center");
        jPanel.add((Component)jLabel, "East");
        this.setLayout(new BorderLayout(10, 10));
        this.add(defaultFormBuilder.getPanel(), "Center");
        this.add(jPanel, "South");
        this.updateLocalization();
        this.load((DbAgencyExport)null, (Is24RestTransport)null);
    }

    private AbstractClient createClient() {
        Cloneable cloneable;
        String string = StringUtils.trimToNull((String)((String)this.webserviceUrlField.getSelectedItem()));
        String string2 = null;
        String string3 = null;
        if (this.consumerDefaultField.isSelected() && string != null) {
            try {
                cloneable = new Is24RestTransport();
                ((Is24RestTransport)cloneable).setWebserviceUrl(string);
                string2 = ((Is24RestTransport)cloneable).getWebserviceConsumerToken();
                string3 = ((Is24RestTransport)cloneable).getWebserviceConsumerSecret();
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read URL!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            }
        } else {
            string2 = StringUtils.trimToNull((String)this.consumerTokenField.getText());
            string3 = StringUtils.trimToNull((String)String.valueOf(this.consumerSecretField.getPassword()));
        }
        cloneable = new ArrayList();
        if (string == null) {
            cloneable.add(I18N.tr("Please enter a valid webservice URL."));
        }
        if (string2 == null) {
            cloneable.add(I18N.tr("Please enter a valid application key."));
        }
        if (string3 == null) {
            cloneable.add(I18N.tr("Please enter a valid application password."));
        }
        if (!cloneable.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Collection)((Object)cloneable), (Component)((Object)this));
            return null;
        }
        return new HttpComponents43Client(string, string2, string3, (HttpClient)HttpUtils.builder().build());
    }

    private void doAccessRequest() {
        AbstractClient abstractClient = this.createClient();
        if (abstractClient == null) {
            return;
        }
        this.setFormEnabled(false);
        this.busyLabel.setText(I18N.tr("Requesting access credentials from the webservice."));
        this.busyLabel.setBusy(true);
        this.busyLabel.setVisible(true);
        ImmoToolUtils.executeTask((ImmoToolTask)new AccessRequestTask(abstractClient));
    }

    private void doAccessTest() {
        AbstractClient abstractClient = this.createClient();
        if (abstractClient == null) {
            return;
        }
        String string = StringUtils.trimToNull((String)this.accessTokenField.getText());
        String string2 = StringUtils.trimToNull((String)String.valueOf(this.accessSecretField.getPassword()));
        if (string == null || string2 == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Please provide a valid user account!"), (Component)((Object)this));
            return;
        }
        this.setFormEnabled(false);
        this.busyLabel.setText(I18N.tr("Testing communication with the webservice."));
        this.busyLabel.setBusy(true);
        this.busyLabel.setVisible(true);
        ImmoToolUtils.executeTask((ImmoToolTask)new AccessTestTask(abstractClient, string, string2));
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DbAgencyExport dbAgencyExport, Is24RestTransport is24RestTransport) {
        this.setFormEnabled(false);
        try {
            if (is24RestTransport == null) {
                this.webserviceUrlField.setSelectedItem("https://rest.immobilienscout24.de/restapi");
                this.consumerTokenField.setText("");
                this.consumerSecretField.setText("");
                this.consumerDefaultField.setSelected(true);
                this.accessTokenField.setText("");
                this.accessSecretField.setText("");
            } else {
                URI uRI = is24RestTransport.getWebserviceUrl();
                this.webserviceUrlField.setSelectedItem(uRI != null ? uRI.toString() : "");
                this.accessTokenField.setText(StringUtils.trimToEmpty((String)is24RestTransport.getWebserviceAccessToken()));
                this.accessTokenField.setCaretPosition(0);
                this.accessSecretField.setText(StringUtils.trimToEmpty((String)is24RestTransport.getWebserviceAccessSecret()));
                this.accessSecretField.setCaretPosition(0);
                if (is24RestTransport.isWebserviceConsumerDefault()) {
                    this.consumerTokenField.setText("");
                    this.consumerSecretField.setText("");
                    this.consumerDefaultField.setSelected(true);
                } else {
                    this.consumerTokenField.setText(StringUtils.trimToEmpty((String)is24RestTransport.getWebserviceConsumerToken()));
                    this.consumerSecretField.setText(StringUtils.trimToEmpty((String)is24RestTransport.getWebserviceConsumerSecret()));
                    this.consumerDefaultField.setSelected(false);
                }
            }
        }
        finally {
            this.setFormEnabled(true);
        }
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, Is24RestTransport is24RestTransport) {
        if (is24RestTransport == null) {
            throw new NullPointerException("empty transport-class!");
        }
        try {
            is24RestTransport.setWebserviceUrl((String)this.webserviceUrlField.getSelectedItem());
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("invalid http-url!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        is24RestTransport.setWebserviceAccessToken(this.accessTokenField.getText().trim());
        is24RestTransport.setWebserviceAccessSecret(String.valueOf(this.accessSecretField.getPassword()).trim());
        if (this.consumerDefaultField.isSelected()) {
            is24RestTransport.setWebserviceConsumerDefault(true);
            is24RestTransport.setWebserviceConsumerToken(null);
            is24RestTransport.setWebserviceConsumerSecret(null);
        } else {
            is24RestTransport.setWebserviceConsumerDefault(false);
            is24RestTransport.setWebserviceConsumerToken(this.consumerTokenField.getText().trim());
            is24RestTransport.setWebserviceConsumerSecret(String.valueOf(this.consumerSecretField.getPassword()).trim());
        }
    }

    private void setFormEnabled(boolean bl) {
        this.webserviceUrlField.setEnabled(bl);
        this.accessTokenField.setEnabled(bl);
        this.accessSecretField.setEnabled(bl);
        this.accessRequestAction.setEnabled(bl);
        this.accessTestAction.setEnabled(bl);
        this.consumerDefaultField.setEnabled(bl);
        this.consumerTokenField.setEnabled(bl && !this.consumerDefaultField.isSelected());
        this.consumerSecretField.setEnabled(bl && !this.consumerDefaultField.isSelected());
        if (bl) {
            this.validationHandler.init();
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.webserviceUrlLabel.setText(StringUtils.capitalize((String)I18N.tr("URL")) + ":");
        this.webserviceUrlField.setToolTipText(I18N.tr("Enter the URL of the webservice."));
        this.consumerTitle.setTitle(StringUtils.capitalize((String)I18N.tr("identification of the application")));
        this.consumerTokenLabel.setText(StringUtils.capitalize((String)I18N.tr("key")) + ":");
        this.consumerTokenField.setToolTipText(I18N.tr("The key identifies the application at the webservice."));
        this.consumerSecretLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
        this.consumerSecretField.setToolTipText(I18N.tr("The password identifies the application at the webservice."));
        this.consumerDefaultField.setText(I18N.tr("Identify as {0}.", (Object)ImmoToolEnvironment.getApplicationTitle()));
        this.consumerDefaultField.setToolTipText(I18N.tr("Enable this option to identify the application as {0} at the webservice.", (Object)ImmoToolEnvironment.getApplicationTitle()));
        this.accessTitle.setTitle(StringUtils.capitalize((String)I18N.tr("identification of the user account")));
        this.accessTokenLabel.setText(StringUtils.capitalize((String)I18N.tr("key")) + ":");
        this.accessTokenField.setToolTipText(I18N.tr("The key identifies the user account at the webservice."));
        this.accessSecretLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
        this.accessSecretField.setToolTipText(I18N.tr("The password identifies the user account at the webservice."));
    }

    private class AccessTestTask
    extends ImmoToolTask<RealEstateCounts, Void> {
        private final AbstractClient client;
        private final String accessToken;
        private final String accessSecret;

        private AccessTestTask(AbstractClient abstractClient, String string, String string2) {
            this.client = abstractClient;
            this.accessToken = string;
            this.accessSecret = string2;
        }

        protected RealEstateCounts doInBackground() throws Exception {
            XmlUtils.initContext((ClassLoader)AgencyPlugin.class.getClassLoader());
            this.client.authorize(this.accessToken, this.accessSecret);
            return ImportExport.RealEstatesCountsService.get((AbstractClient)this.client);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            Is24RestTransportPanel.this.busyLabel.setText("<html><b stlye=\"color:red;\">" + I18N.tr("The connection-test failed!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
            ImmoToolUtils.showMessageErrorDialog((String)"The connection-test failed!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            Is24RestTransportPanel.this.setFormEnabled(true);
            Is24RestTransportPanel.this.busyLabel.setBusy(false);
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void succeeded(RealEstateCounts realEstateCounts) {
            super.succeeded((Object)realEstateCounts);
            if (realEstateCounts != null) {
                long l = realEstateCounts.getIs24PublishedRealEstatesCount() + realEstateCounts.getIs24NotPublishedRealEstatesCount();
                Is24RestTransportPanel.this.busyLabel.setText("<html><b>" + I18N.tr("The connection-test was successful!") + "</b><br>" + I18N.trn("{0} property is currently available through the webservice.", "{0} properties are currently available through the webservice.", l, (Object)NumberFormat.getIntegerInstance().format(l)) + "</html>");
            } else {
                Is24RestTransportPanel.this.busyLabel.setText("<html><b>Something went wrong during the connection-test!</b></html>");
            }
        }
    }

    private class AccessTestAction
    extends AbstractI18nAction {
        public AccessTestAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"restart.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Is24RestTransportPanel.this.doAccessTest();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test access")));
            this.setShortDescription(I18N.tr("Let the program try to connect to the webservice."));
        }
    }

    private class AccessRequestTask
    extends ImmoToolTask<Verification, Void> {
        private final AbstractClient client;

        private AccessRequestTask(AbstractClient abstractClient) {
            this.client = abstractClient;
        }

        protected Verification doInBackground() throws Exception {
            return this.client.fetchVerification(Is24RestTransportPanel.CALLBACK_URL);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            Is24RestTransportPanel.this.busyLabel.setText("<html><b stlye=\"color:red;\">" + I18N.tr("Can't request access for the webservice!") + "</b><br>" + StringEscapeUtils.escapeXml11((String)throwable.getLocalizedMessage()) + "</html>");
            ImmoToolUtils.showMessageErrorDialog((String)"Can't request access for the webservice!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            Is24RestTransportPanel.this.setFormEnabled(true);
            Is24RestTransportPanel.this.busyLabel.setBusy(false);
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void succeeded(Verification verification) {
            super.succeeded((Object)verification);
            Is24RestTransportPanel.this.busyLabel.setVisible(false);
            Authorization authorization = Is24RestAccessDialog.showDialog(this.client, verification, (Window)ImmoToolEnvironment.getFrame());
            if (authorization != null) {
                Is24RestTransportPanel.this.accessTokenField.setText(StringUtils.trimToEmpty((String)authorization.accessToken));
                Is24RestTransportPanel.this.accessTokenField.setCaretPosition(0);
                Is24RestTransportPanel.this.accessSecretField.setText(StringUtils.trimToEmpty((String)authorization.accessTokenSecret));
                Is24RestTransportPanel.this.accessSecretField.setCaretPosition(0);
            }
        }
    }

    private class AccessRequestAction
    extends AbstractI18nAction {
        public AccessRequestAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"password.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Is24RestTransportPanel.this.doAccessRequest();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("request access")));
            this.setShortDescription(I18N.tr("Request a user account from the webservice."));
        }
    }
}

